/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.selectable.BillingDocumentRequestItemSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequestItem
 * BillingDocumentRequestItem} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class BillingDocumentRequestItemByKeyFluentHelper
    extends
    FluentHelperByKey<BillingDocumentRequestItemByKeyFluentHelper, BillingDocumentRequestItem, BillingDocumentRequestItemSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequestItem
     * BillingDocumentRequestItem} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param billingDocumentRequest
     *            Billing Document Request
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code BillingDocumentRequestItem}
     * @param billingDocumentRequestItem
     *            Billing Document Request Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code BillingDocumentRequestItem}
     */
    public BillingDocumentRequestItemByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String billingDocumentRequest,
        final String billingDocumentRequestItem )
    {
        super(servicePath, entityCollection);
        this.key.put("BillingDocumentRequest", billingDocumentRequest);
        this.key.put("BillingDocumentRequestItem", billingDocumentRequestItem);
    }

    @Override
    @Nonnull
    protected Class<BillingDocumentRequestItem> getEntityClass()
    {
        return BillingDocumentRequestItem.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
