/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmComplex;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original complex type name from the Odata EDM: <b>Messages_Response</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class Messages_Response extends VdmComplex<Messages_Response>
{

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>BillingDocumentRequest</b>
     * </p>
     *
     * @param billingDocumentRequest
     *
     */
    @SerializedName( "BillingDocumentRequest" )
    @JsonProperty( "BillingDocumentRequest" )
    @Nullable
    @ODataField( odataName = "BillingDocumentRequest" )
    private String billingDocumentRequest;
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>MessageType</b>
     * </p>
     *
     * @param messageType
     *
     */
    @SerializedName( "MessageType" )
    @JsonProperty( "MessageType" )
    @Nullable
    @ODataField( odataName = "MessageType" )
    private String messageType;
    /**
     * Constraints: Not nullable, Maximum length: 256
     * <p>
     * Original property from the Odata EDM: <b>Message</b>
     * </p>
     *
     * @param message
     *
     */
    @SerializedName( "Message" )
    @JsonProperty( "Message" )
    @Nullable
    @ODataField( odataName = "Message" )
    private String message;

    @Nonnull
    @Override
    public Class<Messages_Response> getType()
    {
        return Messages_Response.class;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BillingDocumentRequest", getBillingDocumentRequest());
        values.put("MessageType", getMessageType());
        values.put("Message", getMessage());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BillingDocumentRequest") ) {
                final Object value = values.remove("BillingDocumentRequest");
                if( (value == null) || (!value.equals(getBillingDocumentRequest())) ) {
                    setBillingDocumentRequest(((String) value));
                }
            }
            if( values.containsKey("MessageType") ) {
                final Object value = values.remove("MessageType");
                if( (value == null) || (!value.equals(getMessageType())) ) {
                    setMessageType(((String) value));
                }
            }
            if( values.containsKey("Message") ) {
                final Object value = values.remove("Message");
                if( (value == null) || (!value.equals(getMessage())) ) {
                    setMessage(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        return result;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>BillingDocumentRequest</b>
     * </p>
     *
     * @param billingDocumentRequest
     *            The billingDocumentRequest to set.
     */
    public void setBillingDocumentRequest( @Nullable final String billingDocumentRequest )
    {
        rememberChangedField("BillingDocumentRequest", this.billingDocumentRequest);
        this.billingDocumentRequest = billingDocumentRequest;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>MessageType</b>
     * </p>
     *
     * @param messageType
     *            The messageType to set.
     */
    public void setMessageType( @Nullable final String messageType )
    {
        rememberChangedField("MessageType", this.messageType);
        this.messageType = messageType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 256
     * <p>
     * Original property from the Odata EDM: <b>Message</b>
     * </p>
     *
     * @param message
     *            The message to set.
     */
    public void setMessage( @Nullable final String message )
    {
        rememberChangedField("Message", this.message);
        this.message = message;
    }

}
