/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequest;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillingDocumentRequestService
 * BillingDocumentRequestService}.
 *
 */
public interface BillingDocumentRequestServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<BillingDocumentRequestServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<BillingDocumentRequestServiceBatch>
{

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequest
     * BillingDocumentRequest} entity in the S/4HANA system.
     *
     * @param billingDocumentRequest
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequest
     *            BillingDocumentRequest} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BillingDocumentRequestServiceBatchChangeSet
        deleteBillingDocumentRequest( @Nonnull final BillingDocumentRequest billingDocumentRequest );

}
