/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link BillingDocumentRequestServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillingDocumentRequestService
 * BillingDocumentRequestService}, allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultBillingDocumentRequestServiceBatch
    extends
    BatchFluentHelperBasic<BillingDocumentRequestServiceBatch, BillingDocumentRequestServiceBatchChangeSet>
    implements
    BillingDocumentRequestServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillingDocumentRequestService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultBillingDocumentRequestServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultBillingDocumentRequestServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillingDocumentRequestService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillingDocumentRequestService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultBillingDocumentRequestServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultBillingDocumentRequestServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillingDocumentRequestService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultBillingDocumentRequestServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public BillingDocumentRequestServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultBillingDocumentRequestServiceBatchChangeSet(this, service);
    }

}
