/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequest;

/**
 * Implementation of the {@link BillingDocumentRequestServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillingDocumentRequestService
 * BillingDocumentRequestService}.
 *
 */
public class DefaultBillingDocumentRequestServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<BillingDocumentRequestServiceBatch, BillingDocumentRequestServiceBatchChangeSet>
    implements
    BillingDocumentRequestServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillingDocumentRequestService service;

    @SuppressWarnings( "deprecation" )
    DefaultBillingDocumentRequestServiceBatchChangeSet(
        @Nonnull final DefaultBillingDocumentRequestServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillingDocumentRequestService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultBillingDocumentRequestServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public BillingDocumentRequestServiceBatchChangeSet deleteBillingDocumentRequest(
        @Nonnull final BillingDocumentRequest billingDocumentRequest )
    {
        return addRequestDelete(service::deleteBillingDocumentRequest, billingDocumentRequest);
    }

}
