/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocReqItemPartner;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocReqItemPartner
 * BillingDocReqItemPartner}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.field.BillingDocReqItemPartnerField
 * BillingDocReqItemPartnerField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.link.BillingDocReqItemPartnerLink
 * BillingDocReqItemPartnerLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocReqItemPartner#BILLING_DOCUMENT_REQUEST
 * BILLING_DOCUMENT_REQUEST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocReqItemPartner#BILLING_DOCUMENT_REQUEST_ITEM
 * BILLING_DOCUMENT_REQUEST_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocReqItemPartner#PARTNER_FUNCTION
 * PARTNER_FUNCTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocReqItemPartner#CUSTOMER
 * CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocReqItemPartner#SUPPLIER
 * SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocReqItemPartner#PERSONNEL
 * PERSONNEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocReqItemPartner#CONTACT_PERSON
 * CONTACT_PERSON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocReqItemPartner#TO_BILLING_DOCUMENT_REQUEST
 * TO_BILLING_DOCUMENT_REQUEST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocReqItemPartner#TO_BILLING_DOCUMENT_REQUEST_ITEM
 * TO_BILLING_DOCUMENT_REQUEST_ITEM}</li>
 * </ul>
 *
 */
public interface BillingDocReqItemPartnerSelectable extends EntitySelectable<BillingDocReqItemPartner>
{

}
