/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequestItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequestItem
 * BillingDocumentRequestItem}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.field.BillingDocumentRequestItemField
 * BillingDocumentRequestItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.link.BillingDocumentRequestItemLink
 * BillingDocumentRequestItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequestItem#BILLING_DOCUMENT_REQUEST
 * BILLING_DOCUMENT_REQUEST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequestItem#BILLING_DOCUMENT_REQUEST_ITEM
 * BILLING_DOCUMENT_REQUEST_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequestItem#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequestItem#CREATION_TIME
 * CREATION_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequestItem#REFERENCE_LOGICAL_SYSTEM
 * REFERENCE_LOGICAL_SYSTEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequestItem#DIVISION
 * DIVISION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequestItem#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequestItem#PRODUCT_HIERARCHY_NODE
 * PRODUCT_HIERARCHY_NODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequestItem#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequestItem#BILLING_DOCUMENT_REQUEST_ITEM_TEXT
 * BILLING_DOCUMENT_REQUEST_ITEM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequestItem#SERVICES_RENDERED_DATE
 * SERVICES_RENDERED_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequestItem#BILLING_QUANTITY
 * BILLING_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequestItem#BILLING_QUANTITY_UNIT
 * BILLING_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequestItem#NET_AMOUNT
 * NET_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequestItem#TRANSACTION_CURRENCY
 * TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequestItem#GROSS_AMOUNT
 * GROSS_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequestItem#PRICING_DATE
 * PRICING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequestItem#ABSLT_PRICE_DETN_EXCHANGE_RATE
 * ABSLT_PRICE_DETN_EXCHANGE_RATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequestItem#PRICE_DETN_EXCH_RATE_IS_INDRCT_QTAN
 * PRICE_DETN_EXCH_RATE_IS_INDRCT_QTAN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequestItem#TAX_AMOUNT
 * TAX_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequestItem#DEPARTURE_COUNTRY
 * DEPARTURE_COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequestItem#TAX_JURISDICTION
 * TAX_JURISDICTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequestItem#PRODUCT_TAX_CLASSIFICATION1
 * PRODUCT_TAX_CLASSIFICATION1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequestItem#BUSINESS_AREA
 * BUSINESS_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequestItem#PROFIT_CENTER
 * PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequestItem#WBS_ELEMENT
 * WBS_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequestItem#CONTROLLING_AREA
 * CONTROLLING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequestItem#PROFITABILITY_SEGMENT
 * PROFITABILITY_SEGMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequestItem#ORDER_ID
 * ORDER_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequestItem#COST_CENTER
 * COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequestItem#MATL_ACCOUNT_ASSIGNMENT_GROUP
 * MATL_ACCOUNT_ASSIGNMENT_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequestItem#REFERENCE_DOCUMENT
 * REFERENCE_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequestItem#REFERENCE_DOCUMENT_ITEM
 * REFERENCE_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequestItem#HIGHER_LEVEL_ITEM
 * HIGHER_LEVEL_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequestItem#BILLG_DOC_REQUEST_ITEM_IN_PART_SGMT
 * BILLG_DOC_REQUEST_ITEM_IN_PART_SGMT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequestItem#TO_BILLING_DOCUMENT_REQUEST
 * TO_BILLING_DOCUMENT_REQUEST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequestItem#TO_PARTNER
 * TO_PARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billingdocumentrequest.BillingDocumentRequestItem#TO_PRICING_ELEMENT
 * TO_PRICING_ELEMENT}</li>
 * </ul>
 *
 */
public interface BillingDocumentRequestItemSelectable extends EntitySelectable<BillingDocumentRequestItem>
{

}
