/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison;

import java.net.URI;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.CollectionValuedFluentHelperFunction;

/**
 * Fluent helper for the <b>BOMComparison</b> OData function import.
 *
 */
public class BOMComparisonFluentHelper
    extends
    CollectionValuedFluentHelperFunction<BOMComparisonFluentHelper, ComparisonResult, List<ComparisonResult>>
{

    private final Map<String, Object> values = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will execute the <b>BOMComparison</b> OData function import with the provided
     * parameters. To perform execution, call the {@link #executeRequest executeRequest} method on the fluent helper
     * object.
     *
     * @param isBOMItemNumber
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>IsBOMItemNumber</b>
     *            </p>
     * @param bOMVariantSecondary
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMVariantSecondary</b>
     *            </p>
     * @param isBOMItemDescription
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>IsBOMItemDescription</b>
     *            </p>
     * @param changeNumberPrimary
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ChangeNumberPrimary</b>
     *            </p>
     * @param isBOMItemCategory
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>IsBOMItemCategory</b>
     *            </p>
     * @param plantSecondary
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PlantSecondary</b>
     *            </p>
     * @param changeNumberSecondary
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ChangeNumberSecondary</b>
     *            </p>
     * @param bOMVersionSecondary
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMVersionSecondary</b>
     *            </p>
     * @param bOMVariantPrimary
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMVariantPrimary</b>
     *            </p>
     * @param isBOMItemQuantity
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>IsBOMItemQuantity</b>
     *            </p>
     * @param servicePath
     *            Service path to be used to call the functions against.
     * @param materialSecondary
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaterialSecondary</b>
     *            </p>
     * @param bOMVariantUsagePrimary
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMVariantUsagePrimary</b>
     *            </p>
     * @param plantPrimary
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PlantPrimary</b>
     *            </p>
     * @param bOMValidityDatePrimary
     *            Time Stamp
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMValidityDatePrimary</b>
     *            </p>
     * @param bOMVariantUsageSecondary
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMVariantUsageSecondary</b>
     *            </p>
     * @param bOMValidityDateSecondary
     *            Time Stamp
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMValidityDateSecondary</b>
     *            </p>
     * @param bOMVersionPrimary
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMVersionPrimary</b>
     *            </p>
     * @param materialPrimary
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaterialPrimary</b>
     *            </p>
     */
    public BOMComparisonFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final LocalDateTime bOMValidityDateSecondary,
        @Nonnull final String bOMVersionSecondary,
        @Nonnull final String bOMVariantSecondary,
        @Nonnull final String bOMVariantUsageSecondary,
        @Nonnull final String plantSecondary,
        @Nonnull final String materialSecondary,
        @Nonnull final String changeNumberPrimary,
        @Nonnull final LocalDateTime bOMValidityDatePrimary,
        @Nonnull final String bOMVersionPrimary,
        @Nonnull final String bOMVariantPrimary,
        @Nonnull final String bOMVariantUsagePrimary,
        @Nonnull final String plantPrimary,
        @Nonnull final String materialPrimary,
        @Nonnull final Boolean isBOMItemNumber,
        @Nonnull final Boolean isBOMItemDescription,
        @Nonnull final Boolean isBOMItemCategory,
        @Nonnull final String changeNumberSecondary,
        @Nonnull final Boolean isBOMItemQuantity )
    {
        super(servicePath);
        values.put("BOMValidityDateSecondary", bOMValidityDateSecondary);
        values.put("BOMVersionSecondary", bOMVersionSecondary);
        values.put("BOMVariantSecondary", bOMVariantSecondary);
        values.put("BOMVariantUsageSecondary", bOMVariantUsageSecondary);
        values.put("PlantSecondary", plantSecondary);
        values.put("MaterialSecondary", materialSecondary);
        values.put("ChangeNumberPrimary", changeNumberPrimary);
        values.put("BOMValidityDatePrimary", bOMValidityDatePrimary);
        values.put("BOMVersionPrimary", bOMVersionPrimary);
        values.put("BOMVariantPrimary", bOMVariantPrimary);
        values.put("BOMVariantUsagePrimary", bOMVariantUsagePrimary);
        values.put("PlantPrimary", plantPrimary);
        values.put("MaterialPrimary", materialPrimary);
        values.put("IsBOMItemNumber", isBOMItemNumber);
        values.put("IsBOMItemDescription", isBOMItemDescription);
        values.put("IsBOMItemCategory", isBOMItemCategory);
        values.put("ChangeNumberSecondary", changeNumberSecondary);
        values.put("IsBOMItemQuantity", isBOMItemQuantity);
    }

    @Override
    @Nonnull
    protected Class<ComparisonResult> getEntityClass()
    {
        return ComparisonResult.class;
    }

    @Override
    @Nonnull
    protected String getFunctionName()
    {
        return "BOMComparison";
    }

    @Override
    @Nullable
    protected JsonElement refineJsonResponse( @Nullable JsonElement jsonElement )
    {
        if( (jsonElement instanceof JsonObject) && ((JsonObject) jsonElement).has(getFunctionName()) ) {
            jsonElement = ((JsonObject) jsonElement).get(getFunctionName());
        }
        return super.refineJsonResponse(jsonElement);
    }

    @Override
    @Nonnull
    protected Map<String, Object> getParameters()
    {
        return values;
    }

    @Override
    @Nonnull
    protected HttpUriRequest createRequest( @Nonnull final URI uri )
    {
        return new HttpGet(uri);
    }

    /**
     * Execute this function import.
     *
     */
    @Override
    @Nonnull
    public List<ComparisonResult> executeRequest( @Nonnull final HttpDestinationProperties destination )
    {
        return super.executeMultiple(destination);
    }

}
