/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.field.ComparisonResultField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.selectable.ComparisonResultSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Comparison Result
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ComparisonResult</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ComparisonResult extends VdmEntity<ComparisonResult>
{

    /**
     * Selector for all available fields of ComparisonResult.
     *
     */
    public final static ComparisonResultSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>BOMComparisonUUID</b>
     * </p>
     *
     * @return GUID
     */
    @Key
    @SerializedName( "BOMComparisonUUID" )
    @JsonProperty( "BOMComparisonUUID" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBinaryAdapter.class )
    @ODataField( odataName = "BOMComparisonUUID" )
    private byte[] bOMComparisonUUID;
    /**
     * Use with available fluent helpers to apply the <b>BOMComparisonUUID</b> field to query operations.
     *
     */
    public final static ComparisonResultField<byte[]> BOM_COMPARISON_UUID =
        new ComparisonResultField<byte[]>("BOMComparisonUUID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BOMComponentPrimary</b>
     * </p>
     *
     * @return Component
     */
    @SerializedName( "BOMComponentPrimary" )
    @JsonProperty( "BOMComponentPrimary" )
    @Nullable
    @ODataField( odataName = "BOMComponentPrimary" )
    private String bOMComponentPrimary;
    /**
     * Use with available fluent helpers to apply the <b>BOMComponentPrimary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<String> BOM_COMPONENT_PRIMARY =
        new ComparisonResultField<String>("BOMComponentPrimary");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BOMComponentSecondary</b>
     * </p>
     *
     * @return Component
     */
    @SerializedName( "BOMComponentSecondary" )
    @JsonProperty( "BOMComponentSecondary" )
    @Nullable
    @ODataField( odataName = "BOMComponentSecondary" )
    private String bOMComponentSecondary;
    /**
     * Use with available fluent helpers to apply the <b>BOMComponentSecondary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<String> BOM_COMPONENT_SECONDARY =
        new ComparisonResultField<String>("BOMComponentSecondary");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BOMComparisonResult</b>
     * </p>
     *
     * @return Comparson Result
     */
    @SerializedName( "BOMComparisonResult" )
    @JsonProperty( "BOMComparisonResult" )
    @Nullable
    @ODataField( odataName = "BOMComparisonResult" )
    private String bOMComparisonResult;
    /**
     * Use with available fluent helpers to apply the <b>BOMComparisonResult</b> field to query operations.
     *
     */
    public final static ComparisonResultField<String> BOM_COMPARISON_RESULT =
        new ComparisonResultField<String>("BOMComparisonResult");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialTypePrimary</b>
     * </p>
     *
     * @return Material Type
     */
    @SerializedName( "MaterialTypePrimary" )
    @JsonProperty( "MaterialTypePrimary" )
    @Nullable
    @ODataField( odataName = "MaterialTypePrimary" )
    private String materialTypePrimary;
    /**
     * Use with available fluent helpers to apply the <b>MaterialTypePrimary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<String> MATERIAL_TYPE_PRIMARY =
        new ComparisonResultField<String>("MaterialTypePrimary");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialTypeSecondary</b>
     * </p>
     *
     * @return Material Type
     */
    @SerializedName( "MaterialTypeSecondary" )
    @JsonProperty( "MaterialTypeSecondary" )
    @Nullable
    @ODataField( odataName = "MaterialTypeSecondary" )
    private String materialTypeSecondary;
    /**
     * Use with available fluent helpers to apply the <b>MaterialTypeSecondary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<String> MATERIAL_TYPE_SECONDARY =
        new ComparisonResultField<String>("MaterialTypeSecondary");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemQuantityPrimary</b>
     * </p>
     *
     * @return Quantity
     */
    @SerializedName( "BOMItemQuantityPrimary" )
    @JsonProperty( "BOMItemQuantityPrimary" )
    @Nullable
    @ODataField( odataName = "BOMItemQuantityPrimary" )
    private BigDecimal bOMItemQuantityPrimary;
    /**
     * Use with available fluent helpers to apply the <b>BOMItemQuantityPrimary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<BigDecimal> BOM_ITEM_QUANTITY_PRIMARY =
        new ComparisonResultField<BigDecimal>("BOMItemQuantityPrimary");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemQuantitySecondary</b>
     * </p>
     *
     * @return Quantity
     */
    @SerializedName( "BOMItemQuantitySecondary" )
    @JsonProperty( "BOMItemQuantitySecondary" )
    @Nullable
    @ODataField( odataName = "BOMItemQuantitySecondary" )
    private BigDecimal bOMItemQuantitySecondary;
    /**
     * Use with available fluent helpers to apply the <b>BOMItemQuantitySecondary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<BigDecimal> BOM_ITEM_QUANTITY_SECONDARY =
        new ComparisonResultField<BigDecimal>("BOMItemQuantitySecondary");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemCategoryPrimary</b>
     * </p>
     *
     * @return Item Category
     */
    @SerializedName( "BOMItemCategoryPrimary" )
    @JsonProperty( "BOMItemCategoryPrimary" )
    @Nullable
    @ODataField( odataName = "BOMItemCategoryPrimary" )
    private String bOMItemCategoryPrimary;
    /**
     * Use with available fluent helpers to apply the <b>BOMItemCategoryPrimary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<String> BOM_ITEM_CATEGORY_PRIMARY =
        new ComparisonResultField<String>("BOMItemCategoryPrimary");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemCategorySecondary</b>
     * </p>
     *
     * @return Item Category
     */
    @SerializedName( "BOMItemCategorySecondary" )
    @JsonProperty( "BOMItemCategorySecondary" )
    @Nullable
    @ODataField( odataName = "BOMItemCategorySecondary" )
    private String bOMItemCategorySecondary;
    /**
     * Use with available fluent helpers to apply the <b>BOMItemCategorySecondary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<String> BOM_ITEM_CATEGORY_SECONDARY =
        new ComparisonResultField<String>("BOMItemCategorySecondary");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>CompleteMaintStatusPrimary</b>
     * </p>
     *
     * @return Complete status
     */
    @SerializedName( "CompleteMaintStatusPrimary" )
    @JsonProperty( "CompleteMaintStatusPrimary" )
    @Nullable
    @ODataField( odataName = "CompleteMaintStatusPrimary" )
    private String completeMaintStatusPrimary;
    /**
     * Use with available fluent helpers to apply the <b>CompleteMaintStatusPrimary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<String> COMPLETE_MAINT_STATUS_PRIMARY =
        new ComparisonResultField<String>("CompleteMaintStatusPrimary");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>CompleteMaintStatusSecondary</b>
     * </p>
     *
     * @return Complete status
     */
    @SerializedName( "CompleteMaintStatusSecondary" )
    @JsonProperty( "CompleteMaintStatusSecondary" )
    @Nullable
    @ODataField( odataName = "CompleteMaintStatusSecondary" )
    private String completeMaintStatusSecondary;
    /**
     * Use with available fluent helpers to apply the <b>CompleteMaintStatusSecondary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<String> COMPLETE_MAINT_STATUS_SECONDARY =
        new ComparisonResultField<String>("CompleteMaintStatusSecondary");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemDescriptionPrimary</b>
     * </p>
     *
     * @return Description
     */
    @SerializedName( "BOMItemDescriptionPrimary" )
    @JsonProperty( "BOMItemDescriptionPrimary" )
    @Nullable
    @ODataField( odataName = "BOMItemDescriptionPrimary" )
    private String bOMItemDescriptionPrimary;
    /**
     * Use with available fluent helpers to apply the <b>BOMItemDescriptionPrimary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<String> BOM_ITEM_DESCRIPTION_PRIMARY =
        new ComparisonResultField<String>("BOMItemDescriptionPrimary");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemDescriptionSecondary</b>
     * </p>
     *
     * @return Description
     */
    @SerializedName( "BOMItemDescriptionSecondary" )
    @JsonProperty( "BOMItemDescriptionSecondary" )
    @Nullable
    @ODataField( odataName = "BOMItemDescriptionSecondary" )
    private String bOMItemDescriptionSecondary;
    /**
     * Use with available fluent helpers to apply the <b>BOMItemDescriptionSecondary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<String> BOM_ITEM_DESCRIPTION_SECONDARY =
        new ComparisonResultField<String>("BOMItemDescriptionSecondary");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BOMHeaderBaseUnitPrimary</b>
     * </p>
     *
     * @return Base Unit
     */
    @SerializedName( "BOMHeaderBaseUnitPrimary" )
    @JsonProperty( "BOMHeaderBaseUnitPrimary" )
    @Nullable
    @ODataField( odataName = "BOMHeaderBaseUnitPrimary" )
    private String bOMHeaderBaseUnitPrimary;
    /**
     * Use with available fluent helpers to apply the <b>BOMHeaderBaseUnitPrimary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<String> BOM_HEADER_BASE_UNIT_PRIMARY =
        new ComparisonResultField<String>("BOMHeaderBaseUnitPrimary");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BOMHeaderBaseUnitSecondary</b>
     * </p>
     *
     * @return Base Unit
     */
    @SerializedName( "BOMHeaderBaseUnitSecondary" )
    @JsonProperty( "BOMHeaderBaseUnitSecondary" )
    @Nullable
    @ODataField( odataName = "BOMHeaderBaseUnitSecondary" )
    private String bOMHeaderBaseUnitSecondary;
    /**
     * Use with available fluent helpers to apply the <b>BOMHeaderBaseUnitSecondary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<String> BOM_HEADER_BASE_UNIT_SECONDARY =
        new ComparisonResultField<String>("BOMHeaderBaseUnitSecondary");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemUnitPrimary</b>
     * </p>
     *
     * @return Component UoM
     */
    @SerializedName( "BOMItemUnitPrimary" )
    @JsonProperty( "BOMItemUnitPrimary" )
    @Nullable
    @ODataField( odataName = "BOMItemUnitPrimary" )
    private String bOMItemUnitPrimary;
    /**
     * Use with available fluent helpers to apply the <b>BOMItemUnitPrimary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<String> BOM_ITEM_UNIT_PRIMARY =
        new ComparisonResultField<String>("BOMItemUnitPrimary");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemUnitSecondary</b>
     * </p>
     *
     * @return Component UoM
     */
    @SerializedName( "BOMItemUnitSecondary" )
    @JsonProperty( "BOMItemUnitSecondary" )
    @Nullable
    @ODataField( odataName = "BOMItemUnitSecondary" )
    private String bOMItemUnitSecondary;
    /**
     * Use with available fluent helpers to apply the <b>BOMItemUnitSecondary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<String> BOM_ITEM_UNIT_SECONDARY =
        new ComparisonResultField<String>("BOMItemUnitSecondary");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>IsProductionRelevantPrimary</b>
     * </p>
     *
     * @return Production
     */
    @SerializedName( "IsProductionRelevantPrimary" )
    @JsonProperty( "IsProductionRelevantPrimary" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsProductionRelevantPrimary" )
    private Boolean isProductionRelevantPrimary;
    /**
     * Use with available fluent helpers to apply the <b>IsProductionRelevantPrimary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<Boolean> IS_PRODUCTION_RELEVANT_PRIMARY =
        new ComparisonResultField<Boolean>("IsProductionRelevantPrimary");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>IsProductionRelevantSecond</b>
     * </p>
     *
     * @return Production
     */
    @SerializedName( "IsProductionRelevantSecond" )
    @JsonProperty( "IsProductionRelevantSecond" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsProductionRelevantSecond" )
    private Boolean isProductionRelevantSecond;
    /**
     * Use with available fluent helpers to apply the <b>IsProductionRelevantSecond</b> field to query operations.
     *
     */
    public final static ComparisonResultField<Boolean> IS_PRODUCTION_RELEVANT_SECOND =
        new ComparisonResultField<Boolean>("IsProductionRelevantSecond");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ItemIsCostingRelevantPrimary</b>
     * </p>
     *
     * @return CostingRelevncy
     */
    @SerializedName( "ItemIsCostingRelevantPrimary" )
    @JsonProperty( "ItemIsCostingRelevantPrimary" )
    @Nullable
    @ODataField( odataName = "ItemIsCostingRelevantPrimary" )
    private String itemIsCostingRelevantPrimary;
    /**
     * Use with available fluent helpers to apply the <b>ItemIsCostingRelevantPrimary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<String> ITEM_IS_COSTING_RELEVANT_PRIMARY =
        new ComparisonResultField<String>("ItemIsCostingRelevantPrimary");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ItemIsCostingRelevantSecondary</b>
     * </p>
     *
     * @return CostingRelevncy
     */
    @SerializedName( "ItemIsCostingRelevantSecondary" )
    @JsonProperty( "ItemIsCostingRelevantSecondary" )
    @Nullable
    @ODataField( odataName = "ItemIsCostingRelevantSecondary" )
    private String itemIsCostingRelevantSecondary;
    /**
     * Use with available fluent helpers to apply the <b>ItemIsCostingRelevantSecondary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<String> ITEM_IS_COSTING_RELEVANT_SECONDARY =
        new ComparisonResultField<String>("ItemIsCostingRelevantSecondary");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>IsHeaderDeletePrimary</b>
     * </p>
     *
     * @return Deletion Ind.
     */
    @SerializedName( "IsHeaderDeletePrimary" )
    @JsonProperty( "IsHeaderDeletePrimary" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsHeaderDeletePrimary" )
    private Boolean isHeaderDeletePrimary;
    /**
     * Use with available fluent helpers to apply the <b>IsHeaderDeletePrimary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<Boolean> IS_HEADER_DELETE_PRIMARY =
        new ComparisonResultField<Boolean>("IsHeaderDeletePrimary");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>IsHeaderDeleteSecondary</b>
     * </p>
     *
     * @return Deletion Ind.
     */
    @SerializedName( "IsHeaderDeleteSecondary" )
    @JsonProperty( "IsHeaderDeleteSecondary" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsHeaderDeleteSecondary" )
    private Boolean isHeaderDeleteSecondary;
    /**
     * Use with available fluent helpers to apply the <b>IsHeaderDeleteSecondary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<Boolean> IS_HEADER_DELETE_SECONDARY =
        new ComparisonResultField<Boolean>("IsHeaderDeleteSecondary");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SpclProcurementTypePrimary</b>
     * </p>
     *
     * @return SpecProcurement
     */
    @SerializedName( "SpclProcurementTypePrimary" )
    @JsonProperty( "SpclProcurementTypePrimary" )
    @Nullable
    @ODataField( odataName = "SpclProcurementTypePrimary" )
    private String spclProcurementTypePrimary;
    /**
     * Use with available fluent helpers to apply the <b>SpclProcurementTypePrimary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<String> SPCL_PROCUREMENT_TYPE_PRIMARY =
        new ComparisonResultField<String>("SpclProcurementTypePrimary");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MatlIsConfigurablePrimary</b>
     * </p>
     *
     * @return Configurable
     */
    @SerializedName( "MatlIsConfigurablePrimary" )
    @JsonProperty( "MatlIsConfigurablePrimary" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "MatlIsConfigurablePrimary" )
    private Boolean matlIsConfigurablePrimary;
    /**
     * Use with available fluent helpers to apply the <b>MatlIsConfigurablePrimary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<Boolean> MATL_IS_CONFIGURABLE_PRIMARY =
        new ComparisonResultField<Boolean>("MatlIsConfigurablePrimary");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsMaterialProvisionPrimary</b>
     * </p>
     *
     * @return Mat. Prov. Ind.
     */
    @SerializedName( "IsMaterialProvisionPrimary" )
    @JsonProperty( "IsMaterialProvisionPrimary" )
    @Nullable
    @ODataField( odataName = "IsMaterialProvisionPrimary" )
    private String isMaterialProvisionPrimary;
    /**
     * Use with available fluent helpers to apply the <b>IsMaterialProvisionPrimary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<String> IS_MATERIAL_PROVISION_PRIMARY =
        new ComparisonResultField<String>("IsMaterialProvisionPrimary");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>IsCADPrimary</b>
     * </p>
     *
     * @return CAD Indicator
     */
    @SerializedName( "IsCADPrimary" )
    @JsonProperty( "IsCADPrimary" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsCADPrimary" )
    private Boolean isCADPrimary;
    /**
     * Use with available fluent helpers to apply the <b>IsCADPrimary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<Boolean> IS_CAD_PRIMARY =
        new ComparisonResultField<Boolean>("IsCADPrimary");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>LeadTimeOffsetPrimary</b>
     * </p>
     *
     * @return Lead-tm offset
     */
    @SerializedName( "LeadTimeOffsetPrimary" )
    @JsonProperty( "LeadTimeOffsetPrimary" )
    @Nullable
    @ODataField( odataName = "LeadTimeOffsetPrimary" )
    private BigDecimal leadTimeOffsetPrimary;
    /**
     * Use with available fluent helpers to apply the <b>LeadTimeOffsetPrimary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<BigDecimal> LEAD_TIME_OFFSET_PRIMARY =
        new ComparisonResultField<BigDecimal>("LeadTimeOffsetPrimary");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGrouppPimary</b>
     * </p>
     *
     * @return Purch. Group
     */
    @SerializedName( "PurchasingGrouppPimary" )
    @JsonProperty( "PurchasingGrouppPimary" )
    @Nullable
    @ODataField( odataName = "PurchasingGrouppPimary" )
    private String purchasingGrouppPimary;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingGrouppPimary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<String> PURCHASING_GROUPP_PIMARY =
        new ComparisonResultField<String>("PurchasingGrouppPimary");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>DelivDurationInDaysPrimary</b>
     * </p>
     *
     * @return Del time (days)
     */
    @SerializedName( "DelivDurationInDaysPrimary" )
    @JsonProperty( "DelivDurationInDaysPrimary" )
    @Nullable
    @ODataField( odataName = "DelivDurationInDaysPrimary" )
    private BigDecimal delivDurationInDaysPrimary;
    /**
     * Use with available fluent helpers to apply the <b>DelivDurationInDaysPrimary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<BigDecimal> DELIV_DURATION_IN_DAYS_PRIMARY =
        new ComparisonResultField<BigDecimal>("DelivDurationInDaysPrimary");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplierPrimary</b>
     * </p>
     *
     * @return Supplier
     */
    @SerializedName( "SupplierPrimary" )
    @JsonProperty( "SupplierPrimary" )
    @Nullable
    @ODataField( odataName = "SupplierPrimary" )
    private String supplierPrimary;
    /**
     * Use with available fluent helpers to apply the <b>SupplierPrimary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<String> SUPPLIER_PRIMARY =
        new ComparisonResultField<String>("SupplierPrimary");
    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemPricePrimary</b>
     * </p>
     *
     * @return Price
     */
    @SerializedName( "BOMItemPricePrimary" )
    @JsonProperty( "BOMItemPricePrimary" )
    @Nullable
    @ODataField( odataName = "BOMItemPricePrimary" )
    private BigDecimal bOMItemPricePrimary;
    /**
     * Use with available fluent helpers to apply the <b>BOMItemPricePrimary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<BigDecimal> BOM_ITEM_PRICE_PRIMARY =
        new ComparisonResultField<BigDecimal>("BOMItemPricePrimary");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemPriceUnitPrimary</b>
     * </p>
     *
     * @return Currency
     */
    @SerializedName( "BOMItemPriceUnitPrimary" )
    @JsonProperty( "BOMItemPriceUnitPrimary" )
    @Nullable
    @ODataField( odataName = "BOMItemPriceUnitPrimary" )
    private String bOMItemPriceUnitPrimary;
    /**
     * Use with available fluent helpers to apply the <b>BOMItemPriceUnitPrimary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<String> BOM_ITEM_PRICE_UNIT_PRIMARY =
        new ComparisonResultField<String>("BOMItemPriceUnitPrimary");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NmbrOfVarblSizeItemPrimary</b>
     * </p>
     *
     * @return Number Required
     */
    @SerializedName( "NmbrOfVarblSizeItemPrimary" )
    @JsonProperty( "NmbrOfVarblSizeItemPrimary" )
    @Nullable
    @ODataField( odataName = "NmbrOfVarblSizeItemPrimary" )
    private BigDecimal nmbrOfVarblSizeItemPrimary;
    /**
     * Use with available fluent helpers to apply the <b>NmbrOfVarblSizeItemPrimary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<BigDecimal> NMBR_OF_VARBL_SIZE_ITEM_PRIMARY =
        new ComparisonResultField<BigDecimal>("NmbrOfVarblSizeItemPrimary");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Size1Primary</b>
     * </p>
     *
     * @return Size 1
     */
    @SerializedName( "Size1Primary" )
    @JsonProperty( "Size1Primary" )
    @Nullable
    @ODataField( odataName = "Size1Primary" )
    private BigDecimal size1Primary;
    /**
     * Use with available fluent helpers to apply the <b>Size1Primary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<BigDecimal> SIZE1_PRIMARY =
        new ComparisonResultField<BigDecimal>("Size1Primary");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Size2Primary</b>
     * </p>
     *
     * @return Size 2
     */
    @SerializedName( "Size2Primary" )
    @JsonProperty( "Size2Primary" )
    @Nullable
    @ODataField( odataName = "Size2Primary" )
    private BigDecimal size2Primary;
    /**
     * Use with available fluent helpers to apply the <b>Size2Primary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<BigDecimal> SIZE2_PRIMARY =
        new ComparisonResultField<BigDecimal>("Size2Primary");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Size3Primary</b>
     * </p>
     *
     * @return Size 3
     */
    @SerializedName( "Size3Primary" )
    @JsonProperty( "Size3Primary" )
    @Nullable
    @ODataField( odataName = "Size3Primary" )
    private BigDecimal size3Primary;
    /**
     * Use with available fluent helpers to apply the <b>Size3Primary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<BigDecimal> SIZE3_PRIMARY =
        new ComparisonResultField<BigDecimal>("Size3Primary");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>QtyVariableSizeItemPrimary</b>
     * </p>
     *
     * @return VSI Quantity
     */
    @SerializedName( "QtyVariableSizeItemPrimary" )
    @JsonProperty( "QtyVariableSizeItemPrimary" )
    @Nullable
    @ODataField( odataName = "QtyVariableSizeItemPrimary" )
    private BigDecimal qtyVariableSizeItemPrimary;
    /**
     * Use with available fluent helpers to apply the <b>QtyVariableSizeItemPrimary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<BigDecimal> QTY_VARIABLE_SIZE_ITEM_PRIMARY =
        new ComparisonResultField<BigDecimal>("QtyVariableSizeItemPrimary");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FormulaKeyPrimary</b>
     * </p>
     *
     * @return Formula key
     */
    @SerializedName( "FormulaKeyPrimary" )
    @JsonProperty( "FormulaKeyPrimary" )
    @Nullable
    @ODataField( odataName = "FormulaKeyPrimary" )
    private String formulaKeyPrimary;
    /**
     * Use with available fluent helpers to apply the <b>FormulaKeyPrimary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<String> FORMULA_KEY_PRIMARY =
        new ComparisonResultField<String>("FormulaKeyPrimary");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>GoodsReceiptDurationPrimary</b>
     * </p>
     *
     * @return GR proc. time
     */
    @SerializedName( "GoodsReceiptDurationPrimary" )
    @JsonProperty( "GoodsReceiptDurationPrimary" )
    @Nullable
    @ODataField( odataName = "GoodsReceiptDurationPrimary" )
    private BigDecimal goodsReceiptDurationPrimary;
    /**
     * Use with available fluent helpers to apply the <b>GoodsReceiptDurationPrimary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<BigDecimal> GOODS_RECEIPT_DURATION_PRIMARY =
        new ComparisonResultField<BigDecimal>("GoodsReceiptDurationPrimary");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroupPrimary</b>
     * </p>
     *
     * @return Material Group
     */
    @SerializedName( "MaterialGroupPrimary" )
    @JsonProperty( "MaterialGroupPrimary" )
    @Nullable
    @ODataField( odataName = "MaterialGroupPrimary" )
    private String materialGroupPrimary;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroupPrimary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<String> MATERIAL_GROUP_PRIMARY =
        new ComparisonResultField<String>("MaterialGroupPrimary");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SpclProcurementTypeSecondary</b>
     * </p>
     *
     * @return SpecProcurement
     */
    @SerializedName( "SpclProcurementTypeSecondary" )
    @JsonProperty( "SpclProcurementTypeSecondary" )
    @Nullable
    @ODataField( odataName = "SpclProcurementTypeSecondary" )
    private String spclProcurementTypeSecondary;
    /**
     * Use with available fluent helpers to apply the <b>SpclProcurementTypeSecondary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<String> SPCL_PROCUREMENT_TYPE_SECONDARY =
        new ComparisonResultField<String>("SpclProcurementTypeSecondary");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MatlIsConfigurableSecondary</b>
     * </p>
     *
     * @return Configurable
     */
    @SerializedName( "MatlIsConfigurableSecondary" )
    @JsonProperty( "MatlIsConfigurableSecondary" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "MatlIsConfigurableSecondary" )
    private Boolean matlIsConfigurableSecondary;
    /**
     * Use with available fluent helpers to apply the <b>MatlIsConfigurableSecondary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<Boolean> MATL_IS_CONFIGURABLE_SECONDARY =
        new ComparisonResultField<Boolean>("MatlIsConfigurableSecondary");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsMaterialProvisionSecondary</b>
     * </p>
     *
     * @return Mat. Prov. Ind.
     */
    @SerializedName( "IsMaterialProvisionSecondary" )
    @JsonProperty( "IsMaterialProvisionSecondary" )
    @Nullable
    @ODataField( odataName = "IsMaterialProvisionSecondary" )
    private String isMaterialProvisionSecondary;
    /**
     * Use with available fluent helpers to apply the <b>IsMaterialProvisionSecondary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<String> IS_MATERIAL_PROVISION_SECONDARY =
        new ComparisonResultField<String>("IsMaterialProvisionSecondary");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>IsCADSecondary</b>
     * </p>
     *
     * @return CAD Indicator
     */
    @SerializedName( "IsCADSecondary" )
    @JsonProperty( "IsCADSecondary" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsCADSecondary" )
    private Boolean isCADSecondary;
    /**
     * Use with available fluent helpers to apply the <b>IsCADSecondary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<Boolean> IS_CAD_SECONDARY =
        new ComparisonResultField<Boolean>("IsCADSecondary");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>LeadTimeOffsetSecondary</b>
     * </p>
     *
     * @return Lead-tm offset
     */
    @SerializedName( "LeadTimeOffsetSecondary" )
    @JsonProperty( "LeadTimeOffsetSecondary" )
    @Nullable
    @ODataField( odataName = "LeadTimeOffsetSecondary" )
    private BigDecimal leadTimeOffsetSecondary;
    /**
     * Use with available fluent helpers to apply the <b>LeadTimeOffsetSecondary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<BigDecimal> LEAD_TIME_OFFSET_SECONDARY =
        new ComparisonResultField<BigDecimal>("LeadTimeOffsetSecondary");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroupSecondary</b>
     * </p>
     *
     * @return Purch. Group
     */
    @SerializedName( "PurchasingGroupSecondary" )
    @JsonProperty( "PurchasingGroupSecondary" )
    @Nullable
    @ODataField( odataName = "PurchasingGroupSecondary" )
    private String purchasingGroupSecondary;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingGroupSecondary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<String> PURCHASING_GROUP_SECONDARY =
        new ComparisonResultField<String>("PurchasingGroupSecondary");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>DelivDurationInDaysSecondary</b>
     * </p>
     *
     * @return Del time (days)
     */
    @SerializedName( "DelivDurationInDaysSecondary" )
    @JsonProperty( "DelivDurationInDaysSecondary" )
    @Nullable
    @ODataField( odataName = "DelivDurationInDaysSecondary" )
    private BigDecimal delivDurationInDaysSecondary;
    /**
     * Use with available fluent helpers to apply the <b>DelivDurationInDaysSecondary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<BigDecimal> DELIV_DURATION_IN_DAYS_SECONDARY =
        new ComparisonResultField<BigDecimal>("DelivDurationInDaysSecondary");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplierSecondary</b>
     * </p>
     *
     * @return Supplier
     */
    @SerializedName( "SupplierSecondary" )
    @JsonProperty( "SupplierSecondary" )
    @Nullable
    @ODataField( odataName = "SupplierSecondary" )
    private String supplierSecondary;
    /**
     * Use with available fluent helpers to apply the <b>SupplierSecondary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<String> SUPPLIER_SECONDARY =
        new ComparisonResultField<String>("SupplierSecondary");
    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemPriceSecondary</b>
     * </p>
     *
     * @return Price
     */
    @SerializedName( "BOMItemPriceSecondary" )
    @JsonProperty( "BOMItemPriceSecondary" )
    @Nullable
    @ODataField( odataName = "BOMItemPriceSecondary" )
    private BigDecimal bOMItemPriceSecondary;
    /**
     * Use with available fluent helpers to apply the <b>BOMItemPriceSecondary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<BigDecimal> BOM_ITEM_PRICE_SECONDARY =
        new ComparisonResultField<BigDecimal>("BOMItemPriceSecondary");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>BomItemPriceUnitSecondary</b>
     * </p>
     *
     * @return Currency
     */
    @SerializedName( "BomItemPriceUnitSecondary" )
    @JsonProperty( "BomItemPriceUnitSecondary" )
    @Nullable
    @ODataField( odataName = "BomItemPriceUnitSecondary" )
    private String bomItemPriceUnitSecondary;
    /**
     * Use with available fluent helpers to apply the <b>BomItemPriceUnitSecondary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<String> BOM_ITEM_PRICE_UNIT_SECONDARY =
        new ComparisonResultField<String>("BomItemPriceUnitSecondary");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NmbrOfVarblSizeItemSecondary</b>
     * </p>
     *
     * @return Number Required
     */
    @SerializedName( "NmbrOfVarblSizeItemSecondary" )
    @JsonProperty( "NmbrOfVarblSizeItemSecondary" )
    @Nullable
    @ODataField( odataName = "NmbrOfVarblSizeItemSecondary" )
    private BigDecimal nmbrOfVarblSizeItemSecondary;
    /**
     * Use with available fluent helpers to apply the <b>NmbrOfVarblSizeItemSecondary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<BigDecimal> NMBR_OF_VARBL_SIZE_ITEM_SECONDARY =
        new ComparisonResultField<BigDecimal>("NmbrOfVarblSizeItemSecondary");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Size1Secondary</b>
     * </p>
     *
     * @return Size 1
     */
    @SerializedName( "Size1Secondary" )
    @JsonProperty( "Size1Secondary" )
    @Nullable
    @ODataField( odataName = "Size1Secondary" )
    private BigDecimal size1Secondary;
    /**
     * Use with available fluent helpers to apply the <b>Size1Secondary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<BigDecimal> SIZE1_SECONDARY =
        new ComparisonResultField<BigDecimal>("Size1Secondary");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Size2Secondary</b>
     * </p>
     *
     * @return Size 2
     */
    @SerializedName( "Size2Secondary" )
    @JsonProperty( "Size2Secondary" )
    @Nullable
    @ODataField( odataName = "Size2Secondary" )
    private BigDecimal size2Secondary;
    /**
     * Use with available fluent helpers to apply the <b>Size2Secondary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<BigDecimal> SIZE2_SECONDARY =
        new ComparisonResultField<BigDecimal>("Size2Secondary");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Size3Secondary</b>
     * </p>
     *
     * @return Size 3
     */
    @SerializedName( "Size3Secondary" )
    @JsonProperty( "Size3Secondary" )
    @Nullable
    @ODataField( odataName = "Size3Secondary" )
    private BigDecimal size3Secondary;
    /**
     * Use with available fluent helpers to apply the <b>Size3Secondary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<BigDecimal> SIZE3_SECONDARY =
        new ComparisonResultField<BigDecimal>("Size3Secondary");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>QtyVariableSizeItemSecondary</b>
     * </p>
     *
     * @return VSI Quantity
     */
    @SerializedName( "QtyVariableSizeItemSecondary" )
    @JsonProperty( "QtyVariableSizeItemSecondary" )
    @Nullable
    @ODataField( odataName = "QtyVariableSizeItemSecondary" )
    private BigDecimal qtyVariableSizeItemSecondary;
    /**
     * Use with available fluent helpers to apply the <b>QtyVariableSizeItemSecondary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<BigDecimal> QTY_VARIABLE_SIZE_ITEM_SECONDARY =
        new ComparisonResultField<BigDecimal>("QtyVariableSizeItemSecondary");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FormulaKeySecondary</b>
     * </p>
     *
     * @return Formula key
     */
    @SerializedName( "FormulaKeySecondary" )
    @JsonProperty( "FormulaKeySecondary" )
    @Nullable
    @ODataField( odataName = "FormulaKeySecondary" )
    private String formulaKeySecondary;
    /**
     * Use with available fluent helpers to apply the <b>FormulaKeySecondary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<String> FORMULA_KEY_SECONDARY =
        new ComparisonResultField<String>("FormulaKeySecondary");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>GoodsReceiptDurationSecondary</b>
     * </p>
     *
     * @return GR proc. time
     */
    @SerializedName( "GoodsReceiptDurationSecondary" )
    @JsonProperty( "GoodsReceiptDurationSecondary" )
    @Nullable
    @ODataField( odataName = "GoodsReceiptDurationSecondary" )
    private BigDecimal goodsReceiptDurationSecondary;
    /**
     * Use with available fluent helpers to apply the <b>GoodsReceiptDurationSecondary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<BigDecimal> GOODS_RECEIPT_DURATION_SECONDARY =
        new ComparisonResultField<BigDecimal>("GoodsReceiptDurationSecondary");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroupSecondary</b>
     * </p>
     *
     * @return Material Group
     */
    @SerializedName( "MaterialGroupSecondary" )
    @JsonProperty( "MaterialGroupSecondary" )
    @Nullable
    @ODataField( odataName = "MaterialGroupSecondary" )
    private String materialGroupSecondary;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroupSecondary</b> field to query operations.
     *
     */
    public final static ComparisonResultField<String> MATERIAL_GROUP_SECONDARY =
        new ComparisonResultField<String>("MaterialGroupSecondary");

    @Nonnull
    @Override
    public Class<ComparisonResult> getType()
    {
        return ComparisonResult.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>BOMComparisonUUID</b>
     * </p>
     *
     * @param bOMComparisonUUID
     *            GUID
     */
    public void setBOMComparisonUUID( @Nullable final byte[] bOMComparisonUUID )
    {
        rememberChangedField("BOMComparisonUUID", this.bOMComparisonUUID);
        this.bOMComparisonUUID = bOMComparisonUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BOMComponentPrimary</b>
     * </p>
     *
     * @param bOMComponentPrimary
     *            Component
     */
    public void setBOMComponentPrimary( @Nullable final String bOMComponentPrimary )
    {
        rememberChangedField("BOMComponentPrimary", this.bOMComponentPrimary);
        this.bOMComponentPrimary = bOMComponentPrimary;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BOMComponentSecondary</b>
     * </p>
     *
     * @param bOMComponentSecondary
     *            Component
     */
    public void setBOMComponentSecondary( @Nullable final String bOMComponentSecondary )
    {
        rememberChangedField("BOMComponentSecondary", this.bOMComponentSecondary);
        this.bOMComponentSecondary = bOMComponentSecondary;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BOMComparisonResult</b>
     * </p>
     *
     * @param bOMComparisonResult
     *            Comparson Result
     */
    public void setBOMComparisonResult( @Nullable final String bOMComparisonResult )
    {
        rememberChangedField("BOMComparisonResult", this.bOMComparisonResult);
        this.bOMComparisonResult = bOMComparisonResult;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialTypePrimary</b>
     * </p>
     *
     * @param materialTypePrimary
     *            Material Type
     */
    public void setMaterialTypePrimary( @Nullable final String materialTypePrimary )
    {
        rememberChangedField("MaterialTypePrimary", this.materialTypePrimary);
        this.materialTypePrimary = materialTypePrimary;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialTypeSecondary</b>
     * </p>
     *
     * @param materialTypeSecondary
     *            Material Type
     */
    public void setMaterialTypeSecondary( @Nullable final String materialTypeSecondary )
    {
        rememberChangedField("MaterialTypeSecondary", this.materialTypeSecondary);
        this.materialTypeSecondary = materialTypeSecondary;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemQuantityPrimary</b>
     * </p>
     *
     * @param bOMItemQuantityPrimary
     *            Quantity
     */
    public void setBOMItemQuantityPrimary( @Nullable final BigDecimal bOMItemQuantityPrimary )
    {
        rememberChangedField("BOMItemQuantityPrimary", this.bOMItemQuantityPrimary);
        this.bOMItemQuantityPrimary = bOMItemQuantityPrimary;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemQuantitySecondary</b>
     * </p>
     *
     * @param bOMItemQuantitySecondary
     *            Quantity
     */
    public void setBOMItemQuantitySecondary( @Nullable final BigDecimal bOMItemQuantitySecondary )
    {
        rememberChangedField("BOMItemQuantitySecondary", this.bOMItemQuantitySecondary);
        this.bOMItemQuantitySecondary = bOMItemQuantitySecondary;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemCategoryPrimary</b>
     * </p>
     *
     * @param bOMItemCategoryPrimary
     *            Item Category
     */
    public void setBOMItemCategoryPrimary( @Nullable final String bOMItemCategoryPrimary )
    {
        rememberChangedField("BOMItemCategoryPrimary", this.bOMItemCategoryPrimary);
        this.bOMItemCategoryPrimary = bOMItemCategoryPrimary;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemCategorySecondary</b>
     * </p>
     *
     * @param bOMItemCategorySecondary
     *            Item Category
     */
    public void setBOMItemCategorySecondary( @Nullable final String bOMItemCategorySecondary )
    {
        rememberChangedField("BOMItemCategorySecondary", this.bOMItemCategorySecondary);
        this.bOMItemCategorySecondary = bOMItemCategorySecondary;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>CompleteMaintStatusPrimary</b>
     * </p>
     *
     * @param completeMaintStatusPrimary
     *            Complete status
     */
    public void setCompleteMaintStatusPrimary( @Nullable final String completeMaintStatusPrimary )
    {
        rememberChangedField("CompleteMaintStatusPrimary", this.completeMaintStatusPrimary);
        this.completeMaintStatusPrimary = completeMaintStatusPrimary;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>CompleteMaintStatusSecondary</b>
     * </p>
     *
     * @param completeMaintStatusSecondary
     *            Complete status
     */
    public void setCompleteMaintStatusSecondary( @Nullable final String completeMaintStatusSecondary )
    {
        rememberChangedField("CompleteMaintStatusSecondary", this.completeMaintStatusSecondary);
        this.completeMaintStatusSecondary = completeMaintStatusSecondary;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemDescriptionPrimary</b>
     * </p>
     *
     * @param bOMItemDescriptionPrimary
     *            Description
     */
    public void setBOMItemDescriptionPrimary( @Nullable final String bOMItemDescriptionPrimary )
    {
        rememberChangedField("BOMItemDescriptionPrimary", this.bOMItemDescriptionPrimary);
        this.bOMItemDescriptionPrimary = bOMItemDescriptionPrimary;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemDescriptionSecondary</b>
     * </p>
     *
     * @param bOMItemDescriptionSecondary
     *            Description
     */
    public void setBOMItemDescriptionSecondary( @Nullable final String bOMItemDescriptionSecondary )
    {
        rememberChangedField("BOMItemDescriptionSecondary", this.bOMItemDescriptionSecondary);
        this.bOMItemDescriptionSecondary = bOMItemDescriptionSecondary;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BOMHeaderBaseUnitPrimary</b>
     * </p>
     *
     * @param bOMHeaderBaseUnitPrimary
     *            Base Unit
     */
    public void setBOMHeaderBaseUnitPrimary( @Nullable final String bOMHeaderBaseUnitPrimary )
    {
        rememberChangedField("BOMHeaderBaseUnitPrimary", this.bOMHeaderBaseUnitPrimary);
        this.bOMHeaderBaseUnitPrimary = bOMHeaderBaseUnitPrimary;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BOMHeaderBaseUnitSecondary</b>
     * </p>
     *
     * @param bOMHeaderBaseUnitSecondary
     *            Base Unit
     */
    public void setBOMHeaderBaseUnitSecondary( @Nullable final String bOMHeaderBaseUnitSecondary )
    {
        rememberChangedField("BOMHeaderBaseUnitSecondary", this.bOMHeaderBaseUnitSecondary);
        this.bOMHeaderBaseUnitSecondary = bOMHeaderBaseUnitSecondary;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemUnitPrimary</b>
     * </p>
     *
     * @param bOMItemUnitPrimary
     *            Component UoM
     */
    public void setBOMItemUnitPrimary( @Nullable final String bOMItemUnitPrimary )
    {
        rememberChangedField("BOMItemUnitPrimary", this.bOMItemUnitPrimary);
        this.bOMItemUnitPrimary = bOMItemUnitPrimary;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemUnitSecondary</b>
     * </p>
     *
     * @param bOMItemUnitSecondary
     *            Component UoM
     */
    public void setBOMItemUnitSecondary( @Nullable final String bOMItemUnitSecondary )
    {
        rememberChangedField("BOMItemUnitSecondary", this.bOMItemUnitSecondary);
        this.bOMItemUnitSecondary = bOMItemUnitSecondary;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>IsProductionRelevantPrimary</b>
     * </p>
     *
     * @param isProductionRelevantPrimary
     *            Production
     */
    public void setIsProductionRelevantPrimary( @Nullable final Boolean isProductionRelevantPrimary )
    {
        rememberChangedField("IsProductionRelevantPrimary", this.isProductionRelevantPrimary);
        this.isProductionRelevantPrimary = isProductionRelevantPrimary;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>IsProductionRelevantSecond</b>
     * </p>
     *
     * @param isProductionRelevantSecond
     *            Production
     */
    public void setIsProductionRelevantSecond( @Nullable final Boolean isProductionRelevantSecond )
    {
        rememberChangedField("IsProductionRelevantSecond", this.isProductionRelevantSecond);
        this.isProductionRelevantSecond = isProductionRelevantSecond;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ItemIsCostingRelevantPrimary</b>
     * </p>
     *
     * @param itemIsCostingRelevantPrimary
     *            CostingRelevncy
     */
    public void setItemIsCostingRelevantPrimary( @Nullable final String itemIsCostingRelevantPrimary )
    {
        rememberChangedField("ItemIsCostingRelevantPrimary", this.itemIsCostingRelevantPrimary);
        this.itemIsCostingRelevantPrimary = itemIsCostingRelevantPrimary;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ItemIsCostingRelevantSecondary</b>
     * </p>
     *
     * @param itemIsCostingRelevantSecondary
     *            CostingRelevncy
     */
    public void setItemIsCostingRelevantSecondary( @Nullable final String itemIsCostingRelevantSecondary )
    {
        rememberChangedField("ItemIsCostingRelevantSecondary", this.itemIsCostingRelevantSecondary);
        this.itemIsCostingRelevantSecondary = itemIsCostingRelevantSecondary;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>IsHeaderDeletePrimary</b>
     * </p>
     *
     * @param isHeaderDeletePrimary
     *            Deletion Ind.
     */
    public void setIsHeaderDeletePrimary( @Nullable final Boolean isHeaderDeletePrimary )
    {
        rememberChangedField("IsHeaderDeletePrimary", this.isHeaderDeletePrimary);
        this.isHeaderDeletePrimary = isHeaderDeletePrimary;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>IsHeaderDeleteSecondary</b>
     * </p>
     *
     * @param isHeaderDeleteSecondary
     *            Deletion Ind.
     */
    public void setIsHeaderDeleteSecondary( @Nullable final Boolean isHeaderDeleteSecondary )
    {
        rememberChangedField("IsHeaderDeleteSecondary", this.isHeaderDeleteSecondary);
        this.isHeaderDeleteSecondary = isHeaderDeleteSecondary;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SpclProcurementTypePrimary</b>
     * </p>
     *
     * @param spclProcurementTypePrimary
     *            SpecProcurement
     */
    public void setSpclProcurementTypePrimary( @Nullable final String spclProcurementTypePrimary )
    {
        rememberChangedField("SpclProcurementTypePrimary", this.spclProcurementTypePrimary);
        this.spclProcurementTypePrimary = spclProcurementTypePrimary;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MatlIsConfigurablePrimary</b>
     * </p>
     *
     * @param matlIsConfigurablePrimary
     *            Configurable
     */
    public void setMatlIsConfigurablePrimary( @Nullable final Boolean matlIsConfigurablePrimary )
    {
        rememberChangedField("MatlIsConfigurablePrimary", this.matlIsConfigurablePrimary);
        this.matlIsConfigurablePrimary = matlIsConfigurablePrimary;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsMaterialProvisionPrimary</b>
     * </p>
     *
     * @param isMaterialProvisionPrimary
     *            Mat. Prov. Ind.
     */
    public void setIsMaterialProvisionPrimary( @Nullable final String isMaterialProvisionPrimary )
    {
        rememberChangedField("IsMaterialProvisionPrimary", this.isMaterialProvisionPrimary);
        this.isMaterialProvisionPrimary = isMaterialProvisionPrimary;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>IsCADPrimary</b>
     * </p>
     *
     * @param isCADPrimary
     *            CAD Indicator
     */
    public void setIsCADPrimary( @Nullable final Boolean isCADPrimary )
    {
        rememberChangedField("IsCADPrimary", this.isCADPrimary);
        this.isCADPrimary = isCADPrimary;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>LeadTimeOffsetPrimary</b>
     * </p>
     *
     * @param leadTimeOffsetPrimary
     *            Lead-tm offset
     */
    public void setLeadTimeOffsetPrimary( @Nullable final BigDecimal leadTimeOffsetPrimary )
    {
        rememberChangedField("LeadTimeOffsetPrimary", this.leadTimeOffsetPrimary);
        this.leadTimeOffsetPrimary = leadTimeOffsetPrimary;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGrouppPimary</b>
     * </p>
     *
     * @param purchasingGrouppPimary
     *            Purch. Group
     */
    public void setPurchasingGrouppPimary( @Nullable final String purchasingGrouppPimary )
    {
        rememberChangedField("PurchasingGrouppPimary", this.purchasingGrouppPimary);
        this.purchasingGrouppPimary = purchasingGrouppPimary;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>DelivDurationInDaysPrimary</b>
     * </p>
     *
     * @param delivDurationInDaysPrimary
     *            Del time (days)
     */
    public void setDelivDurationInDaysPrimary( @Nullable final BigDecimal delivDurationInDaysPrimary )
    {
        rememberChangedField("DelivDurationInDaysPrimary", this.delivDurationInDaysPrimary);
        this.delivDurationInDaysPrimary = delivDurationInDaysPrimary;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplierPrimary</b>
     * </p>
     *
     * @param supplierPrimary
     *            Supplier
     */
    public void setSupplierPrimary( @Nullable final String supplierPrimary )
    {
        rememberChangedField("SupplierPrimary", this.supplierPrimary);
        this.supplierPrimary = supplierPrimary;
    }

    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemPricePrimary</b>
     * </p>
     *
     * @param bOMItemPricePrimary
     *            Price
     */
    public void setBOMItemPricePrimary( @Nullable final BigDecimal bOMItemPricePrimary )
    {
        rememberChangedField("BOMItemPricePrimary", this.bOMItemPricePrimary);
        this.bOMItemPricePrimary = bOMItemPricePrimary;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemPriceUnitPrimary</b>
     * </p>
     *
     * @param bOMItemPriceUnitPrimary
     *            Currency
     */
    public void setBOMItemPriceUnitPrimary( @Nullable final String bOMItemPriceUnitPrimary )
    {
        rememberChangedField("BOMItemPriceUnitPrimary", this.bOMItemPriceUnitPrimary);
        this.bOMItemPriceUnitPrimary = bOMItemPriceUnitPrimary;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NmbrOfVarblSizeItemPrimary</b>
     * </p>
     *
     * @param nmbrOfVarblSizeItemPrimary
     *            Number Required
     */
    public void setNmbrOfVarblSizeItemPrimary( @Nullable final BigDecimal nmbrOfVarblSizeItemPrimary )
    {
        rememberChangedField("NmbrOfVarblSizeItemPrimary", this.nmbrOfVarblSizeItemPrimary);
        this.nmbrOfVarblSizeItemPrimary = nmbrOfVarblSizeItemPrimary;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Size1Primary</b>
     * </p>
     *
     * @param size1Primary
     *            Size 1
     */
    public void setSize1Primary( @Nullable final BigDecimal size1Primary )
    {
        rememberChangedField("Size1Primary", this.size1Primary);
        this.size1Primary = size1Primary;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Size2Primary</b>
     * </p>
     *
     * @param size2Primary
     *            Size 2
     */
    public void setSize2Primary( @Nullable final BigDecimal size2Primary )
    {
        rememberChangedField("Size2Primary", this.size2Primary);
        this.size2Primary = size2Primary;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Size3Primary</b>
     * </p>
     *
     * @param size3Primary
     *            Size 3
     */
    public void setSize3Primary( @Nullable final BigDecimal size3Primary )
    {
        rememberChangedField("Size3Primary", this.size3Primary);
        this.size3Primary = size3Primary;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>QtyVariableSizeItemPrimary</b>
     * </p>
     *
     * @param qtyVariableSizeItemPrimary
     *            VSI Quantity
     */
    public void setQtyVariableSizeItemPrimary( @Nullable final BigDecimal qtyVariableSizeItemPrimary )
    {
        rememberChangedField("QtyVariableSizeItemPrimary", this.qtyVariableSizeItemPrimary);
        this.qtyVariableSizeItemPrimary = qtyVariableSizeItemPrimary;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FormulaKeyPrimary</b>
     * </p>
     *
     * @param formulaKeyPrimary
     *            Formula key
     */
    public void setFormulaKeyPrimary( @Nullable final String formulaKeyPrimary )
    {
        rememberChangedField("FormulaKeyPrimary", this.formulaKeyPrimary);
        this.formulaKeyPrimary = formulaKeyPrimary;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>GoodsReceiptDurationPrimary</b>
     * </p>
     *
     * @param goodsReceiptDurationPrimary
     *            GR proc. time
     */
    public void setGoodsReceiptDurationPrimary( @Nullable final BigDecimal goodsReceiptDurationPrimary )
    {
        rememberChangedField("GoodsReceiptDurationPrimary", this.goodsReceiptDurationPrimary);
        this.goodsReceiptDurationPrimary = goodsReceiptDurationPrimary;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroupPrimary</b>
     * </p>
     *
     * @param materialGroupPrimary
     *            Material Group
     */
    public void setMaterialGroupPrimary( @Nullable final String materialGroupPrimary )
    {
        rememberChangedField("MaterialGroupPrimary", this.materialGroupPrimary);
        this.materialGroupPrimary = materialGroupPrimary;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SpclProcurementTypeSecondary</b>
     * </p>
     *
     * @param spclProcurementTypeSecondary
     *            SpecProcurement
     */
    public void setSpclProcurementTypeSecondary( @Nullable final String spclProcurementTypeSecondary )
    {
        rememberChangedField("SpclProcurementTypeSecondary", this.spclProcurementTypeSecondary);
        this.spclProcurementTypeSecondary = spclProcurementTypeSecondary;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MatlIsConfigurableSecondary</b>
     * </p>
     *
     * @param matlIsConfigurableSecondary
     *            Configurable
     */
    public void setMatlIsConfigurableSecondary( @Nullable final Boolean matlIsConfigurableSecondary )
    {
        rememberChangedField("MatlIsConfigurableSecondary", this.matlIsConfigurableSecondary);
        this.matlIsConfigurableSecondary = matlIsConfigurableSecondary;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsMaterialProvisionSecondary</b>
     * </p>
     *
     * @param isMaterialProvisionSecondary
     *            Mat. Prov. Ind.
     */
    public void setIsMaterialProvisionSecondary( @Nullable final String isMaterialProvisionSecondary )
    {
        rememberChangedField("IsMaterialProvisionSecondary", this.isMaterialProvisionSecondary);
        this.isMaterialProvisionSecondary = isMaterialProvisionSecondary;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>IsCADSecondary</b>
     * </p>
     *
     * @param isCADSecondary
     *            CAD Indicator
     */
    public void setIsCADSecondary( @Nullable final Boolean isCADSecondary )
    {
        rememberChangedField("IsCADSecondary", this.isCADSecondary);
        this.isCADSecondary = isCADSecondary;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>LeadTimeOffsetSecondary</b>
     * </p>
     *
     * @param leadTimeOffsetSecondary
     *            Lead-tm offset
     */
    public void setLeadTimeOffsetSecondary( @Nullable final BigDecimal leadTimeOffsetSecondary )
    {
        rememberChangedField("LeadTimeOffsetSecondary", this.leadTimeOffsetSecondary);
        this.leadTimeOffsetSecondary = leadTimeOffsetSecondary;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroupSecondary</b>
     * </p>
     *
     * @param purchasingGroupSecondary
     *            Purch. Group
     */
    public void setPurchasingGroupSecondary( @Nullable final String purchasingGroupSecondary )
    {
        rememberChangedField("PurchasingGroupSecondary", this.purchasingGroupSecondary);
        this.purchasingGroupSecondary = purchasingGroupSecondary;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>DelivDurationInDaysSecondary</b>
     * </p>
     *
     * @param delivDurationInDaysSecondary
     *            Del time (days)
     */
    public void setDelivDurationInDaysSecondary( @Nullable final BigDecimal delivDurationInDaysSecondary )
    {
        rememberChangedField("DelivDurationInDaysSecondary", this.delivDurationInDaysSecondary);
        this.delivDurationInDaysSecondary = delivDurationInDaysSecondary;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplierSecondary</b>
     * </p>
     *
     * @param supplierSecondary
     *            Supplier
     */
    public void setSupplierSecondary( @Nullable final String supplierSecondary )
    {
        rememberChangedField("SupplierSecondary", this.supplierSecondary);
        this.supplierSecondary = supplierSecondary;
    }

    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemPriceSecondary</b>
     * </p>
     *
     * @param bOMItemPriceSecondary
     *            Price
     */
    public void setBOMItemPriceSecondary( @Nullable final BigDecimal bOMItemPriceSecondary )
    {
        rememberChangedField("BOMItemPriceSecondary", this.bOMItemPriceSecondary);
        this.bOMItemPriceSecondary = bOMItemPriceSecondary;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>BomItemPriceUnitSecondary</b>
     * </p>
     *
     * @param bomItemPriceUnitSecondary
     *            Currency
     */
    public void setBomItemPriceUnitSecondary( @Nullable final String bomItemPriceUnitSecondary )
    {
        rememberChangedField("BomItemPriceUnitSecondary", this.bomItemPriceUnitSecondary);
        this.bomItemPriceUnitSecondary = bomItemPriceUnitSecondary;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NmbrOfVarblSizeItemSecondary</b>
     * </p>
     *
     * @param nmbrOfVarblSizeItemSecondary
     *            Number Required
     */
    public void setNmbrOfVarblSizeItemSecondary( @Nullable final BigDecimal nmbrOfVarblSizeItemSecondary )
    {
        rememberChangedField("NmbrOfVarblSizeItemSecondary", this.nmbrOfVarblSizeItemSecondary);
        this.nmbrOfVarblSizeItemSecondary = nmbrOfVarblSizeItemSecondary;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Size1Secondary</b>
     * </p>
     *
     * @param size1Secondary
     *            Size 1
     */
    public void setSize1Secondary( @Nullable final BigDecimal size1Secondary )
    {
        rememberChangedField("Size1Secondary", this.size1Secondary);
        this.size1Secondary = size1Secondary;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Size2Secondary</b>
     * </p>
     *
     * @param size2Secondary
     *            Size 2
     */
    public void setSize2Secondary( @Nullable final BigDecimal size2Secondary )
    {
        rememberChangedField("Size2Secondary", this.size2Secondary);
        this.size2Secondary = size2Secondary;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Size3Secondary</b>
     * </p>
     *
     * @param size3Secondary
     *            Size 3
     */
    public void setSize3Secondary( @Nullable final BigDecimal size3Secondary )
    {
        rememberChangedField("Size3Secondary", this.size3Secondary);
        this.size3Secondary = size3Secondary;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>QtyVariableSizeItemSecondary</b>
     * </p>
     *
     * @param qtyVariableSizeItemSecondary
     *            VSI Quantity
     */
    public void setQtyVariableSizeItemSecondary( @Nullable final BigDecimal qtyVariableSizeItemSecondary )
    {
        rememberChangedField("QtyVariableSizeItemSecondary", this.qtyVariableSizeItemSecondary);
        this.qtyVariableSizeItemSecondary = qtyVariableSizeItemSecondary;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FormulaKeySecondary</b>
     * </p>
     *
     * @param formulaKeySecondary
     *            Formula key
     */
    public void setFormulaKeySecondary( @Nullable final String formulaKeySecondary )
    {
        rememberChangedField("FormulaKeySecondary", this.formulaKeySecondary);
        this.formulaKeySecondary = formulaKeySecondary;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>GoodsReceiptDurationSecondary</b>
     * </p>
     *
     * @param goodsReceiptDurationSecondary
     *            GR proc. time
     */
    public void setGoodsReceiptDurationSecondary( @Nullable final BigDecimal goodsReceiptDurationSecondary )
    {
        rememberChangedField("GoodsReceiptDurationSecondary", this.goodsReceiptDurationSecondary);
        this.goodsReceiptDurationSecondary = goodsReceiptDurationSecondary;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroupSecondary</b>
     * </p>
     *
     * @param materialGroupSecondary
     *            Material Group
     */
    public void setMaterialGroupSecondary( @Nullable final String materialGroupSecondary )
    {
        rememberChangedField("MaterialGroupSecondary", this.materialGroupSecondary);
        this.materialGroupSecondary = materialGroupSecondary;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ComparisonResultSet";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BOMComparisonUUID", getBOMComparisonUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BOMComparisonUUID", getBOMComparisonUUID());
        values.put("BOMComponentPrimary", getBOMComponentPrimary());
        values.put("BOMComponentSecondary", getBOMComponentSecondary());
        values.put("BOMComparisonResult", getBOMComparisonResult());
        values.put("MaterialTypePrimary", getMaterialTypePrimary());
        values.put("MaterialTypeSecondary", getMaterialTypeSecondary());
        values.put("BOMItemQuantityPrimary", getBOMItemQuantityPrimary());
        values.put("BOMItemQuantitySecondary", getBOMItemQuantitySecondary());
        values.put("BOMItemCategoryPrimary", getBOMItemCategoryPrimary());
        values.put("BOMItemCategorySecondary", getBOMItemCategorySecondary());
        values.put("CompleteMaintStatusPrimary", getCompleteMaintStatusPrimary());
        values.put("CompleteMaintStatusSecondary", getCompleteMaintStatusSecondary());
        values.put("BOMItemDescriptionPrimary", getBOMItemDescriptionPrimary());
        values.put("BOMItemDescriptionSecondary", getBOMItemDescriptionSecondary());
        values.put("BOMHeaderBaseUnitPrimary", getBOMHeaderBaseUnitPrimary());
        values.put("BOMHeaderBaseUnitSecondary", getBOMHeaderBaseUnitSecondary());
        values.put("BOMItemUnitPrimary", getBOMItemUnitPrimary());
        values.put("BOMItemUnitSecondary", getBOMItemUnitSecondary());
        values.put("IsProductionRelevantPrimary", getIsProductionRelevantPrimary());
        values.put("IsProductionRelevantSecond", getIsProductionRelevantSecond());
        values.put("ItemIsCostingRelevantPrimary", getItemIsCostingRelevantPrimary());
        values.put("ItemIsCostingRelevantSecondary", getItemIsCostingRelevantSecondary());
        values.put("IsHeaderDeletePrimary", getIsHeaderDeletePrimary());
        values.put("IsHeaderDeleteSecondary", getIsHeaderDeleteSecondary());
        values.put("SpclProcurementTypePrimary", getSpclProcurementTypePrimary());
        values.put("MatlIsConfigurablePrimary", getMatlIsConfigurablePrimary());
        values.put("IsMaterialProvisionPrimary", getIsMaterialProvisionPrimary());
        values.put("IsCADPrimary", getIsCADPrimary());
        values.put("LeadTimeOffsetPrimary", getLeadTimeOffsetPrimary());
        values.put("PurchasingGrouppPimary", getPurchasingGrouppPimary());
        values.put("DelivDurationInDaysPrimary", getDelivDurationInDaysPrimary());
        values.put("SupplierPrimary", getSupplierPrimary());
        values.put("BOMItemPricePrimary", getBOMItemPricePrimary());
        values.put("BOMItemPriceUnitPrimary", getBOMItemPriceUnitPrimary());
        values.put("NmbrOfVarblSizeItemPrimary", getNmbrOfVarblSizeItemPrimary());
        values.put("Size1Primary", getSize1Primary());
        values.put("Size2Primary", getSize2Primary());
        values.put("Size3Primary", getSize3Primary());
        values.put("QtyVariableSizeItemPrimary", getQtyVariableSizeItemPrimary());
        values.put("FormulaKeyPrimary", getFormulaKeyPrimary());
        values.put("GoodsReceiptDurationPrimary", getGoodsReceiptDurationPrimary());
        values.put("MaterialGroupPrimary", getMaterialGroupPrimary());
        values.put("SpclProcurementTypeSecondary", getSpclProcurementTypeSecondary());
        values.put("MatlIsConfigurableSecondary", getMatlIsConfigurableSecondary());
        values.put("IsMaterialProvisionSecondary", getIsMaterialProvisionSecondary());
        values.put("IsCADSecondary", getIsCADSecondary());
        values.put("LeadTimeOffsetSecondary", getLeadTimeOffsetSecondary());
        values.put("PurchasingGroupSecondary", getPurchasingGroupSecondary());
        values.put("DelivDurationInDaysSecondary", getDelivDurationInDaysSecondary());
        values.put("SupplierSecondary", getSupplierSecondary());
        values.put("BOMItemPriceSecondary", getBOMItemPriceSecondary());
        values.put("BomItemPriceUnitSecondary", getBomItemPriceUnitSecondary());
        values.put("NmbrOfVarblSizeItemSecondary", getNmbrOfVarblSizeItemSecondary());
        values.put("Size1Secondary", getSize1Secondary());
        values.put("Size2Secondary", getSize2Secondary());
        values.put("Size3Secondary", getSize3Secondary());
        values.put("QtyVariableSizeItemSecondary", getQtyVariableSizeItemSecondary());
        values.put("FormulaKeySecondary", getFormulaKeySecondary());
        values.put("GoodsReceiptDurationSecondary", getGoodsReceiptDurationSecondary());
        values.put("MaterialGroupSecondary", getMaterialGroupSecondary());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BOMComparisonUUID") ) {
                final Object value = values.remove("BOMComparisonUUID");
                if( (value == null) || (!value.equals(getBOMComparisonUUID())) ) {
                    setBOMComparisonUUID(((byte[]) value));
                }
            }
            if( values.containsKey("BOMComponentPrimary") ) {
                final Object value = values.remove("BOMComponentPrimary");
                if( (value == null) || (!value.equals(getBOMComponentPrimary())) ) {
                    setBOMComponentPrimary(((String) value));
                }
            }
            if( values.containsKey("BOMComponentSecondary") ) {
                final Object value = values.remove("BOMComponentSecondary");
                if( (value == null) || (!value.equals(getBOMComponentSecondary())) ) {
                    setBOMComponentSecondary(((String) value));
                }
            }
            if( values.containsKey("BOMComparisonResult") ) {
                final Object value = values.remove("BOMComparisonResult");
                if( (value == null) || (!value.equals(getBOMComparisonResult())) ) {
                    setBOMComparisonResult(((String) value));
                }
            }
            if( values.containsKey("MaterialTypePrimary") ) {
                final Object value = values.remove("MaterialTypePrimary");
                if( (value == null) || (!value.equals(getMaterialTypePrimary())) ) {
                    setMaterialTypePrimary(((String) value));
                }
            }
            if( values.containsKey("MaterialTypeSecondary") ) {
                final Object value = values.remove("MaterialTypeSecondary");
                if( (value == null) || (!value.equals(getMaterialTypeSecondary())) ) {
                    setMaterialTypeSecondary(((String) value));
                }
            }
            if( values.containsKey("BOMItemQuantityPrimary") ) {
                final Object value = values.remove("BOMItemQuantityPrimary");
                if( (value == null) || (!value.equals(getBOMItemQuantityPrimary())) ) {
                    setBOMItemQuantityPrimary(((BigDecimal) value));
                }
            }
            if( values.containsKey("BOMItemQuantitySecondary") ) {
                final Object value = values.remove("BOMItemQuantitySecondary");
                if( (value == null) || (!value.equals(getBOMItemQuantitySecondary())) ) {
                    setBOMItemQuantitySecondary(((BigDecimal) value));
                }
            }
            if( values.containsKey("BOMItemCategoryPrimary") ) {
                final Object value = values.remove("BOMItemCategoryPrimary");
                if( (value == null) || (!value.equals(getBOMItemCategoryPrimary())) ) {
                    setBOMItemCategoryPrimary(((String) value));
                }
            }
            if( values.containsKey("BOMItemCategorySecondary") ) {
                final Object value = values.remove("BOMItemCategorySecondary");
                if( (value == null) || (!value.equals(getBOMItemCategorySecondary())) ) {
                    setBOMItemCategorySecondary(((String) value));
                }
            }
            if( values.containsKey("CompleteMaintStatusPrimary") ) {
                final Object value = values.remove("CompleteMaintStatusPrimary");
                if( (value == null) || (!value.equals(getCompleteMaintStatusPrimary())) ) {
                    setCompleteMaintStatusPrimary(((String) value));
                }
            }
            if( values.containsKey("CompleteMaintStatusSecondary") ) {
                final Object value = values.remove("CompleteMaintStatusSecondary");
                if( (value == null) || (!value.equals(getCompleteMaintStatusSecondary())) ) {
                    setCompleteMaintStatusSecondary(((String) value));
                }
            }
            if( values.containsKey("BOMItemDescriptionPrimary") ) {
                final Object value = values.remove("BOMItemDescriptionPrimary");
                if( (value == null) || (!value.equals(getBOMItemDescriptionPrimary())) ) {
                    setBOMItemDescriptionPrimary(((String) value));
                }
            }
            if( values.containsKey("BOMItemDescriptionSecondary") ) {
                final Object value = values.remove("BOMItemDescriptionSecondary");
                if( (value == null) || (!value.equals(getBOMItemDescriptionSecondary())) ) {
                    setBOMItemDescriptionSecondary(((String) value));
                }
            }
            if( values.containsKey("BOMHeaderBaseUnitPrimary") ) {
                final Object value = values.remove("BOMHeaderBaseUnitPrimary");
                if( (value == null) || (!value.equals(getBOMHeaderBaseUnitPrimary())) ) {
                    setBOMHeaderBaseUnitPrimary(((String) value));
                }
            }
            if( values.containsKey("BOMHeaderBaseUnitSecondary") ) {
                final Object value = values.remove("BOMHeaderBaseUnitSecondary");
                if( (value == null) || (!value.equals(getBOMHeaderBaseUnitSecondary())) ) {
                    setBOMHeaderBaseUnitSecondary(((String) value));
                }
            }
            if( values.containsKey("BOMItemUnitPrimary") ) {
                final Object value = values.remove("BOMItemUnitPrimary");
                if( (value == null) || (!value.equals(getBOMItemUnitPrimary())) ) {
                    setBOMItemUnitPrimary(((String) value));
                }
            }
            if( values.containsKey("BOMItemUnitSecondary") ) {
                final Object value = values.remove("BOMItemUnitSecondary");
                if( (value == null) || (!value.equals(getBOMItemUnitSecondary())) ) {
                    setBOMItemUnitSecondary(((String) value));
                }
            }
            if( values.containsKey("IsProductionRelevantPrimary") ) {
                final Object value = values.remove("IsProductionRelevantPrimary");
                if( (value == null) || (!value.equals(getIsProductionRelevantPrimary())) ) {
                    setIsProductionRelevantPrimary(((Boolean) value));
                }
            }
            if( values.containsKey("IsProductionRelevantSecond") ) {
                final Object value = values.remove("IsProductionRelevantSecond");
                if( (value == null) || (!value.equals(getIsProductionRelevantSecond())) ) {
                    setIsProductionRelevantSecond(((Boolean) value));
                }
            }
            if( values.containsKey("ItemIsCostingRelevantPrimary") ) {
                final Object value = values.remove("ItemIsCostingRelevantPrimary");
                if( (value == null) || (!value.equals(getItemIsCostingRelevantPrimary())) ) {
                    setItemIsCostingRelevantPrimary(((String) value));
                }
            }
            if( values.containsKey("ItemIsCostingRelevantSecondary") ) {
                final Object value = values.remove("ItemIsCostingRelevantSecondary");
                if( (value == null) || (!value.equals(getItemIsCostingRelevantSecondary())) ) {
                    setItemIsCostingRelevantSecondary(((String) value));
                }
            }
            if( values.containsKey("IsHeaderDeletePrimary") ) {
                final Object value = values.remove("IsHeaderDeletePrimary");
                if( (value == null) || (!value.equals(getIsHeaderDeletePrimary())) ) {
                    setIsHeaderDeletePrimary(((Boolean) value));
                }
            }
            if( values.containsKey("IsHeaderDeleteSecondary") ) {
                final Object value = values.remove("IsHeaderDeleteSecondary");
                if( (value == null) || (!value.equals(getIsHeaderDeleteSecondary())) ) {
                    setIsHeaderDeleteSecondary(((Boolean) value));
                }
            }
            if( values.containsKey("SpclProcurementTypePrimary") ) {
                final Object value = values.remove("SpclProcurementTypePrimary");
                if( (value == null) || (!value.equals(getSpclProcurementTypePrimary())) ) {
                    setSpclProcurementTypePrimary(((String) value));
                }
            }
            if( values.containsKey("MatlIsConfigurablePrimary") ) {
                final Object value = values.remove("MatlIsConfigurablePrimary");
                if( (value == null) || (!value.equals(getMatlIsConfigurablePrimary())) ) {
                    setMatlIsConfigurablePrimary(((Boolean) value));
                }
            }
            if( values.containsKey("IsMaterialProvisionPrimary") ) {
                final Object value = values.remove("IsMaterialProvisionPrimary");
                if( (value == null) || (!value.equals(getIsMaterialProvisionPrimary())) ) {
                    setIsMaterialProvisionPrimary(((String) value));
                }
            }
            if( values.containsKey("IsCADPrimary") ) {
                final Object value = values.remove("IsCADPrimary");
                if( (value == null) || (!value.equals(getIsCADPrimary())) ) {
                    setIsCADPrimary(((Boolean) value));
                }
            }
            if( values.containsKey("LeadTimeOffsetPrimary") ) {
                final Object value = values.remove("LeadTimeOffsetPrimary");
                if( (value == null) || (!value.equals(getLeadTimeOffsetPrimary())) ) {
                    setLeadTimeOffsetPrimary(((BigDecimal) value));
                }
            }
            if( values.containsKey("PurchasingGrouppPimary") ) {
                final Object value = values.remove("PurchasingGrouppPimary");
                if( (value == null) || (!value.equals(getPurchasingGrouppPimary())) ) {
                    setPurchasingGrouppPimary(((String) value));
                }
            }
            if( values.containsKey("DelivDurationInDaysPrimary") ) {
                final Object value = values.remove("DelivDurationInDaysPrimary");
                if( (value == null) || (!value.equals(getDelivDurationInDaysPrimary())) ) {
                    setDelivDurationInDaysPrimary(((BigDecimal) value));
                }
            }
            if( values.containsKey("SupplierPrimary") ) {
                final Object value = values.remove("SupplierPrimary");
                if( (value == null) || (!value.equals(getSupplierPrimary())) ) {
                    setSupplierPrimary(((String) value));
                }
            }
            if( values.containsKey("BOMItemPricePrimary") ) {
                final Object value = values.remove("BOMItemPricePrimary");
                if( (value == null) || (!value.equals(getBOMItemPricePrimary())) ) {
                    setBOMItemPricePrimary(((BigDecimal) value));
                }
            }
            if( values.containsKey("BOMItemPriceUnitPrimary") ) {
                final Object value = values.remove("BOMItemPriceUnitPrimary");
                if( (value == null) || (!value.equals(getBOMItemPriceUnitPrimary())) ) {
                    setBOMItemPriceUnitPrimary(((String) value));
                }
            }
            if( values.containsKey("NmbrOfVarblSizeItemPrimary") ) {
                final Object value = values.remove("NmbrOfVarblSizeItemPrimary");
                if( (value == null) || (!value.equals(getNmbrOfVarblSizeItemPrimary())) ) {
                    setNmbrOfVarblSizeItemPrimary(((BigDecimal) value));
                }
            }
            if( values.containsKey("Size1Primary") ) {
                final Object value = values.remove("Size1Primary");
                if( (value == null) || (!value.equals(getSize1Primary())) ) {
                    setSize1Primary(((BigDecimal) value));
                }
            }
            if( values.containsKey("Size2Primary") ) {
                final Object value = values.remove("Size2Primary");
                if( (value == null) || (!value.equals(getSize2Primary())) ) {
                    setSize2Primary(((BigDecimal) value));
                }
            }
            if( values.containsKey("Size3Primary") ) {
                final Object value = values.remove("Size3Primary");
                if( (value == null) || (!value.equals(getSize3Primary())) ) {
                    setSize3Primary(((BigDecimal) value));
                }
            }
            if( values.containsKey("QtyVariableSizeItemPrimary") ) {
                final Object value = values.remove("QtyVariableSizeItemPrimary");
                if( (value == null) || (!value.equals(getQtyVariableSizeItemPrimary())) ) {
                    setQtyVariableSizeItemPrimary(((BigDecimal) value));
                }
            }
            if( values.containsKey("FormulaKeyPrimary") ) {
                final Object value = values.remove("FormulaKeyPrimary");
                if( (value == null) || (!value.equals(getFormulaKeyPrimary())) ) {
                    setFormulaKeyPrimary(((String) value));
                }
            }
            if( values.containsKey("GoodsReceiptDurationPrimary") ) {
                final Object value = values.remove("GoodsReceiptDurationPrimary");
                if( (value == null) || (!value.equals(getGoodsReceiptDurationPrimary())) ) {
                    setGoodsReceiptDurationPrimary(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaterialGroupPrimary") ) {
                final Object value = values.remove("MaterialGroupPrimary");
                if( (value == null) || (!value.equals(getMaterialGroupPrimary())) ) {
                    setMaterialGroupPrimary(((String) value));
                }
            }
            if( values.containsKey("SpclProcurementTypeSecondary") ) {
                final Object value = values.remove("SpclProcurementTypeSecondary");
                if( (value == null) || (!value.equals(getSpclProcurementTypeSecondary())) ) {
                    setSpclProcurementTypeSecondary(((String) value));
                }
            }
            if( values.containsKey("MatlIsConfigurableSecondary") ) {
                final Object value = values.remove("MatlIsConfigurableSecondary");
                if( (value == null) || (!value.equals(getMatlIsConfigurableSecondary())) ) {
                    setMatlIsConfigurableSecondary(((Boolean) value));
                }
            }
            if( values.containsKey("IsMaterialProvisionSecondary") ) {
                final Object value = values.remove("IsMaterialProvisionSecondary");
                if( (value == null) || (!value.equals(getIsMaterialProvisionSecondary())) ) {
                    setIsMaterialProvisionSecondary(((String) value));
                }
            }
            if( values.containsKey("IsCADSecondary") ) {
                final Object value = values.remove("IsCADSecondary");
                if( (value == null) || (!value.equals(getIsCADSecondary())) ) {
                    setIsCADSecondary(((Boolean) value));
                }
            }
            if( values.containsKey("LeadTimeOffsetSecondary") ) {
                final Object value = values.remove("LeadTimeOffsetSecondary");
                if( (value == null) || (!value.equals(getLeadTimeOffsetSecondary())) ) {
                    setLeadTimeOffsetSecondary(((BigDecimal) value));
                }
            }
            if( values.containsKey("PurchasingGroupSecondary") ) {
                final Object value = values.remove("PurchasingGroupSecondary");
                if( (value == null) || (!value.equals(getPurchasingGroupSecondary())) ) {
                    setPurchasingGroupSecondary(((String) value));
                }
            }
            if( values.containsKey("DelivDurationInDaysSecondary") ) {
                final Object value = values.remove("DelivDurationInDaysSecondary");
                if( (value == null) || (!value.equals(getDelivDurationInDaysSecondary())) ) {
                    setDelivDurationInDaysSecondary(((BigDecimal) value));
                }
            }
            if( values.containsKey("SupplierSecondary") ) {
                final Object value = values.remove("SupplierSecondary");
                if( (value == null) || (!value.equals(getSupplierSecondary())) ) {
                    setSupplierSecondary(((String) value));
                }
            }
            if( values.containsKey("BOMItemPriceSecondary") ) {
                final Object value = values.remove("BOMItemPriceSecondary");
                if( (value == null) || (!value.equals(getBOMItemPriceSecondary())) ) {
                    setBOMItemPriceSecondary(((BigDecimal) value));
                }
            }
            if( values.containsKey("BomItemPriceUnitSecondary") ) {
                final Object value = values.remove("BomItemPriceUnitSecondary");
                if( (value == null) || (!value.equals(getBomItemPriceUnitSecondary())) ) {
                    setBomItemPriceUnitSecondary(((String) value));
                }
            }
            if( values.containsKey("NmbrOfVarblSizeItemSecondary") ) {
                final Object value = values.remove("NmbrOfVarblSizeItemSecondary");
                if( (value == null) || (!value.equals(getNmbrOfVarblSizeItemSecondary())) ) {
                    setNmbrOfVarblSizeItemSecondary(((BigDecimal) value));
                }
            }
            if( values.containsKey("Size1Secondary") ) {
                final Object value = values.remove("Size1Secondary");
                if( (value == null) || (!value.equals(getSize1Secondary())) ) {
                    setSize1Secondary(((BigDecimal) value));
                }
            }
            if( values.containsKey("Size2Secondary") ) {
                final Object value = values.remove("Size2Secondary");
                if( (value == null) || (!value.equals(getSize2Secondary())) ) {
                    setSize2Secondary(((BigDecimal) value));
                }
            }
            if( values.containsKey("Size3Secondary") ) {
                final Object value = values.remove("Size3Secondary");
                if( (value == null) || (!value.equals(getSize3Secondary())) ) {
                    setSize3Secondary(((BigDecimal) value));
                }
            }
            if( values.containsKey("QtyVariableSizeItemSecondary") ) {
                final Object value = values.remove("QtyVariableSizeItemSecondary");
                if( (value == null) || (!value.equals(getQtyVariableSizeItemSecondary())) ) {
                    setQtyVariableSizeItemSecondary(((BigDecimal) value));
                }
            }
            if( values.containsKey("FormulaKeySecondary") ) {
                final Object value = values.remove("FormulaKeySecondary");
                if( (value == null) || (!value.equals(getFormulaKeySecondary())) ) {
                    setFormulaKeySecondary(((String) value));
                }
            }
            if( values.containsKey("GoodsReceiptDurationSecondary") ) {
                final Object value = values.remove("GoodsReceiptDurationSecondary");
                if( (value == null) || (!value.equals(getGoodsReceiptDurationSecondary())) ) {
                    setGoodsReceiptDurationSecondary(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaterialGroupSecondary") ) {
                final Object value = values.remove("MaterialGroupSecondary");
                if( (value == null) || (!value.equals(getMaterialGroupSecondary())) ) {
                    setMaterialGroupSecondary(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ComparisonResultField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ComparisonResultField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ComparisonResultField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ComparisonResultField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillOfMaterialComparisonService.DEFAULT_SERVICE_PATH);
    }

}
