/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.selectable.ComparisonResultSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult
 * ComparisonResult} entity using key fields. This fluent helper allows methods which modify the underlying query to be
 * called before executing the query itself.
 *
 */
public class ComparisonResultByKeyFluentHelper
    extends
    FluentHelperByKey<ComparisonResultByKeyFluentHelper, ComparisonResult, ComparisonResultSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult
     * ComparisonResult} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ComparisonResult}
     * @param servicePath
     *            Service path to be used to fetch a single {@code ComparisonResult}
     * @param bOMComparisonUUID
     *            GUID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 16
     *            </p>
     */
    public ComparisonResultByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final byte[] bOMComparisonUUID )
    {
        super(servicePath, entityCollection);
        this.key.put("BOMComparisonUUID", bOMComparisonUUID);
    }

    @Override
    @Nonnull
    protected Class<ComparisonResult> getEntityClass()
    {
        return ComparisonResult.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
