/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link BillOfMaterialComparisonServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillOfMaterialComparisonService
 * BillOfMaterialComparisonService}, allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultBillOfMaterialComparisonServiceBatch
    extends
    BatchFluentHelperBasic<BillOfMaterialComparisonServiceBatch, BillOfMaterialComparisonServiceBatchChangeSet>
    implements
    BillOfMaterialComparisonServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillOfMaterialComparisonService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultBillOfMaterialComparisonServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultBillOfMaterialComparisonServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillOfMaterialComparisonService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillOfMaterialComparisonService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultBillOfMaterialComparisonServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultBillOfMaterialComparisonServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillOfMaterialComparisonService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultBillOfMaterialComparisonServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public BillOfMaterialComparisonServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultBillOfMaterialComparisonServiceBatchChangeSet(this, service);
    }

}
