/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link BillOfMaterialComparisonServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillOfMaterialComparisonService
 * BillOfMaterialComparisonService}.
 *
 */
public class DefaultBillOfMaterialComparisonServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<BillOfMaterialComparisonServiceBatch, BillOfMaterialComparisonServiceBatchChangeSet>
    implements
    BillOfMaterialComparisonServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillOfMaterialComparisonService service;

    @SuppressWarnings( "deprecation" )
    DefaultBillOfMaterialComparisonServiceBatchChangeSet(
        @Nonnull final DefaultBillOfMaterialComparisonServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillOfMaterialComparisonService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultBillOfMaterialComparisonServiceBatchChangeSet getThis()
    {
        return this;
    }

}
