/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult
 * ComparisonResult}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.field.ComparisonResultField
 * ComparisonResultField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.link.ComparisonResultLink
 * ComparisonResultLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#BOM_COMPARISON_UUID
 * BOM_COMPARISON_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#BOM_COMPONENT_PRIMARY
 * BOM_COMPONENT_PRIMARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#BOM_COMPONENT_SECONDARY
 * BOM_COMPONENT_SECONDARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#BOM_COMPARISON_RESULT
 * BOM_COMPARISON_RESULT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#MATERIAL_TYPE_PRIMARY
 * MATERIAL_TYPE_PRIMARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#MATERIAL_TYPE_SECONDARY
 * MATERIAL_TYPE_SECONDARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#BOM_ITEM_QUANTITY_PRIMARY
 * BOM_ITEM_QUANTITY_PRIMARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#BOM_ITEM_QUANTITY_SECONDARY
 * BOM_ITEM_QUANTITY_SECONDARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#BOM_ITEM_CATEGORY_PRIMARY
 * BOM_ITEM_CATEGORY_PRIMARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#BOM_ITEM_CATEGORY_SECONDARY
 * BOM_ITEM_CATEGORY_SECONDARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#COMPLETE_MAINT_STATUS_PRIMARY
 * COMPLETE_MAINT_STATUS_PRIMARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#COMPLETE_MAINT_STATUS_SECONDARY
 * COMPLETE_MAINT_STATUS_SECONDARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#BOM_ITEM_DESCRIPTION_PRIMARY
 * BOM_ITEM_DESCRIPTION_PRIMARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#BOM_ITEM_DESCRIPTION_SECONDARY
 * BOM_ITEM_DESCRIPTION_SECONDARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#BOM_HEADER_BASE_UNIT_PRIMARY
 * BOM_HEADER_BASE_UNIT_PRIMARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#BOM_HEADER_BASE_UNIT_SECONDARY
 * BOM_HEADER_BASE_UNIT_SECONDARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#BOM_ITEM_UNIT_PRIMARY
 * BOM_ITEM_UNIT_PRIMARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#BOM_ITEM_UNIT_SECONDARY
 * BOM_ITEM_UNIT_SECONDARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#IS_PRODUCTION_RELEVANT_PRIMARY
 * IS_PRODUCTION_RELEVANT_PRIMARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#IS_PRODUCTION_RELEVANT_SECOND
 * IS_PRODUCTION_RELEVANT_SECOND}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#ITEM_IS_COSTING_RELEVANT_PRIMARY
 * ITEM_IS_COSTING_RELEVANT_PRIMARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#ITEM_IS_COSTING_RELEVANT_SECONDARY
 * ITEM_IS_COSTING_RELEVANT_SECONDARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#IS_HEADER_DELETE_PRIMARY
 * IS_HEADER_DELETE_PRIMARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#IS_HEADER_DELETE_SECONDARY
 * IS_HEADER_DELETE_SECONDARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#SPCL_PROCUREMENT_TYPE_PRIMARY
 * SPCL_PROCUREMENT_TYPE_PRIMARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#MATL_IS_CONFIGURABLE_PRIMARY
 * MATL_IS_CONFIGURABLE_PRIMARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#IS_MATERIAL_PROVISION_PRIMARY
 * IS_MATERIAL_PROVISION_PRIMARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#IS_CAD_PRIMARY
 * IS_CAD_PRIMARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#LEAD_TIME_OFFSET_PRIMARY
 * LEAD_TIME_OFFSET_PRIMARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#PURCHASING_GROUPP_PIMARY
 * PURCHASING_GROUPP_PIMARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#DELIV_DURATION_IN_DAYS_PRIMARY
 * DELIV_DURATION_IN_DAYS_PRIMARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#SUPPLIER_PRIMARY
 * SUPPLIER_PRIMARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#BOM_ITEM_PRICE_PRIMARY
 * BOM_ITEM_PRICE_PRIMARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#BOM_ITEM_PRICE_UNIT_PRIMARY
 * BOM_ITEM_PRICE_UNIT_PRIMARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#NMBR_OF_VARBL_SIZE_ITEM_PRIMARY
 * NMBR_OF_VARBL_SIZE_ITEM_PRIMARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#SIZE1_PRIMARY
 * SIZE1_PRIMARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#SIZE2_PRIMARY
 * SIZE2_PRIMARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#SIZE3_PRIMARY
 * SIZE3_PRIMARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#QTY_VARIABLE_SIZE_ITEM_PRIMARY
 * QTY_VARIABLE_SIZE_ITEM_PRIMARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#FORMULA_KEY_PRIMARY
 * FORMULA_KEY_PRIMARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#GOODS_RECEIPT_DURATION_PRIMARY
 * GOODS_RECEIPT_DURATION_PRIMARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#MATERIAL_GROUP_PRIMARY
 * MATERIAL_GROUP_PRIMARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#SPCL_PROCUREMENT_TYPE_SECONDARY
 * SPCL_PROCUREMENT_TYPE_SECONDARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#MATL_IS_CONFIGURABLE_SECONDARY
 * MATL_IS_CONFIGURABLE_SECONDARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#IS_MATERIAL_PROVISION_SECONDARY
 * IS_MATERIAL_PROVISION_SECONDARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#IS_CAD_SECONDARY
 * IS_CAD_SECONDARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#LEAD_TIME_OFFSET_SECONDARY
 * LEAD_TIME_OFFSET_SECONDARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#PURCHASING_GROUP_SECONDARY
 * PURCHASING_GROUP_SECONDARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#DELIV_DURATION_IN_DAYS_SECONDARY
 * DELIV_DURATION_IN_DAYS_SECONDARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#SUPPLIER_SECONDARY
 * SUPPLIER_SECONDARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#BOM_ITEM_PRICE_SECONDARY
 * BOM_ITEM_PRICE_SECONDARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#BOM_ITEM_PRICE_UNIT_SECONDARY
 * BOM_ITEM_PRICE_UNIT_SECONDARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#NMBR_OF_VARBL_SIZE_ITEM_SECONDARY
 * NMBR_OF_VARBL_SIZE_ITEM_SECONDARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#SIZE1_SECONDARY
 * SIZE1_SECONDARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#SIZE2_SECONDARY
 * SIZE2_SECONDARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#SIZE3_SECONDARY
 * SIZE3_SECONDARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#QTY_VARIABLE_SIZE_ITEM_SECONDARY
 * QTY_VARIABLE_SIZE_ITEM_SECONDARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#FORMULA_KEY_SECONDARY
 * FORMULA_KEY_SECONDARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#GOODS_RECEIPT_DURATION_SECONDARY
 * GOODS_RECEIPT_DURATION_SECONDARY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialcomparison.ComparisonResult#MATERIAL_GROUP_SECONDARY
 * MATERIAL_GROUP_SECONDARY}</li>
 * </ul>
 *
 */
public interface ComparisonResultSelectable extends EntitySelectable<ComparisonResult>
{

}
