/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.field.BOMItemCategoryTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.selectable.BOMItemCategoryTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Item Category Description
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BOMItemCategoryTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BOMItemCategoryText extends VdmEntity<BOMItemCategoryText>
{

    /**
     * Selector for all available fields of BOMItemCategoryText.
     *
     */
    public final static BOMItemCategoryTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static BOMItemCategoryTextField<String> LANGUAGE = new BOMItemCategoryTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemCategory</b>
     * </p>
     *
     * @return Item category (bill of material)
     */
    @Key
    @SerializedName( "BillOfMaterialItemCategory" )
    @JsonProperty( "BillOfMaterialItemCategory" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialItemCategory" )
    private String billOfMaterialItemCategory;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialItemCategory</b> field to query operations.
     *
     */
    public final static BOMItemCategoryTextField<String> BILL_OF_MATERIAL_ITEM_CATEGORY =
        new BOMItemCategoryTextField<String>("BillOfMaterialItemCategory");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemCategoryDesc</b>
     * </p>
     *
     * @return Item Category Description
     */
    @SerializedName( "BillOfMaterialItemCategoryDesc" )
    @JsonProperty( "BillOfMaterialItemCategoryDesc" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialItemCategoryDesc" )
    private String billOfMaterialItemCategoryDesc;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialItemCategoryDesc</b> field to query operations.
     *
     */
    public final static BOMItemCategoryTextField<String> BILL_OF_MATERIAL_ITEM_CATEGORY_DESC =
        new BOMItemCategoryTextField<String>("BillOfMaterialItemCategoryDesc");

    @Nonnull
    @Override
    public Class<BOMItemCategoryText> getType()
    {
        return BOMItemCategoryText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemCategory</b>
     * </p>
     *
     * @param billOfMaterialItemCategory
     *            Item category (bill of material)
     */
    public void setBillOfMaterialItemCategory( @Nullable final String billOfMaterialItemCategory )
    {
        rememberChangedField("BillOfMaterialItemCategory", this.billOfMaterialItemCategory);
        this.billOfMaterialItemCategory = billOfMaterialItemCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemCategoryDesc</b>
     * </p>
     *
     * @param billOfMaterialItemCategoryDesc
     *            Item Category Description
     */
    public void setBillOfMaterialItemCategoryDesc( @Nullable final String billOfMaterialItemCategoryDesc )
    {
        rememberChangedField("BillOfMaterialItemCategoryDesc", this.billOfMaterialItemCategoryDesc);
        this.billOfMaterialItemCategoryDesc = billOfMaterialItemCategoryDesc;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BOMItemCategoryText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("BillOfMaterialItemCategory", getBillOfMaterialItemCategory());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("BillOfMaterialItemCategory", getBillOfMaterialItemCategory());
        values.put("BillOfMaterialItemCategoryDesc", getBillOfMaterialItemCategoryDesc());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialItemCategory") ) {
                final Object value = values.remove("BillOfMaterialItemCategory");
                if( (value == null) || (!value.equals(getBillOfMaterialItemCategory())) ) {
                    setBillOfMaterialItemCategory(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialItemCategoryDesc") ) {
                final Object value = values.remove("BillOfMaterialItemCategoryDesc");
                if( (value == null) || (!value.equals(getBillOfMaterialItemCategoryDesc())) ) {
                    setBillOfMaterialItemCategoryDesc(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> BOMItemCategoryTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BOMItemCategoryTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BOMItemCategoryTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BOMItemCategoryTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillOfMaterialsService.DEFAULT_SERVICE_PATH);
    }

}
