/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.field.BillOfMaterialField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.link.BillOfMaterialLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.link.BillOfMaterialOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.selectable.BillOfMaterialSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Bill of Material
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BillOfMaterialType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BillOfMaterial extends VdmEntity<BillOfMaterial>
{

    /**
     * Selector for all available fields of BillOfMaterial.
     *
     */
    public final static BillOfMaterialSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialHeaderUUID</b>
     * </p>
     *
     * @return Global identification of a BOM header change status
     */
    @Key
    @SerializedName( "BillOfMaterialHeaderUUID" )
    @JsonProperty( "BillOfMaterialHeaderUUID" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialHeaderUUID" )
    private UUID billOfMaterialHeaderUUID;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialHeaderUUID</b> field to query operations.
     *
     */
    public final static BillOfMaterialField<UUID> BILL_OF_MATERIAL_HEADER_UUID =
        new BillOfMaterialField<UUID>("BillOfMaterialHeaderUUID");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialVariantUsage</b>
     * </p>
     *
     * @return BOM Usage
     */
    @SerializedName( "BillOfMaterialVariantUsage" )
    @JsonProperty( "BillOfMaterialVariantUsage" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialVariantUsage" )
    private String billOfMaterialVariantUsage;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialVariantUsage</b> field to query operations.
     *
     */
    public final static BillOfMaterialField<String> BILL_OF_MATERIAL_VARIANT_USAGE =
        new BillOfMaterialField<String>("BillOfMaterialVariantUsage");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialCategory</b>
     * </p>
     *
     * @return BOM category
     */
    @SerializedName( "BillOfMaterialCategory" )
    @JsonProperty( "BillOfMaterialCategory" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialCategory" )
    private String billOfMaterialCategory;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialCategory</b> field to query operations.
     *
     */
    public final static BillOfMaterialField<String> BILL_OF_MATERIAL_CATEGORY =
        new BillOfMaterialField<String>("BillOfMaterialCategory");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterial</b>
     * </p>
     *
     * @return Bill of Material
     */
    @SerializedName( "BillOfMaterial" )
    @JsonProperty( "BillOfMaterial" )
    @Nullable
    @ODataField( odataName = "BillOfMaterial" )
    private String billOfMaterial;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterial</b> field to query operations.
     *
     */
    public final static BillOfMaterialField<String> BILL_OF_MATERIAL =
        new BillOfMaterialField<String>("BillOfMaterial");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialVariant</b>
     * </p>
     *
     * @return Alternative BOM
     */
    @SerializedName( "BillOfMaterialVariant" )
    @JsonProperty( "BillOfMaterialVariant" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialVariant" )
    private String billOfMaterialVariant;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialVariant</b> field to query operations.
     *
     */
    public final static BillOfMaterialField<String> BILL_OF_MATERIAL_VARIANT =
        new BillOfMaterialField<String>("BillOfMaterialVariant");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static BillOfMaterialField<String> MATERIAL = new BillOfMaterialField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static BillOfMaterialField<String> PLANT = new BillOfMaterialField<String>("Plant");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsMultipleBOMAlt</b>
     * </p>
     *
     * @return Indicator: alternative determination for multiple BOMs
     */
    @SerializedName( "IsMultipleBOMAlt" )
    @JsonProperty( "IsMultipleBOMAlt" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsMultipleBOMAlt" )
    private Boolean isMultipleBOMAlt;
    /**
     * Use with available fluent helpers to apply the <b>IsMultipleBOMAlt</b> field to query operations.
     *
     */
    public final static BillOfMaterialField<Boolean> IS_MULTIPLE_BOM_ALT =
        new BillOfMaterialField<Boolean>("IsMultipleBOMAlt");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOMHeaderInternalChangeCount</b>
     * </p>
     *
     * @return Internal counter
     */
    @SerializedName( "BOMHeaderInternalChangeCount" )
    @JsonProperty( "BOMHeaderInternalChangeCount" )
    @Nullable
    @ODataField( odataName = "BOMHeaderInternalChangeCount" )
    private String bOMHeaderInternalChangeCount;
    /**
     * Use with available fluent helpers to apply the <b>BOMHeaderInternalChangeCount</b> field to query operations.
     *
     */
    public final static BillOfMaterialField<String> BOM_HEADER_INTERNAL_CHANGE_COUNT =
        new BillOfMaterialField<String>("BOMHeaderInternalChangeCount");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BOMUsagePriority</b>
     * </p>
     *
     * @return CIM priority for selection ID
     */
    @SerializedName( "BOMUsagePriority" )
    @JsonProperty( "BOMUsagePriority" )
    @Nullable
    @ODataField( odataName = "BOMUsagePriority" )
    private String bOMUsagePriority;
    /**
     * Use with available fluent helpers to apply the <b>BOMUsagePriority</b> field to query operations.
     *
     */
    public final static BillOfMaterialField<String> BOM_USAGE_PRIORITY =
        new BillOfMaterialField<String>("BOMUsagePriority");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialAuthsnGrp</b>
     * </p>
     *
     * @return Authorization group for bills of material
     */
    @SerializedName( "BillOfMaterialAuthsnGrp" )
    @JsonProperty( "BillOfMaterialAuthsnGrp" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialAuthsnGrp" )
    private String billOfMaterialAuthsnGrp;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialAuthsnGrp</b> field to query operations.
     *
     */
    public final static BillOfMaterialField<String> BILL_OF_MATERIAL_AUTHSN_GRP =
        new BillOfMaterialField<String>("BillOfMaterialAuthsnGrp");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialVersion</b>
     * </p>
     *
     * @return BOM Version
     */
    @SerializedName( "BillOfMaterialVersion" )
    @JsonProperty( "BillOfMaterialVersion" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialVersion" )
    private String billOfMaterialVersion;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialVersion</b> field to query operations.
     *
     */
    public final static BillOfMaterialField<String> BILL_OF_MATERIAL_VERSION =
        new BillOfMaterialField<String>("BillOfMaterialVersion");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BOMVersionStatus</b>
     * </p>
     *
     * @return BOM Version Status
     */
    @SerializedName( "BOMVersionStatus" )
    @JsonProperty( "BOMVersionStatus" )
    @Nullable
    @ODataField( odataName = "BOMVersionStatus" )
    private String bOMVersionStatus;
    /**
     * Use with available fluent helpers to apply the <b>BOMVersionStatus</b> field to query operations.
     *
     */
    public final static BillOfMaterialField<String> BOM_VERSION_STATUS =
        new BillOfMaterialField<String>("BOMVersionStatus");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsVersionBillOfMaterial</b>
     * </p>
     *
     * @return Indicator: Relevant for Versioning
     */
    @SerializedName( "IsVersionBillOfMaterial" )
    @JsonProperty( "IsVersionBillOfMaterial" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsVersionBillOfMaterial" )
    private Boolean isVersionBillOfMaterial;
    /**
     * Use with available fluent helpers to apply the <b>IsVersionBillOfMaterial</b> field to query operations.
     *
     */
    public final static BillOfMaterialField<Boolean> IS_VERSION_BILL_OF_MATERIAL =
        new BillOfMaterialField<Boolean>("IsVersionBillOfMaterial");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsLatestBOMVersion</b>
     * </p>
     *
     * @return Indicator: Latest Released BOM Version
     */
    @SerializedName( "IsLatestBOMVersion" )
    @JsonProperty( "IsLatestBOMVersion" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsLatestBOMVersion" )
    private Boolean isLatestBOMVersion;
    /**
     * Use with available fluent helpers to apply the <b>IsLatestBOMVersion</b> field to query operations.
     *
     */
    public final static BillOfMaterialField<Boolean> IS_LATEST_BOM_VERSION =
        new BillOfMaterialField<Boolean>("IsLatestBOMVersion");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsConfiguredMaterial</b>
     * </p>
     *
     * @return Product is Configurable
     */
    @SerializedName( "IsConfiguredMaterial" )
    @JsonProperty( "IsConfiguredMaterial" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsConfiguredMaterial" )
    private Boolean isConfiguredMaterial;
    /**
     * Use with available fluent helpers to apply the <b>IsConfiguredMaterial</b> field to query operations.
     *
     */
    public final static BillOfMaterialField<Boolean> IS_CONFIGURED_MATERIAL =
        new BillOfMaterialField<Boolean>("IsConfiguredMaterial");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BOMTechnicalType</b>
     * </p>
     *
     * @return Technical type
     */
    @SerializedName( "BOMTechnicalType" )
    @JsonProperty( "BOMTechnicalType" )
    @Nullable
    @ODataField( odataName = "BOMTechnicalType" )
    private String bOMTechnicalType;
    /**
     * Use with available fluent helpers to apply the <b>BOMTechnicalType</b> field to query operations.
     *
     */
    public final static BillOfMaterialField<String> BOM_TECHNICAL_TYPE =
        new BillOfMaterialField<String>("BOMTechnicalType");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>BOMGroup</b>
     * </p>
     *
     * @return BOM group
     */
    @SerializedName( "BOMGroup" )
    @JsonProperty( "BOMGroup" )
    @Nullable
    @ODataField( odataName = "BOMGroup" )
    private String bOMGroup;
    /**
     * Use with available fluent helpers to apply the <b>BOMGroup</b> field to query operations.
     *
     */
    public final static BillOfMaterialField<String> BOM_GROUP = new BillOfMaterialField<String>("BOMGroup");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BOMHeaderText</b>
     * </p>
     *
     * @return BOM Description
     */
    @SerializedName( "BOMHeaderText" )
    @JsonProperty( "BOMHeaderText" )
    @Nullable
    @ODataField( odataName = "BOMHeaderText" )
    private String bOMHeaderText;
    /**
     * Use with available fluent helpers to apply the <b>BOMHeaderText</b> field to query operations.
     *
     */
    public final static BillOfMaterialField<String> BOM_HEADER_TEXT = new BillOfMaterialField<String>("BOMHeaderText");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BOMAlternativeText</b>
     * </p>
     *
     * @return Alternative BOM Text
     */
    @SerializedName( "BOMAlternativeText" )
    @JsonProperty( "BOMAlternativeText" )
    @Nullable
    @ODataField( odataName = "BOMAlternativeText" )
    private String bOMAlternativeText;
    /**
     * Use with available fluent helpers to apply the <b>BOMAlternativeText</b> field to query operations.
     *
     */
    public final static BillOfMaterialField<String> BOM_ALTERNATIVE_TEXT =
        new BillOfMaterialField<String>("BOMAlternativeText");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialStatus</b>
     * </p>
     *
     * @return Bill of Material Status
     */
    @SerializedName( "BillOfMaterialStatus" )
    @JsonProperty( "BillOfMaterialStatus" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialStatus" )
    private String billOfMaterialStatus;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialStatus</b> field to query operations.
     *
     */
    public final static BillOfMaterialField<String> BILL_OF_MATERIAL_STATUS =
        new BillOfMaterialField<String>("BillOfMaterialStatus");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>HeaderValidityStartDate</b>
     * </p>
     *
     * @return Valid-From Date
     */
    @SerializedName( "HeaderValidityStartDate" )
    @JsonProperty( "HeaderValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "HeaderValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime headerValidityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>HeaderValidityStartDate</b> field to query operations.
     *
     */
    public final static BillOfMaterialField<LocalDateTime> HEADER_VALIDITY_START_DATE =
        new BillOfMaterialField<LocalDateTime>("HeaderValidityStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>HeaderValidityEndDate</b>
     * </p>
     *
     * @return Valid-to date
     */
    @SerializedName( "HeaderValidityEndDate" )
    @JsonProperty( "HeaderValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "HeaderValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime headerValidityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>HeaderValidityEndDate</b> field to query operations.
     *
     */
    public final static BillOfMaterialField<LocalDateTime> HEADER_VALIDITY_END_DATE =
        new BillOfMaterialField<LocalDateTime>("HeaderValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>EngineeringChangeDocument</b>
     * </p>
     *
     * @return Change Number
     */
    @SerializedName( "EngineeringChangeDocument" )
    @JsonProperty( "EngineeringChangeDocument" )
    @Nullable
    @ODataField( odataName = "EngineeringChangeDocument" )
    private String engineeringChangeDocument;
    /**
     * Use with available fluent helpers to apply the <b>EngineeringChangeDocument</b> field to query operations.
     *
     */
    public final static BillOfMaterialField<String> ENGINEERING_CHANGE_DOCUMENT =
        new BillOfMaterialField<String>("EngineeringChangeDocument");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>EngineeringChangeDocForEdit</b>
     * </p>
     *
     * @return Change Number
     */
    @SerializedName( "EngineeringChangeDocForEdit" )
    @JsonProperty( "EngineeringChangeDocForEdit" )
    @Nullable
    @ODataField( odataName = "EngineeringChangeDocForEdit" )
    private String engineeringChangeDocForEdit;
    /**
     * Use with available fluent helpers to apply the <b>EngineeringChangeDocForEdit</b> field to query operations.
     *
     */
    public final static BillOfMaterialField<String> ENGINEERING_CHANGE_DOC_FOR_EDIT =
        new BillOfMaterialField<String>("EngineeringChangeDocForEdit");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChgToEngineeringChgDocument</b>
     * </p>
     *
     * @return Change Number To
     */
    @SerializedName( "ChgToEngineeringChgDocument" )
    @JsonProperty( "ChgToEngineeringChgDocument" )
    @Nullable
    @ODataField( odataName = "ChgToEngineeringChgDocument" )
    private String chgToEngineeringChgDocument;
    /**
     * Use with available fluent helpers to apply the <b>ChgToEngineeringChgDocument</b> field to query operations.
     *
     */
    public final static BillOfMaterialField<String> CHG_TO_ENGINEERING_CHG_DOCUMENT =
        new BillOfMaterialField<String>("ChgToEngineeringChgDocument");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsMarkedForDeletion</b>
     * </p>
     *
     * @return Deletion Indicator
     */
    @SerializedName( "IsMarkedForDeletion" )
    @JsonProperty( "IsMarkedForDeletion" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsMarkedForDeletion" )
    private Boolean isMarkedForDeletion;
    /**
     * Use with available fluent helpers to apply the <b>IsMarkedForDeletion</b> field to query operations.
     *
     */
    public final static BillOfMaterialField<Boolean> IS_MARKED_FOR_DELETION =
        new BillOfMaterialField<Boolean>("IsMarkedForDeletion");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsALE</b>
     * </p>
     *
     * @return ALE indicator
     */
    @SerializedName( "IsALE" )
    @JsonProperty( "IsALE" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsALE" )
    private Boolean isALE;
    /**
     * Use with available fluent helpers to apply the <b>IsALE</b> field to query operations.
     *
     */
    public final static BillOfMaterialField<Boolean> IS_ALE = new BillOfMaterialField<Boolean>("IsALE");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BOMHeaderBaseUnit</b>
     * </p>
     *
     * @return Base Unit of Measure for BOM
     */
    @SerializedName( "BOMHeaderBaseUnit" )
    @JsonProperty( "BOMHeaderBaseUnit" )
    @Nullable
    @ODataField( odataName = "BOMHeaderBaseUnit" )
    private String bOMHeaderBaseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BOMHeaderBaseUnit</b> field to query operations.
     *
     */
    public final static BillOfMaterialField<String> BOM_HEADER_BASE_UNIT =
        new BillOfMaterialField<String>("BOMHeaderBaseUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BOMHeaderQuantityInBaseUnit</b>
     * </p>
     *
     * @return Base quantity
     */
    @SerializedName( "BOMHeaderQuantityInBaseUnit" )
    @JsonProperty( "BOMHeaderQuantityInBaseUnit" )
    @Nullable
    @ODataField( odataName = "BOMHeaderQuantityInBaseUnit" )
    private BigDecimal bOMHeaderQuantityInBaseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BOMHeaderQuantityInBaseUnit</b> field to query operations.
     *
     */
    public final static BillOfMaterialField<BigDecimal> BOM_HEADER_QUANTITY_IN_BASE_UNIT =
        new BillOfMaterialField<BigDecimal>("BOMHeaderQuantityInBaseUnit");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RecordCreationDate</b>
     * </p>
     *
     * @return Date Record Created On
     */
    @SerializedName( "RecordCreationDate" )
    @JsonProperty( "RecordCreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "RecordCreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime recordCreationDate;
    /**
     * Use with available fluent helpers to apply the <b>RecordCreationDate</b> field to query operations.
     *
     */
    public final static BillOfMaterialField<LocalDateTime> RECORD_CREATION_DATE =
        new BillOfMaterialField<LocalDateTime>("RecordCreationDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Last Changed On
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static BillOfMaterialField<LocalDateTime> LAST_CHANGE_DATE =
        new BillOfMaterialField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return User Who Created Record
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static BillOfMaterialField<String> CREATED_BY_USER = new BillOfMaterialField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Name of Person Who Changed Object
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static BillOfMaterialField<String> LAST_CHANGED_BY_USER =
        new BillOfMaterialField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BOMIsToBeDeleted</b>
     * </p>
     *
     * @return Handling Deletion Flag During BOM Explosion
     */
    @SerializedName( "BOMIsToBeDeleted" )
    @JsonProperty( "BOMIsToBeDeleted" )
    @Nullable
    @ODataField( odataName = "BOMIsToBeDeleted" )
    private String bOMIsToBeDeleted;
    /**
     * Use with available fluent helpers to apply the <b>BOMIsToBeDeleted</b> field to query operations.
     *
     */
    public final static BillOfMaterialField<String> BOM_IS_TO_BE_DELETED =
        new BillOfMaterialField<String>("BOMIsToBeDeleted");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DocumentIsCreatedByCAD</b>
     * </p>
     *
     * @return CAD Indicator
     */
    @SerializedName( "DocumentIsCreatedByCAD" )
    @JsonProperty( "DocumentIsCreatedByCAD" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "DocumentIsCreatedByCAD" )
    private Boolean documentIsCreatedByCAD;
    /**
     * Use with available fluent helpers to apply the <b>DocumentIsCreatedByCAD</b> field to query operations.
     *
     */
    public final static BillOfMaterialField<Boolean> DOCUMENT_IS_CREATED_BY_CAD =
        new BillOfMaterialField<Boolean>("DocumentIsCreatedByCAD");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>LaboratoryOrDesignOffice</b>
     * </p>
     *
     * @return Laboratory/design office
     */
    @SerializedName( "LaboratoryOrDesignOffice" )
    @JsonProperty( "LaboratoryOrDesignOffice" )
    @Nullable
    @ODataField( odataName = "LaboratoryOrDesignOffice" )
    private String laboratoryOrDesignOffice;
    /**
     * Use with available fluent helpers to apply the <b>LaboratoryOrDesignOffice</b> field to query operations.
     *
     */
    public final static BillOfMaterialField<String> LABORATORY_OR_DESIGN_OFFICE =
        new BillOfMaterialField<String>("LaboratoryOrDesignOffice");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SelectedBillOfMaterialVersion</b>
     * </p>
     *
     * @return The selectedBillOfMaterialVersion contained in this entity.
     */
    @SerializedName( "SelectedBillOfMaterialVersion" )
    @JsonProperty( "SelectedBillOfMaterialVersion" )
    @Nullable
    @ODataField( odataName = "SelectedBillOfMaterialVersion" )
    private String selectedBillOfMaterialVersion;
    /**
     * Use with available fluent helpers to apply the <b>SelectedBillOfMaterialVersion</b> field to query operations.
     *
     */
    public final static BillOfMaterialField<String> SELECTED_BILL_OF_MATERIAL_VERSION =
        new BillOfMaterialField<String>("SelectedBillOfMaterialVersion");
    /**
     * Navigation property <b>to_BillOfMaterialItem</b> for <b>BillOfMaterial</b> to multiple <b>BillOfMaterialItem</b>.
     *
     */
    @SerializedName( "to_BillOfMaterialItem" )
    @JsonProperty( "to_BillOfMaterialItem" )
    @ODataField( odataName = "to_BillOfMaterialItem" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BillOfMaterialItem> toBillOfMaterialItem;
    /**
     * Navigation property <b>to_BillOfMaterialUsage</b> for <b>BillOfMaterial</b> to single <b>BillOfMaterialUsage</b>.
     *
     */
    @SerializedName( "to_BillOfMaterialUsage" )
    @JsonProperty( "to_BillOfMaterialUsage" )
    @ODataField( odataName = "to_BillOfMaterialUsage" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BillOfMaterialUsage toBillOfMaterialUsage;
    /**
     * Use with available fluent helpers to apply the <b>to_BillOfMaterialItem</b> navigation property to query
     * operations.
     *
     */
    public final static BillOfMaterialLink<BillOfMaterialItem> TO_BILL_OF_MATERIAL_ITEM =
        new BillOfMaterialLink<BillOfMaterialItem>("to_BillOfMaterialItem");
    /**
     * Use with available fluent helpers to apply the <b>to_BillOfMaterialUsage</b> navigation property to query
     * operations.
     *
     */
    public final static BillOfMaterialOneToOneLink<BillOfMaterialUsage> TO_BILL_OF_MATERIAL_USAGE =
        new BillOfMaterialOneToOneLink<BillOfMaterialUsage>("to_BillOfMaterialUsage");

    @Nonnull
    @Override
    public Class<BillOfMaterial> getType()
    {
        return BillOfMaterial.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialHeaderUUID</b>
     * </p>
     *
     * @param billOfMaterialHeaderUUID
     *            Global identification of a BOM header change status
     */
    public void setBillOfMaterialHeaderUUID( @Nullable final UUID billOfMaterialHeaderUUID )
    {
        rememberChangedField("BillOfMaterialHeaderUUID", this.billOfMaterialHeaderUUID);
        this.billOfMaterialHeaderUUID = billOfMaterialHeaderUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialVariantUsage</b>
     * </p>
     *
     * @param billOfMaterialVariantUsage
     *            BOM Usage
     */
    public void setBillOfMaterialVariantUsage( @Nullable final String billOfMaterialVariantUsage )
    {
        rememberChangedField("BillOfMaterialVariantUsage", this.billOfMaterialVariantUsage);
        this.billOfMaterialVariantUsage = billOfMaterialVariantUsage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialCategory</b>
     * </p>
     *
     * @param billOfMaterialCategory
     *            BOM category
     */
    public void setBillOfMaterialCategory( @Nullable final String billOfMaterialCategory )
    {
        rememberChangedField("BillOfMaterialCategory", this.billOfMaterialCategory);
        this.billOfMaterialCategory = billOfMaterialCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterial</b>
     * </p>
     *
     * @param billOfMaterial
     *            Bill of Material
     */
    public void setBillOfMaterial( @Nullable final String billOfMaterial )
    {
        rememberChangedField("BillOfMaterial", this.billOfMaterial);
        this.billOfMaterial = billOfMaterial;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialVariant</b>
     * </p>
     *
     * @param billOfMaterialVariant
     *            Alternative BOM
     */
    public void setBillOfMaterialVariant( @Nullable final String billOfMaterialVariant )
    {
        rememberChangedField("BillOfMaterialVariant", this.billOfMaterialVariant);
        this.billOfMaterialVariant = billOfMaterialVariant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsMultipleBOMAlt</b>
     * </p>
     *
     * @param isMultipleBOMAlt
     *            Indicator: alternative determination for multiple BOMs
     */
    public void setIsMultipleBOMAlt( @Nullable final Boolean isMultipleBOMAlt )
    {
        rememberChangedField("IsMultipleBOMAlt", this.isMultipleBOMAlt);
        this.isMultipleBOMAlt = isMultipleBOMAlt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOMHeaderInternalChangeCount</b>
     * </p>
     *
     * @param bOMHeaderInternalChangeCount
     *            Internal counter
     */
    public void setBOMHeaderInternalChangeCount( @Nullable final String bOMHeaderInternalChangeCount )
    {
        rememberChangedField("BOMHeaderInternalChangeCount", this.bOMHeaderInternalChangeCount);
        this.bOMHeaderInternalChangeCount = bOMHeaderInternalChangeCount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BOMUsagePriority</b>
     * </p>
     *
     * @param bOMUsagePriority
     *            CIM priority for selection ID
     */
    public void setBOMUsagePriority( @Nullable final String bOMUsagePriority )
    {
        rememberChangedField("BOMUsagePriority", this.bOMUsagePriority);
        this.bOMUsagePriority = bOMUsagePriority;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialAuthsnGrp</b>
     * </p>
     *
     * @param billOfMaterialAuthsnGrp
     *            Authorization group for bills of material
     */
    public void setBillOfMaterialAuthsnGrp( @Nullable final String billOfMaterialAuthsnGrp )
    {
        rememberChangedField("BillOfMaterialAuthsnGrp", this.billOfMaterialAuthsnGrp);
        this.billOfMaterialAuthsnGrp = billOfMaterialAuthsnGrp;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialVersion</b>
     * </p>
     *
     * @param billOfMaterialVersion
     *            BOM Version
     */
    public void setBillOfMaterialVersion( @Nullable final String billOfMaterialVersion )
    {
        rememberChangedField("BillOfMaterialVersion", this.billOfMaterialVersion);
        this.billOfMaterialVersion = billOfMaterialVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BOMVersionStatus</b>
     * </p>
     *
     * @param bOMVersionStatus
     *            BOM Version Status
     */
    public void setBOMVersionStatus( @Nullable final String bOMVersionStatus )
    {
        rememberChangedField("BOMVersionStatus", this.bOMVersionStatus);
        this.bOMVersionStatus = bOMVersionStatus;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsVersionBillOfMaterial</b>
     * </p>
     *
     * @param isVersionBillOfMaterial
     *            Indicator: Relevant for Versioning
     */
    public void setIsVersionBillOfMaterial( @Nullable final Boolean isVersionBillOfMaterial )
    {
        rememberChangedField("IsVersionBillOfMaterial", this.isVersionBillOfMaterial);
        this.isVersionBillOfMaterial = isVersionBillOfMaterial;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsLatestBOMVersion</b>
     * </p>
     *
     * @param isLatestBOMVersion
     *            Indicator: Latest Released BOM Version
     */
    public void setIsLatestBOMVersion( @Nullable final Boolean isLatestBOMVersion )
    {
        rememberChangedField("IsLatestBOMVersion", this.isLatestBOMVersion);
        this.isLatestBOMVersion = isLatestBOMVersion;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsConfiguredMaterial</b>
     * </p>
     *
     * @param isConfiguredMaterial
     *            Product is Configurable
     */
    public void setIsConfiguredMaterial( @Nullable final Boolean isConfiguredMaterial )
    {
        rememberChangedField("IsConfiguredMaterial", this.isConfiguredMaterial);
        this.isConfiguredMaterial = isConfiguredMaterial;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BOMTechnicalType</b>
     * </p>
     *
     * @param bOMTechnicalType
     *            Technical type
     */
    public void setBOMTechnicalType( @Nullable final String bOMTechnicalType )
    {
        rememberChangedField("BOMTechnicalType", this.bOMTechnicalType);
        this.bOMTechnicalType = bOMTechnicalType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>BOMGroup</b>
     * </p>
     *
     * @param bOMGroup
     *            BOM group
     */
    public void setBOMGroup( @Nullable final String bOMGroup )
    {
        rememberChangedField("BOMGroup", this.bOMGroup);
        this.bOMGroup = bOMGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BOMHeaderText</b>
     * </p>
     *
     * @param bOMHeaderText
     *            BOM Description
     */
    public void setBOMHeaderText( @Nullable final String bOMHeaderText )
    {
        rememberChangedField("BOMHeaderText", this.bOMHeaderText);
        this.bOMHeaderText = bOMHeaderText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BOMAlternativeText</b>
     * </p>
     *
     * @param bOMAlternativeText
     *            Alternative BOM Text
     */
    public void setBOMAlternativeText( @Nullable final String bOMAlternativeText )
    {
        rememberChangedField("BOMAlternativeText", this.bOMAlternativeText);
        this.bOMAlternativeText = bOMAlternativeText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialStatus</b>
     * </p>
     *
     * @param billOfMaterialStatus
     *            Bill of Material Status
     */
    public void setBillOfMaterialStatus( @Nullable final String billOfMaterialStatus )
    {
        rememberChangedField("BillOfMaterialStatus", this.billOfMaterialStatus);
        this.billOfMaterialStatus = billOfMaterialStatus;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>HeaderValidityStartDate</b>
     * </p>
     *
     * @param headerValidityStartDate
     *            Valid-From Date
     */
    public void setHeaderValidityStartDate( @Nullable final LocalDateTime headerValidityStartDate )
    {
        rememberChangedField("HeaderValidityStartDate", this.headerValidityStartDate);
        this.headerValidityStartDate = headerValidityStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>HeaderValidityEndDate</b>
     * </p>
     *
     * @param headerValidityEndDate
     *            Valid-to date
     */
    public void setHeaderValidityEndDate( @Nullable final LocalDateTime headerValidityEndDate )
    {
        rememberChangedField("HeaderValidityEndDate", this.headerValidityEndDate);
        this.headerValidityEndDate = headerValidityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>EngineeringChangeDocument</b>
     * </p>
     *
     * @param engineeringChangeDocument
     *            Change Number
     */
    public void setEngineeringChangeDocument( @Nullable final String engineeringChangeDocument )
    {
        rememberChangedField("EngineeringChangeDocument", this.engineeringChangeDocument);
        this.engineeringChangeDocument = engineeringChangeDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>EngineeringChangeDocForEdit</b>
     * </p>
     *
     * @param engineeringChangeDocForEdit
     *            Change Number
     */
    public void setEngineeringChangeDocForEdit( @Nullable final String engineeringChangeDocForEdit )
    {
        rememberChangedField("EngineeringChangeDocForEdit", this.engineeringChangeDocForEdit);
        this.engineeringChangeDocForEdit = engineeringChangeDocForEdit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChgToEngineeringChgDocument</b>
     * </p>
     *
     * @param chgToEngineeringChgDocument
     *            Change Number To
     */
    public void setChgToEngineeringChgDocument( @Nullable final String chgToEngineeringChgDocument )
    {
        rememberChangedField("ChgToEngineeringChgDocument", this.chgToEngineeringChgDocument);
        this.chgToEngineeringChgDocument = chgToEngineeringChgDocument;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsMarkedForDeletion</b>
     * </p>
     *
     * @param isMarkedForDeletion
     *            Deletion Indicator
     */
    public void setIsMarkedForDeletion( @Nullable final Boolean isMarkedForDeletion )
    {
        rememberChangedField("IsMarkedForDeletion", this.isMarkedForDeletion);
        this.isMarkedForDeletion = isMarkedForDeletion;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsALE</b>
     * </p>
     *
     * @param isALE
     *            ALE indicator
     */
    public void setIsALE( @Nullable final Boolean isALE )
    {
        rememberChangedField("IsALE", this.isALE);
        this.isALE = isALE;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BOMHeaderBaseUnit</b>
     * </p>
     *
     * @param bOMHeaderBaseUnit
     *            Base Unit of Measure for BOM
     */
    public void setBOMHeaderBaseUnit( @Nullable final String bOMHeaderBaseUnit )
    {
        rememberChangedField("BOMHeaderBaseUnit", this.bOMHeaderBaseUnit);
        this.bOMHeaderBaseUnit = bOMHeaderBaseUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BOMHeaderQuantityInBaseUnit</b>
     * </p>
     *
     * @param bOMHeaderQuantityInBaseUnit
     *            Base quantity
     */
    public void setBOMHeaderQuantityInBaseUnit( @Nullable final BigDecimal bOMHeaderQuantityInBaseUnit )
    {
        rememberChangedField("BOMHeaderQuantityInBaseUnit", this.bOMHeaderQuantityInBaseUnit);
        this.bOMHeaderQuantityInBaseUnit = bOMHeaderQuantityInBaseUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RecordCreationDate</b>
     * </p>
     *
     * @param recordCreationDate
     *            Date Record Created On
     */
    public void setRecordCreationDate( @Nullable final LocalDateTime recordCreationDate )
    {
        rememberChangedField("RecordCreationDate", this.recordCreationDate);
        this.recordCreationDate = recordCreationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Last Changed On
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            User Who Created Record
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Name of Person Who Changed Object
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BOMIsToBeDeleted</b>
     * </p>
     *
     * @param bOMIsToBeDeleted
     *            Handling Deletion Flag During BOM Explosion
     */
    public void setBOMIsToBeDeleted( @Nullable final String bOMIsToBeDeleted )
    {
        rememberChangedField("BOMIsToBeDeleted", this.bOMIsToBeDeleted);
        this.bOMIsToBeDeleted = bOMIsToBeDeleted;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DocumentIsCreatedByCAD</b>
     * </p>
     *
     * @param documentIsCreatedByCAD
     *            CAD Indicator
     */
    public void setDocumentIsCreatedByCAD( @Nullable final Boolean documentIsCreatedByCAD )
    {
        rememberChangedField("DocumentIsCreatedByCAD", this.documentIsCreatedByCAD);
        this.documentIsCreatedByCAD = documentIsCreatedByCAD;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>LaboratoryOrDesignOffice</b>
     * </p>
     *
     * @param laboratoryOrDesignOffice
     *            Laboratory/design office
     */
    public void setLaboratoryOrDesignOffice( @Nullable final String laboratoryOrDesignOffice )
    {
        rememberChangedField("LaboratoryOrDesignOffice", this.laboratoryOrDesignOffice);
        this.laboratoryOrDesignOffice = laboratoryOrDesignOffice;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SelectedBillOfMaterialVersion</b>
     * </p>
     *
     * @param selectedBillOfMaterialVersion
     *            The selectedBillOfMaterialVersion to set.
     */
    public void setSelectedBillOfMaterialVersion( @Nullable final String selectedBillOfMaterialVersion )
    {
        rememberChangedField("SelectedBillOfMaterialVersion", this.selectedBillOfMaterialVersion);
        this.selectedBillOfMaterialVersion = selectedBillOfMaterialVersion;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BillOfMaterial";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BillOfMaterialHeaderUUID", getBillOfMaterialHeaderUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BillOfMaterialHeaderUUID", getBillOfMaterialHeaderUUID());
        values.put("BillOfMaterialVariantUsage", getBillOfMaterialVariantUsage());
        values.put("BillOfMaterialCategory", getBillOfMaterialCategory());
        values.put("BillOfMaterial", getBillOfMaterial());
        values.put("BillOfMaterialVariant", getBillOfMaterialVariant());
        values.put("Material", getMaterial());
        values.put("Plant", getPlant());
        values.put("IsMultipleBOMAlt", getIsMultipleBOMAlt());
        values.put("BOMHeaderInternalChangeCount", getBOMHeaderInternalChangeCount());
        values.put("BOMUsagePriority", getBOMUsagePriority());
        values.put("BillOfMaterialAuthsnGrp", getBillOfMaterialAuthsnGrp());
        values.put("BillOfMaterialVersion", getBillOfMaterialVersion());
        values.put("BOMVersionStatus", getBOMVersionStatus());
        values.put("IsVersionBillOfMaterial", getIsVersionBillOfMaterial());
        values.put("IsLatestBOMVersion", getIsLatestBOMVersion());
        values.put("IsConfiguredMaterial", getIsConfiguredMaterial());
        values.put("BOMTechnicalType", getBOMTechnicalType());
        values.put("BOMGroup", getBOMGroup());
        values.put("BOMHeaderText", getBOMHeaderText());
        values.put("BOMAlternativeText", getBOMAlternativeText());
        values.put("BillOfMaterialStatus", getBillOfMaterialStatus());
        values.put("HeaderValidityStartDate", getHeaderValidityStartDate());
        values.put("HeaderValidityEndDate", getHeaderValidityEndDate());
        values.put("EngineeringChangeDocument", getEngineeringChangeDocument());
        values.put("EngineeringChangeDocForEdit", getEngineeringChangeDocForEdit());
        values.put("ChgToEngineeringChgDocument", getChgToEngineeringChgDocument());
        values.put("IsMarkedForDeletion", getIsMarkedForDeletion());
        values.put("IsALE", getIsALE());
        values.put("BOMHeaderBaseUnit", getBOMHeaderBaseUnit());
        values.put("BOMHeaderQuantityInBaseUnit", getBOMHeaderQuantityInBaseUnit());
        values.put("RecordCreationDate", getRecordCreationDate());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("BOMIsToBeDeleted", getBOMIsToBeDeleted());
        values.put("DocumentIsCreatedByCAD", getDocumentIsCreatedByCAD());
        values.put("LaboratoryOrDesignOffice", getLaboratoryOrDesignOffice());
        values.put("SelectedBillOfMaterialVersion", getSelectedBillOfMaterialVersion());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BillOfMaterialHeaderUUID") ) {
                final Object value = values.remove("BillOfMaterialHeaderUUID");
                if( (value == null) || (!value.equals(getBillOfMaterialHeaderUUID())) ) {
                    setBillOfMaterialHeaderUUID(((UUID) value));
                }
            }
            if( values.containsKey("BillOfMaterialVariantUsage") ) {
                final Object value = values.remove("BillOfMaterialVariantUsage");
                if( (value == null) || (!value.equals(getBillOfMaterialVariantUsage())) ) {
                    setBillOfMaterialVariantUsage(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialCategory") ) {
                final Object value = values.remove("BillOfMaterialCategory");
                if( (value == null) || (!value.equals(getBillOfMaterialCategory())) ) {
                    setBillOfMaterialCategory(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterial") ) {
                final Object value = values.remove("BillOfMaterial");
                if( (value == null) || (!value.equals(getBillOfMaterial())) ) {
                    setBillOfMaterial(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialVariant") ) {
                final Object value = values.remove("BillOfMaterialVariant");
                if( (value == null) || (!value.equals(getBillOfMaterialVariant())) ) {
                    setBillOfMaterialVariant(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("IsMultipleBOMAlt") ) {
                final Object value = values.remove("IsMultipleBOMAlt");
                if( (value == null) || (!value.equals(getIsMultipleBOMAlt())) ) {
                    setIsMultipleBOMAlt(((Boolean) value));
                }
            }
            if( values.containsKey("BOMHeaderInternalChangeCount") ) {
                final Object value = values.remove("BOMHeaderInternalChangeCount");
                if( (value == null) || (!value.equals(getBOMHeaderInternalChangeCount())) ) {
                    setBOMHeaderInternalChangeCount(((String) value));
                }
            }
            if( values.containsKey("BOMUsagePriority") ) {
                final Object value = values.remove("BOMUsagePriority");
                if( (value == null) || (!value.equals(getBOMUsagePriority())) ) {
                    setBOMUsagePriority(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialAuthsnGrp") ) {
                final Object value = values.remove("BillOfMaterialAuthsnGrp");
                if( (value == null) || (!value.equals(getBillOfMaterialAuthsnGrp())) ) {
                    setBillOfMaterialAuthsnGrp(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialVersion") ) {
                final Object value = values.remove("BillOfMaterialVersion");
                if( (value == null) || (!value.equals(getBillOfMaterialVersion())) ) {
                    setBillOfMaterialVersion(((String) value));
                }
            }
            if( values.containsKey("BOMVersionStatus") ) {
                final Object value = values.remove("BOMVersionStatus");
                if( (value == null) || (!value.equals(getBOMVersionStatus())) ) {
                    setBOMVersionStatus(((String) value));
                }
            }
            if( values.containsKey("IsVersionBillOfMaterial") ) {
                final Object value = values.remove("IsVersionBillOfMaterial");
                if( (value == null) || (!value.equals(getIsVersionBillOfMaterial())) ) {
                    setIsVersionBillOfMaterial(((Boolean) value));
                }
            }
            if( values.containsKey("IsLatestBOMVersion") ) {
                final Object value = values.remove("IsLatestBOMVersion");
                if( (value == null) || (!value.equals(getIsLatestBOMVersion())) ) {
                    setIsLatestBOMVersion(((Boolean) value));
                }
            }
            if( values.containsKey("IsConfiguredMaterial") ) {
                final Object value = values.remove("IsConfiguredMaterial");
                if( (value == null) || (!value.equals(getIsConfiguredMaterial())) ) {
                    setIsConfiguredMaterial(((Boolean) value));
                }
            }
            if( values.containsKey("BOMTechnicalType") ) {
                final Object value = values.remove("BOMTechnicalType");
                if( (value == null) || (!value.equals(getBOMTechnicalType())) ) {
                    setBOMTechnicalType(((String) value));
                }
            }
            if( values.containsKey("BOMGroup") ) {
                final Object value = values.remove("BOMGroup");
                if( (value == null) || (!value.equals(getBOMGroup())) ) {
                    setBOMGroup(((String) value));
                }
            }
            if( values.containsKey("BOMHeaderText") ) {
                final Object value = values.remove("BOMHeaderText");
                if( (value == null) || (!value.equals(getBOMHeaderText())) ) {
                    setBOMHeaderText(((String) value));
                }
            }
            if( values.containsKey("BOMAlternativeText") ) {
                final Object value = values.remove("BOMAlternativeText");
                if( (value == null) || (!value.equals(getBOMAlternativeText())) ) {
                    setBOMAlternativeText(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialStatus") ) {
                final Object value = values.remove("BillOfMaterialStatus");
                if( (value == null) || (!value.equals(getBillOfMaterialStatus())) ) {
                    setBillOfMaterialStatus(((String) value));
                }
            }
            if( values.containsKey("HeaderValidityStartDate") ) {
                final Object value = values.remove("HeaderValidityStartDate");
                if( (value == null) || (!value.equals(getHeaderValidityStartDate())) ) {
                    setHeaderValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("HeaderValidityEndDate") ) {
                final Object value = values.remove("HeaderValidityEndDate");
                if( (value == null) || (!value.equals(getHeaderValidityEndDate())) ) {
                    setHeaderValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("EngineeringChangeDocument") ) {
                final Object value = values.remove("EngineeringChangeDocument");
                if( (value == null) || (!value.equals(getEngineeringChangeDocument())) ) {
                    setEngineeringChangeDocument(((String) value));
                }
            }
            if( values.containsKey("EngineeringChangeDocForEdit") ) {
                final Object value = values.remove("EngineeringChangeDocForEdit");
                if( (value == null) || (!value.equals(getEngineeringChangeDocForEdit())) ) {
                    setEngineeringChangeDocForEdit(((String) value));
                }
            }
            if( values.containsKey("ChgToEngineeringChgDocument") ) {
                final Object value = values.remove("ChgToEngineeringChgDocument");
                if( (value == null) || (!value.equals(getChgToEngineeringChgDocument())) ) {
                    setChgToEngineeringChgDocument(((String) value));
                }
            }
            if( values.containsKey("IsMarkedForDeletion") ) {
                final Object value = values.remove("IsMarkedForDeletion");
                if( (value == null) || (!value.equals(getIsMarkedForDeletion())) ) {
                    setIsMarkedForDeletion(((Boolean) value));
                }
            }
            if( values.containsKey("IsALE") ) {
                final Object value = values.remove("IsALE");
                if( (value == null) || (!value.equals(getIsALE())) ) {
                    setIsALE(((Boolean) value));
                }
            }
            if( values.containsKey("BOMHeaderBaseUnit") ) {
                final Object value = values.remove("BOMHeaderBaseUnit");
                if( (value == null) || (!value.equals(getBOMHeaderBaseUnit())) ) {
                    setBOMHeaderBaseUnit(((String) value));
                }
            }
            if( values.containsKey("BOMHeaderQuantityInBaseUnit") ) {
                final Object value = values.remove("BOMHeaderQuantityInBaseUnit");
                if( (value == null) || (!value.equals(getBOMHeaderQuantityInBaseUnit())) ) {
                    setBOMHeaderQuantityInBaseUnit(((BigDecimal) value));
                }
            }
            if( values.containsKey("RecordCreationDate") ) {
                final Object value = values.remove("RecordCreationDate");
                if( (value == null) || (!value.equals(getRecordCreationDate())) ) {
                    setRecordCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("BOMIsToBeDeleted") ) {
                final Object value = values.remove("BOMIsToBeDeleted");
                if( (value == null) || (!value.equals(getBOMIsToBeDeleted())) ) {
                    setBOMIsToBeDeleted(((String) value));
                }
            }
            if( values.containsKey("DocumentIsCreatedByCAD") ) {
                final Object value = values.remove("DocumentIsCreatedByCAD");
                if( (value == null) || (!value.equals(getDocumentIsCreatedByCAD())) ) {
                    setDocumentIsCreatedByCAD(((Boolean) value));
                }
            }
            if( values.containsKey("LaboratoryOrDesignOffice") ) {
                final Object value = values.remove("LaboratoryOrDesignOffice");
                if( (value == null) || (!value.equals(getLaboratoryOrDesignOffice())) ) {
                    setLaboratoryOrDesignOffice(((String) value));
                }
            }
            if( values.containsKey("SelectedBillOfMaterialVersion") ) {
                final Object value = values.remove("SelectedBillOfMaterialVersion");
                if( (value == null) || (!value.equals(getSelectedBillOfMaterialVersion())) ) {
                    setSelectedBillOfMaterialVersion(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_BillOfMaterialItem") ) {
                final Object value = (values).remove("to_BillOfMaterialItem");
                if( value instanceof Iterable ) {
                    if( toBillOfMaterialItem == null ) {
                        toBillOfMaterialItem = Lists.newArrayList();
                    } else {
                        toBillOfMaterialItem = Lists.newArrayList(toBillOfMaterialItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BillOfMaterialItem entity;
                        if( toBillOfMaterialItem.size() > i ) {
                            entity = toBillOfMaterialItem.get(i);
                        } else {
                            entity = new BillOfMaterialItem();
                            toBillOfMaterialItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_BillOfMaterialUsage") ) {
                final Object value = (values).remove("to_BillOfMaterialUsage");
                if( value instanceof Map ) {
                    if( toBillOfMaterialUsage == null ) {
                        toBillOfMaterialUsage = new BillOfMaterialUsage();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBillOfMaterialUsage.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> BillOfMaterialField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BillOfMaterialField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BillOfMaterialField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BillOfMaterialField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillOfMaterialsService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBillOfMaterialItem != null ) {
            (values).put("to_BillOfMaterialItem", toBillOfMaterialItem);
        }
        if( toBillOfMaterialUsage != null ) {
            (values).put("to_BillOfMaterialUsage", toBillOfMaterialUsage);
        }
        return values;
    }

    /**
     * Fetches the <b>BillOfMaterialItem</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_BillOfMaterialItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BillOfMaterialItem</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BillOfMaterialItem> fetchBillOfMaterialItem()
    {
        return fetchFieldAsList("to_BillOfMaterialItem", BillOfMaterialItem.class);
    }

    /**
     * Retrieval of associated <b>BillOfMaterialItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BillOfMaterialItem</b>.
     * <p>
     * If the navigation property <b>to_BillOfMaterialItem</b> of a queried <b>BillOfMaterial</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BillOfMaterialItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BillOfMaterialItem> getBillOfMaterialItemOrFetch()
    {
        if( toBillOfMaterialItem == null ) {
            toBillOfMaterialItem = fetchBillOfMaterialItem();
        }
        return toBillOfMaterialItem;
    }

    /**
     * Retrieval of associated <b>BillOfMaterialItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BillOfMaterialItem</b>.
     * <p>
     * If the navigation property for an entity <b>BillOfMaterial</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BillOfMaterialItem</b> is already loaded, the result
     *         will contain the <b>BillOfMaterialItem</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BillOfMaterialItem>> getBillOfMaterialItemIfPresent()
    {
        return Option.of(toBillOfMaterialItem);
    }

    /**
     * Overwrites the list of associated <b>BillOfMaterialItem</b> entities for the loaded navigation property
     * <b>to_BillOfMaterialItem</b>.
     * <p>
     * If the navigation property <b>to_BillOfMaterialItem</b> of a queried <b>BillOfMaterial</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BillOfMaterialItem</b> entities.
     */
    public void setBillOfMaterialItem( @Nonnull final List<BillOfMaterialItem> value )
    {
        if( toBillOfMaterialItem == null ) {
            toBillOfMaterialItem = Lists.newArrayList();
        }
        toBillOfMaterialItem.clear();
        toBillOfMaterialItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BillOfMaterialItem</b> entities. This corresponds to the OData
     * navigation property <b>to_BillOfMaterialItem</b>.
     * <p>
     * If the navigation property <b>to_BillOfMaterialItem</b> of a queried <b>BillOfMaterial</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BillOfMaterialItem</b> entities.
     */
    public void addBillOfMaterialItem( BillOfMaterialItem... entity )
    {
        if( toBillOfMaterialItem == null ) {
            toBillOfMaterialItem = Lists.newArrayList();
        }
        toBillOfMaterialItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BillOfMaterialUsage</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_BillOfMaterialUsage</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BillOfMaterialUsage</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BillOfMaterialUsage fetchBillOfMaterialUsage()
    {
        return fetchFieldAsSingle("to_BillOfMaterialUsage", BillOfMaterialUsage.class);
    }

    /**
     * Retrieval of associated <b>BillOfMaterialUsage</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BillOfMaterialUsage</b>.
     * <p>
     * If the navigation property <b>to_BillOfMaterialUsage</b> of a queried <b>BillOfMaterial</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BillOfMaterialUsage</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BillOfMaterialUsage getBillOfMaterialUsageOrFetch()
    {
        if( toBillOfMaterialUsage == null ) {
            toBillOfMaterialUsage = fetchBillOfMaterialUsage();
        }
        return toBillOfMaterialUsage;
    }

    /**
     * Retrieval of associated <b>BillOfMaterialUsage</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BillOfMaterialUsage</b>.
     * <p>
     * If the navigation property for an entity <b>BillOfMaterial</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BillOfMaterialUsage</b> is already loaded, the result
     *         will contain the <b>BillOfMaterialUsage</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<BillOfMaterialUsage> getBillOfMaterialUsageIfPresent()
    {
        return Option.of(toBillOfMaterialUsage);
    }

    /**
     * Overwrites the associated <b>BillOfMaterialUsage</b> entity for the loaded navigation property
     * <b>to_BillOfMaterialUsage</b>.
     *
     * @param value
     *            New <b>BillOfMaterialUsage</b> entity.
     */
    public void setBillOfMaterialUsage( final BillOfMaterialUsage value )
    {
        toBillOfMaterialUsage = value;
    }

    /**
     * Helper class to allow for fluent creation of BillOfMaterial instances.
     *
     */
    public final static class BillOfMaterialBuilder
    {

        private List<BillOfMaterialItem> toBillOfMaterialItem = Lists.newArrayList();
        private BillOfMaterialUsage toBillOfMaterialUsage;

        private BillOfMaterial.BillOfMaterialBuilder toBillOfMaterialItem( final List<BillOfMaterialItem> value )
        {
            toBillOfMaterialItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_BillOfMaterialItem</b> for <b>BillOfMaterial</b> to multiple
         * <b>BillOfMaterialItem</b>.
         *
         * @param value
         *            The BillOfMaterialItems to build this BillOfMaterial with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BillOfMaterial.BillOfMaterialBuilder billOfMaterialItem( BillOfMaterialItem... value )
        {
            return toBillOfMaterialItem(Lists.newArrayList(value));
        }

        private BillOfMaterial.BillOfMaterialBuilder toBillOfMaterialUsage( final BillOfMaterialUsage value )
        {
            toBillOfMaterialUsage = value;
            return this;
        }

        /**
         * Navigation property <b>to_BillOfMaterialUsage</b> for <b>BillOfMaterial</b> to single
         * <b>BillOfMaterialUsage</b>.
         *
         * @param value
         *            The BillOfMaterialUsage to build this BillOfMaterial with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BillOfMaterial.BillOfMaterialBuilder billOfMaterialUsage( final BillOfMaterialUsage value )
        {
            return toBillOfMaterialUsage(value);
        }

    }

}
