/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.selectable.BillOfMaterialSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial BillOfMaterial} entity
 * using key fields. This fluent helper allows methods which modify the underlying query to be called before executing
 * the query itself.
 *
 */
public class BillOfMaterialByKeyFluentHelper
    extends
    FluentHelperByKey<BillOfMaterialByKeyFluentHelper, BillOfMaterial, BillOfMaterialSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial BillOfMaterial} entity
     * with the provided key field values. To perform execution, call the {@link #executeRequest executeRequest} method
     * on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code BillOfMaterial}
     * @param billOfMaterialHeaderUUID
     *            Global identification of a BOM header change status
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code BillOfMaterial}
     */
    public BillOfMaterialByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final UUID billOfMaterialHeaderUUID )
    {
        super(servicePath, entityCollection);
        this.key.put("BillOfMaterialHeaderUUID", billOfMaterialHeaderUUID);
    }

    @Override
    @Nonnull
    protected Class<BillOfMaterial> getEntityClass()
    {
        return BillOfMaterial.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
