/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.selectable.BillOfMaterialItemSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialItem BillOfMaterialItem}
 * entity using key fields. This fluent helper allows methods which modify the underlying query to be called before
 * executing the query itself.
 *
 */
public class BillOfMaterialItemByKeyFluentHelper
    extends
    FluentHelperByKey<BillOfMaterialItemByKeyFluentHelper, BillOfMaterialItem, BillOfMaterialItemSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialItem BillOfMaterialItem}
     * entity with the provided key field values. To perform execution, call the {@link #executeRequest executeRequest}
     * method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code BillOfMaterialItem}
     * @param billOfMaterialItemUUID
     *            Global identification of an item's change status
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code BillOfMaterialItem}
     */
    public BillOfMaterialItemByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final UUID billOfMaterialItemUUID )
    {
        super(servicePath, entityCollection);
        this.key.put("BillOfMaterialItemUUID", billOfMaterialItemUUID);
    }

    @Override
    @Nonnull
    protected Class<BillOfMaterialItem> getEntityClass()
    {
        return BillOfMaterialItem.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
