/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.field.BillOfMaterialUsageField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.link.BillOfMaterialUsageOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.selectable.BillOfMaterialUsageSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Usage
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BillOfMaterialUsageType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BillOfMaterialUsage extends VdmEntity<BillOfMaterialUsage>
{

    /**
     * Selector for all available fields of BillOfMaterialUsage.
     *
     */
    public final static BillOfMaterialUsageSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialVariantUsage</b>
     * </p>
     *
     * @return BOM Usage
     */
    @Key
    @SerializedName( "BillOfMaterialVariantUsage" )
    @JsonProperty( "BillOfMaterialVariantUsage" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialVariantUsage" )
    private String billOfMaterialVariantUsage;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialVariantUsage</b> field to query operations.
     *
     */
    public final static BillOfMaterialUsageField<String> BILL_OF_MATERIAL_VARIANT_USAGE =
        new BillOfMaterialUsageField<String>("BillOfMaterialVariantUsage");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialVariantUsageDesc</b>
     * </p>
     *
     * @return BOM usage text
     */
    @SerializedName( "BillOfMaterialVariantUsageDesc" )
    @JsonProperty( "BillOfMaterialVariantUsageDesc" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialVariantUsageDesc" )
    private String billOfMaterialVariantUsageDesc;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialVariantUsageDesc</b> field to query operations.
     *
     */
    public final static BillOfMaterialUsageField<String> BILL_OF_MATERIAL_VARIANT_USAGE_DESC =
        new BillOfMaterialUsageField<String>("BillOfMaterialVariantUsageDesc");
    /**
     * Navigation property <b>to_BillOfMaterialUsageText</b> for <b>BillOfMaterialUsage</b> to single
     * <b>BillOfMaterialUsageText</b>.
     *
     */
    @SerializedName( "to_BillOfMaterialUsageText" )
    @JsonProperty( "to_BillOfMaterialUsageText" )
    @ODataField( odataName = "to_BillOfMaterialUsageText" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BillOfMaterialUsageText toBillOfMaterialUsageText;
    /**
     * Use with available fluent helpers to apply the <b>to_BillOfMaterialUsageText</b> navigation property to query
     * operations.
     *
     */
    public final static BillOfMaterialUsageOneToOneLink<BillOfMaterialUsageText> TO_BILL_OF_MATERIAL_USAGE_TEXT =
        new BillOfMaterialUsageOneToOneLink<BillOfMaterialUsageText>("to_BillOfMaterialUsageText");

    @Nonnull
    @Override
    public Class<BillOfMaterialUsage> getType()
    {
        return BillOfMaterialUsage.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialVariantUsage</b>
     * </p>
     *
     * @param billOfMaterialVariantUsage
     *            BOM Usage
     */
    public void setBillOfMaterialVariantUsage( @Nullable final String billOfMaterialVariantUsage )
    {
        rememberChangedField("BillOfMaterialVariantUsage", this.billOfMaterialVariantUsage);
        this.billOfMaterialVariantUsage = billOfMaterialVariantUsage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialVariantUsageDesc</b>
     * </p>
     *
     * @param billOfMaterialVariantUsageDesc
     *            BOM usage text
     */
    public void setBillOfMaterialVariantUsageDesc( @Nullable final String billOfMaterialVariantUsageDesc )
    {
        rememberChangedField("BillOfMaterialVariantUsageDesc", this.billOfMaterialVariantUsageDesc);
        this.billOfMaterialVariantUsageDesc = billOfMaterialVariantUsageDesc;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BillOfMaterialUsage";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BillOfMaterialVariantUsage", getBillOfMaterialVariantUsage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BillOfMaterialVariantUsage", getBillOfMaterialVariantUsage());
        values.put("BillOfMaterialVariantUsageDesc", getBillOfMaterialVariantUsageDesc());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BillOfMaterialVariantUsage") ) {
                final Object value = values.remove("BillOfMaterialVariantUsage");
                if( (value == null) || (!value.equals(getBillOfMaterialVariantUsage())) ) {
                    setBillOfMaterialVariantUsage(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialVariantUsageDesc") ) {
                final Object value = values.remove("BillOfMaterialVariantUsageDesc");
                if( (value == null) || (!value.equals(getBillOfMaterialVariantUsageDesc())) ) {
                    setBillOfMaterialVariantUsageDesc(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_BillOfMaterialUsageText") ) {
                final Object value = (values).remove("to_BillOfMaterialUsageText");
                if( value instanceof Map ) {
                    if( toBillOfMaterialUsageText == null ) {
                        toBillOfMaterialUsageText = new BillOfMaterialUsageText();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBillOfMaterialUsageText.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> BillOfMaterialUsageField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BillOfMaterialUsageField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BillOfMaterialUsageField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BillOfMaterialUsageField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillOfMaterialsService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBillOfMaterialUsageText != null ) {
            (values).put("to_BillOfMaterialUsageText", toBillOfMaterialUsageText);
        }
        return values;
    }

    /**
     * Fetches the <b>BillOfMaterialUsageText</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_BillOfMaterialUsageText</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BillOfMaterialUsageText</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BillOfMaterialUsageText fetchBillOfMaterialUsageText()
    {
        return fetchFieldAsSingle("to_BillOfMaterialUsageText", BillOfMaterialUsageText.class);
    }

    /**
     * Retrieval of associated <b>BillOfMaterialUsageText</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_BillOfMaterialUsageText</b>.
     * <p>
     * If the navigation property <b>to_BillOfMaterialUsageText</b> of a queried <b>BillOfMaterialUsage</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BillOfMaterialUsageText</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BillOfMaterialUsageText getBillOfMaterialUsageTextOrFetch()
    {
        if( toBillOfMaterialUsageText == null ) {
            toBillOfMaterialUsageText = fetchBillOfMaterialUsageText();
        }
        return toBillOfMaterialUsageText;
    }

    /**
     * Retrieval of associated <b>BillOfMaterialUsageText</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_BillOfMaterialUsageText</b>.
     * <p>
     * If the navigation property for an entity <b>BillOfMaterialUsage</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BillOfMaterialUsageText</b> is already loaded, the
     *         result will contain the <b>BillOfMaterialUsageText</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<BillOfMaterialUsageText> getBillOfMaterialUsageTextIfPresent()
    {
        return Option.of(toBillOfMaterialUsageText);
    }

    /**
     * Overwrites the associated <b>BillOfMaterialUsageText</b> entity for the loaded navigation property
     * <b>to_BillOfMaterialUsageText</b>.
     *
     * @param value
     *            New <b>BillOfMaterialUsageText</b> entity.
     */
    public void setBillOfMaterialUsageText( final BillOfMaterialUsageText value )
    {
        toBillOfMaterialUsageText = value;
    }

    /**
     * Helper class to allow for fluent creation of BillOfMaterialUsage instances.
     *
     */
    public final static class BillOfMaterialUsageBuilder
    {

        private BillOfMaterialUsageText toBillOfMaterialUsageText;

        private BillOfMaterialUsage.BillOfMaterialUsageBuilder toBillOfMaterialUsageText(
            final BillOfMaterialUsageText value )
        {
            toBillOfMaterialUsageText = value;
            return this;
        }

        /**
         * Navigation property <b>to_BillOfMaterialUsageText</b> for <b>BillOfMaterialUsage</b> to single
         * <b>BillOfMaterialUsageText</b>.
         *
         * @param value
         *            The BillOfMaterialUsageText to build this BillOfMaterialUsage with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BillOfMaterialUsage.BillOfMaterialUsageBuilder billOfMaterialUsageText(
            final BillOfMaterialUsageText value )
        {
            return toBillOfMaterialUsageText(value);
        }

    }

}
