/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialItem;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillOfMaterialsService BillOfMaterialsService}.
 *
 */
public interface BillOfMaterialsServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<BillOfMaterialsServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<BillOfMaterialsServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial
     * BillOfMaterial} entity and save it to the S/4HANA system.
     *
     * @param billOfMaterial
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial
     *            BillOfMaterial} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BillOfMaterialsServiceBatchChangeSet createBillOfMaterial( @Nonnull final BillOfMaterial billOfMaterial );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial
     * BillOfMaterial} entity and save it to the S/4HANA system.
     *
     * @param billOfMaterial
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial
     *            BillOfMaterial} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BillOfMaterialsServiceBatchChangeSet updateBillOfMaterial( @Nonnull final BillOfMaterial billOfMaterial );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialItem
     * BillOfMaterialItem} entity and save it to the S/4HANA system.
     *
     * @param billOfMaterialItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialItem
     *            BillOfMaterialItem} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BillOfMaterialsServiceBatchChangeSet
        createBillOfMaterialItem( @Nonnull final BillOfMaterialItem billOfMaterialItem );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialItem
     * BillOfMaterialItem} entity and save it to the S/4HANA system.
     *
     * @param billOfMaterialItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialItem
     *            BillOfMaterialItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BillOfMaterialsServiceBatchChangeSet
        updateBillOfMaterialItem( @Nonnull final BillOfMaterialItem billOfMaterialItem );

}
