/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link BillOfMaterialsServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillOfMaterialsService BillOfMaterialsService}, allowing you
 * to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultBillOfMaterialsServiceBatch
    extends
    BatchFluentHelperBasic<BillOfMaterialsServiceBatch, BillOfMaterialsServiceBatchChangeSet>
    implements
    BillOfMaterialsServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillOfMaterialsService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultBillOfMaterialsServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultBillOfMaterialsServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillOfMaterialsService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillOfMaterialsService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultBillOfMaterialsServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultBillOfMaterialsServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillOfMaterialsService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultBillOfMaterialsServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public BillOfMaterialsServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultBillOfMaterialsServiceBatchChangeSet(this, service);
    }

}
