/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialItem;

/**
 * Implementation of the {@link BillOfMaterialsServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillOfMaterialsService BillOfMaterialsService}.
 *
 */
public class DefaultBillOfMaterialsServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<BillOfMaterialsServiceBatch, BillOfMaterialsServiceBatchChangeSet>
    implements
    BillOfMaterialsServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillOfMaterialsService service;

    @SuppressWarnings( "deprecation" )
    DefaultBillOfMaterialsServiceBatchChangeSet(
        @Nonnull final DefaultBillOfMaterialsServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillOfMaterialsService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultBillOfMaterialsServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public BillOfMaterialsServiceBatchChangeSet createBillOfMaterial( @Nonnull final BillOfMaterial billOfMaterial )
    {
        return addRequestCreate(service::createBillOfMaterial, billOfMaterial);
    }

    @Nonnull
    @Override
    public BillOfMaterialsServiceBatchChangeSet updateBillOfMaterial( @Nonnull final BillOfMaterial billOfMaterial )
    {
        return addRequestUpdate(service::updateBillOfMaterial, billOfMaterial);
    }

    @Nonnull
    @Override
    public BillOfMaterialsServiceBatchChangeSet createBillOfMaterialItem(
        @Nonnull final BillOfMaterialItem billOfMaterialItem )
    {
        return addRequestCreate(service::createBillOfMaterialItem, billOfMaterialItem);
    }

    @Nonnull
    @Override
    public BillOfMaterialsServiceBatchChangeSet updateBillOfMaterialItem(
        @Nonnull final BillOfMaterialItem billOfMaterialItem )
    {
        return addRequestUpdate(service::updateBillOfMaterialItem, billOfMaterialItem);
    }

}
