/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BOMItemCategory;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BOMItemCategory BOMItemCategory}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.field.BOMItemCategoryField
 * BOMItemCategoryField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.link.BOMItemCategoryLink
 * BOMItemCategoryLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BOMItemCategory#BILL_OF_MATERIAL_ITEM_CATEGORY
 * BILL_OF_MATERIAL_ITEM_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BOMItemCategory#FIXED_ITEM_CATEGORY
 * FIXED_ITEM_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BOMItemCategory#BILL_OF_MATERIAL_ITEM_CATEGORY_DESC
 * BILL_OF_MATERIAL_ITEM_CATEGORY_DESC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BOMItemCategory#TO_BOM_ITEM_CATEGORY_TEXT
 * TO_BOM_ITEM_CATEGORY_TEXT}</li>
 * </ul>
 *
 */
public interface BOMItemCategorySelectable extends EntitySelectable<BOMItemCategory>
{

}
