/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BOMItemCategoryText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BOMItemCategoryText BOMItemCategoryText}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.field.BOMItemCategoryTextField
 * BOMItemCategoryTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.link.BOMItemCategoryTextLink
 * BOMItemCategoryTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BOMItemCategoryText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BOMItemCategoryText#BILL_OF_MATERIAL_ITEM_CATEGORY
 * BILL_OF_MATERIAL_ITEM_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BOMItemCategoryText#BILL_OF_MATERIAL_ITEM_CATEGORY_DESC
 * BILL_OF_MATERIAL_ITEM_CATEGORY_DESC}</li>
 * </ul>
 *
 */
public interface BOMItemCategoryTextSelectable extends EntitySelectable<BOMItemCategoryText>
{

}
