/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial BillOfMaterial}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.field.BillOfMaterialField
 * BillOfMaterialField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.link.BillOfMaterialLink
 * BillOfMaterialLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial#BILL_OF_MATERIAL_HEADER_UUID
 * BILL_OF_MATERIAL_HEADER_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial#BILL_OF_MATERIAL_VARIANT_USAGE
 * BILL_OF_MATERIAL_VARIANT_USAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial#BILL_OF_MATERIAL_CATEGORY
 * BILL_OF_MATERIAL_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial#BILL_OF_MATERIAL
 * BILL_OF_MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial#BILL_OF_MATERIAL_VARIANT
 * BILL_OF_MATERIAL_VARIANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial#MATERIAL MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial#PLANT PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial#IS_MULTIPLE_BOM_ALT
 * IS_MULTIPLE_BOM_ALT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial#BOM_HEADER_INTERNAL_CHANGE_COUNT
 * BOM_HEADER_INTERNAL_CHANGE_COUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial#BOM_USAGE_PRIORITY
 * BOM_USAGE_PRIORITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial#BILL_OF_MATERIAL_AUTHSN_GRP
 * BILL_OF_MATERIAL_AUTHSN_GRP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial#BILL_OF_MATERIAL_VERSION
 * BILL_OF_MATERIAL_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial#BOM_VERSION_STATUS
 * BOM_VERSION_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial#IS_VERSION_BILL_OF_MATERIAL
 * IS_VERSION_BILL_OF_MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial#IS_LATEST_BOM_VERSION
 * IS_LATEST_BOM_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial#IS_CONFIGURED_MATERIAL
 * IS_CONFIGURED_MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial#BOM_TECHNICAL_TYPE
 * BOM_TECHNICAL_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial#BOM_GROUP
 * BOM_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial#BOM_HEADER_TEXT
 * BOM_HEADER_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial#BOM_ALTERNATIVE_TEXT
 * BOM_ALTERNATIVE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial#BILL_OF_MATERIAL_STATUS
 * BILL_OF_MATERIAL_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial#HEADER_VALIDITY_START_DATE
 * HEADER_VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial#HEADER_VALIDITY_END_DATE
 * HEADER_VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial#ENGINEERING_CHANGE_DOCUMENT
 * ENGINEERING_CHANGE_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial#ENGINEERING_CHANGE_DOC_FOR_EDIT
 * ENGINEERING_CHANGE_DOC_FOR_EDIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial#CHG_TO_ENGINEERING_CHG_DOCUMENT
 * CHG_TO_ENGINEERING_CHG_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial#IS_MARKED_FOR_DELETION
 * IS_MARKED_FOR_DELETION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial#IS_ALE IS_ALE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial#BOM_HEADER_BASE_UNIT
 * BOM_HEADER_BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial#BOM_HEADER_QUANTITY_IN_BASE_UNIT
 * BOM_HEADER_QUANTITY_IN_BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial#RECORD_CREATION_DATE
 * RECORD_CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial#LAST_CHANGE_DATE
 * LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial#BOM_IS_TO_BE_DELETED
 * BOM_IS_TO_BE_DELETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial#DOCUMENT_IS_CREATED_BY_CAD
 * DOCUMENT_IS_CREATED_BY_CAD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial#LABORATORY_OR_DESIGN_OFFICE
 * LABORATORY_OR_DESIGN_OFFICE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial#SELECTED_BILL_OF_MATERIAL_VERSION
 * SELECTED_BILL_OF_MATERIAL_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial#TO_BILL_OF_MATERIAL_ITEM
 * TO_BILL_OF_MATERIAL_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterial#TO_BILL_OF_MATERIAL_USAGE
 * TO_BILL_OF_MATERIAL_USAGE}</li>
 * </ul>
 *
 */
public interface BillOfMaterialSelectable extends EntitySelectable<BillOfMaterial>
{

}
