/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialUsage;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialUsage BillOfMaterialUsage}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.field.BillOfMaterialUsageField
 * BillOfMaterialUsageField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.link.BillOfMaterialUsageLink
 * BillOfMaterialUsageLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialUsage#BILL_OF_MATERIAL_VARIANT_USAGE
 * BILL_OF_MATERIAL_VARIANT_USAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialUsage#BILL_OF_MATERIAL_VARIANT_USAGE_DESC
 * BILL_OF_MATERIAL_VARIANT_USAGE_DESC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterials.BillOfMaterialUsage#TO_BILL_OF_MATERIAL_USAGE_TEXT
 * TO_BILL_OF_MATERIAL_USAGE_TEXT}</li>
 * </ul>
 *
 */
public interface BillOfMaterialUsageSelectable extends EntitySelectable<BillOfMaterialUsage>
{

}
