/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.selectable.BillOfMaterialUsageSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.BillOfMaterialUsage BillOfMaterialUsage}
 * entity using key fields. This fluent helper allows methods which modify the underlying query to be called before
 * executing the query itself.
 *
 */
public class BillOfMaterialUsageByKeyFluentHelper
    extends
    FluentHelperByKey<BillOfMaterialUsageByKeyFluentHelper, BillOfMaterialUsage, BillOfMaterialUsageSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.BillOfMaterialUsage
     * BillOfMaterialUsage} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code BillOfMaterialUsage}
     * @param servicePath
     *            Service path to be used to fetch a single {@code BillOfMaterialUsage}
     * @param billOfMaterialVariantUsage
     *            BOM Usage
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     */
    public BillOfMaterialUsageByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String billOfMaterialVariantUsage )
    {
        super(servicePath, entityCollection);
        this.key.put("BillOfMaterialVariantUsage", billOfMaterialVariantUsage);
    }

    @Override
    @Nonnull
    protected Class<BillOfMaterialUsage> getEntityClass()
    {
        return BillOfMaterialUsage.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
