/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.field.BillOfMaterialUsageTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.selectable.BillOfMaterialUsageTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Usage Description
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BillOfMaterialUsageTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BillOfMaterialUsageText extends VdmEntity<BillOfMaterialUsageText>
{

    /**
     * Selector for all available fields of BillOfMaterialUsageText.
     *
     */
    public final static BillOfMaterialUsageTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static BillOfMaterialUsageTextField<String> LANGUAGE =
        new BillOfMaterialUsageTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialVariantUsage</b>
     * </p>
     *
     * @return BOM Usage
     */
    @Key
    @SerializedName( "BillOfMaterialVariantUsage" )
    @JsonProperty( "BillOfMaterialVariantUsage" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialVariantUsage" )
    private String billOfMaterialVariantUsage;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialVariantUsage</b> field to query operations.
     *
     */
    public final static BillOfMaterialUsageTextField<String> BILL_OF_MATERIAL_VARIANT_USAGE =
        new BillOfMaterialUsageTextField<String>("BillOfMaterialVariantUsage");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialVariantUsageDesc</b>
     * </p>
     *
     * @return BOM usage text
     */
    @SerializedName( "BillOfMaterialVariantUsageDesc" )
    @JsonProperty( "BillOfMaterialVariantUsageDesc" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialVariantUsageDesc" )
    private String billOfMaterialVariantUsageDesc;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialVariantUsageDesc</b> field to query operations.
     *
     */
    public final static BillOfMaterialUsageTextField<String> BILL_OF_MATERIAL_VARIANT_USAGE_DESC =
        new BillOfMaterialUsageTextField<String>("BillOfMaterialVariantUsageDesc");

    @Nonnull
    @Override
    public Class<BillOfMaterialUsageText> getType()
    {
        return BillOfMaterialUsageText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialVariantUsage</b>
     * </p>
     *
     * @param billOfMaterialVariantUsage
     *            BOM Usage
     */
    public void setBillOfMaterialVariantUsage( @Nullable final String billOfMaterialVariantUsage )
    {
        rememberChangedField("BillOfMaterialVariantUsage", this.billOfMaterialVariantUsage);
        this.billOfMaterialVariantUsage = billOfMaterialVariantUsage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialVariantUsageDesc</b>
     * </p>
     *
     * @param billOfMaterialVariantUsageDesc
     *            BOM usage text
     */
    public void setBillOfMaterialVariantUsageDesc( @Nullable final String billOfMaterialVariantUsageDesc )
    {
        rememberChangedField("BillOfMaterialVariantUsageDesc", this.billOfMaterialVariantUsageDesc);
        this.billOfMaterialVariantUsageDesc = billOfMaterialVariantUsageDesc;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BillOfMaterialUsageText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("BillOfMaterialVariantUsage", getBillOfMaterialVariantUsage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("BillOfMaterialVariantUsage", getBillOfMaterialVariantUsage());
        values.put("BillOfMaterialVariantUsageDesc", getBillOfMaterialVariantUsageDesc());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialVariantUsage") ) {
                final Object value = values.remove("BillOfMaterialVariantUsage");
                if( (value == null) || (!value.equals(getBillOfMaterialVariantUsage())) ) {
                    setBillOfMaterialVariantUsage(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialVariantUsageDesc") ) {
                final Object value = values.remove("BillOfMaterialVariantUsageDesc");
                if( (value == null) || (!value.equals(getBillOfMaterialVariantUsageDesc())) ) {
                    setBillOfMaterialVariantUsageDesc(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> BillOfMaterialUsageTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BillOfMaterialUsageTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BillOfMaterialUsageTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BillOfMaterialUsageTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillOfMaterialsV2Service.DEFAULT_SERVICE_PATH);
    }

}
