/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmComplex;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original complex type name from the Odata EDM: <b>DBomdelchangenooutparameter</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class DBomdelchangenooutparameter extends VdmComplex<DBomdelchangenooutparameter>
{

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>BOMIsSuccessfulDeleted</b>
     * </p>
     *
     * @param bOMIsSuccessfulDeleted
     *
     * @return Boolean Variable (X = True, - = False, Space = Unknown)
     */
    @SerializedName( "BOMIsSuccessfulDeleted" )
    @JsonProperty( "BOMIsSuccessfulDeleted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "BOMIsSuccessfulDeleted" )
    private Boolean bOMIsSuccessfulDeleted;

    @Nonnull
    @Override
    public Class<DBomdelchangenooutparameter> getType()
    {
        return DBomdelchangenooutparameter.class;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BOMIsSuccessfulDeleted", getBOMIsSuccessfulDeleted());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BOMIsSuccessfulDeleted") ) {
                final Object value = values.remove("BOMIsSuccessfulDeleted");
                if( (value == null) || (!value.equals(getBOMIsSuccessfulDeleted())) ) {
                    setBOMIsSuccessfulDeleted(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        return result;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>BOMIsSuccessfulDeleted</b>
     * </p>
     *
     * @param bOMIsSuccessfulDeleted
     *            Boolean Variable (X = True, - = False, Space = Unknown)
     */
    public void setBOMIsSuccessfulDeleted( @Nullable final Boolean bOMIsSuccessfulDeleted )
    {
        rememberChangedField("BOMIsSuccessfulDeleted", this.bOMIsSuccessfulDeleted);
        this.bOMIsSuccessfulDeleted = bOMIsSuccessfulDeleted;
    }

}
