/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmComplex;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original complex type name from the Odata EDM: <b>DBomheaderforexplosionOut</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class DBomheaderforexplosionOut extends VdmComplex<DBomheaderforexplosionOut>
{

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>alternative_item</b>
     * </p>
     *
     * @param alternative_item
     *
     * @return Alternative item
     */
    @SerializedName( "alternative_item" )
    @JsonProperty( "alternative_item" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "alternative_item" )
    private Boolean alternative_item;
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>alt_item_group</b>
     * </p>
     *
     * @param alt_item_group
     *
     * @return AltItemGroup
     */
    @SerializedName( "alt_item_group" )
    @JsonProperty( "alt_item_group" )
    @Nullable
    @ODataField( odataName = "alt_item_group" )
    private String alt_item_group;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>alt_nxt_lvl</b>
     * </p>
     *
     * @param alt_nxt_lvl
     *
     * @return Altrntvs (Nxt Level)
     */
    @SerializedName( "alt_nxt_lvl" )
    @JsonProperty( "alt_nxt_lvl" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "alt_nxt_lvl" )
    private Boolean alt_nxt_lvl;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>assembly_indicator</b>
     * </p>
     *
     * @param assembly_indicator
     *
     * @return PM assembly
     */
    @SerializedName( "assembly_indicator" )
    @JsonProperty( "assembly_indicator" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "assembly_indicator" )
    private Boolean assembly_indicator;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>assign_effect_vals</b>
     * </p>
     *
     * @param assign_effect_vals
     *
     * @return Assign effect. vals
     */
    @SerializedName( "assign_effect_vals" )
    @JsonProperty( "assign_effect_vals" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "assign_effect_vals" )
    private Boolean assign_effect_vals;
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property from the Odata EDM: <b>assy_scrap_itm_mat</b>
     * </p>
     *
     * @param assy_scrap_itm_mat
     *
     * @return AssyScrap (ItemMat)
     */
    @SerializedName( "assy_scrap_itm_mat" )
    @JsonProperty( "assy_scrap_itm_mat" )
    @Nullable
    @ODataField( odataName = "assy_scrap_itm_mat" )
    private BigDecimal assy_scrap_itm_mat;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>as_selection_cond</b>
     * </p>
     *
     * @param as_selection_cond
     *
     * @return as selection cond.
     */
    @SerializedName( "as_selection_cond" )
    @JsonProperty( "as_selection_cond" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "as_selection_cond" )
    private Boolean as_selection_cond;
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>base_qty_nxt_lvl</b>
     * </p>
     *
     * @param base_qty_nxt_lvl
     *
     * @return BasQty (Next Level)
     */
    @SerializedName( "base_qty_nxt_lvl" )
    @JsonProperty( "base_qty_nxt_lvl" )
    @Nullable
    @ODataField( odataName = "base_qty_nxt_lvl" )
    private BigDecimal base_qty_nxt_lvl;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>base_unit_nxt_lvl</b>
     * </p>
     *
     * @param base_unit_nxt_lvl
     *
     * @return BasUnit (Next Level)
     */
    @SerializedName( "base_unit_nxt_lvl" )
    @JsonProperty( "base_unit_nxt_lvl" )
    @Nullable
    @ODataField( odataName = "base_unit_nxt_lvl" )
    private String base_unit_nxt_lvl;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>base_uom</b>
     * </p>
     *
     * @param base_uom
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "base_uom" )
    @JsonProperty( "base_uom" )
    @Nullable
    @ODataField( odataName = "base_uom" )
    private String base_uom;
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>batch_entry</b>
     * </p>
     *
     * @param batch_entry
     *
     * @return Batch entry
     */
    @SerializedName( "batch_entry" )
    @JsonProperty( "batch_entry" )
    @Nullable
    @ODataField( odataName = "batch_entry" )
    private String batch_entry;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>batch_mgmt</b>
     * </p>
     *
     * @param batch_mgmt
     *
     * @return Batch Management
     */
    @SerializedName( "batch_mgmt" )
    @JsonProperty( "batch_mgmt" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "batch_mgmt" )
    private Boolean batch_mgmt;
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property from the Odata EDM: <b>bill_of_material</b>
     * </p>
     *
     * @param bill_of_material
     *
     * @return Bill of Material
     */
    @SerializedName( "bill_of_material" )
    @JsonProperty( "bill_of_material" )
    @Nullable
    @ODataField( odataName = "bill_of_material" )
    private String bill_of_material;
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>bill_of_material_base_quant</b>
     * </p>
     *
     * @param bill_of_material_base_quant
     *
     * @return Comp. Qty (BUn)
     */
    @SerializedName( "bill_of_material_base_quant" )
    @JsonProperty( "bill_of_material_base_quant" )
    @Nullable
    @ODataField( odataName = "bill_of_material_base_quant" )
    private BigDecimal bill_of_material_base_quant;
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>bill_of_material_component</b>
     * </p>
     *
     * @param bill_of_material_component
     *
     * @return Component
     */
    @SerializedName( "bill_of_material_component" )
    @JsonProperty( "bill_of_material_component" )
    @Nullable
    @ODataField( odataName = "bill_of_material_component" )
    private String bill_of_material_component;
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>bill_of_material_comp_quant</b>
     * </p>
     *
     * @param bill_of_material_comp_quant
     *
     * @return Comp. Qty (CUn)
     */
    @SerializedName( "bill_of_material_comp_quant" )
    @JsonProperty( "bill_of_material_comp_quant" )
    @Nullable
    @ODataField( odataName = "bill_of_material_comp_quant" )
    private BigDecimal bill_of_material_comp_quant;
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>bill_of_material_item_category</b>
     * </p>
     *
     * @param bill_of_material_item_category
     *
     * @return Item Category
     */
    @SerializedName( "bill_of_material_item_category" )
    @JsonProperty( "bill_of_material_item_category" )
    @Nullable
    @ODataField( odataName = "bill_of_material_item_category" )
    private String bill_of_material_item_category;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>bill_of_material_item_number</b>
     * </p>
     *
     * @param bill_of_material_item_number
     *
     * @return Item Number
     */
    @SerializedName( "bill_of_material_item_number" )
    @JsonProperty( "bill_of_material_item_number" )
    @Nullable
    @ODataField( odataName = "bill_of_material_item_number" )
    private String bill_of_material_item_number;
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>bill_of_material_item_quantity</b>
     * </p>
     *
     * @param bill_of_material_item_quantity
     *
     * @return Component Quantity
     */
    @SerializedName( "bill_of_material_item_quantity" )
    @JsonProperty( "bill_of_material_item_quantity" )
    @Nullable
    @ODataField( odataName = "bill_of_material_item_quantity" )
    private BigDecimal bill_of_material_item_quantity;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>bill_of_material_item_unit</b>
     * </p>
     *
     * @param bill_of_material_item_unit
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "bill_of_material_item_unit" )
    @JsonProperty( "bill_of_material_item_unit" )
    @Nullable
    @ODataField( odataName = "bill_of_material_item_unit" )
    private String bill_of_material_item_unit;
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property from the Odata EDM: <b>Bill_Of_Material_Root</b>
     * </p>
     *
     * @param bill_Of_Material_Root
     *
     * @return Bill of Material
     */
    @SerializedName( "Bill_Of_Material_Root" )
    @JsonProperty( "Bill_Of_Material_Root" )
    @Nullable
    @ODataField( odataName = "Bill_Of_Material_Root" )
    private String bill_Of_Material_Root;
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>bill_of_material_root_variant</b>
     * </p>
     *
     * @param bill_of_material_root_variant
     *
     * @return Alternative BOM
     */
    @SerializedName( "bill_of_material_root_variant" )
    @JsonProperty( "bill_of_material_root_variant" )
    @Nullable
    @ODataField( odataName = "bill_of_material_root_variant" )
    private String bill_of_material_root_variant;
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>bill_of_material_variant</b>
     * </p>
     *
     * @param bill_of_material_variant
     *
     * @return Alternative BOM
     */
    @SerializedName( "bill_of_material_variant" )
    @JsonProperty( "bill_of_material_variant" )
    @Nullable
    @ODataField( odataName = "bill_of_material_variant" )
    private String bill_of_material_variant;
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>bill_of_material_variant_usage</b>
     * </p>
     *
     * @param bill_of_material_variant_usage
     *
     * @return BOM usage
     */
    @SerializedName( "bill_of_material_variant_usage" )
    @JsonProperty( "bill_of_material_variant_usage" )
    @Nullable
    @ODataField( odataName = "bill_of_material_variant_usage" )
    private String bill_of_material_variant_usage;
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property from the Odata EDM: <b>bom_change_number</b>
     * </p>
     *
     * @param bom_change_number
     *
     * @return Change Number
     */
    @SerializedName( "bom_change_number" )
    @JsonProperty( "bom_change_number" )
    @Nullable
    @ODataField( odataName = "bom_change_number" )
    private String bom_change_number;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>bulk_material</b>
     * </p>
     *
     * @param bulk_material
     *
     * @return Bulk Material
     */
    @SerializedName( "bulk_material" )
    @JsonProperty( "bulk_material" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "bulk_material" )
    private Boolean bulk_material;
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>b_o_m_alternative_text</b>
     * </p>
     *
     * @param b_o_m_alternative_text
     *
     * @return Alternative Text
     */
    @SerializedName( "b_o_m_alternative_text" )
    @JsonProperty( "b_o_m_alternative_text" )
    @Nullable
    @ODataField( odataName = "b_o_m_alternative_text" )
    private String b_o_m_alternative_text;
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>b_o_m_alt_nxt_lvl</b>
     * </p>
     *
     * @param b_o_m_alt_nxt_lvl
     *
     * @return BOM Alt (Next Level)
     */
    @SerializedName( "b_o_m_alt_nxt_lvl" )
    @JsonProperty( "b_o_m_alt_nxt_lvl" )
    @Nullable
    @ODataField( odataName = "b_o_m_alt_nxt_lvl" )
    private String b_o_m_alt_nxt_lvl;
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>b_o_m_category</b>
     * </p>
     *
     * @param b_o_m_category
     *
     * @return BOM category
     */
    @SerializedName( "b_o_m_category" )
    @JsonProperty( "b_o_m_category" )
    @Nullable
    @ODataField( odataName = "b_o_m_category" )
    private String b_o_m_category;
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>b_o_m_cat_nxt_lvl</b>
     * </p>
     *
     * @param b_o_m_cat_nxt_lvl
     *
     * @return BOM Cat (Next Level)
     */
    @SerializedName( "b_o_m_cat_nxt_lvl" )
    @JsonProperty( "b_o_m_cat_nxt_lvl" )
    @Nullable
    @ODataField( odataName = "b_o_m_cat_nxt_lvl" )
    private String b_o_m_cat_nxt_lvl;
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>b_o_m_component_description</b>
     * </p>
     *
     * @param b_o_m_component_description
     *
     * @return Object description
     */
    @SerializedName( "b_o_m_component_description" )
    @JsonProperty( "b_o_m_component_description" )
    @Nullable
    @ODataField( odataName = "b_o_m_component_description" )
    private String b_o_m_component_description;
    /**
     * Constraints: Not nullable, Precision: 2, Scale: 0
     * <p>
     * Original property from the Odata EDM: <b>b_o_m_explosion_level</b>
     * </p>
     *
     * @param b_o_m_explosion_level
     *
     * @return Level
     */
    @SerializedName( "b_o_m_explosion_level" )
    @JsonProperty( "b_o_m_explosion_level" )
    @Nullable
    @ODataField( odataName = "b_o_m_explosion_level" )
    private BigDecimal b_o_m_explosion_level;
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>b_o_m_hdr_matl_hier_node</b>
     * </p>
     *
     * @param b_o_m_hdr_matl_hier_node
     *
     * @return Material
     */
    @SerializedName( "b_o_m_hdr_matl_hier_node" )
    @JsonProperty( "b_o_m_hdr_matl_hier_node" )
    @Nullable
    @ODataField( odataName = "b_o_m_hdr_matl_hier_node" )
    private String b_o_m_hdr_matl_hier_node;
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>B_O_M_Hdr_Root_Matl_Hier_Node</b>
     * </p>
     *
     * @param b_O_M_Hdr_Root_Matl_Hier_Node
     *
     * @return Material
     */
    @SerializedName( "B_O_M_Hdr_Root_Matl_Hier_Node" )
    @JsonProperty( "B_O_M_Hdr_Root_Matl_Hier_Node" )
    @Nullable
    @ODataField( odataName = "B_O_M_Hdr_Root_Matl_Hier_Node" )
    private String b_O_M_Hdr_Root_Matl_Hier_Node;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>b_o_m_header_base_unit</b>
     * </p>
     *
     * @param b_o_m_header_base_unit
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "b_o_m_header_base_unit" )
    @JsonProperty( "b_o_m_header_base_unit" )
    @Nullable
    @ODataField( odataName = "b_o_m_header_base_unit" )
    private String b_o_m_header_base_unit;
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>b_o_m_header_quantity_primary</b>
     * </p>
     *
     * @param b_o_m_header_quantity_primary
     *
     * @return Base quantity
     */
    @SerializedName( "b_o_m_header_quantity_primary" )
    @JsonProperty( "b_o_m_header_quantity_primary" )
    @Nullable
    @ODataField( odataName = "b_o_m_header_quantity_primary" )
    private BigDecimal b_o_m_header_quantity_primary;
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>b_o_m_item_description</b>
     * </p>
     *
     * @param b_o_m_item_description
     *
     * @return Item Text
     */
    @SerializedName( "b_o_m_item_description" )
    @JsonProperty( "b_o_m_item_description" )
    @Nullable
    @ODataField( odataName = "b_o_m_item_description" )
    private String b_o_m_item_description;
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>b_o_m_item_is_discontinued</b>
     * </p>
     *
     * @param b_o_m_item_is_discontinued
     *
     * @return Discontinuation ind.
     */
    @SerializedName( "b_o_m_item_is_discontinued" )
    @JsonProperty( "b_o_m_item_is_discontinued" )
    @Nullable
    @ODataField( odataName = "b_o_m_item_is_discontinued" )
    private String b_o_m_item_is_discontinued;
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property from the Odata EDM: <b>b_o_m_no_nxt_lvl</b>
     * </p>
     *
     * @param b_o_m_no_nxt_lvl
     *
     * @return BOM No. (Next Level)
     */
    @SerializedName( "b_o_m_no_nxt_lvl" )
    @JsonProperty( "b_o_m_no_nxt_lvl" )
    @Nullable
    @ODataField( odataName = "b_o_m_no_nxt_lvl" )
    private String b_o_m_no_nxt_lvl;
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>b_o_m_usage_nxt_lvl</b>
     * </p>
     *
     * @param b_o_m_usage_nxt_lvl
     *
     * @return BOM Usage (Next Lvl)
     */
    @SerializedName( "b_o_m_usage_nxt_lvl" )
    @JsonProperty( "b_o_m_usage_nxt_lvl" )
    @Nullable
    @ODataField( odataName = "b_o_m_usage_nxt_lvl" )
    private String b_o_m_usage_nxt_lvl;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>b_o_m_version</b>
     * </p>
     *
     * @param b_o_m_version
     *
     * @return BOM Version
     */
    @SerializedName( "b_o_m_version" )
    @JsonProperty( "b_o_m_version" )
    @Nullable
    @ODataField( odataName = "b_o_m_version" )
    private String b_o_m_version;
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>b_o_m_version_status</b>
     * </p>
     *
     * @param b_o_m_version_status
     *
     * @return BOM Version Status
     */
    @SerializedName( "b_o_m_version_status" )
    @JsonProperty( "b_o_m_version_status" )
    @Nullable
    @ODataField( odataName = "b_o_m_version_status" )
    private String b_o_m_version_status;
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property from the Odata EDM: <b>b_o_m_vers_status_description</b>
     * </p>
     *
     * @param b_o_m_vers_status_description
     *
     * @return Short text
     */
    @SerializedName( "b_o_m_vers_status_description" )
    @JsonProperty( "b_o_m_vers_status_description" )
    @Nullable
    @ODataField( odataName = "b_o_m_vers_status_description" )
    private String b_o_m_vers_status_description;
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property from the Odata EDM: <b>change_number</b>
     * </p>
     *
     * @param change_number
     *
     * @return Change Number
     */
    @SerializedName( "change_number" )
    @JsonProperty( "change_number" )
    @Nullable
    @ODataField( odataName = "change_number" )
    private String change_number;
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property from the Odata EDM: <b>chg_to_eng_chg_number</b>
     * </p>
     *
     * @param chg_to_eng_chg_number
     *
     * @return Change Number To
     */
    @SerializedName( "chg_to_eng_chg_number" )
    @JsonProperty( "chg_to_eng_chg_number" )
    @Nullable
    @ODataField( odataName = "chg_to_eng_chg_number" )
    private String chg_to_eng_chg_number;
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property from the Odata EDM: <b>class</b>
     * </p>
     *
     * @param classProperty
     *
     * @return Class
     */
    @SerializedName( "class" )
    @JsonProperty( "class" )
    @Nullable
    @ODataField( odataName = "class" )
    private String classProperty;
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property from the Odata EDM: <b>classification</b>
     * </p>
     *
     * @param classification
     *
     * @return Classification
     */
    @SerializedName( "classification" )
    @JsonProperty( "classification" )
    @Nullable
    @ODataField( odataName = "classification" )
    private String classification;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>class_type</b>
     * </p>
     *
     * @param class_type
     *
     * @return Class Type
     */
    @SerializedName( "class_type" )
    @JsonProperty( "class_type" )
    @Nullable
    @ODataField( odataName = "class_type" )
    private String class_type;
    /**
     * Constraints: Not nullable, Maximum length: 17
     * <p>
     * Original property from the Odata EDM: <b>commodity_code</b>
     * </p>
     *
     * @param commodity_code
     *
     * @return Commodity Code
     */
    @SerializedName( "commodity_code" )
    @JsonProperty( "commodity_code" )
    @Nullable
    @ODataField( odataName = "commodity_code" )
    private String commodity_code;
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property from the Odata EDM: <b>comp_maint_status</b>
     * </p>
     *
     * @param comp_maint_status
     *
     * @return Compl. maint. status
     */
    @SerializedName( "comp_maint_status" )
    @JsonProperty( "comp_maint_status" )
    @Nullable
    @ODataField( odataName = "comp_maint_status" )
    private String comp_maint_status;
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property from the Odata EDM: <b>comp_scrap_itm</b>
     * </p>
     *
     * @param comp_scrap_itm
     *
     * @return CmpScrap (Item)
     */
    @SerializedName( "comp_scrap_itm" )
    @JsonProperty( "comp_scrap_itm" )
    @Nullable
    @ODataField( odataName = "comp_scrap_itm" )
    private BigDecimal comp_scrap_itm;
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property from the Odata EDM: <b>comp_scrap_itm_mat</b>
     * </p>
     *
     * @param comp_scrap_itm_mat
     *
     * @return Comp.Scrap (ItemMat)
     */
    @SerializedName( "comp_scrap_itm_mat" )
    @JsonProperty( "comp_scrap_itm_mat" )
    @Nullable
    @ODataField( odataName = "comp_scrap_itm_mat" )
    private BigDecimal comp_scrap_itm_mat;
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property from the Odata EDM: <b>config_mat_var</b>
     * </p>
     *
     * @param config_mat_var
     *
     * @return Config. (MatVar)
     */
    @SerializedName( "config_mat_var" )
    @JsonProperty( "config_mat_var" )
    @Nullable
    @ODataField( odataName = "config_mat_var" )
    private String config_mat_var;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>config_multi_level</b>
     * </p>
     *
     * @param config_multi_level
     *
     * @return Configd multi
     */
    @SerializedName( "config_multi_level" )
    @JsonProperty( "config_multi_level" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "config_multi_level" )
    private Boolean config_multi_level;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>conf_bom_nxt_lvl</b>
     * </p>
     *
     * @param conf_bom_nxt_lvl
     *
     * @return Conf BOM (Nxt Level)
     */
    @SerializedName( "conf_bom_nxt_lvl" )
    @JsonProperty( "conf_bom_nxt_lvl" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "conf_bom_nxt_lvl" )
    private Boolean conf_bom_nxt_lvl;
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>cost_element</b>
     * </p>
     *
     * @param cost_element
     *
     * @return Cost element
     */
    @SerializedName( "cost_element" )
    @JsonProperty( "cost_element" )
    @Nullable
    @ODataField( odataName = "cost_element" )
    private String cost_element;
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property from the Odata EDM: <b>counter</b>
     * </p>
     *
     * @param counter
     *
     * @return Counter
     */
    @SerializedName( "counter" )
    @JsonProperty( "counter" )
    @Nullable
    @ODataField( odataName = "counter" )
    private String counter;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>co_product</b>
     * </p>
     *
     * @param co_product
     *
     * @return Co-product
     */
    @SerializedName( "co_product" )
    @JsonProperty( "co_product" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "co_product" )
    private Boolean co_product;
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property from the Odata EDM: <b>created_by_user</b>
     * </p>
     *
     * @param created_by_user
     *
     * @return Created By
     */
    @SerializedName( "created_by_user" )
    @JsonProperty( "created_by_user" )
    @Nullable
    @ODataField( odataName = "created_by_user" )
    private String created_by_user;
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property from the Odata EDM: <b>currency</b>
     * </p>
     *
     * @param currency
     *
     * @return Currency
     */
    @SerializedName( "currency" )
    @JsonProperty( "currency" )
    @Nullable
    @ODataField( odataName = "currency" )
    private String currency;
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>customs_preference</b>
     * </p>
     *
     * @param customs_preference
     *
     * @return Customs Preference
     */
    @SerializedName( "customs_preference" )
    @JsonProperty( "customs_preference" )
    @Nullable
    @ODataField( odataName = "customs_preference" )
    private String customs_preference;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>dat_hist_nxt_lvl</b>
     * </p>
     *
     * @param dat_hist_nxt_lvl
     *
     * @return DatHist (Next Level)
     */
    @SerializedName( "dat_hist_nxt_lvl" )
    @JsonProperty( "dat_hist_nxt_lvl" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "dat_hist_nxt_lvl" )
    private Boolean dat_hist_nxt_lvl;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>deletion_indicator</b>
     * </p>
     *
     * @param deletion_indicator
     *
     * @return Dln Indicator(Head)
     */
    @SerializedName( "deletion_indicator" )
    @JsonProperty( "deletion_indicator" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "deletion_indicator" )
    private Boolean deletion_indicator;
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property from the Odata EDM: <b>delivery_time_in_days</b>
     * </p>
     *
     * @param delivery_time_in_days
     *
     * @return Delivery time (days)
     */
    @SerializedName( "delivery_time_in_days" )
    @JsonProperty( "delivery_time_in_days" )
    @Nullable
    @ODataField( odataName = "delivery_time_in_days" )
    private BigDecimal delivery_time_in_days;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>del_Ind_nxt_lvl</b>
     * </p>
     *
     * @param del_Ind_nxt_lvl
     *
     * @return DlInd (Next Level)
     */
    @SerializedName( "del_Ind_nxt_lvl" )
    @JsonProperty( "del_Ind_nxt_lvl" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "del_Ind_nxt_lvl" )
    private Boolean del_Ind_nxt_lvl;
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property from the Odata EDM: <b>denominator</b>
     * </p>
     *
     * @param denominator
     *
     * @return Denominator
     */
    @SerializedName( "denominator" )
    @JsonProperty( "denominator" )
    @Nullable
    @ODataField( odataName = "denominator" )
    private BigDecimal denominator;
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>discont_group</b>
     * </p>
     *
     * @param discont_group
     *
     * @return Discont. group
     */
    @SerializedName( "discont_group" )
    @JsonProperty( "discont_group" )
    @Nullable
    @ODataField( odataName = "discont_group" )
    private String discont_group;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>distribution_key</b>
     * </p>
     *
     * @param distribution_key
     *
     * @return Distribution key
     */
    @SerializedName( "distribution_key" )
    @JsonProperty( "distribution_key" )
    @Nullable
    @ODataField( odataName = "distribution_key" )
    private String distribution_key;
    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property from the Odata EDM: <b>doc</b>
     * </p>
     *
     * @param doc
     *
     * @return Document
     */
    @SerializedName( "doc" )
    @JsonProperty( "doc" )
    @Nullable
    @ODataField( odataName = "doc" )
    private String doc;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>document_part</b>
     * </p>
     *
     * @param document_part
     *
     * @return Document Part
     */
    @SerializedName( "document_part" )
    @JsonProperty( "document_part" )
    @Nullable
    @ODataField( odataName = "document_part" )
    private String document_part;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>document_type</b>
     * </p>
     *
     * @param document_type
     *
     * @return Document Type
     */
    @SerializedName( "document_type" )
    @JsonProperty( "document_type" )
    @Nullable
    @ODataField( odataName = "document_type" )
    private String document_type;
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>document_version</b>
     * </p>
     *
     * @param document_version
     *
     * @return Document Version
     */
    @SerializedName( "document_version" )
    @JsonProperty( "document_version" )
    @Nullable
    @ODataField( odataName = "document_version" )
    private String document_version;
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property from the Odata EDM: <b>doc_number</b>
     * </p>
     *
     * @param doc_number
     *
     * @return Document
     */
    @SerializedName( "doc_number" )
    @JsonProperty( "doc_number" )
    @Nullable
    @ODataField( odataName = "doc_number" )
    private String doc_number;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>doc_reqd</b>
     * </p>
     *
     * @param doc_reqd
     *
     * @return Documentation reqd
     */
    @SerializedName( "doc_reqd" )
    @JsonProperty( "doc_reqd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "doc_reqd" )
    private Boolean doc_reqd;
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>doc_status</b>
     * </p>
     *
     * @param doc_status
     *
     * @return Document Status
     */
    @SerializedName( "doc_status" )
    @JsonProperty( "doc_status" )
    @Nullable
    @ODataField( odataName = "doc_status" )
    private String doc_status;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>doc_type</b>
     * </p>
     *
     * @param doc_type
     *
     * @return Document Type
     */
    @SerializedName( "doc_type" )
    @JsonProperty( "doc_type" )
    @Nullable
    @ODataField( odataName = "doc_type" )
    private String doc_type;
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>doc_version</b>
     * </p>
     *
     * @param doc_version
     *
     * @return Document Version
     */
    @SerializedName( "doc_version" )
    @JsonProperty( "doc_version" )
    @Nullable
    @ODataField( odataName = "doc_version" )
    private String doc_version;
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>effective_out_date</b>
     * </p>
     *
     * @param effective_out_date
     *
     * @return Effective-Out Date
     */
    @SerializedName( "effective_out_date" )
    @JsonProperty( "effective_out_date" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "effective_out_date",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime effective_out_date;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>engineering_design</b>
     * </p>
     *
     * @param engineering_design
     *
     * @return Engineering/design
     */
    @SerializedName( "engineering_design" )
    @JsonProperty( "engineering_design" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "engineering_design" )
    private Boolean engineering_design;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>exception_bom</b>
     * </p>
     *
     * @param exception_bom
     *
     * @return Exception
     */
    @SerializedName( "exception_bom" )
    @JsonProperty( "exception_bom" )
    @Nullable
    @ODataField( odataName = "exception_bom" )
    private String exception_bom;
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>explosion_type</b>
     * </p>
     *
     * @param explosion_type
     *
     * @return Explosion type
     */
    @SerializedName( "explosion_type" )
    @JsonProperty( "explosion_type" )
    @Nullable
    @ODataField( odataName = "explosion_type" )
    private String explosion_type;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>fixed_price_co_prod</b>
     * </p>
     *
     * @param fixed_price_co_prod
     *
     * @return Fixed-Price Co-Prod.
     */
    @SerializedName( "fixed_price_co_prod" )
    @JsonProperty( "fixed_price_co_prod" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "fixed_price_co_prod" )
    private Boolean fixed_price_co_prod;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>fixed_quantity</b>
     * </p>
     *
     * @param fixed_quantity
     *
     * @return Fixed Quantity
     */
    @SerializedName( "fixed_quantity" )
    @JsonProperty( "fixed_quantity" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "fixed_quantity" )
    private Boolean fixed_quantity;
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>follow_up_grp</b>
     * </p>
     *
     * @param follow_up_grp
     *
     * @return Follow-up group
     */
    @SerializedName( "follow_up_grp" )
    @JsonProperty( "follow_up_grp" )
    @Nullable
    @ODataField( odataName = "follow_up_grp" )
    private String follow_up_grp;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>follow_up_item</b>
     * </p>
     *
     * @param follow_up_item
     *
     * @return Follow-Up Item
     */
    @SerializedName( "follow_up_item" )
    @JsonProperty( "follow_up_item" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "follow_up_item" )
    private Boolean follow_up_item;
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>follow_up_product</b>
     * </p>
     *
     * @param follow_up_product
     *
     * @return Follow-Up Material
     */
    @SerializedName( "follow_up_product" )
    @JsonProperty( "follow_up_product" )
    @Nullable
    @ODataField( odataName = "follow_up_product" )
    private String follow_up_product;
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>formula_key</b>
     * </p>
     *
     * @param formula_key
     *
     * @return VSI Formula
     */
    @SerializedName( "formula_key" )
    @JsonProperty( "formula_key" )
    @Nullable
    @ODataField( odataName = "formula_key" )
    private String formula_key;
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property from the Odata EDM: <b>goods_receipt_duration_in_days</b>
     * </p>
     *
     * @param goods_receipt_duration_in_days
     *
     * @return GR processing time
     */
    @SerializedName( "goods_receipt_duration_in_days" )
    @JsonProperty( "goods_receipt_duration_in_days" )
    @Nullable
    @ODataField( odataName = "goods_receipt_duration_in_days" )
    private BigDecimal goods_receipt_duration_in_days;
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property from the Odata EDM: <b>goods_recipient</b>
     * </p>
     *
     * @param goods_recipient
     *
     * @return Goods Recipient
     */
    @SerializedName( "goods_recipient" )
    @JsonProperty( "goods_recipient" )
    @Nullable
    @ODataField( odataName = "goods_recipient" )
    private String goods_recipient;
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>header_record_id</b>
     * </p>
     *
     * @param header_record_id
     *
     * @return Header record ID
     */
    @SerializedName( "header_record_id" )
    @JsonProperty( "header_record_id" )
    @Nullable
    @ODataField( odataName = "header_record_id" )
    private String header_record_id;
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>header_validity_end_date</b>
     * </p>
     *
     * @param header_validity_end_date
     *
     * @return Valid to
     */
    @SerializedName( "header_validity_end_date" )
    @JsonProperty( "header_validity_end_date" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "header_validity_end_date",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime header_validity_end_date;
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>header_validity_start_date</b>
     * </p>
     *
     * @param header_validity_start_date
     *
     * @return Valid From
     */
    @SerializedName( "header_validity_start_date" )
    @JsonProperty( "header_validity_start_date" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "header_validity_start_date",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime header_validity_start_date;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>hl_configuration</b>
     * </p>
     *
     * @param hl_configuration
     *
     * @return HL configuration
     */
    @SerializedName( "hl_configuration" )
    @JsonProperty( "hl_configuration" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "hl_configuration" )
    private Boolean hl_configuration;
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>individual_coll</b>
     * </p>
     *
     * @param individual_coll
     *
     * @return Indiv./ Coll.
     */
    @SerializedName( "individual_coll" )
    @JsonProperty( "individual_coll" )
    @Nullable
    @ODataField( odataName = "individual_coll" )
    private String individual_coll;
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property from the Odata EDM: <b>internal_obj_no</b>
     * </p>
     *
     * @param internal_obj_no
     *
     * @return Internal Object No.
     */
    @SerializedName( "internal_obj_no" )
    @JsonProperty( "internal_obj_no" )
    @Nullable
    @ODataField( odataName = "internal_obj_no" )
    private String internal_obj_no;
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>intra_material</b>
     * </p>
     *
     * @param intra_material
     *
     * @return Intra Material
     */
    @SerializedName( "intra_material" )
    @JsonProperty( "intra_material" )
    @Nullable
    @ODataField( odataName = "intra_material" )
    private String intra_material;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>issuing_plant</b>
     * </p>
     *
     * @param issuing_plant
     *
     * @return Issuing Plant
     */
    @SerializedName( "issuing_plant" )
    @JsonProperty( "issuing_plant" )
    @Nullable
    @ODataField( odataName = "issuing_plant" )
    private String issuing_plant;
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>is_b_o_m_item_spare_part</b>
     * </p>
     *
     * @param is_b_o_m_item_spare_part
     *
     * @return Spare Part Indicator
     */
    @SerializedName( "is_b_o_m_item_spare_part" )
    @JsonProperty( "is_b_o_m_item_spare_part" )
    @Nullable
    @ODataField( odataName = "is_b_o_m_item_spare_part" )
    private String is_b_o_m_item_spare_part;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>is_c_a_d</b>
     * </p>
     *
     * @param is_c_a_d
     *
     * @return CAD Indicator
     */
    @SerializedName( "is_c_a_d" )
    @JsonProperty( "is_c_a_d" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "is_c_a_d" )
    private Boolean is_c_a_d;
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>is_material_provision</b>
     * </p>
     *
     * @param is_material_provision
     *
     * @return Mat. Provision Ind.
     */
    @SerializedName( "is_material_provision" )
    @JsonProperty( "is_material_provision" )
    @Nullable
    @ODataField( odataName = "is_material_provision" )
    private String is_material_provision;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>is_phantom_item</b>
     * </p>
     *
     * @param is_phantom_item
     *
     * @return Phantom item
     */
    @SerializedName( "is_phantom_item" )
    @JsonProperty( "is_phantom_item" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "is_phantom_item" )
    private Boolean is_phantom_item;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>is_software_component</b>
     * </p>
     *
     * @param is_software_component
     *
     * @return Software component
     */
    @SerializedName( "is_software_component" )
    @JsonProperty( "is_software_component" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "is_software_component" )
    private Boolean is_software_component;
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>item_description_line_2</b>
     * </p>
     *
     * @param item_description_line_2
     *
     * @return Item Text 2
     */
    @SerializedName( "item_description_line_2" )
    @JsonProperty( "item_description_line_2" )
    @Nullable
    @ODataField( odataName = "item_description_line_2" )
    private String item_description_line_2;
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property from the Odata EDM: <b>item_identification</b>
     * </p>
     *
     * @param item_identification
     *
     * @return Item identification
     */
    @SerializedName( "item_identification" )
    @JsonProperty( "item_identification" )
    @Nullable
    @ODataField( odataName = "item_identification" )
    private String item_identification;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>item_index</b>
     * </p>
     *
     * @param item_index
     *
     * @return Table Row
     */
    @SerializedName( "item_index" )
    @JsonProperty( "item_index" )
    @Nullable
    @ODataField( odataName = "item_index" )
    private Integer item_index;
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property from the Odata EDM: <b>item_node</b>
     * </p>
     *
     * @param item_node
     *
     * @return Item node
     */
    @SerializedName( "item_node" )
    @JsonProperty( "item_node" )
    @Nullable
    @ODataField( odataName = "item_node" )
    private String item_node;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>item_sign</b>
     * </p>
     *
     * @param item_sign
     *
     * @return +/- sign
     */
    @SerializedName( "item_sign" )
    @JsonProperty( "item_sign" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "item_sign" )
    private Boolean item_sign;
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property from the Odata EDM: <b>last_changed_by_user</b>
     * </p>
     *
     * @param last_changed_by_user
     *
     * @return Changed By
     */
    @SerializedName( "last_changed_by_user" )
    @JsonProperty( "last_changed_by_user" )
    @Nullable
    @ODataField( odataName = "last_changed_by_user" )
    private String last_changed_by_user;
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>last_change_date</b>
     * </p>
     *
     * @param last_change_date
     *
     * @return Changed On
     */
    @SerializedName( "last_change_date" )
    @JsonProperty( "last_change_date" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "last_change_date",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime last_change_date;
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property from the Odata EDM: <b>lead_time_offset</b>
     * </p>
     *
     * @param lead_time_offset
     *
     * @return Lead-time offset
     */
    @SerializedName( "lead_time_offset" )
    @JsonProperty( "lead_time_offset" )
    @Nullable
    @ODataField( odataName = "lead_time_offset" )
    private BigDecimal lead_time_offset;
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>long_text_lang</b>
     * </p>
     *
     * @param long_text_lang
     *
     * @return Long Text Language
     */
    @SerializedName( "long_text_lang" )
    @JsonProperty( "long_text_lang" )
    @Nullable
    @ODataField( odataName = "long_text_lang" )
    private String long_text_lang;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>low_level_code</b>
     * </p>
     *
     * @param low_level_code
     *
     * @return Low-Level Code
     */
    @SerializedName( "low_level_code" )
    @JsonProperty( "low_level_code" )
    @Nullable
    @ODataField( odataName = "low_level_code" )
    private String low_level_code;
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property from the Odata EDM: <b>maintenance_status</b>
     * </p>
     *
     * @param maintenance_status
     *
     * @return Maintenance status
     */
    @SerializedName( "maintenance_status" )
    @JsonProperty( "maintenance_status" )
    @Nullable
    @ODataField( odataName = "maintenance_status" )
    private String maintenance_status;
    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>material_component_price</b>
     * </p>
     *
     * @param material_component_price
     *
     * @return Price
     */
    @SerializedName( "material_component_price" )
    @JsonProperty( "material_component_price" )
    @Nullable
    @ODataField( odataName = "material_component_price" )
    private BigDecimal material_component_price;
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property from the Odata EDM: <b>material_group</b>
     * </p>
     *
     * @param material_group
     *
     * @return Material Group
     */
    @SerializedName( "material_group" )
    @JsonProperty( "material_group" )
    @Nullable
    @ODataField( odataName = "material_group" )
    private String material_group;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>material_is_configurable</b>
     * </p>
     *
     * @param material_is_configurable
     *
     * @return Configurable
     */
    @SerializedName( "material_is_configurable" )
    @JsonProperty( "material_is_configurable" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "material_is_configurable" )
    private Boolean material_is_configurable;
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>Material_Name</b>
     * </p>
     *
     * @param material_Name
     *
     * @return Material Description
     */
    @SerializedName( "Material_Name" )
    @JsonProperty( "Material_Name" )
    @Nullable
    @ODataField( odataName = "Material_Name" )
    private String material_Name;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>material_type</b>
     * </p>
     *
     * @param material_type
     *
     * @return Material Type
     */
    @SerializedName( "material_type" )
    @JsonProperty( "material_type" )
    @Nullable
    @ODataField( odataName = "material_type" )
    private String material_type;
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property from the Odata EDM: <b>mat_purity_in_perc</b>
     * </p>
     *
     * @param mat_purity_in_perc
     *
     * @return Mat. purity in %
     */
    @SerializedName( "mat_purity_in_perc" )
    @JsonProperty( "mat_purity_in_perc" )
    @Nullable
    @ODataField( odataName = "mat_purity_in_perc" )
    private BigDecimal mat_purity_in_perc;
    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>moving_price</b>
     * </p>
     *
     * @param moving_price
     *
     * @return Moving price
     */
    @SerializedName( "moving_price" )
    @JsonProperty( "moving_price" )
    @Nullable
    @ODataField( odataName = "moving_price" )
    private BigDecimal moving_price;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>multiple_sel</b>
     * </p>
     *
     * @param multiple_sel
     *
     * @return Multiple Selection
     */
    @SerializedName( "multiple_sel" )
    @JsonProperty( "multiple_sel" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "multiple_sel" )
    private Boolean multiple_sel;
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>m_r_p_type</b>
     * </p>
     *
     * @param m_r_p_type
     *
     * @return MRP Type
     */
    @SerializedName( "m_r_p_type" )
    @JsonProperty( "m_r_p_type" )
    @Nullable
    @ODataField( odataName = "m_r_p_type" )
    private String m_r_p_type;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>net_scrap_indicator</b>
     * </p>
     *
     * @param net_scrap_indicator
     *
     * @return Net Scrap Indicator
     */
    @SerializedName( "net_scrap_indicator" )
    @JsonProperty( "net_scrap_indicator" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "net_scrap_indicator" )
    private Boolean net_scrap_indicator;
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property from the Odata EDM: <b>no_cu_instances</b>
     * </p>
     *
     * @param no_cu_instances
     *
     * @return NoCUInstances
     */
    @SerializedName( "no_cu_instances" )
    @JsonProperty( "no_cu_instances" )
    @Nullable
    @ODataField( odataName = "no_cu_instances" )
    private String no_cu_instances;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>no_of_sheets</b>
     * </p>
     *
     * @param no_of_sheets
     *
     * @return Number Of Sheets
     */
    @SerializedName( "no_of_sheets" )
    @JsonProperty( "no_of_sheets" )
    @Nullable
    @ODataField( odataName = "no_of_sheets" )
    private String no_of_sheets;
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>no_var_size_items</b>
     * </p>
     *
     * @param no_var_size_items
     *
     * @return No. of VSI Required
     */
    @SerializedName( "no_var_size_items" )
    @JsonProperty( "no_var_size_items" )
    @Nullable
    @ODataField( odataName = "no_var_size_items" )
    private BigDecimal no_var_size_items;
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property from the Odata EDM: <b>numerator</b>
     * </p>
     *
     * @param numerator
     *
     * @return Numerator
     */
    @SerializedName( "numerator" )
    @JsonProperty( "numerator" )
    @Nullable
    @ODataField( odataName = "numerator" )
    private BigDecimal numerator;
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>object_description</b>
     * </p>
     *
     * @param object_description
     *
     * @return Object description
     */
    @SerializedName( "object_description" )
    @JsonProperty( "object_description" )
    @Nullable
    @ODataField( odataName = "object_description" )
    private String object_description;
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>object_type</b>
     * </p>
     *
     * @param object_type
     *
     * @return Object Type
     */
    @SerializedName( "object_type" )
    @JsonProperty( "object_type" )
    @Nullable
    @ODataField( odataName = "object_type" )
    private String object_type;
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property from the Odata EDM: <b>obj_dep_assgt_no</b>
     * </p>
     *
     * @param obj_dep_assgt_no
     *
     * @return Assignment number
     */
    @SerializedName( "obj_dep_assgt_no" )
    @JsonProperty( "obj_dep_assgt_no" )
    @Nullable
    @ODataField( odataName = "obj_dep_assgt_no" )
    private String obj_dep_assgt_no;
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property from the Odata EDM: <b>operation_scrap_perc</b>
     * </p>
     *
     * @param operation_scrap_perc
     *
     * @return Operation Scrap in %
     */
    @SerializedName( "operation_scrap_perc" )
    @JsonProperty( "operation_scrap_perc" )
    @Nullable
    @ODataField( odataName = "operation_scrap_perc" )
    private BigDecimal operation_scrap_perc;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>oper_lto_unit</b>
     * </p>
     *
     * @param oper_lto_unit
     *
     * @return Operation LTO unit
     */
    @SerializedName( "oper_lto_unit" )
    @JsonProperty( "oper_lto_unit" )
    @Nullable
    @ODataField( odataName = "oper_lto_unit" )
    private String oper_lto_unit;
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property from the Odata EDM: <b>oper_lt_offset</b>
     * </p>
     *
     * @param oper_lt_offset
     *
     * @return Oper. LT offset
     */
    @SerializedName( "oper_lt_offset" )
    @JsonProperty( "oper_lt_offset" )
    @Nullable
    @ODataField( odataName = "oper_lt_offset" )
    private BigDecimal oper_lt_offset;
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>org_area</b>
     * </p>
     *
     * @param org_area
     *
     * @return Organizational area
     */
    @SerializedName( "org_area" )
    @JsonProperty( "org_area" )
    @Nullable
    @ODataField( odataName = "org_area" )
    private String org_area;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>page_format</b>
     * </p>
     *
     * @param page_format
     *
     * @return Page Format
     */
    @SerializedName( "page_format" )
    @JsonProperty( "page_format" )
    @Nullable
    @ODataField( odataName = "page_format" )
    private String page_format;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>page_number</b>
     * </p>
     *
     * @param page_number
     *
     * @return Page Number
     */
    @SerializedName( "page_number" )
    @JsonProperty( "page_number" )
    @Nullable
    @ODataField( odataName = "page_number" )
    private String page_number;
    /**
     * Constraints: Not nullable, Precision: 4, Scale: 0
     * <p>
     * Original property from the Odata EDM: <b>path</b>
     * </p>
     *
     * @param path
     *
     * @return Path
     */
    @SerializedName( "path" )
    @JsonProperty( "path" )
    @Nullable
    @ODataField( odataName = "path" )
    private BigDecimal path;
    /**
     * Constraints: Not nullable, Precision: 4, Scale: 0
     * <p>
     * Original property from the Odata EDM: <b>path_predecessor</b>
     * </p>
     *
     * @param path_predecessor
     *
     * @return Path (Predecessor)
     */
    @SerializedName( "path_predecessor" )
    @JsonProperty( "path_predecessor" )
    @Nullable
    @ODataField( odataName = "path_predecessor" )
    private BigDecimal path_predecessor;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>plant</b>
     * </p>
     *
     * @param plant
     *
     * @return Plant
     */
    @SerializedName( "plant" )
    @JsonProperty( "plant" )
    @Nullable
    @ODataField( odataName = "plant" )
    private String plant;
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property from the Odata EDM: <b>plantName</b>
     * </p>
     *
     * @param plantName
     *
     * @return Name 1
     */
    @SerializedName( "plantName" )
    @JsonProperty( "plantName" )
    @Nullable
    @ODataField( odataName = "plantName" )
    private String plantName;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>plant_maintenance</b>
     * </p>
     *
     * @param plant_maintenance
     *
     * @return Plant maintenance
     */
    @SerializedName( "plant_maintenance" )
    @JsonProperty( "plant_maintenance" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "plant_maintenance" )
    private Boolean plant_maintenance;
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>plant_sp_matl_status</b>
     * </p>
     *
     * @param plant_sp_matl_status
     *
     * @return Material Status
     */
    @SerializedName( "plant_sp_matl_status" )
    @JsonProperty( "plant_sp_matl_status" )
    @Nullable
    @ODataField( odataName = "plant_sp_matl_status" )
    private String plant_sp_matl_status;
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>plt_sp_status_valid_from</b>
     * </p>
     *
     * @param plt_sp_status_valid_from
     *
     * @return Valid From
     */
    @SerializedName( "plt_sp_status_valid_from" )
    @JsonProperty( "plt_sp_status_valid_from" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "plt_sp_status_valid_from",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime plt_sp_status_valid_from;
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>price_control</b>
     * </p>
     *
     * @param price_control
     *
     * @return Price control
     */
    @SerializedName( "price_control" )
    @JsonProperty( "price_control" )
    @Nullable
    @ODataField( odataName = "price_control" )
    private String price_control;
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property from the Odata EDM: <b>price_unit</b>
     * </p>
     *
     * @param price_unit
     *
     * @return Price Unit (ItemMat)
     */
    @SerializedName( "price_unit" )
    @JsonProperty( "price_unit" )
    @Nullable
    @ODataField( odataName = "price_unit" )
    private BigDecimal price_unit;
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>priority</b>
     * </p>
     *
     * @param priority
     *
     * @return Priority
     */
    @SerializedName( "priority" )
    @JsonProperty( "priority" )
    @Nullable
    @ODataField( odataName = "priority" )
    private String priority;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>procured_externally</b>
     * </p>
     *
     * @param procured_externally
     *
     * @return Procured externally
     */
    @SerializedName( "procured_externally" )
    @JsonProperty( "procured_externally" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "procured_externally" )
    private Boolean procured_externally;
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>prodn_supply_area</b>
     * </p>
     *
     * @param prodn_supply_area
     *
     * @return Prodn Supply Area
     */
    @SerializedName( "prodn_supply_area" )
    @JsonProperty( "prodn_supply_area" )
    @Nullable
    @ODataField( odataName = "prodn_supply_area" )
    private String prodn_supply_area;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>production_relevant</b>
     * </p>
     *
     * @param production_relevant
     *
     * @return Production relevant
     */
    @SerializedName( "production_relevant" )
    @JsonProperty( "production_relevant" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "production_relevant" )
    private Boolean production_relevant;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>production_version</b>
     * </p>
     *
     * @param production_version
     *
     * @return Production Version
     */
    @SerializedName( "production_version" )
    @JsonProperty( "production_version" )
    @Nullable
    @ODataField( odataName = "production_version" )
    private String production_version;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>prod_order_issue_location</b>
     * </p>
     *
     * @param prod_order_issue_location
     *
     * @return Storage Location
     */
    @SerializedName( "prod_order_issue_location" )
    @JsonProperty( "prod_order_issue_location" )
    @Nullable
    @ODataField( odataName = "prod_order_issue_location" )
    private String prod_order_issue_location;
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>profit_center</b>
     * </p>
     *
     * @param profit_center
     *
     * @return Profit Center
     */
    @SerializedName( "profit_center" )
    @JsonProperty( "profit_center" )
    @Nullable
    @ODataField( odataName = "profit_center" )
    private String profit_center;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>purchasing_group</b>
     * </p>
     *
     * @param purchasing_group
     *
     * @return Purchasing Group
     */
    @SerializedName( "purchasing_group" )
    @JsonProperty( "purchasing_group" )
    @Nullable
    @ODataField( odataName = "purchasing_group" )
    private String purchasing_group;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>purchasing_organisation</b>
     * </p>
     *
     * @param purchasing_organisation
     *
     * @return Purch. Organization
     */
    @SerializedName( "purchasing_organisation" )
    @JsonProperty( "purchasing_organisation" )
    @Nullable
    @ODataField( odataName = "purchasing_organisation" )
    private String purchasing_organisation;
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>qty_var_size_item</b>
     * </p>
     *
     * @param qty_var_size_item
     *
     * @return VSI Quantity per PC
     */
    @SerializedName( "qty_var_size_item" )
    @JsonProperty( "qty_var_size_item" )
    @Nullable
    @ODataField( odataName = "qty_var_size_item" )
    private BigDecimal qty_var_size_item;
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>record_creation_date</b>
     * </p>
     *
     * @param record_creation_date
     *
     * @return Created On
     */
    @SerializedName( "record_creation_date" )
    @JsonProperty( "record_creation_date" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "record_creation_date",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime record_creation_date;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>recurisve</b>
     * </p>
     *
     * @param recurisve
     *
     * @return Recursive
     */
    @SerializedName( "recurisve" )
    @JsonProperty( "recurisve" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "recurisve" )
    private Boolean recurisve;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>recurs_allowed</b>
     * </p>
     *
     * @param recurs_allowed
     *
     * @return Recurs. allowed
     */
    @SerializedName( "recurs_allowed" )
    @JsonProperty( "recurs_allowed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "recurs_allowed" )
    private Boolean recurs_allowed;
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property from the Odata EDM: <b>reference_point</b>
     * </p>
     *
     * @param reference_point
     *
     * @return Reference point
     */
    @SerializedName( "reference_point" )
    @JsonProperty( "reference_point" )
    @Nullable
    @ODataField( odataName = "reference_point" )
    private String reference_point;
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>relevancy_to_costing</b>
     * </p>
     *
     * @param relevancy_to_costing
     *
     * @return CostingRelevncy
     */
    @SerializedName( "relevancy_to_costing" )
    @JsonProperty( "relevancy_to_costing" )
    @Nullable
    @ODataField( odataName = "relevancy_to_costing" )
    private String relevancy_to_costing;
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>relevant_to_sales</b>
     * </p>
     *
     * @param relevant_to_sales
     *
     * @return Relevant to sales
     */
    @SerializedName( "relevant_to_sales" )
    @JsonProperty( "relevant_to_sales" )
    @Nullable
    @ODataField( odataName = "relevant_to_sales" )
    private String relevant_to_sales;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>required_component</b>
     * </p>
     *
     * @param required_component
     *
     * @return Required Component
     */
    @SerializedName( "required_component" )
    @JsonProperty( "required_component" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "required_component" )
    private Boolean required_component;
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>requirement_segment</b>
     * </p>
     *
     * @param requirement_segment
     *
     * @return Requirement Segment
     */
    @SerializedName( "requirement_segment" )
    @JsonProperty( "requirement_segment" )
    @Nullable
    @ODataField( odataName = "requirement_segment" )
    private String requirement_segment;
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>revision_level</b>
     * </p>
     *
     * @param revision_level
     *
     * @return Revision Level
     */
    @SerializedName( "revision_level" )
    @JsonProperty( "revision_level" )
    @Nullable
    @ODataField( odataName = "revision_level" )
    private String revision_level;
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>scrap_qty_bun</b>
     * </p>
     *
     * @param scrap_qty_bun
     *
     * @return Scrap Qty (BUn)
     */
    @SerializedName( "scrap_qty_bun" )
    @JsonProperty( "scrap_qty_bun" )
    @Nullable
    @ODataField( odataName = "scrap_qty_bun" )
    private BigDecimal scrap_qty_bun;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>serial_no_profile</b>
     * </p>
     *
     * @param serial_no_profile
     *
     * @return Serial No. Profile
     */
    @SerializedName( "serial_no_profile" )
    @JsonProperty( "serial_no_profile" )
    @Nullable
    @ODataField( odataName = "serial_no_profile" )
    private String serial_no_profile;
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>size1</b>
     * </p>
     *
     * @param size1
     *
     * @return Size 1
     */
    @SerializedName( "size1" )
    @JsonProperty( "size1" )
    @Nullable
    @ODataField( odataName = "size1" )
    private BigDecimal size1;
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>size2</b>
     * </p>
     *
     * @param size2
     *
     * @return Size 2
     */
    @SerializedName( "size2" )
    @JsonProperty( "size2" )
    @Nullable
    @ODataField( odataName = "size2" )
    private BigDecimal size2;
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>size3</b>
     * </p>
     *
     * @param size3
     *
     * @return Size 3
     */
    @SerializedName( "size3" )
    @JsonProperty( "size3" )
    @Nullable
    @ODataField( odataName = "size3" )
    private BigDecimal size3;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>size_unit</b>
     * </p>
     *
     * @param size_unit
     *
     * @return Size unit
     */
    @SerializedName( "size_unit" )
    @JsonProperty( "size_unit" )
    @Nullable
    @ODataField( odataName = "size_unit" )
    private String size_unit;
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>sort_string</b>
     * </p>
     *
     * @param sort_string
     *
     * @return Sort String
     */
    @SerializedName( "sort_string" )
    @JsonProperty( "sort_string" )
    @Nullable
    @ODataField( odataName = "sort_string" )
    private String sort_string;
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>special_procurement_type</b>
     * </p>
     *
     * @param special_procurement_type
     *
     * @return Special Procurement
     */
    @SerializedName( "special_procurement_type" )
    @JsonProperty( "special_procurement_type" )
    @Nullable
    @ODataField( odataName = "special_procurement_type" )
    private String special_procurement_type;
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>special_proc_typ_itm</b>
     * </p>
     *
     * @param special_proc_typ_itm
     *
     * @return Special Procurement
     */
    @SerializedName( "special_proc_typ_itm" )
    @JsonProperty( "special_proc_typ_itm" )
    @Nullable
    @ODataField( odataName = "special_proc_typ_itm" )
    private String special_proc_typ_itm;
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>special_proc_typ_mastr</b>
     * </p>
     *
     * @param special_proc_typ_mastr
     *
     * @return Special procurement
     */
    @SerializedName( "special_proc_typ_mastr" )
    @JsonProperty( "special_proc_typ_mastr" )
    @Nullable
    @ODataField( odataName = "special_proc_typ_mastr" )
    private String special_proc_typ_mastr;
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>spec_proc_costing</b>
     * </p>
     *
     * @param spec_proc_costing
     *
     * @return SpecProcurem Costing
     */
    @SerializedName( "spec_proc_costing" )
    @JsonProperty( "spec_proc_costing" )
    @Nullable
    @ODataField( odataName = "spec_proc_costing" )
    private String spec_proc_costing;
    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>standard_price</b>
     * </p>
     *
     * @param standard_price
     *
     * @return Standard price
     */
    @SerializedName( "standard_price" )
    @JsonProperty( "standard_price" )
    @Nullable
    @ODataField( odataName = "standard_price" )
    private BigDecimal standard_price;
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property from the Odata EDM: <b>status_text</b>
     * </p>
     *
     * @param status_text
     *
     * @return Status Text
     */
    @SerializedName( "status_text" )
    @JsonProperty( "status_text" )
    @Nullable
    @ODataField( odataName = "status_text" )
    private String status_text;
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>stock_segment</b>
     * </p>
     *
     * @param stock_segment
     *
     * @return Stock Segment
     */
    @SerializedName( "stock_segment" )
    @JsonProperty( "stock_segment" )
    @Nullable
    @ODataField( odataName = "stock_segment" )
    private String stock_segment;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>storage_location</b>
     * </p>
     *
     * @param storage_location
     *
     * @return Storage Location
     */
    @SerializedName( "storage_location" )
    @JsonProperty( "storage_location" )
    @Nullable
    @ODataField( odataName = "storage_location" )
    private String storage_location;
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>strategy</b>
     * </p>
     *
     * @param strategy
     *
     * @return Strategy
     */
    @SerializedName( "strategy" )
    @JsonProperty( "strategy" )
    @Nullable
    @ODataField( odataName = "strategy" )
    private String strategy;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>sub_item_indicator</b>
     * </p>
     *
     * @param sub_item_indicator
     *
     * @return Sub-item indicator
     */
    @SerializedName( "sub_item_indicator" )
    @JsonProperty( "sub_item_indicator" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "sub_item_indicator" )
    private Boolean sub_item_indicator;
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>supplier</b>
     * </p>
     *
     * @param supplier
     *
     * @return Supplier
     */
    @SerializedName( "supplier" )
    @JsonProperty( "supplier" )
    @Nullable
    @ODataField( odataName = "supplier" )
    private String supplier;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>table_row</b>
     * </p>
     *
     * @param table_row
     *
     * @return Table Row
     */
    @SerializedName( "table_row" )
    @JsonProperty( "table_row" )
    @Nullable
    @ODataField( odataName = "table_row" )
    private Integer table_row;
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property from the Odata EDM: <b>tech_status_from</b>
     * </p>
     *
     * @param tech_status_from
     *
     * @return Tech status from
     */
    @SerializedName( "tech_status_from" )
    @JsonProperty( "tech_status_from" )
    @Nullable
    @ODataField( odataName = "tech_status_from" )
    private String tech_status_from;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>test_hist_nxt_lvl</b>
     * </p>
     *
     * @param test_hist_nxt_lvl
     *
     * @return TeStHist (Next Lvl)
     */
    @SerializedName( "test_hist_nxt_lvl" )
    @JsonProperty( "test_hist_nxt_lvl" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "test_hist_nxt_lvl" )
    private Boolean test_hist_nxt_lvl;
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>totals_record_id</b>
     * </p>
     *
     * @param totals_record_id
     *
     * @return Totals record ID
     */
    @SerializedName( "totals_record_id" )
    @JsonProperty( "totals_record_id" )
    @Nullable
    @ODataField( odataName = "totals_record_id" )
    private String totals_record_id;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>unit_of_measure</b>
     * </p>
     *
     * @param unit_of_measure
     *
     * @return Component UoM
     */
    @SerializedName( "unit_of_measure" )
    @JsonProperty( "unit_of_measure" )
    @Nullable
    @ODataField( odataName = "unit_of_measure" )
    private String unit_of_measure;
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property from the Odata EDM: <b>unloading_point</b>
     * </p>
     *
     * @param unloading_point
     *
     * @return Unloading Point
     */
    @SerializedName( "unloading_point" )
    @JsonProperty( "unloading_point" )
    @Nullable
    @ODataField( odataName = "unloading_point" )
    private String unloading_point;
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>uom_usage</b>
     * </p>
     *
     * @param uom_usage
     *
     * @return Units of meas. usage
     */
    @SerializedName( "uom_usage" )
    @JsonProperty( "uom_usage" )
    @Nullable
    @ODataField( odataName = "uom_usage" )
    private String uom_usage;
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property from the Odata EDM: <b>usage_probability</b>
     * </p>
     *
     * @param usage_probability
     *
     * @return Usage Probability
     */
    @SerializedName( "usage_probability" )
    @JsonProperty( "usage_probability" )
    @Nullable
    @ODataField( odataName = "usage_probability" )
    private BigDecimal usage_probability;
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>validity_end_date</b>
     * </p>
     *
     * @param validity_end_date
     *
     * @return Valid to
     */
    @SerializedName( "validity_end_date" )
    @JsonProperty( "validity_end_date" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "validity_end_date",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validity_end_date;
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>validity_start_date</b>
     * </p>
     *
     * @param validity_start_date
     *
     * @return Valid From
     */
    @SerializedName( "validity_start_date" )
    @JsonProperty( "validity_start_date" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "validity_start_date",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validity_start_date;
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>valuation_category</b>
     * </p>
     *
     * @param valuation_category
     *
     * @return Valuation Category
     */
    @SerializedName( "valuation_category" )
    @JsonProperty( "valuation_category" )
    @Nullable
    @ODataField( odataName = "valuation_category" )
    private String valuation_category;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>variants_nxt_lvl</b>
     * </p>
     *
     * @param variants_nxt_lvl
     *
     * @return Variants(Next Level)
     */
    @SerializedName( "variants_nxt_lvl" )
    @JsonProperty( "variants_nxt_lvl" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "variants_nxt_lvl" )
    private Boolean variants_nxt_lvl;
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>x_plant_material_status</b>
     * </p>
     *
     * @param x_plant_material_status
     *
     * @return X-Plant Status
     */
    @SerializedName( "x_plant_material_status" )
    @JsonProperty( "x_plant_material_status" )
    @Nullable
    @ODataField( odataName = "x_plant_material_status" )
    private String x_plant_material_status;
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>x_plt_status_valid_from</b>
     * </p>
     *
     * @param x_plt_status_valid_from
     *
     * @return Valid from
     */
    @SerializedName( "x_plt_status_valid_from" )
    @JsonProperty( "x_plt_status_valid_from" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "x_plt_status_valid_from",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime x_plt_status_valid_from;

    @Nonnull
    @Override
    public Class<DBomheaderforexplosionOut> getType()
    {
        return DBomheaderforexplosionOut.class;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("alternative_item", getAlternative_item());
        values.put("alt_item_group", getAlt_item_group());
        values.put("alt_nxt_lvl", getAlt_nxt_lvl());
        values.put("assembly_indicator", getAssembly_indicator());
        values.put("assign_effect_vals", getAssign_effect_vals());
        values.put("assy_scrap_itm_mat", getAssy_scrap_itm_mat());
        values.put("as_selection_cond", getAs_selection_cond());
        values.put("base_qty_nxt_lvl", getBase_qty_nxt_lvl());
        values.put("base_unit_nxt_lvl", getBase_unit_nxt_lvl());
        values.put("base_uom", getBase_uom());
        values.put("batch_entry", getBatch_entry());
        values.put("batch_mgmt", getBatch_mgmt());
        values.put("bill_of_material", getBill_of_material());
        values.put("bill_of_material_base_quant", getBill_of_material_base_quant());
        values.put("bill_of_material_component", getBill_of_material_component());
        values.put("bill_of_material_comp_quant", getBill_of_material_comp_quant());
        values.put("bill_of_material_item_category", getBill_of_material_item_category());
        values.put("bill_of_material_item_number", getBill_of_material_item_number());
        values.put("bill_of_material_item_quantity", getBill_of_material_item_quantity());
        values.put("bill_of_material_item_unit", getBill_of_material_item_unit());
        values.put("Bill_Of_Material_Root", getBill_Of_Material_Root());
        values.put("bill_of_material_root_variant", getBill_of_material_root_variant());
        values.put("bill_of_material_variant", getBill_of_material_variant());
        values.put("bill_of_material_variant_usage", getBill_of_material_variant_usage());
        values.put("bom_change_number", getBom_change_number());
        values.put("bulk_material", getBulk_material());
        values.put("b_o_m_alternative_text", getB_o_m_alternative_text());
        values.put("b_o_m_alt_nxt_lvl", getB_o_m_alt_nxt_lvl());
        values.put("b_o_m_category", getB_o_m_category());
        values.put("b_o_m_cat_nxt_lvl", getB_o_m_cat_nxt_lvl());
        values.put("b_o_m_component_description", getB_o_m_component_description());
        values.put("b_o_m_explosion_level", getB_o_m_explosion_level());
        values.put("b_o_m_hdr_matl_hier_node", getB_o_m_hdr_matl_hier_node());
        values.put("B_O_M_Hdr_Root_Matl_Hier_Node", getB_O_M_Hdr_Root_Matl_Hier_Node());
        values.put("b_o_m_header_base_unit", getB_o_m_header_base_unit());
        values.put("b_o_m_header_quantity_primary", getB_o_m_header_quantity_primary());
        values.put("b_o_m_item_description", getB_o_m_item_description());
        values.put("b_o_m_item_is_discontinued", getB_o_m_item_is_discontinued());
        values.put("b_o_m_no_nxt_lvl", getB_o_m_no_nxt_lvl());
        values.put("b_o_m_usage_nxt_lvl", getB_o_m_usage_nxt_lvl());
        values.put("b_o_m_version", getB_o_m_version());
        values.put("b_o_m_version_status", getB_o_m_version_status());
        values.put("b_o_m_vers_status_description", getB_o_m_vers_status_description());
        values.put("change_number", getChange_number());
        values.put("chg_to_eng_chg_number", getChg_to_eng_chg_number());
        values.put("class", getClassProperty());
        values.put("classification", getClassification());
        values.put("class_type", getClass_type());
        values.put("commodity_code", getCommodity_code());
        values.put("comp_maint_status", getComp_maint_status());
        values.put("comp_scrap_itm", getComp_scrap_itm());
        values.put("comp_scrap_itm_mat", getComp_scrap_itm_mat());
        values.put("config_mat_var", getConfig_mat_var());
        values.put("config_multi_level", getConfig_multi_level());
        values.put("conf_bom_nxt_lvl", getConf_bom_nxt_lvl());
        values.put("cost_element", getCost_element());
        values.put("counter", getCounter());
        values.put("co_product", getCo_product());
        values.put("created_by_user", getCreated_by_user());
        values.put("currency", getCurrency());
        values.put("customs_preference", getCustoms_preference());
        values.put("dat_hist_nxt_lvl", getDat_hist_nxt_lvl());
        values.put("deletion_indicator", getDeletion_indicator());
        values.put("delivery_time_in_days", getDelivery_time_in_days());
        values.put("del_Ind_nxt_lvl", getDel_Ind_nxt_lvl());
        values.put("denominator", getDenominator());
        values.put("discont_group", getDiscont_group());
        values.put("distribution_key", getDistribution_key());
        values.put("doc", getDoc());
        values.put("document_part", getDocument_part());
        values.put("document_type", getDocument_type());
        values.put("document_version", getDocument_version());
        values.put("doc_number", getDoc_number());
        values.put("doc_reqd", getDoc_reqd());
        values.put("doc_status", getDoc_status());
        values.put("doc_type", getDoc_type());
        values.put("doc_version", getDoc_version());
        values.put("effective_out_date", getEffective_out_date());
        values.put("engineering_design", getEngineering_design());
        values.put("exception_bom", getException_bom());
        values.put("explosion_type", getExplosion_type());
        values.put("fixed_price_co_prod", getFixed_price_co_prod());
        values.put("fixed_quantity", getFixed_quantity());
        values.put("follow_up_grp", getFollow_up_grp());
        values.put("follow_up_item", getFollow_up_item());
        values.put("follow_up_product", getFollow_up_product());
        values.put("formula_key", getFormula_key());
        values.put("goods_receipt_duration_in_days", getGoods_receipt_duration_in_days());
        values.put("goods_recipient", getGoods_recipient());
        values.put("header_record_id", getHeader_record_id());
        values.put("header_validity_end_date", getHeader_validity_end_date());
        values.put("header_validity_start_date", getHeader_validity_start_date());
        values.put("hl_configuration", getHl_configuration());
        values.put("individual_coll", getIndividual_coll());
        values.put("internal_obj_no", getInternal_obj_no());
        values.put("intra_material", getIntra_material());
        values.put("issuing_plant", getIssuing_plant());
        values.put("is_b_o_m_item_spare_part", getIs_b_o_m_item_spare_part());
        values.put("is_c_a_d", getIs_c_a_d());
        values.put("is_material_provision", getIs_material_provision());
        values.put("is_phantom_item", getIs_phantom_item());
        values.put("is_software_component", getIs_software_component());
        values.put("item_description_line_2", getItem_description_line_2());
        values.put("item_identification", getItem_identification());
        values.put("item_index", getItem_index());
        values.put("item_node", getItem_node());
        values.put("item_sign", getItem_sign());
        values.put("last_changed_by_user", getLast_changed_by_user());
        values.put("last_change_date", getLast_change_date());
        values.put("lead_time_offset", getLead_time_offset());
        values.put("long_text_lang", getLong_text_lang());
        values.put("low_level_code", getLow_level_code());
        values.put("maintenance_status", getMaintenance_status());
        values.put("material_component_price", getMaterial_component_price());
        values.put("material_group", getMaterial_group());
        values.put("material_is_configurable", getMaterial_is_configurable());
        values.put("Material_Name", getMaterial_Name());
        values.put("material_type", getMaterial_type());
        values.put("mat_purity_in_perc", getMat_purity_in_perc());
        values.put("moving_price", getMoving_price());
        values.put("multiple_sel", getMultiple_sel());
        values.put("m_r_p_type", getM_r_p_type());
        values.put("net_scrap_indicator", getNet_scrap_indicator());
        values.put("no_cu_instances", getNo_cu_instances());
        values.put("no_of_sheets", getNo_of_sheets());
        values.put("no_var_size_items", getNo_var_size_items());
        values.put("numerator", getNumerator());
        values.put("object_description", getObject_description());
        values.put("object_type", getObject_type());
        values.put("obj_dep_assgt_no", getObj_dep_assgt_no());
        values.put("operation_scrap_perc", getOperation_scrap_perc());
        values.put("oper_lto_unit", getOper_lto_unit());
        values.put("oper_lt_offset", getOper_lt_offset());
        values.put("org_area", getOrg_area());
        values.put("page_format", getPage_format());
        values.put("page_number", getPage_number());
        values.put("path", getPath());
        values.put("path_predecessor", getPath_predecessor());
        values.put("plant", getPlant());
        values.put("plantName", getPlantName());
        values.put("plant_maintenance", getPlant_maintenance());
        values.put("plant_sp_matl_status", getPlant_sp_matl_status());
        values.put("plt_sp_status_valid_from", getPlt_sp_status_valid_from());
        values.put("price_control", getPrice_control());
        values.put("price_unit", getPrice_unit());
        values.put("priority", getPriority());
        values.put("procured_externally", getProcured_externally());
        values.put("prodn_supply_area", getProdn_supply_area());
        values.put("production_relevant", getProduction_relevant());
        values.put("production_version", getProduction_version());
        values.put("prod_order_issue_location", getProd_order_issue_location());
        values.put("profit_center", getProfit_center());
        values.put("purchasing_group", getPurchasing_group());
        values.put("purchasing_organisation", getPurchasing_organisation());
        values.put("qty_var_size_item", getQty_var_size_item());
        values.put("record_creation_date", getRecord_creation_date());
        values.put("recurisve", getRecurisve());
        values.put("recurs_allowed", getRecurs_allowed());
        values.put("reference_point", getReference_point());
        values.put("relevancy_to_costing", getRelevancy_to_costing());
        values.put("relevant_to_sales", getRelevant_to_sales());
        values.put("required_component", getRequired_component());
        values.put("requirement_segment", getRequirement_segment());
        values.put("revision_level", getRevision_level());
        values.put("scrap_qty_bun", getScrap_qty_bun());
        values.put("serial_no_profile", getSerial_no_profile());
        values.put("size1", getSize1());
        values.put("size2", getSize2());
        values.put("size3", getSize3());
        values.put("size_unit", getSize_unit());
        values.put("sort_string", getSort_string());
        values.put("special_procurement_type", getSpecial_procurement_type());
        values.put("special_proc_typ_itm", getSpecial_proc_typ_itm());
        values.put("special_proc_typ_mastr", getSpecial_proc_typ_mastr());
        values.put("spec_proc_costing", getSpec_proc_costing());
        values.put("standard_price", getStandard_price());
        values.put("status_text", getStatus_text());
        values.put("stock_segment", getStock_segment());
        values.put("storage_location", getStorage_location());
        values.put("strategy", getStrategy());
        values.put("sub_item_indicator", getSub_item_indicator());
        values.put("supplier", getSupplier());
        values.put("table_row", getTable_row());
        values.put("tech_status_from", getTech_status_from());
        values.put("test_hist_nxt_lvl", getTest_hist_nxt_lvl());
        values.put("totals_record_id", getTotals_record_id());
        values.put("unit_of_measure", getUnit_of_measure());
        values.put("unloading_point", getUnloading_point());
        values.put("uom_usage", getUom_usage());
        values.put("usage_probability", getUsage_probability());
        values.put("validity_end_date", getValidity_end_date());
        values.put("validity_start_date", getValidity_start_date());
        values.put("valuation_category", getValuation_category());
        values.put("variants_nxt_lvl", getVariants_nxt_lvl());
        values.put("x_plant_material_status", getX_plant_material_status());
        values.put("x_plt_status_valid_from", getX_plt_status_valid_from());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("alternative_item") ) {
                final Object value = values.remove("alternative_item");
                if( (value == null) || (!value.equals(getAlternative_item())) ) {
                    setAlternative_item(((Boolean) value));
                }
            }
            if( values.containsKey("alt_item_group") ) {
                final Object value = values.remove("alt_item_group");
                if( (value == null) || (!value.equals(getAlt_item_group())) ) {
                    setAlt_item_group(((String) value));
                }
            }
            if( values.containsKey("alt_nxt_lvl") ) {
                final Object value = values.remove("alt_nxt_lvl");
                if( (value == null) || (!value.equals(getAlt_nxt_lvl())) ) {
                    setAlt_nxt_lvl(((Boolean) value));
                }
            }
            if( values.containsKey("assembly_indicator") ) {
                final Object value = values.remove("assembly_indicator");
                if( (value == null) || (!value.equals(getAssembly_indicator())) ) {
                    setAssembly_indicator(((Boolean) value));
                }
            }
            if( values.containsKey("assign_effect_vals") ) {
                final Object value = values.remove("assign_effect_vals");
                if( (value == null) || (!value.equals(getAssign_effect_vals())) ) {
                    setAssign_effect_vals(((Boolean) value));
                }
            }
            if( values.containsKey("assy_scrap_itm_mat") ) {
                final Object value = values.remove("assy_scrap_itm_mat");
                if( (value == null) || (!value.equals(getAssy_scrap_itm_mat())) ) {
                    setAssy_scrap_itm_mat(((BigDecimal) value));
                }
            }
            if( values.containsKey("as_selection_cond") ) {
                final Object value = values.remove("as_selection_cond");
                if( (value == null) || (!value.equals(getAs_selection_cond())) ) {
                    setAs_selection_cond(((Boolean) value));
                }
            }
            if( values.containsKey("base_qty_nxt_lvl") ) {
                final Object value = values.remove("base_qty_nxt_lvl");
                if( (value == null) || (!value.equals(getBase_qty_nxt_lvl())) ) {
                    setBase_qty_nxt_lvl(((BigDecimal) value));
                }
            }
            if( values.containsKey("base_unit_nxt_lvl") ) {
                final Object value = values.remove("base_unit_nxt_lvl");
                if( (value == null) || (!value.equals(getBase_unit_nxt_lvl())) ) {
                    setBase_unit_nxt_lvl(((String) value));
                }
            }
            if( values.containsKey("base_uom") ) {
                final Object value = values.remove("base_uom");
                if( (value == null) || (!value.equals(getBase_uom())) ) {
                    setBase_uom(((String) value));
                }
            }
            if( values.containsKey("batch_entry") ) {
                final Object value = values.remove("batch_entry");
                if( (value == null) || (!value.equals(getBatch_entry())) ) {
                    setBatch_entry(((String) value));
                }
            }
            if( values.containsKey("batch_mgmt") ) {
                final Object value = values.remove("batch_mgmt");
                if( (value == null) || (!value.equals(getBatch_mgmt())) ) {
                    setBatch_mgmt(((Boolean) value));
                }
            }
            if( values.containsKey("bill_of_material") ) {
                final Object value = values.remove("bill_of_material");
                if( (value == null) || (!value.equals(getBill_of_material())) ) {
                    setBill_of_material(((String) value));
                }
            }
            if( values.containsKey("bill_of_material_base_quant") ) {
                final Object value = values.remove("bill_of_material_base_quant");
                if( (value == null) || (!value.equals(getBill_of_material_base_quant())) ) {
                    setBill_of_material_base_quant(((BigDecimal) value));
                }
            }
            if( values.containsKey("bill_of_material_component") ) {
                final Object value = values.remove("bill_of_material_component");
                if( (value == null) || (!value.equals(getBill_of_material_component())) ) {
                    setBill_of_material_component(((String) value));
                }
            }
            if( values.containsKey("bill_of_material_comp_quant") ) {
                final Object value = values.remove("bill_of_material_comp_quant");
                if( (value == null) || (!value.equals(getBill_of_material_comp_quant())) ) {
                    setBill_of_material_comp_quant(((BigDecimal) value));
                }
            }
            if( values.containsKey("bill_of_material_item_category") ) {
                final Object value = values.remove("bill_of_material_item_category");
                if( (value == null) || (!value.equals(getBill_of_material_item_category())) ) {
                    setBill_of_material_item_category(((String) value));
                }
            }
            if( values.containsKey("bill_of_material_item_number") ) {
                final Object value = values.remove("bill_of_material_item_number");
                if( (value == null) || (!value.equals(getBill_of_material_item_number())) ) {
                    setBill_of_material_item_number(((String) value));
                }
            }
            if( values.containsKey("bill_of_material_item_quantity") ) {
                final Object value = values.remove("bill_of_material_item_quantity");
                if( (value == null) || (!value.equals(getBill_of_material_item_quantity())) ) {
                    setBill_of_material_item_quantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("bill_of_material_item_unit") ) {
                final Object value = values.remove("bill_of_material_item_unit");
                if( (value == null) || (!value.equals(getBill_of_material_item_unit())) ) {
                    setBill_of_material_item_unit(((String) value));
                }
            }
            if( values.containsKey("Bill_Of_Material_Root") ) {
                final Object value = values.remove("Bill_Of_Material_Root");
                if( (value == null) || (!value.equals(getBill_Of_Material_Root())) ) {
                    setBill_Of_Material_Root(((String) value));
                }
            }
            if( values.containsKey("bill_of_material_root_variant") ) {
                final Object value = values.remove("bill_of_material_root_variant");
                if( (value == null) || (!value.equals(getBill_of_material_root_variant())) ) {
                    setBill_of_material_root_variant(((String) value));
                }
            }
            if( values.containsKey("bill_of_material_variant") ) {
                final Object value = values.remove("bill_of_material_variant");
                if( (value == null) || (!value.equals(getBill_of_material_variant())) ) {
                    setBill_of_material_variant(((String) value));
                }
            }
            if( values.containsKey("bill_of_material_variant_usage") ) {
                final Object value = values.remove("bill_of_material_variant_usage");
                if( (value == null) || (!value.equals(getBill_of_material_variant_usage())) ) {
                    setBill_of_material_variant_usage(((String) value));
                }
            }
            if( values.containsKey("bom_change_number") ) {
                final Object value = values.remove("bom_change_number");
                if( (value == null) || (!value.equals(getBom_change_number())) ) {
                    setBom_change_number(((String) value));
                }
            }
            if( values.containsKey("bulk_material") ) {
                final Object value = values.remove("bulk_material");
                if( (value == null) || (!value.equals(getBulk_material())) ) {
                    setBulk_material(((Boolean) value));
                }
            }
            if( values.containsKey("b_o_m_alternative_text") ) {
                final Object value = values.remove("b_o_m_alternative_text");
                if( (value == null) || (!value.equals(getB_o_m_alternative_text())) ) {
                    setB_o_m_alternative_text(((String) value));
                }
            }
            if( values.containsKey("b_o_m_alt_nxt_lvl") ) {
                final Object value = values.remove("b_o_m_alt_nxt_lvl");
                if( (value == null) || (!value.equals(getB_o_m_alt_nxt_lvl())) ) {
                    setB_o_m_alt_nxt_lvl(((String) value));
                }
            }
            if( values.containsKey("b_o_m_category") ) {
                final Object value = values.remove("b_o_m_category");
                if( (value == null) || (!value.equals(getB_o_m_category())) ) {
                    setB_o_m_category(((String) value));
                }
            }
            if( values.containsKey("b_o_m_cat_nxt_lvl") ) {
                final Object value = values.remove("b_o_m_cat_nxt_lvl");
                if( (value == null) || (!value.equals(getB_o_m_cat_nxt_lvl())) ) {
                    setB_o_m_cat_nxt_lvl(((String) value));
                }
            }
            if( values.containsKey("b_o_m_component_description") ) {
                final Object value = values.remove("b_o_m_component_description");
                if( (value == null) || (!value.equals(getB_o_m_component_description())) ) {
                    setB_o_m_component_description(((String) value));
                }
            }
            if( values.containsKey("b_o_m_explosion_level") ) {
                final Object value = values.remove("b_o_m_explosion_level");
                if( (value == null) || (!value.equals(getB_o_m_explosion_level())) ) {
                    setB_o_m_explosion_level(((BigDecimal) value));
                }
            }
            if( values.containsKey("b_o_m_hdr_matl_hier_node") ) {
                final Object value = values.remove("b_o_m_hdr_matl_hier_node");
                if( (value == null) || (!value.equals(getB_o_m_hdr_matl_hier_node())) ) {
                    setB_o_m_hdr_matl_hier_node(((String) value));
                }
            }
            if( values.containsKey("B_O_M_Hdr_Root_Matl_Hier_Node") ) {
                final Object value = values.remove("B_O_M_Hdr_Root_Matl_Hier_Node");
                if( (value == null) || (!value.equals(getB_O_M_Hdr_Root_Matl_Hier_Node())) ) {
                    setB_O_M_Hdr_Root_Matl_Hier_Node(((String) value));
                }
            }
            if( values.containsKey("b_o_m_header_base_unit") ) {
                final Object value = values.remove("b_o_m_header_base_unit");
                if( (value == null) || (!value.equals(getB_o_m_header_base_unit())) ) {
                    setB_o_m_header_base_unit(((String) value));
                }
            }
            if( values.containsKey("b_o_m_header_quantity_primary") ) {
                final Object value = values.remove("b_o_m_header_quantity_primary");
                if( (value == null) || (!value.equals(getB_o_m_header_quantity_primary())) ) {
                    setB_o_m_header_quantity_primary(((BigDecimal) value));
                }
            }
            if( values.containsKey("b_o_m_item_description") ) {
                final Object value = values.remove("b_o_m_item_description");
                if( (value == null) || (!value.equals(getB_o_m_item_description())) ) {
                    setB_o_m_item_description(((String) value));
                }
            }
            if( values.containsKey("b_o_m_item_is_discontinued") ) {
                final Object value = values.remove("b_o_m_item_is_discontinued");
                if( (value == null) || (!value.equals(getB_o_m_item_is_discontinued())) ) {
                    setB_o_m_item_is_discontinued(((String) value));
                }
            }
            if( values.containsKey("b_o_m_no_nxt_lvl") ) {
                final Object value = values.remove("b_o_m_no_nxt_lvl");
                if( (value == null) || (!value.equals(getB_o_m_no_nxt_lvl())) ) {
                    setB_o_m_no_nxt_lvl(((String) value));
                }
            }
            if( values.containsKey("b_o_m_usage_nxt_lvl") ) {
                final Object value = values.remove("b_o_m_usage_nxt_lvl");
                if( (value == null) || (!value.equals(getB_o_m_usage_nxt_lvl())) ) {
                    setB_o_m_usage_nxt_lvl(((String) value));
                }
            }
            if( values.containsKey("b_o_m_version") ) {
                final Object value = values.remove("b_o_m_version");
                if( (value == null) || (!value.equals(getB_o_m_version())) ) {
                    setB_o_m_version(((String) value));
                }
            }
            if( values.containsKey("b_o_m_version_status") ) {
                final Object value = values.remove("b_o_m_version_status");
                if( (value == null) || (!value.equals(getB_o_m_version_status())) ) {
                    setB_o_m_version_status(((String) value));
                }
            }
            if( values.containsKey("b_o_m_vers_status_description") ) {
                final Object value = values.remove("b_o_m_vers_status_description");
                if( (value == null) || (!value.equals(getB_o_m_vers_status_description())) ) {
                    setB_o_m_vers_status_description(((String) value));
                }
            }
            if( values.containsKey("change_number") ) {
                final Object value = values.remove("change_number");
                if( (value == null) || (!value.equals(getChange_number())) ) {
                    setChange_number(((String) value));
                }
            }
            if( values.containsKey("chg_to_eng_chg_number") ) {
                final Object value = values.remove("chg_to_eng_chg_number");
                if( (value == null) || (!value.equals(getChg_to_eng_chg_number())) ) {
                    setChg_to_eng_chg_number(((String) value));
                }
            }
            if( values.containsKey("class") ) {
                final Object value = values.remove("class");
                if( (value == null) || (!value.equals(getClassProperty())) ) {
                    setClassProperty(((String) value));
                }
            }
            if( values.containsKey("classification") ) {
                final Object value = values.remove("classification");
                if( (value == null) || (!value.equals(getClassification())) ) {
                    setClassification(((String) value));
                }
            }
            if( values.containsKey("class_type") ) {
                final Object value = values.remove("class_type");
                if( (value == null) || (!value.equals(getClass_type())) ) {
                    setClass_type(((String) value));
                }
            }
            if( values.containsKey("commodity_code") ) {
                final Object value = values.remove("commodity_code");
                if( (value == null) || (!value.equals(getCommodity_code())) ) {
                    setCommodity_code(((String) value));
                }
            }
            if( values.containsKey("comp_maint_status") ) {
                final Object value = values.remove("comp_maint_status");
                if( (value == null) || (!value.equals(getComp_maint_status())) ) {
                    setComp_maint_status(((String) value));
                }
            }
            if( values.containsKey("comp_scrap_itm") ) {
                final Object value = values.remove("comp_scrap_itm");
                if( (value == null) || (!value.equals(getComp_scrap_itm())) ) {
                    setComp_scrap_itm(((BigDecimal) value));
                }
            }
            if( values.containsKey("comp_scrap_itm_mat") ) {
                final Object value = values.remove("comp_scrap_itm_mat");
                if( (value == null) || (!value.equals(getComp_scrap_itm_mat())) ) {
                    setComp_scrap_itm_mat(((BigDecimal) value));
                }
            }
            if( values.containsKey("config_mat_var") ) {
                final Object value = values.remove("config_mat_var");
                if( (value == null) || (!value.equals(getConfig_mat_var())) ) {
                    setConfig_mat_var(((String) value));
                }
            }
            if( values.containsKey("config_multi_level") ) {
                final Object value = values.remove("config_multi_level");
                if( (value == null) || (!value.equals(getConfig_multi_level())) ) {
                    setConfig_multi_level(((Boolean) value));
                }
            }
            if( values.containsKey("conf_bom_nxt_lvl") ) {
                final Object value = values.remove("conf_bom_nxt_lvl");
                if( (value == null) || (!value.equals(getConf_bom_nxt_lvl())) ) {
                    setConf_bom_nxt_lvl(((Boolean) value));
                }
            }
            if( values.containsKey("cost_element") ) {
                final Object value = values.remove("cost_element");
                if( (value == null) || (!value.equals(getCost_element())) ) {
                    setCost_element(((String) value));
                }
            }
            if( values.containsKey("counter") ) {
                final Object value = values.remove("counter");
                if( (value == null) || (!value.equals(getCounter())) ) {
                    setCounter(((String) value));
                }
            }
            if( values.containsKey("co_product") ) {
                final Object value = values.remove("co_product");
                if( (value == null) || (!value.equals(getCo_product())) ) {
                    setCo_product(((Boolean) value));
                }
            }
            if( values.containsKey("created_by_user") ) {
                final Object value = values.remove("created_by_user");
                if( (value == null) || (!value.equals(getCreated_by_user())) ) {
                    setCreated_by_user(((String) value));
                }
            }
            if( values.containsKey("currency") ) {
                final Object value = values.remove("currency");
                if( (value == null) || (!value.equals(getCurrency())) ) {
                    setCurrency(((String) value));
                }
            }
            if( values.containsKey("customs_preference") ) {
                final Object value = values.remove("customs_preference");
                if( (value == null) || (!value.equals(getCustoms_preference())) ) {
                    setCustoms_preference(((String) value));
                }
            }
            if( values.containsKey("dat_hist_nxt_lvl") ) {
                final Object value = values.remove("dat_hist_nxt_lvl");
                if( (value == null) || (!value.equals(getDat_hist_nxt_lvl())) ) {
                    setDat_hist_nxt_lvl(((Boolean) value));
                }
            }
            if( values.containsKey("deletion_indicator") ) {
                final Object value = values.remove("deletion_indicator");
                if( (value == null) || (!value.equals(getDeletion_indicator())) ) {
                    setDeletion_indicator(((Boolean) value));
                }
            }
            if( values.containsKey("delivery_time_in_days") ) {
                final Object value = values.remove("delivery_time_in_days");
                if( (value == null) || (!value.equals(getDelivery_time_in_days())) ) {
                    setDelivery_time_in_days(((BigDecimal) value));
                }
            }
            if( values.containsKey("del_Ind_nxt_lvl") ) {
                final Object value = values.remove("del_Ind_nxt_lvl");
                if( (value == null) || (!value.equals(getDel_Ind_nxt_lvl())) ) {
                    setDel_Ind_nxt_lvl(((Boolean) value));
                }
            }
            if( values.containsKey("denominator") ) {
                final Object value = values.remove("denominator");
                if( (value == null) || (!value.equals(getDenominator())) ) {
                    setDenominator(((BigDecimal) value));
                }
            }
            if( values.containsKey("discont_group") ) {
                final Object value = values.remove("discont_group");
                if( (value == null) || (!value.equals(getDiscont_group())) ) {
                    setDiscont_group(((String) value));
                }
            }
            if( values.containsKey("distribution_key") ) {
                final Object value = values.remove("distribution_key");
                if( (value == null) || (!value.equals(getDistribution_key())) ) {
                    setDistribution_key(((String) value));
                }
            }
            if( values.containsKey("doc") ) {
                final Object value = values.remove("doc");
                if( (value == null) || (!value.equals(getDoc())) ) {
                    setDoc(((String) value));
                }
            }
            if( values.containsKey("document_part") ) {
                final Object value = values.remove("document_part");
                if( (value == null) || (!value.equals(getDocument_part())) ) {
                    setDocument_part(((String) value));
                }
            }
            if( values.containsKey("document_type") ) {
                final Object value = values.remove("document_type");
                if( (value == null) || (!value.equals(getDocument_type())) ) {
                    setDocument_type(((String) value));
                }
            }
            if( values.containsKey("document_version") ) {
                final Object value = values.remove("document_version");
                if( (value == null) || (!value.equals(getDocument_version())) ) {
                    setDocument_version(((String) value));
                }
            }
            if( values.containsKey("doc_number") ) {
                final Object value = values.remove("doc_number");
                if( (value == null) || (!value.equals(getDoc_number())) ) {
                    setDoc_number(((String) value));
                }
            }
            if( values.containsKey("doc_reqd") ) {
                final Object value = values.remove("doc_reqd");
                if( (value == null) || (!value.equals(getDoc_reqd())) ) {
                    setDoc_reqd(((Boolean) value));
                }
            }
            if( values.containsKey("doc_status") ) {
                final Object value = values.remove("doc_status");
                if( (value == null) || (!value.equals(getDoc_status())) ) {
                    setDoc_status(((String) value));
                }
            }
            if( values.containsKey("doc_type") ) {
                final Object value = values.remove("doc_type");
                if( (value == null) || (!value.equals(getDoc_type())) ) {
                    setDoc_type(((String) value));
                }
            }
            if( values.containsKey("doc_version") ) {
                final Object value = values.remove("doc_version");
                if( (value == null) || (!value.equals(getDoc_version())) ) {
                    setDoc_version(((String) value));
                }
            }
            if( values.containsKey("effective_out_date") ) {
                final Object value = values.remove("effective_out_date");
                if( (value == null) || (!value.equals(getEffective_out_date())) ) {
                    setEffective_out_date(((LocalDateTime) value));
                }
            }
            if( values.containsKey("engineering_design") ) {
                final Object value = values.remove("engineering_design");
                if( (value == null) || (!value.equals(getEngineering_design())) ) {
                    setEngineering_design(((Boolean) value));
                }
            }
            if( values.containsKey("exception_bom") ) {
                final Object value = values.remove("exception_bom");
                if( (value == null) || (!value.equals(getException_bom())) ) {
                    setException_bom(((String) value));
                }
            }
            if( values.containsKey("explosion_type") ) {
                final Object value = values.remove("explosion_type");
                if( (value == null) || (!value.equals(getExplosion_type())) ) {
                    setExplosion_type(((String) value));
                }
            }
            if( values.containsKey("fixed_price_co_prod") ) {
                final Object value = values.remove("fixed_price_co_prod");
                if( (value == null) || (!value.equals(getFixed_price_co_prod())) ) {
                    setFixed_price_co_prod(((Boolean) value));
                }
            }
            if( values.containsKey("fixed_quantity") ) {
                final Object value = values.remove("fixed_quantity");
                if( (value == null) || (!value.equals(getFixed_quantity())) ) {
                    setFixed_quantity(((Boolean) value));
                }
            }
            if( values.containsKey("follow_up_grp") ) {
                final Object value = values.remove("follow_up_grp");
                if( (value == null) || (!value.equals(getFollow_up_grp())) ) {
                    setFollow_up_grp(((String) value));
                }
            }
            if( values.containsKey("follow_up_item") ) {
                final Object value = values.remove("follow_up_item");
                if( (value == null) || (!value.equals(getFollow_up_item())) ) {
                    setFollow_up_item(((Boolean) value));
                }
            }
            if( values.containsKey("follow_up_product") ) {
                final Object value = values.remove("follow_up_product");
                if( (value == null) || (!value.equals(getFollow_up_product())) ) {
                    setFollow_up_product(((String) value));
                }
            }
            if( values.containsKey("formula_key") ) {
                final Object value = values.remove("formula_key");
                if( (value == null) || (!value.equals(getFormula_key())) ) {
                    setFormula_key(((String) value));
                }
            }
            if( values.containsKey("goods_receipt_duration_in_days") ) {
                final Object value = values.remove("goods_receipt_duration_in_days");
                if( (value == null) || (!value.equals(getGoods_receipt_duration_in_days())) ) {
                    setGoods_receipt_duration_in_days(((BigDecimal) value));
                }
            }
            if( values.containsKey("goods_recipient") ) {
                final Object value = values.remove("goods_recipient");
                if( (value == null) || (!value.equals(getGoods_recipient())) ) {
                    setGoods_recipient(((String) value));
                }
            }
            if( values.containsKey("header_record_id") ) {
                final Object value = values.remove("header_record_id");
                if( (value == null) || (!value.equals(getHeader_record_id())) ) {
                    setHeader_record_id(((String) value));
                }
            }
            if( values.containsKey("header_validity_end_date") ) {
                final Object value = values.remove("header_validity_end_date");
                if( (value == null) || (!value.equals(getHeader_validity_end_date())) ) {
                    setHeader_validity_end_date(((LocalDateTime) value));
                }
            }
            if( values.containsKey("header_validity_start_date") ) {
                final Object value = values.remove("header_validity_start_date");
                if( (value == null) || (!value.equals(getHeader_validity_start_date())) ) {
                    setHeader_validity_start_date(((LocalDateTime) value));
                }
            }
            if( values.containsKey("hl_configuration") ) {
                final Object value = values.remove("hl_configuration");
                if( (value == null) || (!value.equals(getHl_configuration())) ) {
                    setHl_configuration(((Boolean) value));
                }
            }
            if( values.containsKey("individual_coll") ) {
                final Object value = values.remove("individual_coll");
                if( (value == null) || (!value.equals(getIndividual_coll())) ) {
                    setIndividual_coll(((String) value));
                }
            }
            if( values.containsKey("internal_obj_no") ) {
                final Object value = values.remove("internal_obj_no");
                if( (value == null) || (!value.equals(getInternal_obj_no())) ) {
                    setInternal_obj_no(((String) value));
                }
            }
            if( values.containsKey("intra_material") ) {
                final Object value = values.remove("intra_material");
                if( (value == null) || (!value.equals(getIntra_material())) ) {
                    setIntra_material(((String) value));
                }
            }
            if( values.containsKey("issuing_plant") ) {
                final Object value = values.remove("issuing_plant");
                if( (value == null) || (!value.equals(getIssuing_plant())) ) {
                    setIssuing_plant(((String) value));
                }
            }
            if( values.containsKey("is_b_o_m_item_spare_part") ) {
                final Object value = values.remove("is_b_o_m_item_spare_part");
                if( (value == null) || (!value.equals(getIs_b_o_m_item_spare_part())) ) {
                    setIs_b_o_m_item_spare_part(((String) value));
                }
            }
            if( values.containsKey("is_c_a_d") ) {
                final Object value = values.remove("is_c_a_d");
                if( (value == null) || (!value.equals(getIs_c_a_d())) ) {
                    setIs_c_a_d(((Boolean) value));
                }
            }
            if( values.containsKey("is_material_provision") ) {
                final Object value = values.remove("is_material_provision");
                if( (value == null) || (!value.equals(getIs_material_provision())) ) {
                    setIs_material_provision(((String) value));
                }
            }
            if( values.containsKey("is_phantom_item") ) {
                final Object value = values.remove("is_phantom_item");
                if( (value == null) || (!value.equals(getIs_phantom_item())) ) {
                    setIs_phantom_item(((Boolean) value));
                }
            }
            if( values.containsKey("is_software_component") ) {
                final Object value = values.remove("is_software_component");
                if( (value == null) || (!value.equals(getIs_software_component())) ) {
                    setIs_software_component(((Boolean) value));
                }
            }
            if( values.containsKey("item_description_line_2") ) {
                final Object value = values.remove("item_description_line_2");
                if( (value == null) || (!value.equals(getItem_description_line_2())) ) {
                    setItem_description_line_2(((String) value));
                }
            }
            if( values.containsKey("item_identification") ) {
                final Object value = values.remove("item_identification");
                if( (value == null) || (!value.equals(getItem_identification())) ) {
                    setItem_identification(((String) value));
                }
            }
            if( values.containsKey("item_index") ) {
                final Object value = values.remove("item_index");
                if( (value == null) || (!value.equals(getItem_index())) ) {
                    setItem_index(((Integer) value));
                }
            }
            if( values.containsKey("item_node") ) {
                final Object value = values.remove("item_node");
                if( (value == null) || (!value.equals(getItem_node())) ) {
                    setItem_node(((String) value));
                }
            }
            if( values.containsKey("item_sign") ) {
                final Object value = values.remove("item_sign");
                if( (value == null) || (!value.equals(getItem_sign())) ) {
                    setItem_sign(((Boolean) value));
                }
            }
            if( values.containsKey("last_changed_by_user") ) {
                final Object value = values.remove("last_changed_by_user");
                if( (value == null) || (!value.equals(getLast_changed_by_user())) ) {
                    setLast_changed_by_user(((String) value));
                }
            }
            if( values.containsKey("last_change_date") ) {
                final Object value = values.remove("last_change_date");
                if( (value == null) || (!value.equals(getLast_change_date())) ) {
                    setLast_change_date(((LocalDateTime) value));
                }
            }
            if( values.containsKey("lead_time_offset") ) {
                final Object value = values.remove("lead_time_offset");
                if( (value == null) || (!value.equals(getLead_time_offset())) ) {
                    setLead_time_offset(((BigDecimal) value));
                }
            }
            if( values.containsKey("long_text_lang") ) {
                final Object value = values.remove("long_text_lang");
                if( (value == null) || (!value.equals(getLong_text_lang())) ) {
                    setLong_text_lang(((String) value));
                }
            }
            if( values.containsKey("low_level_code") ) {
                final Object value = values.remove("low_level_code");
                if( (value == null) || (!value.equals(getLow_level_code())) ) {
                    setLow_level_code(((String) value));
                }
            }
            if( values.containsKey("maintenance_status") ) {
                final Object value = values.remove("maintenance_status");
                if( (value == null) || (!value.equals(getMaintenance_status())) ) {
                    setMaintenance_status(((String) value));
                }
            }
            if( values.containsKey("material_component_price") ) {
                final Object value = values.remove("material_component_price");
                if( (value == null) || (!value.equals(getMaterial_component_price())) ) {
                    setMaterial_component_price(((BigDecimal) value));
                }
            }
            if( values.containsKey("material_group") ) {
                final Object value = values.remove("material_group");
                if( (value == null) || (!value.equals(getMaterial_group())) ) {
                    setMaterial_group(((String) value));
                }
            }
            if( values.containsKey("material_is_configurable") ) {
                final Object value = values.remove("material_is_configurable");
                if( (value == null) || (!value.equals(getMaterial_is_configurable())) ) {
                    setMaterial_is_configurable(((Boolean) value));
                }
            }
            if( values.containsKey("Material_Name") ) {
                final Object value = values.remove("Material_Name");
                if( (value == null) || (!value.equals(getMaterial_Name())) ) {
                    setMaterial_Name(((String) value));
                }
            }
            if( values.containsKey("material_type") ) {
                final Object value = values.remove("material_type");
                if( (value == null) || (!value.equals(getMaterial_type())) ) {
                    setMaterial_type(((String) value));
                }
            }
            if( values.containsKey("mat_purity_in_perc") ) {
                final Object value = values.remove("mat_purity_in_perc");
                if( (value == null) || (!value.equals(getMat_purity_in_perc())) ) {
                    setMat_purity_in_perc(((BigDecimal) value));
                }
            }
            if( values.containsKey("moving_price") ) {
                final Object value = values.remove("moving_price");
                if( (value == null) || (!value.equals(getMoving_price())) ) {
                    setMoving_price(((BigDecimal) value));
                }
            }
            if( values.containsKey("multiple_sel") ) {
                final Object value = values.remove("multiple_sel");
                if( (value == null) || (!value.equals(getMultiple_sel())) ) {
                    setMultiple_sel(((Boolean) value));
                }
            }
            if( values.containsKey("m_r_p_type") ) {
                final Object value = values.remove("m_r_p_type");
                if( (value == null) || (!value.equals(getM_r_p_type())) ) {
                    setM_r_p_type(((String) value));
                }
            }
            if( values.containsKey("net_scrap_indicator") ) {
                final Object value = values.remove("net_scrap_indicator");
                if( (value == null) || (!value.equals(getNet_scrap_indicator())) ) {
                    setNet_scrap_indicator(((Boolean) value));
                }
            }
            if( values.containsKey("no_cu_instances") ) {
                final Object value = values.remove("no_cu_instances");
                if( (value == null) || (!value.equals(getNo_cu_instances())) ) {
                    setNo_cu_instances(((String) value));
                }
            }
            if( values.containsKey("no_of_sheets") ) {
                final Object value = values.remove("no_of_sheets");
                if( (value == null) || (!value.equals(getNo_of_sheets())) ) {
                    setNo_of_sheets(((String) value));
                }
            }
            if( values.containsKey("no_var_size_items") ) {
                final Object value = values.remove("no_var_size_items");
                if( (value == null) || (!value.equals(getNo_var_size_items())) ) {
                    setNo_var_size_items(((BigDecimal) value));
                }
            }
            if( values.containsKey("numerator") ) {
                final Object value = values.remove("numerator");
                if( (value == null) || (!value.equals(getNumerator())) ) {
                    setNumerator(((BigDecimal) value));
                }
            }
            if( values.containsKey("object_description") ) {
                final Object value = values.remove("object_description");
                if( (value == null) || (!value.equals(getObject_description())) ) {
                    setObject_description(((String) value));
                }
            }
            if( values.containsKey("object_type") ) {
                final Object value = values.remove("object_type");
                if( (value == null) || (!value.equals(getObject_type())) ) {
                    setObject_type(((String) value));
                }
            }
            if( values.containsKey("obj_dep_assgt_no") ) {
                final Object value = values.remove("obj_dep_assgt_no");
                if( (value == null) || (!value.equals(getObj_dep_assgt_no())) ) {
                    setObj_dep_assgt_no(((String) value));
                }
            }
            if( values.containsKey("operation_scrap_perc") ) {
                final Object value = values.remove("operation_scrap_perc");
                if( (value == null) || (!value.equals(getOperation_scrap_perc())) ) {
                    setOperation_scrap_perc(((BigDecimal) value));
                }
            }
            if( values.containsKey("oper_lto_unit") ) {
                final Object value = values.remove("oper_lto_unit");
                if( (value == null) || (!value.equals(getOper_lto_unit())) ) {
                    setOper_lto_unit(((String) value));
                }
            }
            if( values.containsKey("oper_lt_offset") ) {
                final Object value = values.remove("oper_lt_offset");
                if( (value == null) || (!value.equals(getOper_lt_offset())) ) {
                    setOper_lt_offset(((BigDecimal) value));
                }
            }
            if( values.containsKey("org_area") ) {
                final Object value = values.remove("org_area");
                if( (value == null) || (!value.equals(getOrg_area())) ) {
                    setOrg_area(((String) value));
                }
            }
            if( values.containsKey("page_format") ) {
                final Object value = values.remove("page_format");
                if( (value == null) || (!value.equals(getPage_format())) ) {
                    setPage_format(((String) value));
                }
            }
            if( values.containsKey("page_number") ) {
                final Object value = values.remove("page_number");
                if( (value == null) || (!value.equals(getPage_number())) ) {
                    setPage_number(((String) value));
                }
            }
            if( values.containsKey("path") ) {
                final Object value = values.remove("path");
                if( (value == null) || (!value.equals(getPath())) ) {
                    setPath(((BigDecimal) value));
                }
            }
            if( values.containsKey("path_predecessor") ) {
                final Object value = values.remove("path_predecessor");
                if( (value == null) || (!value.equals(getPath_predecessor())) ) {
                    setPath_predecessor(((BigDecimal) value));
                }
            }
            if( values.containsKey("plant") ) {
                final Object value = values.remove("plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("plantName") ) {
                final Object value = values.remove("plantName");
                if( (value == null) || (!value.equals(getPlantName())) ) {
                    setPlantName(((String) value));
                }
            }
            if( values.containsKey("plant_maintenance") ) {
                final Object value = values.remove("plant_maintenance");
                if( (value == null) || (!value.equals(getPlant_maintenance())) ) {
                    setPlant_maintenance(((Boolean) value));
                }
            }
            if( values.containsKey("plant_sp_matl_status") ) {
                final Object value = values.remove("plant_sp_matl_status");
                if( (value == null) || (!value.equals(getPlant_sp_matl_status())) ) {
                    setPlant_sp_matl_status(((String) value));
                }
            }
            if( values.containsKey("plt_sp_status_valid_from") ) {
                final Object value = values.remove("plt_sp_status_valid_from");
                if( (value == null) || (!value.equals(getPlt_sp_status_valid_from())) ) {
                    setPlt_sp_status_valid_from(((LocalDateTime) value));
                }
            }
            if( values.containsKey("price_control") ) {
                final Object value = values.remove("price_control");
                if( (value == null) || (!value.equals(getPrice_control())) ) {
                    setPrice_control(((String) value));
                }
            }
            if( values.containsKey("price_unit") ) {
                final Object value = values.remove("price_unit");
                if( (value == null) || (!value.equals(getPrice_unit())) ) {
                    setPrice_unit(((BigDecimal) value));
                }
            }
            if( values.containsKey("priority") ) {
                final Object value = values.remove("priority");
                if( (value == null) || (!value.equals(getPriority())) ) {
                    setPriority(((String) value));
                }
            }
            if( values.containsKey("procured_externally") ) {
                final Object value = values.remove("procured_externally");
                if( (value == null) || (!value.equals(getProcured_externally())) ) {
                    setProcured_externally(((Boolean) value));
                }
            }
            if( values.containsKey("prodn_supply_area") ) {
                final Object value = values.remove("prodn_supply_area");
                if( (value == null) || (!value.equals(getProdn_supply_area())) ) {
                    setProdn_supply_area(((String) value));
                }
            }
            if( values.containsKey("production_relevant") ) {
                final Object value = values.remove("production_relevant");
                if( (value == null) || (!value.equals(getProduction_relevant())) ) {
                    setProduction_relevant(((Boolean) value));
                }
            }
            if( values.containsKey("production_version") ) {
                final Object value = values.remove("production_version");
                if( (value == null) || (!value.equals(getProduction_version())) ) {
                    setProduction_version(((String) value));
                }
            }
            if( values.containsKey("prod_order_issue_location") ) {
                final Object value = values.remove("prod_order_issue_location");
                if( (value == null) || (!value.equals(getProd_order_issue_location())) ) {
                    setProd_order_issue_location(((String) value));
                }
            }
            if( values.containsKey("profit_center") ) {
                final Object value = values.remove("profit_center");
                if( (value == null) || (!value.equals(getProfit_center())) ) {
                    setProfit_center(((String) value));
                }
            }
            if( values.containsKey("purchasing_group") ) {
                final Object value = values.remove("purchasing_group");
                if( (value == null) || (!value.equals(getPurchasing_group())) ) {
                    setPurchasing_group(((String) value));
                }
            }
            if( values.containsKey("purchasing_organisation") ) {
                final Object value = values.remove("purchasing_organisation");
                if( (value == null) || (!value.equals(getPurchasing_organisation())) ) {
                    setPurchasing_organisation(((String) value));
                }
            }
            if( values.containsKey("qty_var_size_item") ) {
                final Object value = values.remove("qty_var_size_item");
                if( (value == null) || (!value.equals(getQty_var_size_item())) ) {
                    setQty_var_size_item(((BigDecimal) value));
                }
            }
            if( values.containsKey("record_creation_date") ) {
                final Object value = values.remove("record_creation_date");
                if( (value == null) || (!value.equals(getRecord_creation_date())) ) {
                    setRecord_creation_date(((LocalDateTime) value));
                }
            }
            if( values.containsKey("recurisve") ) {
                final Object value = values.remove("recurisve");
                if( (value == null) || (!value.equals(getRecurisve())) ) {
                    setRecurisve(((Boolean) value));
                }
            }
            if( values.containsKey("recurs_allowed") ) {
                final Object value = values.remove("recurs_allowed");
                if( (value == null) || (!value.equals(getRecurs_allowed())) ) {
                    setRecurs_allowed(((Boolean) value));
                }
            }
            if( values.containsKey("reference_point") ) {
                final Object value = values.remove("reference_point");
                if( (value == null) || (!value.equals(getReference_point())) ) {
                    setReference_point(((String) value));
                }
            }
            if( values.containsKey("relevancy_to_costing") ) {
                final Object value = values.remove("relevancy_to_costing");
                if( (value == null) || (!value.equals(getRelevancy_to_costing())) ) {
                    setRelevancy_to_costing(((String) value));
                }
            }
            if( values.containsKey("relevant_to_sales") ) {
                final Object value = values.remove("relevant_to_sales");
                if( (value == null) || (!value.equals(getRelevant_to_sales())) ) {
                    setRelevant_to_sales(((String) value));
                }
            }
            if( values.containsKey("required_component") ) {
                final Object value = values.remove("required_component");
                if( (value == null) || (!value.equals(getRequired_component())) ) {
                    setRequired_component(((Boolean) value));
                }
            }
            if( values.containsKey("requirement_segment") ) {
                final Object value = values.remove("requirement_segment");
                if( (value == null) || (!value.equals(getRequirement_segment())) ) {
                    setRequirement_segment(((String) value));
                }
            }
            if( values.containsKey("revision_level") ) {
                final Object value = values.remove("revision_level");
                if( (value == null) || (!value.equals(getRevision_level())) ) {
                    setRevision_level(((String) value));
                }
            }
            if( values.containsKey("scrap_qty_bun") ) {
                final Object value = values.remove("scrap_qty_bun");
                if( (value == null) || (!value.equals(getScrap_qty_bun())) ) {
                    setScrap_qty_bun(((BigDecimal) value));
                }
            }
            if( values.containsKey("serial_no_profile") ) {
                final Object value = values.remove("serial_no_profile");
                if( (value == null) || (!value.equals(getSerial_no_profile())) ) {
                    setSerial_no_profile(((String) value));
                }
            }
            if( values.containsKey("size1") ) {
                final Object value = values.remove("size1");
                if( (value == null) || (!value.equals(getSize1())) ) {
                    setSize1(((BigDecimal) value));
                }
            }
            if( values.containsKey("size2") ) {
                final Object value = values.remove("size2");
                if( (value == null) || (!value.equals(getSize2())) ) {
                    setSize2(((BigDecimal) value));
                }
            }
            if( values.containsKey("size3") ) {
                final Object value = values.remove("size3");
                if( (value == null) || (!value.equals(getSize3())) ) {
                    setSize3(((BigDecimal) value));
                }
            }
            if( values.containsKey("size_unit") ) {
                final Object value = values.remove("size_unit");
                if( (value == null) || (!value.equals(getSize_unit())) ) {
                    setSize_unit(((String) value));
                }
            }
            if( values.containsKey("sort_string") ) {
                final Object value = values.remove("sort_string");
                if( (value == null) || (!value.equals(getSort_string())) ) {
                    setSort_string(((String) value));
                }
            }
            if( values.containsKey("special_procurement_type") ) {
                final Object value = values.remove("special_procurement_type");
                if( (value == null) || (!value.equals(getSpecial_procurement_type())) ) {
                    setSpecial_procurement_type(((String) value));
                }
            }
            if( values.containsKey("special_proc_typ_itm") ) {
                final Object value = values.remove("special_proc_typ_itm");
                if( (value == null) || (!value.equals(getSpecial_proc_typ_itm())) ) {
                    setSpecial_proc_typ_itm(((String) value));
                }
            }
            if( values.containsKey("special_proc_typ_mastr") ) {
                final Object value = values.remove("special_proc_typ_mastr");
                if( (value == null) || (!value.equals(getSpecial_proc_typ_mastr())) ) {
                    setSpecial_proc_typ_mastr(((String) value));
                }
            }
            if( values.containsKey("spec_proc_costing") ) {
                final Object value = values.remove("spec_proc_costing");
                if( (value == null) || (!value.equals(getSpec_proc_costing())) ) {
                    setSpec_proc_costing(((String) value));
                }
            }
            if( values.containsKey("standard_price") ) {
                final Object value = values.remove("standard_price");
                if( (value == null) || (!value.equals(getStandard_price())) ) {
                    setStandard_price(((BigDecimal) value));
                }
            }
            if( values.containsKey("status_text") ) {
                final Object value = values.remove("status_text");
                if( (value == null) || (!value.equals(getStatus_text())) ) {
                    setStatus_text(((String) value));
                }
            }
            if( values.containsKey("stock_segment") ) {
                final Object value = values.remove("stock_segment");
                if( (value == null) || (!value.equals(getStock_segment())) ) {
                    setStock_segment(((String) value));
                }
            }
            if( values.containsKey("storage_location") ) {
                final Object value = values.remove("storage_location");
                if( (value == null) || (!value.equals(getStorage_location())) ) {
                    setStorage_location(((String) value));
                }
            }
            if( values.containsKey("strategy") ) {
                final Object value = values.remove("strategy");
                if( (value == null) || (!value.equals(getStrategy())) ) {
                    setStrategy(((String) value));
                }
            }
            if( values.containsKey("sub_item_indicator") ) {
                final Object value = values.remove("sub_item_indicator");
                if( (value == null) || (!value.equals(getSub_item_indicator())) ) {
                    setSub_item_indicator(((Boolean) value));
                }
            }
            if( values.containsKey("supplier") ) {
                final Object value = values.remove("supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("table_row") ) {
                final Object value = values.remove("table_row");
                if( (value == null) || (!value.equals(getTable_row())) ) {
                    setTable_row(((Integer) value));
                }
            }
            if( values.containsKey("tech_status_from") ) {
                final Object value = values.remove("tech_status_from");
                if( (value == null) || (!value.equals(getTech_status_from())) ) {
                    setTech_status_from(((String) value));
                }
            }
            if( values.containsKey("test_hist_nxt_lvl") ) {
                final Object value = values.remove("test_hist_nxt_lvl");
                if( (value == null) || (!value.equals(getTest_hist_nxt_lvl())) ) {
                    setTest_hist_nxt_lvl(((Boolean) value));
                }
            }
            if( values.containsKey("totals_record_id") ) {
                final Object value = values.remove("totals_record_id");
                if( (value == null) || (!value.equals(getTotals_record_id())) ) {
                    setTotals_record_id(((String) value));
                }
            }
            if( values.containsKey("unit_of_measure") ) {
                final Object value = values.remove("unit_of_measure");
                if( (value == null) || (!value.equals(getUnit_of_measure())) ) {
                    setUnit_of_measure(((String) value));
                }
            }
            if( values.containsKey("unloading_point") ) {
                final Object value = values.remove("unloading_point");
                if( (value == null) || (!value.equals(getUnloading_point())) ) {
                    setUnloading_point(((String) value));
                }
            }
            if( values.containsKey("uom_usage") ) {
                final Object value = values.remove("uom_usage");
                if( (value == null) || (!value.equals(getUom_usage())) ) {
                    setUom_usage(((String) value));
                }
            }
            if( values.containsKey("usage_probability") ) {
                final Object value = values.remove("usage_probability");
                if( (value == null) || (!value.equals(getUsage_probability())) ) {
                    setUsage_probability(((BigDecimal) value));
                }
            }
            if( values.containsKey("validity_end_date") ) {
                final Object value = values.remove("validity_end_date");
                if( (value == null) || (!value.equals(getValidity_end_date())) ) {
                    setValidity_end_date(((LocalDateTime) value));
                }
            }
            if( values.containsKey("validity_start_date") ) {
                final Object value = values.remove("validity_start_date");
                if( (value == null) || (!value.equals(getValidity_start_date())) ) {
                    setValidity_start_date(((LocalDateTime) value));
                }
            }
            if( values.containsKey("valuation_category") ) {
                final Object value = values.remove("valuation_category");
                if( (value == null) || (!value.equals(getValuation_category())) ) {
                    setValuation_category(((String) value));
                }
            }
            if( values.containsKey("variants_nxt_lvl") ) {
                final Object value = values.remove("variants_nxt_lvl");
                if( (value == null) || (!value.equals(getVariants_nxt_lvl())) ) {
                    setVariants_nxt_lvl(((Boolean) value));
                }
            }
            if( values.containsKey("x_plant_material_status") ) {
                final Object value = values.remove("x_plant_material_status");
                if( (value == null) || (!value.equals(getX_plant_material_status())) ) {
                    setX_plant_material_status(((String) value));
                }
            }
            if( values.containsKey("x_plt_status_valid_from") ) {
                final Object value = values.remove("x_plt_status_valid_from");
                if( (value == null) || (!value.equals(getX_plt_status_valid_from())) ) {
                    setX_plt_status_valid_from(((LocalDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        return result;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>alternative_item</b>
     * </p>
     *
     * @param alternative_item
     *            Alternative item
     */
    public void setAlternative_item( @Nullable final Boolean alternative_item )
    {
        rememberChangedField("alternative_item", this.alternative_item);
        this.alternative_item = alternative_item;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>alt_item_group</b>
     * </p>
     *
     * @param alt_item_group
     *            AltItemGroup
     */
    public void setAlt_item_group( @Nullable final String alt_item_group )
    {
        rememberChangedField("alt_item_group", this.alt_item_group);
        this.alt_item_group = alt_item_group;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>alt_nxt_lvl</b>
     * </p>
     *
     * @param alt_nxt_lvl
     *            Altrntvs (Nxt Level)
     */
    public void setAlt_nxt_lvl( @Nullable final Boolean alt_nxt_lvl )
    {
        rememberChangedField("alt_nxt_lvl", this.alt_nxt_lvl);
        this.alt_nxt_lvl = alt_nxt_lvl;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>assembly_indicator</b>
     * </p>
     *
     * @param assembly_indicator
     *            PM assembly
     */
    public void setAssembly_indicator( @Nullable final Boolean assembly_indicator )
    {
        rememberChangedField("assembly_indicator", this.assembly_indicator);
        this.assembly_indicator = assembly_indicator;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>assign_effect_vals</b>
     * </p>
     *
     * @param assign_effect_vals
     *            Assign effect. vals
     */
    public void setAssign_effect_vals( @Nullable final Boolean assign_effect_vals )
    {
        rememberChangedField("assign_effect_vals", this.assign_effect_vals);
        this.assign_effect_vals = assign_effect_vals;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property from the Odata EDM: <b>assy_scrap_itm_mat</b>
     * </p>
     *
     * @param assy_scrap_itm_mat
     *            AssyScrap (ItemMat)
     */
    public void setAssy_scrap_itm_mat( @Nullable final BigDecimal assy_scrap_itm_mat )
    {
        rememberChangedField("assy_scrap_itm_mat", this.assy_scrap_itm_mat);
        this.assy_scrap_itm_mat = assy_scrap_itm_mat;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>as_selection_cond</b>
     * </p>
     *
     * @param as_selection_cond
     *            as selection cond.
     */
    public void setAs_selection_cond( @Nullable final Boolean as_selection_cond )
    {
        rememberChangedField("as_selection_cond", this.as_selection_cond);
        this.as_selection_cond = as_selection_cond;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>base_qty_nxt_lvl</b>
     * </p>
     *
     * @param base_qty_nxt_lvl
     *            BasQty (Next Level)
     */
    public void setBase_qty_nxt_lvl( @Nullable final BigDecimal base_qty_nxt_lvl )
    {
        rememberChangedField("base_qty_nxt_lvl", this.base_qty_nxt_lvl);
        this.base_qty_nxt_lvl = base_qty_nxt_lvl;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>base_unit_nxt_lvl</b>
     * </p>
     *
     * @param base_unit_nxt_lvl
     *            BasUnit (Next Level)
     */
    public void setBase_unit_nxt_lvl( @Nullable final String base_unit_nxt_lvl )
    {
        rememberChangedField("base_unit_nxt_lvl", this.base_unit_nxt_lvl);
        this.base_unit_nxt_lvl = base_unit_nxt_lvl;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>base_uom</b>
     * </p>
     *
     * @param base_uom
     *            Base Unit of Measure
     */
    public void setBase_uom( @Nullable final String base_uom )
    {
        rememberChangedField("base_uom", this.base_uom);
        this.base_uom = base_uom;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>batch_entry</b>
     * </p>
     *
     * @param batch_entry
     *            Batch entry
     */
    public void setBatch_entry( @Nullable final String batch_entry )
    {
        rememberChangedField("batch_entry", this.batch_entry);
        this.batch_entry = batch_entry;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>batch_mgmt</b>
     * </p>
     *
     * @param batch_mgmt
     *            Batch Management
     */
    public void setBatch_mgmt( @Nullable final Boolean batch_mgmt )
    {
        rememberChangedField("batch_mgmt", this.batch_mgmt);
        this.batch_mgmt = batch_mgmt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property from the Odata EDM: <b>bill_of_material</b>
     * </p>
     *
     * @param bill_of_material
     *            Bill of Material
     */
    public void setBill_of_material( @Nullable final String bill_of_material )
    {
        rememberChangedField("bill_of_material", this.bill_of_material);
        this.bill_of_material = bill_of_material;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>bill_of_material_base_quant</b>
     * </p>
     *
     * @param bill_of_material_base_quant
     *            Comp. Qty (BUn)
     */
    public void setBill_of_material_base_quant( @Nullable final BigDecimal bill_of_material_base_quant )
    {
        rememberChangedField("bill_of_material_base_quant", this.bill_of_material_base_quant);
        this.bill_of_material_base_quant = bill_of_material_base_quant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>bill_of_material_component</b>
     * </p>
     *
     * @param bill_of_material_component
     *            Component
     */
    public void setBill_of_material_component( @Nullable final String bill_of_material_component )
    {
        rememberChangedField("bill_of_material_component", this.bill_of_material_component);
        this.bill_of_material_component = bill_of_material_component;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>bill_of_material_comp_quant</b>
     * </p>
     *
     * @param bill_of_material_comp_quant
     *            Comp. Qty (CUn)
     */
    public void setBill_of_material_comp_quant( @Nullable final BigDecimal bill_of_material_comp_quant )
    {
        rememberChangedField("bill_of_material_comp_quant", this.bill_of_material_comp_quant);
        this.bill_of_material_comp_quant = bill_of_material_comp_quant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>bill_of_material_item_category</b>
     * </p>
     *
     * @param bill_of_material_item_category
     *            Item Category
     */
    public void setBill_of_material_item_category( @Nullable final String bill_of_material_item_category )
    {
        rememberChangedField("bill_of_material_item_category", this.bill_of_material_item_category);
        this.bill_of_material_item_category = bill_of_material_item_category;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>bill_of_material_item_number</b>
     * </p>
     *
     * @param bill_of_material_item_number
     *            Item Number
     */
    public void setBill_of_material_item_number( @Nullable final String bill_of_material_item_number )
    {
        rememberChangedField("bill_of_material_item_number", this.bill_of_material_item_number);
        this.bill_of_material_item_number = bill_of_material_item_number;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>bill_of_material_item_quantity</b>
     * </p>
     *
     * @param bill_of_material_item_quantity
     *            Component Quantity
     */
    public void setBill_of_material_item_quantity( @Nullable final BigDecimal bill_of_material_item_quantity )
    {
        rememberChangedField("bill_of_material_item_quantity", this.bill_of_material_item_quantity);
        this.bill_of_material_item_quantity = bill_of_material_item_quantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>bill_of_material_item_unit</b>
     * </p>
     *
     * @param bill_of_material_item_unit
     *            Base Unit of Measure
     */
    public void setBill_of_material_item_unit( @Nullable final String bill_of_material_item_unit )
    {
        rememberChangedField("bill_of_material_item_unit", this.bill_of_material_item_unit);
        this.bill_of_material_item_unit = bill_of_material_item_unit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property from the Odata EDM: <b>Bill_Of_Material_Root</b>
     * </p>
     *
     * @param bill_Of_Material_Root
     *            Bill of Material
     */
    public void setBill_Of_Material_Root( @Nullable final String bill_Of_Material_Root )
    {
        rememberChangedField("Bill_Of_Material_Root", this.bill_Of_Material_Root);
        this.bill_Of_Material_Root = bill_Of_Material_Root;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>bill_of_material_root_variant</b>
     * </p>
     *
     * @param bill_of_material_root_variant
     *            Alternative BOM
     */
    public void setBill_of_material_root_variant( @Nullable final String bill_of_material_root_variant )
    {
        rememberChangedField("bill_of_material_root_variant", this.bill_of_material_root_variant);
        this.bill_of_material_root_variant = bill_of_material_root_variant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>bill_of_material_variant</b>
     * </p>
     *
     * @param bill_of_material_variant
     *            Alternative BOM
     */
    public void setBill_of_material_variant( @Nullable final String bill_of_material_variant )
    {
        rememberChangedField("bill_of_material_variant", this.bill_of_material_variant);
        this.bill_of_material_variant = bill_of_material_variant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>bill_of_material_variant_usage</b>
     * </p>
     *
     * @param bill_of_material_variant_usage
     *            BOM usage
     */
    public void setBill_of_material_variant_usage( @Nullable final String bill_of_material_variant_usage )
    {
        rememberChangedField("bill_of_material_variant_usage", this.bill_of_material_variant_usage);
        this.bill_of_material_variant_usage = bill_of_material_variant_usage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property from the Odata EDM: <b>bom_change_number</b>
     * </p>
     *
     * @param bom_change_number
     *            Change Number
     */
    public void setBom_change_number( @Nullable final String bom_change_number )
    {
        rememberChangedField("bom_change_number", this.bom_change_number);
        this.bom_change_number = bom_change_number;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>bulk_material</b>
     * </p>
     *
     * @param bulk_material
     *            Bulk Material
     */
    public void setBulk_material( @Nullable final Boolean bulk_material )
    {
        rememberChangedField("bulk_material", this.bulk_material);
        this.bulk_material = bulk_material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>b_o_m_alternative_text</b>
     * </p>
     *
     * @param b_o_m_alternative_text
     *            Alternative Text
     */
    public void setB_o_m_alternative_text( @Nullable final String b_o_m_alternative_text )
    {
        rememberChangedField("b_o_m_alternative_text", this.b_o_m_alternative_text);
        this.b_o_m_alternative_text = b_o_m_alternative_text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>b_o_m_alt_nxt_lvl</b>
     * </p>
     *
     * @param b_o_m_alt_nxt_lvl
     *            BOM Alt (Next Level)
     */
    public void setB_o_m_alt_nxt_lvl( @Nullable final String b_o_m_alt_nxt_lvl )
    {
        rememberChangedField("b_o_m_alt_nxt_lvl", this.b_o_m_alt_nxt_lvl);
        this.b_o_m_alt_nxt_lvl = b_o_m_alt_nxt_lvl;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>b_o_m_category</b>
     * </p>
     *
     * @param b_o_m_category
     *            BOM category
     */
    public void setB_o_m_category( @Nullable final String b_o_m_category )
    {
        rememberChangedField("b_o_m_category", this.b_o_m_category);
        this.b_o_m_category = b_o_m_category;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>b_o_m_cat_nxt_lvl</b>
     * </p>
     *
     * @param b_o_m_cat_nxt_lvl
     *            BOM Cat (Next Level)
     */
    public void setB_o_m_cat_nxt_lvl( @Nullable final String b_o_m_cat_nxt_lvl )
    {
        rememberChangedField("b_o_m_cat_nxt_lvl", this.b_o_m_cat_nxt_lvl);
        this.b_o_m_cat_nxt_lvl = b_o_m_cat_nxt_lvl;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>b_o_m_component_description</b>
     * </p>
     *
     * @param b_o_m_component_description
     *            Object description
     */
    public void setB_o_m_component_description( @Nullable final String b_o_m_component_description )
    {
        rememberChangedField("b_o_m_component_description", this.b_o_m_component_description);
        this.b_o_m_component_description = b_o_m_component_description;
    }

    /**
     * Constraints: Not nullable, Precision: 2, Scale: 0
     * <p>
     * Original property from the Odata EDM: <b>b_o_m_explosion_level</b>
     * </p>
     *
     * @param b_o_m_explosion_level
     *            Level
     */
    public void setB_o_m_explosion_level( @Nullable final BigDecimal b_o_m_explosion_level )
    {
        rememberChangedField("b_o_m_explosion_level", this.b_o_m_explosion_level);
        this.b_o_m_explosion_level = b_o_m_explosion_level;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>b_o_m_hdr_matl_hier_node</b>
     * </p>
     *
     * @param b_o_m_hdr_matl_hier_node
     *            Material
     */
    public void setB_o_m_hdr_matl_hier_node( @Nullable final String b_o_m_hdr_matl_hier_node )
    {
        rememberChangedField("b_o_m_hdr_matl_hier_node", this.b_o_m_hdr_matl_hier_node);
        this.b_o_m_hdr_matl_hier_node = b_o_m_hdr_matl_hier_node;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>B_O_M_Hdr_Root_Matl_Hier_Node</b>
     * </p>
     *
     * @param b_O_M_Hdr_Root_Matl_Hier_Node
     *            Material
     */
    public void setB_O_M_Hdr_Root_Matl_Hier_Node( @Nullable final String b_O_M_Hdr_Root_Matl_Hier_Node )
    {
        rememberChangedField("B_O_M_Hdr_Root_Matl_Hier_Node", this.b_O_M_Hdr_Root_Matl_Hier_Node);
        this.b_O_M_Hdr_Root_Matl_Hier_Node = b_O_M_Hdr_Root_Matl_Hier_Node;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>b_o_m_header_base_unit</b>
     * </p>
     *
     * @param b_o_m_header_base_unit
     *            Base Unit of Measure
     */
    public void setB_o_m_header_base_unit( @Nullable final String b_o_m_header_base_unit )
    {
        rememberChangedField("b_o_m_header_base_unit", this.b_o_m_header_base_unit);
        this.b_o_m_header_base_unit = b_o_m_header_base_unit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>b_o_m_header_quantity_primary</b>
     * </p>
     *
     * @param b_o_m_header_quantity_primary
     *            Base quantity
     */
    public void setB_o_m_header_quantity_primary( @Nullable final BigDecimal b_o_m_header_quantity_primary )
    {
        rememberChangedField("b_o_m_header_quantity_primary", this.b_o_m_header_quantity_primary);
        this.b_o_m_header_quantity_primary = b_o_m_header_quantity_primary;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>b_o_m_item_description</b>
     * </p>
     *
     * @param b_o_m_item_description
     *            Item Text
     */
    public void setB_o_m_item_description( @Nullable final String b_o_m_item_description )
    {
        rememberChangedField("b_o_m_item_description", this.b_o_m_item_description);
        this.b_o_m_item_description = b_o_m_item_description;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>b_o_m_item_is_discontinued</b>
     * </p>
     *
     * @param b_o_m_item_is_discontinued
     *            Discontinuation ind.
     */
    public void setB_o_m_item_is_discontinued( @Nullable final String b_o_m_item_is_discontinued )
    {
        rememberChangedField("b_o_m_item_is_discontinued", this.b_o_m_item_is_discontinued);
        this.b_o_m_item_is_discontinued = b_o_m_item_is_discontinued;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property from the Odata EDM: <b>b_o_m_no_nxt_lvl</b>
     * </p>
     *
     * @param b_o_m_no_nxt_lvl
     *            BOM No. (Next Level)
     */
    public void setB_o_m_no_nxt_lvl( @Nullable final String b_o_m_no_nxt_lvl )
    {
        rememberChangedField("b_o_m_no_nxt_lvl", this.b_o_m_no_nxt_lvl);
        this.b_o_m_no_nxt_lvl = b_o_m_no_nxt_lvl;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>b_o_m_usage_nxt_lvl</b>
     * </p>
     *
     * @param b_o_m_usage_nxt_lvl
     *            BOM Usage (Next Lvl)
     */
    public void setB_o_m_usage_nxt_lvl( @Nullable final String b_o_m_usage_nxt_lvl )
    {
        rememberChangedField("b_o_m_usage_nxt_lvl", this.b_o_m_usage_nxt_lvl);
        this.b_o_m_usage_nxt_lvl = b_o_m_usage_nxt_lvl;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>b_o_m_version</b>
     * </p>
     *
     * @param b_o_m_version
     *            BOM Version
     */
    public void setB_o_m_version( @Nullable final String b_o_m_version )
    {
        rememberChangedField("b_o_m_version", this.b_o_m_version);
        this.b_o_m_version = b_o_m_version;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>b_o_m_version_status</b>
     * </p>
     *
     * @param b_o_m_version_status
     *            BOM Version Status
     */
    public void setB_o_m_version_status( @Nullable final String b_o_m_version_status )
    {
        rememberChangedField("b_o_m_version_status", this.b_o_m_version_status);
        this.b_o_m_version_status = b_o_m_version_status;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property from the Odata EDM: <b>b_o_m_vers_status_description</b>
     * </p>
     *
     * @param b_o_m_vers_status_description
     *            Short text
     */
    public void setB_o_m_vers_status_description( @Nullable final String b_o_m_vers_status_description )
    {
        rememberChangedField("b_o_m_vers_status_description", this.b_o_m_vers_status_description);
        this.b_o_m_vers_status_description = b_o_m_vers_status_description;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property from the Odata EDM: <b>change_number</b>
     * </p>
     *
     * @param change_number
     *            Change Number
     */
    public void setChange_number( @Nullable final String change_number )
    {
        rememberChangedField("change_number", this.change_number);
        this.change_number = change_number;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property from the Odata EDM: <b>chg_to_eng_chg_number</b>
     * </p>
     *
     * @param chg_to_eng_chg_number
     *            Change Number To
     */
    public void setChg_to_eng_chg_number( @Nullable final String chg_to_eng_chg_number )
    {
        rememberChangedField("chg_to_eng_chg_number", this.chg_to_eng_chg_number);
        this.chg_to_eng_chg_number = chg_to_eng_chg_number;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property from the Odata EDM: <b>class</b>
     * </p>
     *
     * @param classProperty
     *            Class
     */
    public void setClassProperty( @Nullable final String classProperty )
    {
        rememberChangedField("class", this.classProperty);
        this.classProperty = classProperty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property from the Odata EDM: <b>classification</b>
     * </p>
     *
     * @param classification
     *            Classification
     */
    public void setClassification( @Nullable final String classification )
    {
        rememberChangedField("classification", this.classification);
        this.classification = classification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>class_type</b>
     * </p>
     *
     * @param class_type
     *            Class Type
     */
    public void setClass_type( @Nullable final String class_type )
    {
        rememberChangedField("class_type", this.class_type);
        this.class_type = class_type;
    }

    /**
     * Constraints: Not nullable, Maximum length: 17
     * <p>
     * Original property from the Odata EDM: <b>commodity_code</b>
     * </p>
     *
     * @param commodity_code
     *            Commodity Code
     */
    public void setCommodity_code( @Nullable final String commodity_code )
    {
        rememberChangedField("commodity_code", this.commodity_code);
        this.commodity_code = commodity_code;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property from the Odata EDM: <b>comp_maint_status</b>
     * </p>
     *
     * @param comp_maint_status
     *            Compl. maint. status
     */
    public void setComp_maint_status( @Nullable final String comp_maint_status )
    {
        rememberChangedField("comp_maint_status", this.comp_maint_status);
        this.comp_maint_status = comp_maint_status;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property from the Odata EDM: <b>comp_scrap_itm</b>
     * </p>
     *
     * @param comp_scrap_itm
     *            CmpScrap (Item)
     */
    public void setComp_scrap_itm( @Nullable final BigDecimal comp_scrap_itm )
    {
        rememberChangedField("comp_scrap_itm", this.comp_scrap_itm);
        this.comp_scrap_itm = comp_scrap_itm;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property from the Odata EDM: <b>comp_scrap_itm_mat</b>
     * </p>
     *
     * @param comp_scrap_itm_mat
     *            Comp.Scrap (ItemMat)
     */
    public void setComp_scrap_itm_mat( @Nullable final BigDecimal comp_scrap_itm_mat )
    {
        rememberChangedField("comp_scrap_itm_mat", this.comp_scrap_itm_mat);
        this.comp_scrap_itm_mat = comp_scrap_itm_mat;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property from the Odata EDM: <b>config_mat_var</b>
     * </p>
     *
     * @param config_mat_var
     *            Config. (MatVar)
     */
    public void setConfig_mat_var( @Nullable final String config_mat_var )
    {
        rememberChangedField("config_mat_var", this.config_mat_var);
        this.config_mat_var = config_mat_var;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>config_multi_level</b>
     * </p>
     *
     * @param config_multi_level
     *            Configd multi
     */
    public void setConfig_multi_level( @Nullable final Boolean config_multi_level )
    {
        rememberChangedField("config_multi_level", this.config_multi_level);
        this.config_multi_level = config_multi_level;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>conf_bom_nxt_lvl</b>
     * </p>
     *
     * @param conf_bom_nxt_lvl
     *            Conf BOM (Nxt Level)
     */
    public void setConf_bom_nxt_lvl( @Nullable final Boolean conf_bom_nxt_lvl )
    {
        rememberChangedField("conf_bom_nxt_lvl", this.conf_bom_nxt_lvl);
        this.conf_bom_nxt_lvl = conf_bom_nxt_lvl;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>cost_element</b>
     * </p>
     *
     * @param cost_element
     *            Cost element
     */
    public void setCost_element( @Nullable final String cost_element )
    {
        rememberChangedField("cost_element", this.cost_element);
        this.cost_element = cost_element;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property from the Odata EDM: <b>counter</b>
     * </p>
     *
     * @param counter
     *            Counter
     */
    public void setCounter( @Nullable final String counter )
    {
        rememberChangedField("counter", this.counter);
        this.counter = counter;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>co_product</b>
     * </p>
     *
     * @param co_product
     *            Co-product
     */
    public void setCo_product( @Nullable final Boolean co_product )
    {
        rememberChangedField("co_product", this.co_product);
        this.co_product = co_product;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property from the Odata EDM: <b>created_by_user</b>
     * </p>
     *
     * @param created_by_user
     *            Created By
     */
    public void setCreated_by_user( @Nullable final String created_by_user )
    {
        rememberChangedField("created_by_user", this.created_by_user);
        this.created_by_user = created_by_user;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property from the Odata EDM: <b>currency</b>
     * </p>
     *
     * @param currency
     *            Currency
     */
    public void setCurrency( @Nullable final String currency )
    {
        rememberChangedField("currency", this.currency);
        this.currency = currency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>customs_preference</b>
     * </p>
     *
     * @param customs_preference
     *            Customs Preference
     */
    public void setCustoms_preference( @Nullable final String customs_preference )
    {
        rememberChangedField("customs_preference", this.customs_preference);
        this.customs_preference = customs_preference;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>dat_hist_nxt_lvl</b>
     * </p>
     *
     * @param dat_hist_nxt_lvl
     *            DatHist (Next Level)
     */
    public void setDat_hist_nxt_lvl( @Nullable final Boolean dat_hist_nxt_lvl )
    {
        rememberChangedField("dat_hist_nxt_lvl", this.dat_hist_nxt_lvl);
        this.dat_hist_nxt_lvl = dat_hist_nxt_lvl;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>deletion_indicator</b>
     * </p>
     *
     * @param deletion_indicator
     *            Dln Indicator(Head)
     */
    public void setDeletion_indicator( @Nullable final Boolean deletion_indicator )
    {
        rememberChangedField("deletion_indicator", this.deletion_indicator);
        this.deletion_indicator = deletion_indicator;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property from the Odata EDM: <b>delivery_time_in_days</b>
     * </p>
     *
     * @param delivery_time_in_days
     *            Delivery time (days)
     */
    public void setDelivery_time_in_days( @Nullable final BigDecimal delivery_time_in_days )
    {
        rememberChangedField("delivery_time_in_days", this.delivery_time_in_days);
        this.delivery_time_in_days = delivery_time_in_days;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>del_Ind_nxt_lvl</b>
     * </p>
     *
     * @param del_Ind_nxt_lvl
     *            DlInd (Next Level)
     */
    public void setDel_Ind_nxt_lvl( @Nullable final Boolean del_Ind_nxt_lvl )
    {
        rememberChangedField("del_Ind_nxt_lvl", this.del_Ind_nxt_lvl);
        this.del_Ind_nxt_lvl = del_Ind_nxt_lvl;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property from the Odata EDM: <b>denominator</b>
     * </p>
     *
     * @param denominator
     *            Denominator
     */
    public void setDenominator( @Nullable final BigDecimal denominator )
    {
        rememberChangedField("denominator", this.denominator);
        this.denominator = denominator;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>discont_group</b>
     * </p>
     *
     * @param discont_group
     *            Discont. group
     */
    public void setDiscont_group( @Nullable final String discont_group )
    {
        rememberChangedField("discont_group", this.discont_group);
        this.discont_group = discont_group;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>distribution_key</b>
     * </p>
     *
     * @param distribution_key
     *            Distribution key
     */
    public void setDistribution_key( @Nullable final String distribution_key )
    {
        rememberChangedField("distribution_key", this.distribution_key);
        this.distribution_key = distribution_key;
    }

    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property from the Odata EDM: <b>doc</b>
     * </p>
     *
     * @param doc
     *            Document
     */
    public void setDoc( @Nullable final String doc )
    {
        rememberChangedField("doc", this.doc);
        this.doc = doc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>document_part</b>
     * </p>
     *
     * @param document_part
     *            Document Part
     */
    public void setDocument_part( @Nullable final String document_part )
    {
        rememberChangedField("document_part", this.document_part);
        this.document_part = document_part;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>document_type</b>
     * </p>
     *
     * @param document_type
     *            Document Type
     */
    public void setDocument_type( @Nullable final String document_type )
    {
        rememberChangedField("document_type", this.document_type);
        this.document_type = document_type;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>document_version</b>
     * </p>
     *
     * @param document_version
     *            Document Version
     */
    public void setDocument_version( @Nullable final String document_version )
    {
        rememberChangedField("document_version", this.document_version);
        this.document_version = document_version;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property from the Odata EDM: <b>doc_number</b>
     * </p>
     *
     * @param doc_number
     *            Document
     */
    public void setDoc_number( @Nullable final String doc_number )
    {
        rememberChangedField("doc_number", this.doc_number);
        this.doc_number = doc_number;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>doc_reqd</b>
     * </p>
     *
     * @param doc_reqd
     *            Documentation reqd
     */
    public void setDoc_reqd( @Nullable final Boolean doc_reqd )
    {
        rememberChangedField("doc_reqd", this.doc_reqd);
        this.doc_reqd = doc_reqd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>doc_status</b>
     * </p>
     *
     * @param doc_status
     *            Document Status
     */
    public void setDoc_status( @Nullable final String doc_status )
    {
        rememberChangedField("doc_status", this.doc_status);
        this.doc_status = doc_status;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>doc_type</b>
     * </p>
     *
     * @param doc_type
     *            Document Type
     */
    public void setDoc_type( @Nullable final String doc_type )
    {
        rememberChangedField("doc_type", this.doc_type);
        this.doc_type = doc_type;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>doc_version</b>
     * </p>
     *
     * @param doc_version
     *            Document Version
     */
    public void setDoc_version( @Nullable final String doc_version )
    {
        rememberChangedField("doc_version", this.doc_version);
        this.doc_version = doc_version;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>effective_out_date</b>
     * </p>
     *
     * @param effective_out_date
     *            Effective-Out Date
     */
    public void setEffective_out_date( @Nullable final LocalDateTime effective_out_date )
    {
        rememberChangedField("effective_out_date", this.effective_out_date);
        this.effective_out_date = effective_out_date;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>engineering_design</b>
     * </p>
     *
     * @param engineering_design
     *            Engineering/design
     */
    public void setEngineering_design( @Nullable final Boolean engineering_design )
    {
        rememberChangedField("engineering_design", this.engineering_design);
        this.engineering_design = engineering_design;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>exception_bom</b>
     * </p>
     *
     * @param exception_bom
     *            Exception
     */
    public void setException_bom( @Nullable final String exception_bom )
    {
        rememberChangedField("exception_bom", this.exception_bom);
        this.exception_bom = exception_bom;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>explosion_type</b>
     * </p>
     *
     * @param explosion_type
     *            Explosion type
     */
    public void setExplosion_type( @Nullable final String explosion_type )
    {
        rememberChangedField("explosion_type", this.explosion_type);
        this.explosion_type = explosion_type;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>fixed_price_co_prod</b>
     * </p>
     *
     * @param fixed_price_co_prod
     *            Fixed-Price Co-Prod.
     */
    public void setFixed_price_co_prod( @Nullable final Boolean fixed_price_co_prod )
    {
        rememberChangedField("fixed_price_co_prod", this.fixed_price_co_prod);
        this.fixed_price_co_prod = fixed_price_co_prod;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>fixed_quantity</b>
     * </p>
     *
     * @param fixed_quantity
     *            Fixed Quantity
     */
    public void setFixed_quantity( @Nullable final Boolean fixed_quantity )
    {
        rememberChangedField("fixed_quantity", this.fixed_quantity);
        this.fixed_quantity = fixed_quantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>follow_up_grp</b>
     * </p>
     *
     * @param follow_up_grp
     *            Follow-up group
     */
    public void setFollow_up_grp( @Nullable final String follow_up_grp )
    {
        rememberChangedField("follow_up_grp", this.follow_up_grp);
        this.follow_up_grp = follow_up_grp;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>follow_up_item</b>
     * </p>
     *
     * @param follow_up_item
     *            Follow-Up Item
     */
    public void setFollow_up_item( @Nullable final Boolean follow_up_item )
    {
        rememberChangedField("follow_up_item", this.follow_up_item);
        this.follow_up_item = follow_up_item;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>follow_up_product</b>
     * </p>
     *
     * @param follow_up_product
     *            Follow-Up Material
     */
    public void setFollow_up_product( @Nullable final String follow_up_product )
    {
        rememberChangedField("follow_up_product", this.follow_up_product);
        this.follow_up_product = follow_up_product;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>formula_key</b>
     * </p>
     *
     * @param formula_key
     *            VSI Formula
     */
    public void setFormula_key( @Nullable final String formula_key )
    {
        rememberChangedField("formula_key", this.formula_key);
        this.formula_key = formula_key;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property from the Odata EDM: <b>goods_receipt_duration_in_days</b>
     * </p>
     *
     * @param goods_receipt_duration_in_days
     *            GR processing time
     */
    public void setGoods_receipt_duration_in_days( @Nullable final BigDecimal goods_receipt_duration_in_days )
    {
        rememberChangedField("goods_receipt_duration_in_days", this.goods_receipt_duration_in_days);
        this.goods_receipt_duration_in_days = goods_receipt_duration_in_days;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property from the Odata EDM: <b>goods_recipient</b>
     * </p>
     *
     * @param goods_recipient
     *            Goods Recipient
     */
    public void setGoods_recipient( @Nullable final String goods_recipient )
    {
        rememberChangedField("goods_recipient", this.goods_recipient);
        this.goods_recipient = goods_recipient;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>header_record_id</b>
     * </p>
     *
     * @param header_record_id
     *            Header record ID
     */
    public void setHeader_record_id( @Nullable final String header_record_id )
    {
        rememberChangedField("header_record_id", this.header_record_id);
        this.header_record_id = header_record_id;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>header_validity_end_date</b>
     * </p>
     *
     * @param header_validity_end_date
     *            Valid to
     */
    public void setHeader_validity_end_date( @Nullable final LocalDateTime header_validity_end_date )
    {
        rememberChangedField("header_validity_end_date", this.header_validity_end_date);
        this.header_validity_end_date = header_validity_end_date;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>header_validity_start_date</b>
     * </p>
     *
     * @param header_validity_start_date
     *            Valid From
     */
    public void setHeader_validity_start_date( @Nullable final LocalDateTime header_validity_start_date )
    {
        rememberChangedField("header_validity_start_date", this.header_validity_start_date);
        this.header_validity_start_date = header_validity_start_date;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>hl_configuration</b>
     * </p>
     *
     * @param hl_configuration
     *            HL configuration
     */
    public void setHl_configuration( @Nullable final Boolean hl_configuration )
    {
        rememberChangedField("hl_configuration", this.hl_configuration);
        this.hl_configuration = hl_configuration;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>individual_coll</b>
     * </p>
     *
     * @param individual_coll
     *            Indiv./ Coll.
     */
    public void setIndividual_coll( @Nullable final String individual_coll )
    {
        rememberChangedField("individual_coll", this.individual_coll);
        this.individual_coll = individual_coll;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property from the Odata EDM: <b>internal_obj_no</b>
     * </p>
     *
     * @param internal_obj_no
     *            Internal Object No.
     */
    public void setInternal_obj_no( @Nullable final String internal_obj_no )
    {
        rememberChangedField("internal_obj_no", this.internal_obj_no);
        this.internal_obj_no = internal_obj_no;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>intra_material</b>
     * </p>
     *
     * @param intra_material
     *            Intra Material
     */
    public void setIntra_material( @Nullable final String intra_material )
    {
        rememberChangedField("intra_material", this.intra_material);
        this.intra_material = intra_material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>issuing_plant</b>
     * </p>
     *
     * @param issuing_plant
     *            Issuing Plant
     */
    public void setIssuing_plant( @Nullable final String issuing_plant )
    {
        rememberChangedField("issuing_plant", this.issuing_plant);
        this.issuing_plant = issuing_plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>is_b_o_m_item_spare_part</b>
     * </p>
     *
     * @param is_b_o_m_item_spare_part
     *            Spare Part Indicator
     */
    public void setIs_b_o_m_item_spare_part( @Nullable final String is_b_o_m_item_spare_part )
    {
        rememberChangedField("is_b_o_m_item_spare_part", this.is_b_o_m_item_spare_part);
        this.is_b_o_m_item_spare_part = is_b_o_m_item_spare_part;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>is_c_a_d</b>
     * </p>
     *
     * @param is_c_a_d
     *            CAD Indicator
     */
    public void setIs_c_a_d( @Nullable final Boolean is_c_a_d )
    {
        rememberChangedField("is_c_a_d", this.is_c_a_d);
        this.is_c_a_d = is_c_a_d;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>is_material_provision</b>
     * </p>
     *
     * @param is_material_provision
     *            Mat. Provision Ind.
     */
    public void setIs_material_provision( @Nullable final String is_material_provision )
    {
        rememberChangedField("is_material_provision", this.is_material_provision);
        this.is_material_provision = is_material_provision;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>is_phantom_item</b>
     * </p>
     *
     * @param is_phantom_item
     *            Phantom item
     */
    public void setIs_phantom_item( @Nullable final Boolean is_phantom_item )
    {
        rememberChangedField("is_phantom_item", this.is_phantom_item);
        this.is_phantom_item = is_phantom_item;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>is_software_component</b>
     * </p>
     *
     * @param is_software_component
     *            Software component
     */
    public void setIs_software_component( @Nullable final Boolean is_software_component )
    {
        rememberChangedField("is_software_component", this.is_software_component);
        this.is_software_component = is_software_component;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>item_description_line_2</b>
     * </p>
     *
     * @param item_description_line_2
     *            Item Text 2
     */
    public void setItem_description_line_2( @Nullable final String item_description_line_2 )
    {
        rememberChangedField("item_description_line_2", this.item_description_line_2);
        this.item_description_line_2 = item_description_line_2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property from the Odata EDM: <b>item_identification</b>
     * </p>
     *
     * @param item_identification
     *            Item identification
     */
    public void setItem_identification( @Nullable final String item_identification )
    {
        rememberChangedField("item_identification", this.item_identification);
        this.item_identification = item_identification;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>item_index</b>
     * </p>
     *
     * @param item_index
     *            Table Row
     */
    public void setItem_index( @Nullable final Integer item_index )
    {
        rememberChangedField("item_index", this.item_index);
        this.item_index = item_index;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property from the Odata EDM: <b>item_node</b>
     * </p>
     *
     * @param item_node
     *            Item node
     */
    public void setItem_node( @Nullable final String item_node )
    {
        rememberChangedField("item_node", this.item_node);
        this.item_node = item_node;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>item_sign</b>
     * </p>
     *
     * @param item_sign
     *            +/- sign
     */
    public void setItem_sign( @Nullable final Boolean item_sign )
    {
        rememberChangedField("item_sign", this.item_sign);
        this.item_sign = item_sign;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property from the Odata EDM: <b>last_changed_by_user</b>
     * </p>
     *
     * @param last_changed_by_user
     *            Changed By
     */
    public void setLast_changed_by_user( @Nullable final String last_changed_by_user )
    {
        rememberChangedField("last_changed_by_user", this.last_changed_by_user);
        this.last_changed_by_user = last_changed_by_user;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>last_change_date</b>
     * </p>
     *
     * @param last_change_date
     *            Changed On
     */
    public void setLast_change_date( @Nullable final LocalDateTime last_change_date )
    {
        rememberChangedField("last_change_date", this.last_change_date);
        this.last_change_date = last_change_date;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property from the Odata EDM: <b>lead_time_offset</b>
     * </p>
     *
     * @param lead_time_offset
     *            Lead-time offset
     */
    public void setLead_time_offset( @Nullable final BigDecimal lead_time_offset )
    {
        rememberChangedField("lead_time_offset", this.lead_time_offset);
        this.lead_time_offset = lead_time_offset;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>long_text_lang</b>
     * </p>
     *
     * @param long_text_lang
     *            Long Text Language
     */
    public void setLong_text_lang( @Nullable final String long_text_lang )
    {
        rememberChangedField("long_text_lang", this.long_text_lang);
        this.long_text_lang = long_text_lang;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>low_level_code</b>
     * </p>
     *
     * @param low_level_code
     *            Low-Level Code
     */
    public void setLow_level_code( @Nullable final String low_level_code )
    {
        rememberChangedField("low_level_code", this.low_level_code);
        this.low_level_code = low_level_code;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property from the Odata EDM: <b>maintenance_status</b>
     * </p>
     *
     * @param maintenance_status
     *            Maintenance status
     */
    public void setMaintenance_status( @Nullable final String maintenance_status )
    {
        rememberChangedField("maintenance_status", this.maintenance_status);
        this.maintenance_status = maintenance_status;
    }

    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>material_component_price</b>
     * </p>
     *
     * @param material_component_price
     *            Price
     */
    public void setMaterial_component_price( @Nullable final BigDecimal material_component_price )
    {
        rememberChangedField("material_component_price", this.material_component_price);
        this.material_component_price = material_component_price;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property from the Odata EDM: <b>material_group</b>
     * </p>
     *
     * @param material_group
     *            Material Group
     */
    public void setMaterial_group( @Nullable final String material_group )
    {
        rememberChangedField("material_group", this.material_group);
        this.material_group = material_group;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>material_is_configurable</b>
     * </p>
     *
     * @param material_is_configurable
     *            Configurable
     */
    public void setMaterial_is_configurable( @Nullable final Boolean material_is_configurable )
    {
        rememberChangedField("material_is_configurable", this.material_is_configurable);
        this.material_is_configurable = material_is_configurable;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>Material_Name</b>
     * </p>
     *
     * @param material_Name
     *            Material Description
     */
    public void setMaterial_Name( @Nullable final String material_Name )
    {
        rememberChangedField("Material_Name", this.material_Name);
        this.material_Name = material_Name;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>material_type</b>
     * </p>
     *
     * @param material_type
     *            Material Type
     */
    public void setMaterial_type( @Nullable final String material_type )
    {
        rememberChangedField("material_type", this.material_type);
        this.material_type = material_type;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property from the Odata EDM: <b>mat_purity_in_perc</b>
     * </p>
     *
     * @param mat_purity_in_perc
     *            Mat. purity in %
     */
    public void setMat_purity_in_perc( @Nullable final BigDecimal mat_purity_in_perc )
    {
        rememberChangedField("mat_purity_in_perc", this.mat_purity_in_perc);
        this.mat_purity_in_perc = mat_purity_in_perc;
    }

    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>moving_price</b>
     * </p>
     *
     * @param moving_price
     *            Moving price
     */
    public void setMoving_price( @Nullable final BigDecimal moving_price )
    {
        rememberChangedField("moving_price", this.moving_price);
        this.moving_price = moving_price;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>multiple_sel</b>
     * </p>
     *
     * @param multiple_sel
     *            Multiple Selection
     */
    public void setMultiple_sel( @Nullable final Boolean multiple_sel )
    {
        rememberChangedField("multiple_sel", this.multiple_sel);
        this.multiple_sel = multiple_sel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>m_r_p_type</b>
     * </p>
     *
     * @param m_r_p_type
     *            MRP Type
     */
    public void setM_r_p_type( @Nullable final String m_r_p_type )
    {
        rememberChangedField("m_r_p_type", this.m_r_p_type);
        this.m_r_p_type = m_r_p_type;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>net_scrap_indicator</b>
     * </p>
     *
     * @param net_scrap_indicator
     *            Net Scrap Indicator
     */
    public void setNet_scrap_indicator( @Nullable final Boolean net_scrap_indicator )
    {
        rememberChangedField("net_scrap_indicator", this.net_scrap_indicator);
        this.net_scrap_indicator = net_scrap_indicator;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property from the Odata EDM: <b>no_cu_instances</b>
     * </p>
     *
     * @param no_cu_instances
     *            NoCUInstances
     */
    public void setNo_cu_instances( @Nullable final String no_cu_instances )
    {
        rememberChangedField("no_cu_instances", this.no_cu_instances);
        this.no_cu_instances = no_cu_instances;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>no_of_sheets</b>
     * </p>
     *
     * @param no_of_sheets
     *            Number Of Sheets
     */
    public void setNo_of_sheets( @Nullable final String no_of_sheets )
    {
        rememberChangedField("no_of_sheets", this.no_of_sheets);
        this.no_of_sheets = no_of_sheets;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>no_var_size_items</b>
     * </p>
     *
     * @param no_var_size_items
     *            No. of VSI Required
     */
    public void setNo_var_size_items( @Nullable final BigDecimal no_var_size_items )
    {
        rememberChangedField("no_var_size_items", this.no_var_size_items);
        this.no_var_size_items = no_var_size_items;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property from the Odata EDM: <b>numerator</b>
     * </p>
     *
     * @param numerator
     *            Numerator
     */
    public void setNumerator( @Nullable final BigDecimal numerator )
    {
        rememberChangedField("numerator", this.numerator);
        this.numerator = numerator;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>object_description</b>
     * </p>
     *
     * @param object_description
     *            Object description
     */
    public void setObject_description( @Nullable final String object_description )
    {
        rememberChangedField("object_description", this.object_description);
        this.object_description = object_description;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>object_type</b>
     * </p>
     *
     * @param object_type
     *            Object Type
     */
    public void setObject_type( @Nullable final String object_type )
    {
        rememberChangedField("object_type", this.object_type);
        this.object_type = object_type;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property from the Odata EDM: <b>obj_dep_assgt_no</b>
     * </p>
     *
     * @param obj_dep_assgt_no
     *            Assignment number
     */
    public void setObj_dep_assgt_no( @Nullable final String obj_dep_assgt_no )
    {
        rememberChangedField("obj_dep_assgt_no", this.obj_dep_assgt_no);
        this.obj_dep_assgt_no = obj_dep_assgt_no;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property from the Odata EDM: <b>operation_scrap_perc</b>
     * </p>
     *
     * @param operation_scrap_perc
     *            Operation Scrap in %
     */
    public void setOperation_scrap_perc( @Nullable final BigDecimal operation_scrap_perc )
    {
        rememberChangedField("operation_scrap_perc", this.operation_scrap_perc);
        this.operation_scrap_perc = operation_scrap_perc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>oper_lto_unit</b>
     * </p>
     *
     * @param oper_lto_unit
     *            Operation LTO unit
     */
    public void setOper_lto_unit( @Nullable final String oper_lto_unit )
    {
        rememberChangedField("oper_lto_unit", this.oper_lto_unit);
        this.oper_lto_unit = oper_lto_unit;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property from the Odata EDM: <b>oper_lt_offset</b>
     * </p>
     *
     * @param oper_lt_offset
     *            Oper. LT offset
     */
    public void setOper_lt_offset( @Nullable final BigDecimal oper_lt_offset )
    {
        rememberChangedField("oper_lt_offset", this.oper_lt_offset);
        this.oper_lt_offset = oper_lt_offset;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>org_area</b>
     * </p>
     *
     * @param org_area
     *            Organizational area
     */
    public void setOrg_area( @Nullable final String org_area )
    {
        rememberChangedField("org_area", this.org_area);
        this.org_area = org_area;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>page_format</b>
     * </p>
     *
     * @param page_format
     *            Page Format
     */
    public void setPage_format( @Nullable final String page_format )
    {
        rememberChangedField("page_format", this.page_format);
        this.page_format = page_format;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>page_number</b>
     * </p>
     *
     * @param page_number
     *            Page Number
     */
    public void setPage_number( @Nullable final String page_number )
    {
        rememberChangedField("page_number", this.page_number);
        this.page_number = page_number;
    }

    /**
     * Constraints: Not nullable, Precision: 4, Scale: 0
     * <p>
     * Original property from the Odata EDM: <b>path</b>
     * </p>
     *
     * @param path
     *            Path
     */
    public void setPath( @Nullable final BigDecimal path )
    {
        rememberChangedField("path", this.path);
        this.path = path;
    }

    /**
     * Constraints: Not nullable, Precision: 4, Scale: 0
     * <p>
     * Original property from the Odata EDM: <b>path_predecessor</b>
     * </p>
     *
     * @param path_predecessor
     *            Path (Predecessor)
     */
    public void setPath_predecessor( @Nullable final BigDecimal path_predecessor )
    {
        rememberChangedField("path_predecessor", this.path_predecessor);
        this.path_predecessor = path_predecessor;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property from the Odata EDM: <b>plantName</b>
     * </p>
     *
     * @param plantName
     *            Name 1
     */
    public void setPlantName( @Nullable final String plantName )
    {
        rememberChangedField("plantName", this.plantName);
        this.plantName = plantName;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>plant_maintenance</b>
     * </p>
     *
     * @param plant_maintenance
     *            Plant maintenance
     */
    public void setPlant_maintenance( @Nullable final Boolean plant_maintenance )
    {
        rememberChangedField("plant_maintenance", this.plant_maintenance);
        this.plant_maintenance = plant_maintenance;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>plant_sp_matl_status</b>
     * </p>
     *
     * @param plant_sp_matl_status
     *            Material Status
     */
    public void setPlant_sp_matl_status( @Nullable final String plant_sp_matl_status )
    {
        rememberChangedField("plant_sp_matl_status", this.plant_sp_matl_status);
        this.plant_sp_matl_status = plant_sp_matl_status;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>plt_sp_status_valid_from</b>
     * </p>
     *
     * @param plt_sp_status_valid_from
     *            Valid From
     */
    public void setPlt_sp_status_valid_from( @Nullable final LocalDateTime plt_sp_status_valid_from )
    {
        rememberChangedField("plt_sp_status_valid_from", this.plt_sp_status_valid_from);
        this.plt_sp_status_valid_from = plt_sp_status_valid_from;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>price_control</b>
     * </p>
     *
     * @param price_control
     *            Price control
     */
    public void setPrice_control( @Nullable final String price_control )
    {
        rememberChangedField("price_control", this.price_control);
        this.price_control = price_control;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property from the Odata EDM: <b>price_unit</b>
     * </p>
     *
     * @param price_unit
     *            Price Unit (ItemMat)
     */
    public void setPrice_unit( @Nullable final BigDecimal price_unit )
    {
        rememberChangedField("price_unit", this.price_unit);
        this.price_unit = price_unit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>priority</b>
     * </p>
     *
     * @param priority
     *            Priority
     */
    public void setPriority( @Nullable final String priority )
    {
        rememberChangedField("priority", this.priority);
        this.priority = priority;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>procured_externally</b>
     * </p>
     *
     * @param procured_externally
     *            Procured externally
     */
    public void setProcured_externally( @Nullable final Boolean procured_externally )
    {
        rememberChangedField("procured_externally", this.procured_externally);
        this.procured_externally = procured_externally;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>prodn_supply_area</b>
     * </p>
     *
     * @param prodn_supply_area
     *            Prodn Supply Area
     */
    public void setProdn_supply_area( @Nullable final String prodn_supply_area )
    {
        rememberChangedField("prodn_supply_area", this.prodn_supply_area);
        this.prodn_supply_area = prodn_supply_area;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>production_relevant</b>
     * </p>
     *
     * @param production_relevant
     *            Production relevant
     */
    public void setProduction_relevant( @Nullable final Boolean production_relevant )
    {
        rememberChangedField("production_relevant", this.production_relevant);
        this.production_relevant = production_relevant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>production_version</b>
     * </p>
     *
     * @param production_version
     *            Production Version
     */
    public void setProduction_version( @Nullable final String production_version )
    {
        rememberChangedField("production_version", this.production_version);
        this.production_version = production_version;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>prod_order_issue_location</b>
     * </p>
     *
     * @param prod_order_issue_location
     *            Storage Location
     */
    public void setProd_order_issue_location( @Nullable final String prod_order_issue_location )
    {
        rememberChangedField("prod_order_issue_location", this.prod_order_issue_location);
        this.prod_order_issue_location = prod_order_issue_location;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>profit_center</b>
     * </p>
     *
     * @param profit_center
     *            Profit Center
     */
    public void setProfit_center( @Nullable final String profit_center )
    {
        rememberChangedField("profit_center", this.profit_center);
        this.profit_center = profit_center;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>purchasing_group</b>
     * </p>
     *
     * @param purchasing_group
     *            Purchasing Group
     */
    public void setPurchasing_group( @Nullable final String purchasing_group )
    {
        rememberChangedField("purchasing_group", this.purchasing_group);
        this.purchasing_group = purchasing_group;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>purchasing_organisation</b>
     * </p>
     *
     * @param purchasing_organisation
     *            Purch. Organization
     */
    public void setPurchasing_organisation( @Nullable final String purchasing_organisation )
    {
        rememberChangedField("purchasing_organisation", this.purchasing_organisation);
        this.purchasing_organisation = purchasing_organisation;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>qty_var_size_item</b>
     * </p>
     *
     * @param qty_var_size_item
     *            VSI Quantity per PC
     */
    public void setQty_var_size_item( @Nullable final BigDecimal qty_var_size_item )
    {
        rememberChangedField("qty_var_size_item", this.qty_var_size_item);
        this.qty_var_size_item = qty_var_size_item;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>record_creation_date</b>
     * </p>
     *
     * @param record_creation_date
     *            Created On
     */
    public void setRecord_creation_date( @Nullable final LocalDateTime record_creation_date )
    {
        rememberChangedField("record_creation_date", this.record_creation_date);
        this.record_creation_date = record_creation_date;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>recurisve</b>
     * </p>
     *
     * @param recurisve
     *            Recursive
     */
    public void setRecurisve( @Nullable final Boolean recurisve )
    {
        rememberChangedField("recurisve", this.recurisve);
        this.recurisve = recurisve;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>recurs_allowed</b>
     * </p>
     *
     * @param recurs_allowed
     *            Recurs. allowed
     */
    public void setRecurs_allowed( @Nullable final Boolean recurs_allowed )
    {
        rememberChangedField("recurs_allowed", this.recurs_allowed);
        this.recurs_allowed = recurs_allowed;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property from the Odata EDM: <b>reference_point</b>
     * </p>
     *
     * @param reference_point
     *            Reference point
     */
    public void setReference_point( @Nullable final String reference_point )
    {
        rememberChangedField("reference_point", this.reference_point);
        this.reference_point = reference_point;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>relevancy_to_costing</b>
     * </p>
     *
     * @param relevancy_to_costing
     *            CostingRelevncy
     */
    public void setRelevancy_to_costing( @Nullable final String relevancy_to_costing )
    {
        rememberChangedField("relevancy_to_costing", this.relevancy_to_costing);
        this.relevancy_to_costing = relevancy_to_costing;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>relevant_to_sales</b>
     * </p>
     *
     * @param relevant_to_sales
     *            Relevant to sales
     */
    public void setRelevant_to_sales( @Nullable final String relevant_to_sales )
    {
        rememberChangedField("relevant_to_sales", this.relevant_to_sales);
        this.relevant_to_sales = relevant_to_sales;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>required_component</b>
     * </p>
     *
     * @param required_component
     *            Required Component
     */
    public void setRequired_component( @Nullable final Boolean required_component )
    {
        rememberChangedField("required_component", this.required_component);
        this.required_component = required_component;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>requirement_segment</b>
     * </p>
     *
     * @param requirement_segment
     *            Requirement Segment
     */
    public void setRequirement_segment( @Nullable final String requirement_segment )
    {
        rememberChangedField("requirement_segment", this.requirement_segment);
        this.requirement_segment = requirement_segment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>revision_level</b>
     * </p>
     *
     * @param revision_level
     *            Revision Level
     */
    public void setRevision_level( @Nullable final String revision_level )
    {
        rememberChangedField("revision_level", this.revision_level);
        this.revision_level = revision_level;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>scrap_qty_bun</b>
     * </p>
     *
     * @param scrap_qty_bun
     *            Scrap Qty (BUn)
     */
    public void setScrap_qty_bun( @Nullable final BigDecimal scrap_qty_bun )
    {
        rememberChangedField("scrap_qty_bun", this.scrap_qty_bun);
        this.scrap_qty_bun = scrap_qty_bun;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>serial_no_profile</b>
     * </p>
     *
     * @param serial_no_profile
     *            Serial No. Profile
     */
    public void setSerial_no_profile( @Nullable final String serial_no_profile )
    {
        rememberChangedField("serial_no_profile", this.serial_no_profile);
        this.serial_no_profile = serial_no_profile;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>size1</b>
     * </p>
     *
     * @param size1
     *            Size 1
     */
    public void setSize1( @Nullable final BigDecimal size1 )
    {
        rememberChangedField("size1", this.size1);
        this.size1 = size1;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>size2</b>
     * </p>
     *
     * @param size2
     *            Size 2
     */
    public void setSize2( @Nullable final BigDecimal size2 )
    {
        rememberChangedField("size2", this.size2);
        this.size2 = size2;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>size3</b>
     * </p>
     *
     * @param size3
     *            Size 3
     */
    public void setSize3( @Nullable final BigDecimal size3 )
    {
        rememberChangedField("size3", this.size3);
        this.size3 = size3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>size_unit</b>
     * </p>
     *
     * @param size_unit
     *            Size unit
     */
    public void setSize_unit( @Nullable final String size_unit )
    {
        rememberChangedField("size_unit", this.size_unit);
        this.size_unit = size_unit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>sort_string</b>
     * </p>
     *
     * @param sort_string
     *            Sort String
     */
    public void setSort_string( @Nullable final String sort_string )
    {
        rememberChangedField("sort_string", this.sort_string);
        this.sort_string = sort_string;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>special_procurement_type</b>
     * </p>
     *
     * @param special_procurement_type
     *            Special Procurement
     */
    public void setSpecial_procurement_type( @Nullable final String special_procurement_type )
    {
        rememberChangedField("special_procurement_type", this.special_procurement_type);
        this.special_procurement_type = special_procurement_type;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>special_proc_typ_itm</b>
     * </p>
     *
     * @param special_proc_typ_itm
     *            Special Procurement
     */
    public void setSpecial_proc_typ_itm( @Nullable final String special_proc_typ_itm )
    {
        rememberChangedField("special_proc_typ_itm", this.special_proc_typ_itm);
        this.special_proc_typ_itm = special_proc_typ_itm;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>special_proc_typ_mastr</b>
     * </p>
     *
     * @param special_proc_typ_mastr
     *            Special procurement
     */
    public void setSpecial_proc_typ_mastr( @Nullable final String special_proc_typ_mastr )
    {
        rememberChangedField("special_proc_typ_mastr", this.special_proc_typ_mastr);
        this.special_proc_typ_mastr = special_proc_typ_mastr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>spec_proc_costing</b>
     * </p>
     *
     * @param spec_proc_costing
     *            SpecProcurem Costing
     */
    public void setSpec_proc_costing( @Nullable final String spec_proc_costing )
    {
        rememberChangedField("spec_proc_costing", this.spec_proc_costing);
        this.spec_proc_costing = spec_proc_costing;
    }

    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>standard_price</b>
     * </p>
     *
     * @param standard_price
     *            Standard price
     */
    public void setStandard_price( @Nullable final BigDecimal standard_price )
    {
        rememberChangedField("standard_price", this.standard_price);
        this.standard_price = standard_price;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property from the Odata EDM: <b>status_text</b>
     * </p>
     *
     * @param status_text
     *            Status Text
     */
    public void setStatus_text( @Nullable final String status_text )
    {
        rememberChangedField("status_text", this.status_text);
        this.status_text = status_text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>stock_segment</b>
     * </p>
     *
     * @param stock_segment
     *            Stock Segment
     */
    public void setStock_segment( @Nullable final String stock_segment )
    {
        rememberChangedField("stock_segment", this.stock_segment);
        this.stock_segment = stock_segment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>storage_location</b>
     * </p>
     *
     * @param storage_location
     *            Storage Location
     */
    public void setStorage_location( @Nullable final String storage_location )
    {
        rememberChangedField("storage_location", this.storage_location);
        this.storage_location = storage_location;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>strategy</b>
     * </p>
     *
     * @param strategy
     *            Strategy
     */
    public void setStrategy( @Nullable final String strategy )
    {
        rememberChangedField("strategy", this.strategy);
        this.strategy = strategy;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>sub_item_indicator</b>
     * </p>
     *
     * @param sub_item_indicator
     *            Sub-item indicator
     */
    public void setSub_item_indicator( @Nullable final Boolean sub_item_indicator )
    {
        rememberChangedField("sub_item_indicator", this.sub_item_indicator);
        this.sub_item_indicator = sub_item_indicator;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>supplier</b>
     * </p>
     *
     * @param supplier
     *            Supplier
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>table_row</b>
     * </p>
     *
     * @param table_row
     *            Table Row
     */
    public void setTable_row( @Nullable final Integer table_row )
    {
        rememberChangedField("table_row", this.table_row);
        this.table_row = table_row;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property from the Odata EDM: <b>tech_status_from</b>
     * </p>
     *
     * @param tech_status_from
     *            Tech status from
     */
    public void setTech_status_from( @Nullable final String tech_status_from )
    {
        rememberChangedField("tech_status_from", this.tech_status_from);
        this.tech_status_from = tech_status_from;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>test_hist_nxt_lvl</b>
     * </p>
     *
     * @param test_hist_nxt_lvl
     *            TeStHist (Next Lvl)
     */
    public void setTest_hist_nxt_lvl( @Nullable final Boolean test_hist_nxt_lvl )
    {
        rememberChangedField("test_hist_nxt_lvl", this.test_hist_nxt_lvl);
        this.test_hist_nxt_lvl = test_hist_nxt_lvl;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>totals_record_id</b>
     * </p>
     *
     * @param totals_record_id
     *            Totals record ID
     */
    public void setTotals_record_id( @Nullable final String totals_record_id )
    {
        rememberChangedField("totals_record_id", this.totals_record_id);
        this.totals_record_id = totals_record_id;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>unit_of_measure</b>
     * </p>
     *
     * @param unit_of_measure
     *            Component UoM
     */
    public void setUnit_of_measure( @Nullable final String unit_of_measure )
    {
        rememberChangedField("unit_of_measure", this.unit_of_measure);
        this.unit_of_measure = unit_of_measure;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property from the Odata EDM: <b>unloading_point</b>
     * </p>
     *
     * @param unloading_point
     *            Unloading Point
     */
    public void setUnloading_point( @Nullable final String unloading_point )
    {
        rememberChangedField("unloading_point", this.unloading_point);
        this.unloading_point = unloading_point;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>uom_usage</b>
     * </p>
     *
     * @param uom_usage
     *            Units of meas. usage
     */
    public void setUom_usage( @Nullable final String uom_usage )
    {
        rememberChangedField("uom_usage", this.uom_usage);
        this.uom_usage = uom_usage;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property from the Odata EDM: <b>usage_probability</b>
     * </p>
     *
     * @param usage_probability
     *            Usage Probability
     */
    public void setUsage_probability( @Nullable final BigDecimal usage_probability )
    {
        rememberChangedField("usage_probability", this.usage_probability);
        this.usage_probability = usage_probability;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>validity_end_date</b>
     * </p>
     *
     * @param validity_end_date
     *            Valid to
     */
    public void setValidity_end_date( @Nullable final LocalDateTime validity_end_date )
    {
        rememberChangedField("validity_end_date", this.validity_end_date);
        this.validity_end_date = validity_end_date;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>validity_start_date</b>
     * </p>
     *
     * @param validity_start_date
     *            Valid From
     */
    public void setValidity_start_date( @Nullable final LocalDateTime validity_start_date )
    {
        rememberChangedField("validity_start_date", this.validity_start_date);
        this.validity_start_date = validity_start_date;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>valuation_category</b>
     * </p>
     *
     * @param valuation_category
     *            Valuation Category
     */
    public void setValuation_category( @Nullable final String valuation_category )
    {
        rememberChangedField("valuation_category", this.valuation_category);
        this.valuation_category = valuation_category;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>variants_nxt_lvl</b>
     * </p>
     *
     * @param variants_nxt_lvl
     *            Variants(Next Level)
     */
    public void setVariants_nxt_lvl( @Nullable final Boolean variants_nxt_lvl )
    {
        rememberChangedField("variants_nxt_lvl", this.variants_nxt_lvl);
        this.variants_nxt_lvl = variants_nxt_lvl;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>x_plant_material_status</b>
     * </p>
     *
     * @param x_plant_material_status
     *            X-Plant Status
     */
    public void setX_plant_material_status( @Nullable final String x_plant_material_status )
    {
        rememberChangedField("x_plant_material_status", this.x_plant_material_status);
        this.x_plant_material_status = x_plant_material_status;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>x_plt_status_valid_from</b>
     * </p>
     *
     * @param x_plt_status_valid_from
     *            Valid from
     */
    public void setX_plt_status_valid_from( @Nullable final LocalDateTime x_plt_status_valid_from )
    {
        rememberChangedField("x_plt_status_valid_from", this.x_plt_status_valid_from);
        this.x_plt_status_valid_from = x_plt_status_valid_from;
    }

}
