/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.selectable.MBOMItmObjDpnAssignmentSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MBOMItmObjDpnAssignment
 * MBOMItmObjDpnAssignment} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class MBOMItmObjDpnAssignmentByKeyFluentHelper
    extends
    FluentHelperByKey<MBOMItmObjDpnAssignmentByKeyFluentHelper, MBOMItmObjDpnAssignment, MBOMItmObjDpnAssignmentSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MBOMItmObjDpnAssignment
     * MBOMItmObjDpnAssignment} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code MBOMItmObjDpnAssignment}
     * @param headerChangeDocument
     *            Change Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param material
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param objectDependencyName
     *            Name of Dependency
     *            <p>
     *            Constraints: Not nullable, Maximum length: 30
     *            </p>
     * @param billOfMaterialCategory
     *            BOM category
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code MBOMItmObjDpnAssignment}
     * @param billOfMaterialVersion
     *            BOM Version
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param billOfMaterial
     *            Bill of Material
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param billOfMaterialVariant
     *            Alternative BOM
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param billOfMaterialItemNodeNumber
     *            BOM item node number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     */
    public MBOMItmObjDpnAssignmentByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String billOfMaterial,
        final String billOfMaterialCategory,
        final String billOfMaterialVariant,
        final String billOfMaterialVersion,
        final String headerChangeDocument,
        final String material,
        final String plant,
        final String billOfMaterialItemNodeNumber,
        final String objectDependencyName )
    {
        super(servicePath, entityCollection);
        this.key.put("BillOfMaterial", billOfMaterial);
        this.key.put("BillOfMaterialCategory", billOfMaterialCategory);
        this.key.put("BillOfMaterialVariant", billOfMaterialVariant);
        this.key.put("BillOfMaterialVersion", billOfMaterialVersion);
        this.key.put("HeaderChangeDocument", headerChangeDocument);
        this.key.put("Material", material);
        this.key.put("Plant", plant);
        this.key.put("BillOfMaterialItemNodeNumber", billOfMaterialItemNodeNumber);
        this.key.put("ObjectDependencyName", objectDependencyName);
    }

    @Override
    @Nonnull
    protected Class<MBOMItmObjDpnAssignment> getEntityClass()
    {
        return MBOMItmObjDpnAssignment.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
