/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.field.MaterialBOMField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.link.MaterialBOMLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.link.MaterialBOMOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.selectable.MaterialBOMSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Bill of Material
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MaterialBOMType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MaterialBOM extends VdmEntity<MaterialBOM>
{

    /**
     * Selector for all available fields of MaterialBOM.
     *
     */
    public final static MaterialBOMSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DeleteBOMHeaderWithECN_ac</b>
     * </p>
     *
     * @return Dyn. Action Control
     */
    @SerializedName( "DeleteBOMHeaderWithECN_ac" )
    @JsonProperty( "DeleteBOMHeaderWithECN_ac" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "DeleteBOMHeaderWithECN_ac" )
    private Boolean deleteBOMHeaderWithECN_ac;
    /**
     * Use with available fluent helpers to apply the <b>DeleteBOMHeaderWithECN_ac</b> field to query operations.
     *
     */
    public final static MaterialBOMField<Boolean> DELETE_BOM_HEADER_WITH_ECN_AC =
        new MaterialBOMField<Boolean>("DeleteBOMHeaderWithECN_ac");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ReleaseVersionBOM_ac</b>
     * </p>
     *
     * @return Dyn. Action Control
     */
    @SerializedName( "ReleaseVersionBOM_ac" )
    @JsonProperty( "ReleaseVersionBOM_ac" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ReleaseVersionBOM_ac" )
    private Boolean releaseVersionBOM_ac;
    /**
     * Use with available fluent helpers to apply the <b>ReleaseVersionBOM_ac</b> field to query operations.
     *
     */
    public final static MaterialBOMField<Boolean> RELEASE_VERSION_BOM_AC =
        new MaterialBOMField<Boolean>("ReleaseVersionBOM_ac");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Delete_mc" )
    @JsonProperty( "Delete_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Delete_mc" )
    private Boolean delete_mc;
    /**
     * Use with available fluent helpers to apply the <b>Delete_mc</b> field to query operations.
     *
     */
    public final static MaterialBOMField<Boolean> DELETE_MC = new MaterialBOMField<Boolean>("Delete_mc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Update_mc" )
    @JsonProperty( "Update_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Update_mc" )
    private Boolean update_mc;
    /**
     * Use with available fluent helpers to apply the <b>Update_mc</b> field to query operations.
     *
     */
    public final static MaterialBOMField<Boolean> UPDATE_MC = new MaterialBOMField<Boolean>("Update_mc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_BillOfMaterialItem_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_BillOfMaterialItem_oc" )
    @JsonProperty( "to_BillOfMaterialItem_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_BillOfMaterialItem_oc" )
    private Boolean billOfMaterialItem_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_BillOfMaterialItem_oc</b> field to query operations.
     *
     */
    public final static MaterialBOMField<Boolean> BILL_OF_MATERIAL_ITEM_OC =
        new MaterialBOMField<Boolean>("to_BillOfMaterialItem_oc");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterial</b>
     * </p>
     *
     * @return Bill of Material
     */
    @Key
    @SerializedName( "BillOfMaterial" )
    @JsonProperty( "BillOfMaterial" )
    @Nullable
    @ODataField( odataName = "BillOfMaterial" )
    private String billOfMaterial;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterial</b> field to query operations.
     *
     */
    public final static MaterialBOMField<String> BILL_OF_MATERIAL = new MaterialBOMField<String>("BillOfMaterial");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialCategory</b>
     * </p>
     *
     * @return BOM category
     */
    @Key
    @SerializedName( "BillOfMaterialCategory" )
    @JsonProperty( "BillOfMaterialCategory" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialCategory" )
    private String billOfMaterialCategory;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialCategory</b> field to query operations.
     *
     */
    public final static MaterialBOMField<String> BILL_OF_MATERIAL_CATEGORY =
        new MaterialBOMField<String>("BillOfMaterialCategory");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialVariant</b>
     * </p>
     *
     * @return Alternative BOM
     */
    @Key
    @SerializedName( "BillOfMaterialVariant" )
    @JsonProperty( "BillOfMaterialVariant" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialVariant" )
    private String billOfMaterialVariant;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialVariant</b> field to query operations.
     *
     */
    public final static MaterialBOMField<String> BILL_OF_MATERIAL_VARIANT =
        new MaterialBOMField<String>("BillOfMaterialVariant");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialVersion</b>
     * </p>
     *
     * @return BOM Version
     */
    @Key
    @SerializedName( "BillOfMaterialVersion" )
    @JsonProperty( "BillOfMaterialVersion" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialVersion" )
    private String billOfMaterialVersion;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialVersion</b> field to query operations.
     *
     */
    public final static MaterialBOMField<String> BILL_OF_MATERIAL_VERSION =
        new MaterialBOMField<String>("BillOfMaterialVersion");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>EngineeringChangeDocument</b>
     * </p>
     *
     * @return Change Number
     */
    @Key
    @SerializedName( "EngineeringChangeDocument" )
    @JsonProperty( "EngineeringChangeDocument" )
    @Nullable
    @ODataField( odataName = "EngineeringChangeDocument" )
    private String engineeringChangeDocument;
    /**
     * Use with available fluent helpers to apply the <b>EngineeringChangeDocument</b> field to query operations.
     *
     */
    public final static MaterialBOMField<String> ENGINEERING_CHANGE_DOCUMENT =
        new MaterialBOMField<String>("EngineeringChangeDocument");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @Key
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static MaterialBOMField<String> MATERIAL = new MaterialBOMField<String>("Material");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @Key
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static MaterialBOMField<String> PLANT = new MaterialBOMField<String>("Plant");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialHeaderUUID</b>
     * </p>
     *
     * @return Global identification of a BOM header change status
     */
    @SerializedName( "BillOfMaterialHeaderUUID" )
    @JsonProperty( "BillOfMaterialHeaderUUID" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialHeaderUUID" )
    private UUID billOfMaterialHeaderUUID;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialHeaderUUID</b> field to query operations.
     *
     */
    public final static MaterialBOMField<UUID> BILL_OF_MATERIAL_HEADER_UUID =
        new MaterialBOMField<UUID>("BillOfMaterialHeaderUUID");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialVariantUsage</b>
     * </p>
     *
     * @return BOM Usage
     */
    @SerializedName( "BillOfMaterialVariantUsage" )
    @JsonProperty( "BillOfMaterialVariantUsage" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialVariantUsage" )
    private String billOfMaterialVariantUsage;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialVariantUsage</b> field to query operations.
     *
     */
    public final static MaterialBOMField<String> BILL_OF_MATERIAL_VARIANT_USAGE =
        new MaterialBOMField<String>("BillOfMaterialVariantUsage");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>EngineeringChangeDocForEdit</b>
     * </p>
     *
     * @return Change Number
     */
    @SerializedName( "EngineeringChangeDocForEdit" )
    @JsonProperty( "EngineeringChangeDocForEdit" )
    @Nullable
    @ODataField( odataName = "EngineeringChangeDocForEdit" )
    private String engineeringChangeDocForEdit;
    /**
     * Use with available fluent helpers to apply the <b>EngineeringChangeDocForEdit</b> field to query operations.
     *
     */
    public final static MaterialBOMField<String> ENGINEERING_CHANGE_DOC_FOR_EDIT =
        new MaterialBOMField<String>("EngineeringChangeDocForEdit");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsMultipleBOMAlt</b>
     * </p>
     *
     * @return Indicator: alternative determination for multiple BOMs
     */
    @SerializedName( "IsMultipleBOMAlt" )
    @JsonProperty( "IsMultipleBOMAlt" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsMultipleBOMAlt" )
    private Boolean isMultipleBOMAlt;
    /**
     * Use with available fluent helpers to apply the <b>IsMultipleBOMAlt</b> field to query operations.
     *
     */
    public final static MaterialBOMField<Boolean> IS_MULTIPLE_BOM_ALT =
        new MaterialBOMField<Boolean>("IsMultipleBOMAlt");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOMHeaderInternalChangeCount</b>
     * </p>
     *
     * @return Internal counter
     */
    @SerializedName( "BOMHeaderInternalChangeCount" )
    @JsonProperty( "BOMHeaderInternalChangeCount" )
    @Nullable
    @ODataField( odataName = "BOMHeaderInternalChangeCount" )
    private String bOMHeaderInternalChangeCount;
    /**
     * Use with available fluent helpers to apply the <b>BOMHeaderInternalChangeCount</b> field to query operations.
     *
     */
    public final static MaterialBOMField<String> BOM_HEADER_INTERNAL_CHANGE_COUNT =
        new MaterialBOMField<String>("BOMHeaderInternalChangeCount");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BOMUsagePriority</b>
     * </p>
     *
     * @return CIM priority for selection ID
     */
    @SerializedName( "BOMUsagePriority" )
    @JsonProperty( "BOMUsagePriority" )
    @Nullable
    @ODataField( odataName = "BOMUsagePriority" )
    private String bOMUsagePriority;
    /**
     * Use with available fluent helpers to apply the <b>BOMUsagePriority</b> field to query operations.
     *
     */
    public final static MaterialBOMField<String> BOM_USAGE_PRIORITY = new MaterialBOMField<String>("BOMUsagePriority");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialAuthsnGrp</b>
     * </p>
     *
     * @return Authorization group for bills of material
     */
    @SerializedName( "BillOfMaterialAuthsnGrp" )
    @JsonProperty( "BillOfMaterialAuthsnGrp" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialAuthsnGrp" )
    private String billOfMaterialAuthsnGrp;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialAuthsnGrp</b> field to query operations.
     *
     */
    public final static MaterialBOMField<String> BILL_OF_MATERIAL_AUTHSN_GRP =
        new MaterialBOMField<String>("BillOfMaterialAuthsnGrp");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BOMVersionStatus</b>
     * </p>
     *
     * @return BOM Version Status
     */
    @SerializedName( "BOMVersionStatus" )
    @JsonProperty( "BOMVersionStatus" )
    @Nullable
    @ODataField( odataName = "BOMVersionStatus" )
    private String bOMVersionStatus;
    /**
     * Use with available fluent helpers to apply the <b>BOMVersionStatus</b> field to query operations.
     *
     */
    public final static MaterialBOMField<String> BOM_VERSION_STATUS = new MaterialBOMField<String>("BOMVersionStatus");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsVersionBillOfMaterial</b>
     * </p>
     *
     * @return Indicator: Relevant for Versioning
     */
    @SerializedName( "IsVersionBillOfMaterial" )
    @JsonProperty( "IsVersionBillOfMaterial" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsVersionBillOfMaterial" )
    private Boolean isVersionBillOfMaterial;
    /**
     * Use with available fluent helpers to apply the <b>IsVersionBillOfMaterial</b> field to query operations.
     *
     */
    public final static MaterialBOMField<Boolean> IS_VERSION_BILL_OF_MATERIAL =
        new MaterialBOMField<Boolean>("IsVersionBillOfMaterial");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsLatestBOMVersion</b>
     * </p>
     *
     * @return Indicator: Latest Released BOM Version
     */
    @SerializedName( "IsLatestBOMVersion" )
    @JsonProperty( "IsLatestBOMVersion" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsLatestBOMVersion" )
    private Boolean isLatestBOMVersion;
    /**
     * Use with available fluent helpers to apply the <b>IsLatestBOMVersion</b> field to query operations.
     *
     */
    public final static MaterialBOMField<Boolean> IS_LATEST_BOM_VERSION =
        new MaterialBOMField<Boolean>("IsLatestBOMVersion");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsConfiguredMaterial</b>
     * </p>
     *
     * @return Indicator: configurable BOM
     */
    @SerializedName( "IsConfiguredMaterial" )
    @JsonProperty( "IsConfiguredMaterial" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsConfiguredMaterial" )
    private Boolean isConfiguredMaterial;
    /**
     * Use with available fluent helpers to apply the <b>IsConfiguredMaterial</b> field to query operations.
     *
     */
    public final static MaterialBOMField<Boolean> IS_CONFIGURED_MATERIAL =
        new MaterialBOMField<Boolean>("IsConfiguredMaterial");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BOMTechnicalType</b>
     * </p>
     *
     * @return Technical type
     */
    @SerializedName( "BOMTechnicalType" )
    @JsonProperty( "BOMTechnicalType" )
    @Nullable
    @ODataField( odataName = "BOMTechnicalType" )
    private String bOMTechnicalType;
    /**
     * Use with available fluent helpers to apply the <b>BOMTechnicalType</b> field to query operations.
     *
     */
    public final static MaterialBOMField<String> BOM_TECHNICAL_TYPE = new MaterialBOMField<String>("BOMTechnicalType");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>BOMGroup</b>
     * </p>
     *
     * @return BOM group
     */
    @SerializedName( "BOMGroup" )
    @JsonProperty( "BOMGroup" )
    @Nullable
    @ODataField( odataName = "BOMGroup" )
    private String bOMGroup;
    /**
     * Use with available fluent helpers to apply the <b>BOMGroup</b> field to query operations.
     *
     */
    public final static MaterialBOMField<String> BOM_GROUP = new MaterialBOMField<String>("BOMGroup");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BOMHeaderText</b>
     * </p>
     *
     * @return BOM Description
     */
    @SerializedName( "BOMHeaderText" )
    @JsonProperty( "BOMHeaderText" )
    @Nullable
    @ODataField( odataName = "BOMHeaderText" )
    private String bOMHeaderText;
    /**
     * Use with available fluent helpers to apply the <b>BOMHeaderText</b> field to query operations.
     *
     */
    public final static MaterialBOMField<String> BOM_HEADER_TEXT = new MaterialBOMField<String>("BOMHeaderText");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BOMAlternativeText</b>
     * </p>
     *
     * @return Alternative BOM Text
     */
    @SerializedName( "BOMAlternativeText" )
    @JsonProperty( "BOMAlternativeText" )
    @Nullable
    @ODataField( odataName = "BOMAlternativeText" )
    private String bOMAlternativeText;
    /**
     * Use with available fluent helpers to apply the <b>BOMAlternativeText</b> field to query operations.
     *
     */
    public final static MaterialBOMField<String> BOM_ALTERNATIVE_TEXT =
        new MaterialBOMField<String>("BOMAlternativeText");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialStatus</b>
     * </p>
     *
     * @return Bill of Material Status
     */
    @SerializedName( "BillOfMaterialStatus" )
    @JsonProperty( "BillOfMaterialStatus" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialStatus" )
    private String billOfMaterialStatus;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialStatus</b> field to query operations.
     *
     */
    public final static MaterialBOMField<String> BILL_OF_MATERIAL_STATUS =
        new MaterialBOMField<String>("BillOfMaterialStatus");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>HeaderValidityStartDate</b>
     * </p>
     *
     * @return Valid-From Date
     */
    @SerializedName( "HeaderValidityStartDate" )
    @JsonProperty( "HeaderValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "HeaderValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime headerValidityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>HeaderValidityStartDate</b> field to query operations.
     *
     */
    public final static MaterialBOMField<LocalDateTime> HEADER_VALIDITY_START_DATE =
        new MaterialBOMField<LocalDateTime>("HeaderValidityStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>HeaderValidityEndDate</b>
     * </p>
     *
     * @return Valid-to date
     */
    @SerializedName( "HeaderValidityEndDate" )
    @JsonProperty( "HeaderValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "HeaderValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime headerValidityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>HeaderValidityEndDate</b> field to query operations.
     *
     */
    public final static MaterialBOMField<LocalDateTime> HEADER_VALIDITY_END_DATE =
        new MaterialBOMField<LocalDateTime>("HeaderValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChgToEngineeringChgDocument</b>
     * </p>
     *
     * @return Change Number To
     */
    @SerializedName( "ChgToEngineeringChgDocument" )
    @JsonProperty( "ChgToEngineeringChgDocument" )
    @Nullable
    @ODataField( odataName = "ChgToEngineeringChgDocument" )
    private String chgToEngineeringChgDocument;
    /**
     * Use with available fluent helpers to apply the <b>ChgToEngineeringChgDocument</b> field to query operations.
     *
     */
    public final static MaterialBOMField<String> CHG_TO_ENGINEERING_CHG_DOCUMENT =
        new MaterialBOMField<String>("ChgToEngineeringChgDocument");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsMarkedForDeletion</b>
     * </p>
     *
     * @return Deletion Indicator
     */
    @SerializedName( "IsMarkedForDeletion" )
    @JsonProperty( "IsMarkedForDeletion" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsMarkedForDeletion" )
    private Boolean isMarkedForDeletion;
    /**
     * Use with available fluent helpers to apply the <b>IsMarkedForDeletion</b> field to query operations.
     *
     */
    public final static MaterialBOMField<Boolean> IS_MARKED_FOR_DELETION =
        new MaterialBOMField<Boolean>("IsMarkedForDeletion");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsALE</b>
     * </p>
     *
     * @return ALE indicator
     */
    @SerializedName( "IsALE" )
    @JsonProperty( "IsALE" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsALE" )
    private Boolean isALE;
    /**
     * Use with available fluent helpers to apply the <b>IsALE</b> field to query operations.
     *
     */
    public final static MaterialBOMField<Boolean> IS_ALE = new MaterialBOMField<Boolean>("IsALE");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MatFromLotSizeQuantity</b>
     * </p>
     *
     * @return From Lot Size
     */
    @SerializedName( "MatFromLotSizeQuantity" )
    @JsonProperty( "MatFromLotSizeQuantity" )
    @Nullable
    @ODataField( odataName = "MatFromLotSizeQuantity" )
    private BigDecimal matFromLotSizeQuantity;
    /**
     * Use with available fluent helpers to apply the <b>MatFromLotSizeQuantity</b> field to query operations.
     *
     */
    public final static MaterialBOMField<BigDecimal> MAT_FROM_LOT_SIZE_QUANTITY =
        new MaterialBOMField<BigDecimal>("MatFromLotSizeQuantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaterialToLotSizeQuantity</b>
     * </p>
     *
     * @return To Lot Size
     */
    @SerializedName( "MaterialToLotSizeQuantity" )
    @JsonProperty( "MaterialToLotSizeQuantity" )
    @Nullable
    @ODataField( odataName = "MaterialToLotSizeQuantity" )
    private BigDecimal materialToLotSizeQuantity;
    /**
     * Use with available fluent helpers to apply the <b>MaterialToLotSizeQuantity</b> field to query operations.
     *
     */
    public final static MaterialBOMField<BigDecimal> MATERIAL_TO_LOT_SIZE_QUANTITY =
        new MaterialBOMField<BigDecimal>("MaterialToLotSizeQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BOMHeaderBaseUnit</b>
     * </p>
     *
     * @return Base Unit of Measure for BOM
     */
    @SerializedName( "BOMHeaderBaseUnit" )
    @JsonProperty( "BOMHeaderBaseUnit" )
    @Nullable
    @ODataField( odataName = "BOMHeaderBaseUnit" )
    private String bOMHeaderBaseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BOMHeaderBaseUnit</b> field to query operations.
     *
     */
    public final static MaterialBOMField<String> BOM_HEADER_BASE_UNIT =
        new MaterialBOMField<String>("BOMHeaderBaseUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BOMHeaderQuantityInBaseUnit</b>
     * </p>
     *
     * @return Base quantity
     */
    @SerializedName( "BOMHeaderQuantityInBaseUnit" )
    @JsonProperty( "BOMHeaderQuantityInBaseUnit" )
    @Nullable
    @ODataField( odataName = "BOMHeaderQuantityInBaseUnit" )
    private BigDecimal bOMHeaderQuantityInBaseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BOMHeaderQuantityInBaseUnit</b> field to query operations.
     *
     */
    public final static MaterialBOMField<BigDecimal> BOM_HEADER_QUANTITY_IN_BASE_UNIT =
        new MaterialBOMField<BigDecimal>("BOMHeaderQuantityInBaseUnit");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RecordCreationDate</b>
     * </p>
     *
     * @return Date Record Created On
     */
    @SerializedName( "RecordCreationDate" )
    @JsonProperty( "RecordCreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "RecordCreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime recordCreationDate;
    /**
     * Use with available fluent helpers to apply the <b>RecordCreationDate</b> field to query operations.
     *
     */
    public final static MaterialBOMField<LocalDateTime> RECORD_CREATION_DATE =
        new MaterialBOMField<LocalDateTime>("RecordCreationDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Last Changed On
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static MaterialBOMField<LocalDateTime> LAST_CHANGE_DATE =
        new MaterialBOMField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return User Who Created Record
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static MaterialBOMField<String> CREATED_BY_USER = new MaterialBOMField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Name of Person Who Changed Object
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static MaterialBOMField<String> LAST_CHANGED_BY_USER =
        new MaterialBOMField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BOMIsToBeDeleted</b>
     * </p>
     *
     * @return Handling Deletion Flag During BOM Explosion
     */
    @SerializedName( "BOMIsToBeDeleted" )
    @JsonProperty( "BOMIsToBeDeleted" )
    @Nullable
    @ODataField( odataName = "BOMIsToBeDeleted" )
    private String bOMIsToBeDeleted;
    /**
     * Use with available fluent helpers to apply the <b>BOMIsToBeDeleted</b> field to query operations.
     *
     */
    public final static MaterialBOMField<String> BOM_IS_TO_BE_DELETED =
        new MaterialBOMField<String>("BOMIsToBeDeleted");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DocumentIsCreatedByCAD</b>
     * </p>
     *
     * @return CAD Indicator
     */
    @SerializedName( "DocumentIsCreatedByCAD" )
    @JsonProperty( "DocumentIsCreatedByCAD" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "DocumentIsCreatedByCAD" )
    private Boolean documentIsCreatedByCAD;
    /**
     * Use with available fluent helpers to apply the <b>DocumentIsCreatedByCAD</b> field to query operations.
     *
     */
    public final static MaterialBOMField<Boolean> DOCUMENT_IS_CREATED_BY_CAD =
        new MaterialBOMField<Boolean>("DocumentIsCreatedByCAD");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>LaboratoryOrDesignOffice</b>
     * </p>
     *
     * @return Laboratory/Design Office
     */
    @SerializedName( "LaboratoryOrDesignOffice" )
    @JsonProperty( "LaboratoryOrDesignOffice" )
    @Nullable
    @ODataField( odataName = "LaboratoryOrDesignOffice" )
    private String laboratoryOrDesignOffice;
    /**
     * Use with available fluent helpers to apply the <b>LaboratoryOrDesignOffice</b> field to query operations.
     *
     */
    public final static MaterialBOMField<String> LABORATORY_OR_DESIGN_OFFICE =
        new MaterialBOMField<String>("LaboratoryOrDesignOffice");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static MaterialBOMField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new MaterialBOMField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProductDescription</b>
     * </p>
     *
     * @return Product Description
     */
    @SerializedName( "ProductDescription" )
    @JsonProperty( "ProductDescription" )
    @Nullable
    @ODataField( odataName = "ProductDescription" )
    private String productDescription;
    /**
     * Use with available fluent helpers to apply the <b>ProductDescription</b> field to query operations.
     *
     */
    public final static MaterialBOMField<String> PRODUCT_DESCRIPTION =
        new MaterialBOMField<String>("ProductDescription");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PlantName</b>
     * </p>
     *
     * @return Plant Name
     */
    @SerializedName( "PlantName" )
    @JsonProperty( "PlantName" )
    @Nullable
    @ODataField( odataName = "PlantName" )
    private String plantName;
    /**
     * Use with available fluent helpers to apply the <b>PlantName</b> field to query operations.
     *
     */
    public final static MaterialBOMField<String> PLANT_NAME = new MaterialBOMField<String>("PlantName");
    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialHdrDetailsText</b>
     * </p>
     *
     * @return The billOfMaterialHdrDetailsText contained in this entity.
     */
    @SerializedName( "BillOfMaterialHdrDetailsText" )
    @JsonProperty( "BillOfMaterialHdrDetailsText" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialHdrDetailsText" )
    private String billOfMaterialHdrDetailsText;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialHdrDetailsText</b> field to query operations.
     *
     */
    public final static MaterialBOMField<String> BILL_OF_MATERIAL_HDR_DETAILS_TEXT =
        new MaterialBOMField<String>("BillOfMaterialHdrDetailsText");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SelectedBillOfMaterialVersion</b>
     * </p>
     *
     * @return The selectedBillOfMaterialVersion contained in this entity.
     */
    @SerializedName( "SelectedBillOfMaterialVersion" )
    @JsonProperty( "SelectedBillOfMaterialVersion" )
    @Nullable
    @ODataField( odataName = "SelectedBillOfMaterialVersion" )
    private String selectedBillOfMaterialVersion;
    /**
     * Use with available fluent helpers to apply the <b>SelectedBillOfMaterialVersion</b> field to query operations.
     *
     */
    public final static MaterialBOMField<String> SELECTED_BILL_OF_MATERIAL_VERSION =
        new MaterialBOMField<String>("SelectedBillOfMaterialVersion");
    /**
     * Navigation property <b>to_BillOfMaterialItem</b> for <b>MaterialBOM</b> to multiple <b>MaterialBOMItem</b>.
     *
     */
    @SerializedName( "to_BillOfMaterialItem" )
    @JsonProperty( "to_BillOfMaterialItem" )
    @ODataField( odataName = "to_BillOfMaterialItem" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MaterialBOMItem> toBillOfMaterialItem;
    /**
     * Navigation property <b>to_BillOfMaterialUsage</b> for <b>MaterialBOM</b> to single <b>BillOfMaterialUsage</b>.
     *
     */
    @SerializedName( "to_BillOfMaterialUsage" )
    @JsonProperty( "to_BillOfMaterialUsage" )
    @ODataField( odataName = "to_BillOfMaterialUsage" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BillOfMaterialUsage toBillOfMaterialUsage;
    /**
     * Use with available fluent helpers to apply the <b>to_BillOfMaterialItem</b> navigation property to query
     * operations.
     *
     */
    public final static MaterialBOMLink<MaterialBOMItem> TO_BILL_OF_MATERIAL_ITEM =
        new MaterialBOMLink<MaterialBOMItem>("to_BillOfMaterialItem");
    /**
     * Use with available fluent helpers to apply the <b>to_BillOfMaterialUsage</b> navigation property to query
     * operations.
     *
     */
    public final static MaterialBOMOneToOneLink<BillOfMaterialUsage> TO_BILL_OF_MATERIAL_USAGE =
        new MaterialBOMOneToOneLink<BillOfMaterialUsage>("to_BillOfMaterialUsage");

    @Nonnull
    @Override
    public Class<MaterialBOM> getType()
    {
        return MaterialBOM.class;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DeleteBOMHeaderWithECN_ac</b>
     * </p>
     *
     * @param deleteBOMHeaderWithECN_ac
     *            Dyn. Action Control
     */
    public void setDeleteBOMHeaderWithECN_ac( @Nullable final Boolean deleteBOMHeaderWithECN_ac )
    {
        rememberChangedField("DeleteBOMHeaderWithECN_ac", this.deleteBOMHeaderWithECN_ac);
        this.deleteBOMHeaderWithECN_ac = deleteBOMHeaderWithECN_ac;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ReleaseVersionBOM_ac</b>
     * </p>
     *
     * @param releaseVersionBOM_ac
     *            Dyn. Action Control
     */
    public void setReleaseVersionBOM_ac( @Nullable final Boolean releaseVersionBOM_ac )
    {
        rememberChangedField("ReleaseVersionBOM_ac", this.releaseVersionBOM_ac);
        this.releaseVersionBOM_ac = releaseVersionBOM_ac;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @param delete_mc
     *            Dyn. Method Control
     */
    public void setDelete_mc( @Nullable final Boolean delete_mc )
    {
        rememberChangedField("Delete_mc", this.delete_mc);
        this.delete_mc = delete_mc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @param update_mc
     *            Dyn. Method Control
     */
    public void setUpdate_mc( @Nullable final Boolean update_mc )
    {
        rememberChangedField("Update_mc", this.update_mc);
        this.update_mc = update_mc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_BillOfMaterialItem_oc</b>
     * </p>
     *
     * @param billOfMaterialItem_oc
     *            Dynamic CbA-Control
     */
    public void setBillOfMaterialItem_oc( @Nullable final Boolean billOfMaterialItem_oc )
    {
        rememberChangedField("to_BillOfMaterialItem_oc", this.billOfMaterialItem_oc);
        this.billOfMaterialItem_oc = billOfMaterialItem_oc;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterial</b>
     * </p>
     *
     * @param billOfMaterial
     *            Bill of Material
     */
    public void setBillOfMaterial( @Nullable final String billOfMaterial )
    {
        rememberChangedField("BillOfMaterial", this.billOfMaterial);
        this.billOfMaterial = billOfMaterial;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialCategory</b>
     * </p>
     *
     * @param billOfMaterialCategory
     *            BOM category
     */
    public void setBillOfMaterialCategory( @Nullable final String billOfMaterialCategory )
    {
        rememberChangedField("BillOfMaterialCategory", this.billOfMaterialCategory);
        this.billOfMaterialCategory = billOfMaterialCategory;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialVariant</b>
     * </p>
     *
     * @param billOfMaterialVariant
     *            Alternative BOM
     */
    public void setBillOfMaterialVariant( @Nullable final String billOfMaterialVariant )
    {
        rememberChangedField("BillOfMaterialVariant", this.billOfMaterialVariant);
        this.billOfMaterialVariant = billOfMaterialVariant;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialVersion</b>
     * </p>
     *
     * @param billOfMaterialVersion
     *            BOM Version
     */
    public void setBillOfMaterialVersion( @Nullable final String billOfMaterialVersion )
    {
        rememberChangedField("BillOfMaterialVersion", this.billOfMaterialVersion);
        this.billOfMaterialVersion = billOfMaterialVersion;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>EngineeringChangeDocument</b>
     * </p>
     *
     * @param engineeringChangeDocument
     *            Change Number
     */
    public void setEngineeringChangeDocument( @Nullable final String engineeringChangeDocument )
    {
        rememberChangedField("EngineeringChangeDocument", this.engineeringChangeDocument);
        this.engineeringChangeDocument = engineeringChangeDocument;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialHeaderUUID</b>
     * </p>
     *
     * @param billOfMaterialHeaderUUID
     *            Global identification of a BOM header change status
     */
    public void setBillOfMaterialHeaderUUID( @Nullable final UUID billOfMaterialHeaderUUID )
    {
        rememberChangedField("BillOfMaterialHeaderUUID", this.billOfMaterialHeaderUUID);
        this.billOfMaterialHeaderUUID = billOfMaterialHeaderUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialVariantUsage</b>
     * </p>
     *
     * @param billOfMaterialVariantUsage
     *            BOM Usage
     */
    public void setBillOfMaterialVariantUsage( @Nullable final String billOfMaterialVariantUsage )
    {
        rememberChangedField("BillOfMaterialVariantUsage", this.billOfMaterialVariantUsage);
        this.billOfMaterialVariantUsage = billOfMaterialVariantUsage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>EngineeringChangeDocForEdit</b>
     * </p>
     *
     * @param engineeringChangeDocForEdit
     *            Change Number
     */
    public void setEngineeringChangeDocForEdit( @Nullable final String engineeringChangeDocForEdit )
    {
        rememberChangedField("EngineeringChangeDocForEdit", this.engineeringChangeDocForEdit);
        this.engineeringChangeDocForEdit = engineeringChangeDocForEdit;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsMultipleBOMAlt</b>
     * </p>
     *
     * @param isMultipleBOMAlt
     *            Indicator: alternative determination for multiple BOMs
     */
    public void setIsMultipleBOMAlt( @Nullable final Boolean isMultipleBOMAlt )
    {
        rememberChangedField("IsMultipleBOMAlt", this.isMultipleBOMAlt);
        this.isMultipleBOMAlt = isMultipleBOMAlt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOMHeaderInternalChangeCount</b>
     * </p>
     *
     * @param bOMHeaderInternalChangeCount
     *            Internal counter
     */
    public void setBOMHeaderInternalChangeCount( @Nullable final String bOMHeaderInternalChangeCount )
    {
        rememberChangedField("BOMHeaderInternalChangeCount", this.bOMHeaderInternalChangeCount);
        this.bOMHeaderInternalChangeCount = bOMHeaderInternalChangeCount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BOMUsagePriority</b>
     * </p>
     *
     * @param bOMUsagePriority
     *            CIM priority for selection ID
     */
    public void setBOMUsagePriority( @Nullable final String bOMUsagePriority )
    {
        rememberChangedField("BOMUsagePriority", this.bOMUsagePriority);
        this.bOMUsagePriority = bOMUsagePriority;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialAuthsnGrp</b>
     * </p>
     *
     * @param billOfMaterialAuthsnGrp
     *            Authorization group for bills of material
     */
    public void setBillOfMaterialAuthsnGrp( @Nullable final String billOfMaterialAuthsnGrp )
    {
        rememberChangedField("BillOfMaterialAuthsnGrp", this.billOfMaterialAuthsnGrp);
        this.billOfMaterialAuthsnGrp = billOfMaterialAuthsnGrp;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BOMVersionStatus</b>
     * </p>
     *
     * @param bOMVersionStatus
     *            BOM Version Status
     */
    public void setBOMVersionStatus( @Nullable final String bOMVersionStatus )
    {
        rememberChangedField("BOMVersionStatus", this.bOMVersionStatus);
        this.bOMVersionStatus = bOMVersionStatus;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsVersionBillOfMaterial</b>
     * </p>
     *
     * @param isVersionBillOfMaterial
     *            Indicator: Relevant for Versioning
     */
    public void setIsVersionBillOfMaterial( @Nullable final Boolean isVersionBillOfMaterial )
    {
        rememberChangedField("IsVersionBillOfMaterial", this.isVersionBillOfMaterial);
        this.isVersionBillOfMaterial = isVersionBillOfMaterial;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsLatestBOMVersion</b>
     * </p>
     *
     * @param isLatestBOMVersion
     *            Indicator: Latest Released BOM Version
     */
    public void setIsLatestBOMVersion( @Nullable final Boolean isLatestBOMVersion )
    {
        rememberChangedField("IsLatestBOMVersion", this.isLatestBOMVersion);
        this.isLatestBOMVersion = isLatestBOMVersion;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsConfiguredMaterial</b>
     * </p>
     *
     * @param isConfiguredMaterial
     *            Indicator: configurable BOM
     */
    public void setIsConfiguredMaterial( @Nullable final Boolean isConfiguredMaterial )
    {
        rememberChangedField("IsConfiguredMaterial", this.isConfiguredMaterial);
        this.isConfiguredMaterial = isConfiguredMaterial;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BOMTechnicalType</b>
     * </p>
     *
     * @param bOMTechnicalType
     *            Technical type
     */
    public void setBOMTechnicalType( @Nullable final String bOMTechnicalType )
    {
        rememberChangedField("BOMTechnicalType", this.bOMTechnicalType);
        this.bOMTechnicalType = bOMTechnicalType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>BOMGroup</b>
     * </p>
     *
     * @param bOMGroup
     *            BOM group
     */
    public void setBOMGroup( @Nullable final String bOMGroup )
    {
        rememberChangedField("BOMGroup", this.bOMGroup);
        this.bOMGroup = bOMGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BOMHeaderText</b>
     * </p>
     *
     * @param bOMHeaderText
     *            BOM Description
     */
    public void setBOMHeaderText( @Nullable final String bOMHeaderText )
    {
        rememberChangedField("BOMHeaderText", this.bOMHeaderText);
        this.bOMHeaderText = bOMHeaderText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BOMAlternativeText</b>
     * </p>
     *
     * @param bOMAlternativeText
     *            Alternative BOM Text
     */
    public void setBOMAlternativeText( @Nullable final String bOMAlternativeText )
    {
        rememberChangedField("BOMAlternativeText", this.bOMAlternativeText);
        this.bOMAlternativeText = bOMAlternativeText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialStatus</b>
     * </p>
     *
     * @param billOfMaterialStatus
     *            Bill of Material Status
     */
    public void setBillOfMaterialStatus( @Nullable final String billOfMaterialStatus )
    {
        rememberChangedField("BillOfMaterialStatus", this.billOfMaterialStatus);
        this.billOfMaterialStatus = billOfMaterialStatus;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>HeaderValidityStartDate</b>
     * </p>
     *
     * @param headerValidityStartDate
     *            Valid-From Date
     */
    public void setHeaderValidityStartDate( @Nullable final LocalDateTime headerValidityStartDate )
    {
        rememberChangedField("HeaderValidityStartDate", this.headerValidityStartDate);
        this.headerValidityStartDate = headerValidityStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>HeaderValidityEndDate</b>
     * </p>
     *
     * @param headerValidityEndDate
     *            Valid-to date
     */
    public void setHeaderValidityEndDate( @Nullable final LocalDateTime headerValidityEndDate )
    {
        rememberChangedField("HeaderValidityEndDate", this.headerValidityEndDate);
        this.headerValidityEndDate = headerValidityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChgToEngineeringChgDocument</b>
     * </p>
     *
     * @param chgToEngineeringChgDocument
     *            Change Number To
     */
    public void setChgToEngineeringChgDocument( @Nullable final String chgToEngineeringChgDocument )
    {
        rememberChangedField("ChgToEngineeringChgDocument", this.chgToEngineeringChgDocument);
        this.chgToEngineeringChgDocument = chgToEngineeringChgDocument;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsMarkedForDeletion</b>
     * </p>
     *
     * @param isMarkedForDeletion
     *            Deletion Indicator
     */
    public void setIsMarkedForDeletion( @Nullable final Boolean isMarkedForDeletion )
    {
        rememberChangedField("IsMarkedForDeletion", this.isMarkedForDeletion);
        this.isMarkedForDeletion = isMarkedForDeletion;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsALE</b>
     * </p>
     *
     * @param isALE
     *            ALE indicator
     */
    public void setIsALE( @Nullable final Boolean isALE )
    {
        rememberChangedField("IsALE", this.isALE);
        this.isALE = isALE;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MatFromLotSizeQuantity</b>
     * </p>
     *
     * @param matFromLotSizeQuantity
     *            From Lot Size
     */
    public void setMatFromLotSizeQuantity( @Nullable final BigDecimal matFromLotSizeQuantity )
    {
        rememberChangedField("MatFromLotSizeQuantity", this.matFromLotSizeQuantity);
        this.matFromLotSizeQuantity = matFromLotSizeQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaterialToLotSizeQuantity</b>
     * </p>
     *
     * @param materialToLotSizeQuantity
     *            To Lot Size
     */
    public void setMaterialToLotSizeQuantity( @Nullable final BigDecimal materialToLotSizeQuantity )
    {
        rememberChangedField("MaterialToLotSizeQuantity", this.materialToLotSizeQuantity);
        this.materialToLotSizeQuantity = materialToLotSizeQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BOMHeaderBaseUnit</b>
     * </p>
     *
     * @param bOMHeaderBaseUnit
     *            Base Unit of Measure for BOM
     */
    public void setBOMHeaderBaseUnit( @Nullable final String bOMHeaderBaseUnit )
    {
        rememberChangedField("BOMHeaderBaseUnit", this.bOMHeaderBaseUnit);
        this.bOMHeaderBaseUnit = bOMHeaderBaseUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BOMHeaderQuantityInBaseUnit</b>
     * </p>
     *
     * @param bOMHeaderQuantityInBaseUnit
     *            Base quantity
     */
    public void setBOMHeaderQuantityInBaseUnit( @Nullable final BigDecimal bOMHeaderQuantityInBaseUnit )
    {
        rememberChangedField("BOMHeaderQuantityInBaseUnit", this.bOMHeaderQuantityInBaseUnit);
        this.bOMHeaderQuantityInBaseUnit = bOMHeaderQuantityInBaseUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RecordCreationDate</b>
     * </p>
     *
     * @param recordCreationDate
     *            Date Record Created On
     */
    public void setRecordCreationDate( @Nullable final LocalDateTime recordCreationDate )
    {
        rememberChangedField("RecordCreationDate", this.recordCreationDate);
        this.recordCreationDate = recordCreationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Last Changed On
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            User Who Created Record
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Name of Person Who Changed Object
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BOMIsToBeDeleted</b>
     * </p>
     *
     * @param bOMIsToBeDeleted
     *            Handling Deletion Flag During BOM Explosion
     */
    public void setBOMIsToBeDeleted( @Nullable final String bOMIsToBeDeleted )
    {
        rememberChangedField("BOMIsToBeDeleted", this.bOMIsToBeDeleted);
        this.bOMIsToBeDeleted = bOMIsToBeDeleted;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DocumentIsCreatedByCAD</b>
     * </p>
     *
     * @param documentIsCreatedByCAD
     *            CAD Indicator
     */
    public void setDocumentIsCreatedByCAD( @Nullable final Boolean documentIsCreatedByCAD )
    {
        rememberChangedField("DocumentIsCreatedByCAD", this.documentIsCreatedByCAD);
        this.documentIsCreatedByCAD = documentIsCreatedByCAD;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>LaboratoryOrDesignOffice</b>
     * </p>
     *
     * @param laboratoryOrDesignOffice
     *            Laboratory/Design Office
     */
    public void setLaboratoryOrDesignOffice( @Nullable final String laboratoryOrDesignOffice )
    {
        rememberChangedField("LaboratoryOrDesignOffice", this.laboratoryOrDesignOffice);
        this.laboratoryOrDesignOffice = laboratoryOrDesignOffice;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProductDescription</b>
     * </p>
     *
     * @param productDescription
     *            Product Description
     */
    public void setProductDescription( @Nullable final String productDescription )
    {
        rememberChangedField("ProductDescription", this.productDescription);
        this.productDescription = productDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PlantName</b>
     * </p>
     *
     * @param plantName
     *            Plant Name
     */
    public void setPlantName( @Nullable final String plantName )
    {
        rememberChangedField("PlantName", this.plantName);
        this.plantName = plantName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialHdrDetailsText</b>
     * </p>
     *
     * @param billOfMaterialHdrDetailsText
     *            The billOfMaterialHdrDetailsText to set.
     */
    public void setBillOfMaterialHdrDetailsText( @Nullable final String billOfMaterialHdrDetailsText )
    {
        rememberChangedField("BillOfMaterialHdrDetailsText", this.billOfMaterialHdrDetailsText);
        this.billOfMaterialHdrDetailsText = billOfMaterialHdrDetailsText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SelectedBillOfMaterialVersion</b>
     * </p>
     *
     * @param selectedBillOfMaterialVersion
     *            The selectedBillOfMaterialVersion to set.
     */
    public void setSelectedBillOfMaterialVersion( @Nullable final String selectedBillOfMaterialVersion )
    {
        rememberChangedField("SelectedBillOfMaterialVersion", this.selectedBillOfMaterialVersion);
        this.selectedBillOfMaterialVersion = selectedBillOfMaterialVersion;
    }

    @Override
    protected String getEntityCollection()
    {
        return "MaterialBOM";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BillOfMaterial", getBillOfMaterial());
        result.put("BillOfMaterialCategory", getBillOfMaterialCategory());
        result.put("BillOfMaterialVariant", getBillOfMaterialVariant());
        result.put("BillOfMaterialVersion", getBillOfMaterialVersion());
        result.put("EngineeringChangeDocument", getEngineeringChangeDocument());
        result.put("Material", getMaterial());
        result.put("Plant", getPlant());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("DeleteBOMHeaderWithECN_ac", getDeleteBOMHeaderWithECN_ac());
        values.put("ReleaseVersionBOM_ac", getReleaseVersionBOM_ac());
        values.put("Delete_mc", getDelete_mc());
        values.put("Update_mc", getUpdate_mc());
        values.put("to_BillOfMaterialItem_oc", getBillOfMaterialItem_oc());
        values.put("BillOfMaterial", getBillOfMaterial());
        values.put("BillOfMaterialCategory", getBillOfMaterialCategory());
        values.put("BillOfMaterialVariant", getBillOfMaterialVariant());
        values.put("BillOfMaterialVersion", getBillOfMaterialVersion());
        values.put("EngineeringChangeDocument", getEngineeringChangeDocument());
        values.put("Material", getMaterial());
        values.put("Plant", getPlant());
        values.put("BillOfMaterialHeaderUUID", getBillOfMaterialHeaderUUID());
        values.put("BillOfMaterialVariantUsage", getBillOfMaterialVariantUsage());
        values.put("EngineeringChangeDocForEdit", getEngineeringChangeDocForEdit());
        values.put("IsMultipleBOMAlt", getIsMultipleBOMAlt());
        values.put("BOMHeaderInternalChangeCount", getBOMHeaderInternalChangeCount());
        values.put("BOMUsagePriority", getBOMUsagePriority());
        values.put("BillOfMaterialAuthsnGrp", getBillOfMaterialAuthsnGrp());
        values.put("BOMVersionStatus", getBOMVersionStatus());
        values.put("IsVersionBillOfMaterial", getIsVersionBillOfMaterial());
        values.put("IsLatestBOMVersion", getIsLatestBOMVersion());
        values.put("IsConfiguredMaterial", getIsConfiguredMaterial());
        values.put("BOMTechnicalType", getBOMTechnicalType());
        values.put("BOMGroup", getBOMGroup());
        values.put("BOMHeaderText", getBOMHeaderText());
        values.put("BOMAlternativeText", getBOMAlternativeText());
        values.put("BillOfMaterialStatus", getBillOfMaterialStatus());
        values.put("HeaderValidityStartDate", getHeaderValidityStartDate());
        values.put("HeaderValidityEndDate", getHeaderValidityEndDate());
        values.put("ChgToEngineeringChgDocument", getChgToEngineeringChgDocument());
        values.put("IsMarkedForDeletion", getIsMarkedForDeletion());
        values.put("IsALE", getIsALE());
        values.put("MatFromLotSizeQuantity", getMatFromLotSizeQuantity());
        values.put("MaterialToLotSizeQuantity", getMaterialToLotSizeQuantity());
        values.put("BOMHeaderBaseUnit", getBOMHeaderBaseUnit());
        values.put("BOMHeaderQuantityInBaseUnit", getBOMHeaderQuantityInBaseUnit());
        values.put("RecordCreationDate", getRecordCreationDate());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("BOMIsToBeDeleted", getBOMIsToBeDeleted());
        values.put("DocumentIsCreatedByCAD", getDocumentIsCreatedByCAD());
        values.put("LaboratoryOrDesignOffice", getLaboratoryOrDesignOffice());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("ProductDescription", getProductDescription());
        values.put("PlantName", getPlantName());
        values.put("BillOfMaterialHdrDetailsText", getBillOfMaterialHdrDetailsText());
        values.put("SelectedBillOfMaterialVersion", getSelectedBillOfMaterialVersion());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("DeleteBOMHeaderWithECN_ac") ) {
                final Object value = values.remove("DeleteBOMHeaderWithECN_ac");
                if( (value == null) || (!value.equals(getDeleteBOMHeaderWithECN_ac())) ) {
                    setDeleteBOMHeaderWithECN_ac(((Boolean) value));
                }
            }
            if( values.containsKey("ReleaseVersionBOM_ac") ) {
                final Object value = values.remove("ReleaseVersionBOM_ac");
                if( (value == null) || (!value.equals(getReleaseVersionBOM_ac())) ) {
                    setReleaseVersionBOM_ac(((Boolean) value));
                }
            }
            if( values.containsKey("Delete_mc") ) {
                final Object value = values.remove("Delete_mc");
                if( (value == null) || (!value.equals(getDelete_mc())) ) {
                    setDelete_mc(((Boolean) value));
                }
            }
            if( values.containsKey("Update_mc") ) {
                final Object value = values.remove("Update_mc");
                if( (value == null) || (!value.equals(getUpdate_mc())) ) {
                    setUpdate_mc(((Boolean) value));
                }
            }
            if( values.containsKey("to_BillOfMaterialItem_oc") ) {
                final Object value = values.remove("to_BillOfMaterialItem_oc");
                if( (value == null) || (!value.equals(getBillOfMaterialItem_oc())) ) {
                    setBillOfMaterialItem_oc(((Boolean) value));
                }
            }
            if( values.containsKey("BillOfMaterial") ) {
                final Object value = values.remove("BillOfMaterial");
                if( (value == null) || (!value.equals(getBillOfMaterial())) ) {
                    setBillOfMaterial(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialCategory") ) {
                final Object value = values.remove("BillOfMaterialCategory");
                if( (value == null) || (!value.equals(getBillOfMaterialCategory())) ) {
                    setBillOfMaterialCategory(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialVariant") ) {
                final Object value = values.remove("BillOfMaterialVariant");
                if( (value == null) || (!value.equals(getBillOfMaterialVariant())) ) {
                    setBillOfMaterialVariant(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialVersion") ) {
                final Object value = values.remove("BillOfMaterialVersion");
                if( (value == null) || (!value.equals(getBillOfMaterialVersion())) ) {
                    setBillOfMaterialVersion(((String) value));
                }
            }
            if( values.containsKey("EngineeringChangeDocument") ) {
                final Object value = values.remove("EngineeringChangeDocument");
                if( (value == null) || (!value.equals(getEngineeringChangeDocument())) ) {
                    setEngineeringChangeDocument(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialHeaderUUID") ) {
                final Object value = values.remove("BillOfMaterialHeaderUUID");
                if( (value == null) || (!value.equals(getBillOfMaterialHeaderUUID())) ) {
                    setBillOfMaterialHeaderUUID(((UUID) value));
                }
            }
            if( values.containsKey("BillOfMaterialVariantUsage") ) {
                final Object value = values.remove("BillOfMaterialVariantUsage");
                if( (value == null) || (!value.equals(getBillOfMaterialVariantUsage())) ) {
                    setBillOfMaterialVariantUsage(((String) value));
                }
            }
            if( values.containsKey("EngineeringChangeDocForEdit") ) {
                final Object value = values.remove("EngineeringChangeDocForEdit");
                if( (value == null) || (!value.equals(getEngineeringChangeDocForEdit())) ) {
                    setEngineeringChangeDocForEdit(((String) value));
                }
            }
            if( values.containsKey("IsMultipleBOMAlt") ) {
                final Object value = values.remove("IsMultipleBOMAlt");
                if( (value == null) || (!value.equals(getIsMultipleBOMAlt())) ) {
                    setIsMultipleBOMAlt(((Boolean) value));
                }
            }
            if( values.containsKey("BOMHeaderInternalChangeCount") ) {
                final Object value = values.remove("BOMHeaderInternalChangeCount");
                if( (value == null) || (!value.equals(getBOMHeaderInternalChangeCount())) ) {
                    setBOMHeaderInternalChangeCount(((String) value));
                }
            }
            if( values.containsKey("BOMUsagePriority") ) {
                final Object value = values.remove("BOMUsagePriority");
                if( (value == null) || (!value.equals(getBOMUsagePriority())) ) {
                    setBOMUsagePriority(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialAuthsnGrp") ) {
                final Object value = values.remove("BillOfMaterialAuthsnGrp");
                if( (value == null) || (!value.equals(getBillOfMaterialAuthsnGrp())) ) {
                    setBillOfMaterialAuthsnGrp(((String) value));
                }
            }
            if( values.containsKey("BOMVersionStatus") ) {
                final Object value = values.remove("BOMVersionStatus");
                if( (value == null) || (!value.equals(getBOMVersionStatus())) ) {
                    setBOMVersionStatus(((String) value));
                }
            }
            if( values.containsKey("IsVersionBillOfMaterial") ) {
                final Object value = values.remove("IsVersionBillOfMaterial");
                if( (value == null) || (!value.equals(getIsVersionBillOfMaterial())) ) {
                    setIsVersionBillOfMaterial(((Boolean) value));
                }
            }
            if( values.containsKey("IsLatestBOMVersion") ) {
                final Object value = values.remove("IsLatestBOMVersion");
                if( (value == null) || (!value.equals(getIsLatestBOMVersion())) ) {
                    setIsLatestBOMVersion(((Boolean) value));
                }
            }
            if( values.containsKey("IsConfiguredMaterial") ) {
                final Object value = values.remove("IsConfiguredMaterial");
                if( (value == null) || (!value.equals(getIsConfiguredMaterial())) ) {
                    setIsConfiguredMaterial(((Boolean) value));
                }
            }
            if( values.containsKey("BOMTechnicalType") ) {
                final Object value = values.remove("BOMTechnicalType");
                if( (value == null) || (!value.equals(getBOMTechnicalType())) ) {
                    setBOMTechnicalType(((String) value));
                }
            }
            if( values.containsKey("BOMGroup") ) {
                final Object value = values.remove("BOMGroup");
                if( (value == null) || (!value.equals(getBOMGroup())) ) {
                    setBOMGroup(((String) value));
                }
            }
            if( values.containsKey("BOMHeaderText") ) {
                final Object value = values.remove("BOMHeaderText");
                if( (value == null) || (!value.equals(getBOMHeaderText())) ) {
                    setBOMHeaderText(((String) value));
                }
            }
            if( values.containsKey("BOMAlternativeText") ) {
                final Object value = values.remove("BOMAlternativeText");
                if( (value == null) || (!value.equals(getBOMAlternativeText())) ) {
                    setBOMAlternativeText(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialStatus") ) {
                final Object value = values.remove("BillOfMaterialStatus");
                if( (value == null) || (!value.equals(getBillOfMaterialStatus())) ) {
                    setBillOfMaterialStatus(((String) value));
                }
            }
            if( values.containsKey("HeaderValidityStartDate") ) {
                final Object value = values.remove("HeaderValidityStartDate");
                if( (value == null) || (!value.equals(getHeaderValidityStartDate())) ) {
                    setHeaderValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("HeaderValidityEndDate") ) {
                final Object value = values.remove("HeaderValidityEndDate");
                if( (value == null) || (!value.equals(getHeaderValidityEndDate())) ) {
                    setHeaderValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ChgToEngineeringChgDocument") ) {
                final Object value = values.remove("ChgToEngineeringChgDocument");
                if( (value == null) || (!value.equals(getChgToEngineeringChgDocument())) ) {
                    setChgToEngineeringChgDocument(((String) value));
                }
            }
            if( values.containsKey("IsMarkedForDeletion") ) {
                final Object value = values.remove("IsMarkedForDeletion");
                if( (value == null) || (!value.equals(getIsMarkedForDeletion())) ) {
                    setIsMarkedForDeletion(((Boolean) value));
                }
            }
            if( values.containsKey("IsALE") ) {
                final Object value = values.remove("IsALE");
                if( (value == null) || (!value.equals(getIsALE())) ) {
                    setIsALE(((Boolean) value));
                }
            }
            if( values.containsKey("MatFromLotSizeQuantity") ) {
                final Object value = values.remove("MatFromLotSizeQuantity");
                if( (value == null) || (!value.equals(getMatFromLotSizeQuantity())) ) {
                    setMatFromLotSizeQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaterialToLotSizeQuantity") ) {
                final Object value = values.remove("MaterialToLotSizeQuantity");
                if( (value == null) || (!value.equals(getMaterialToLotSizeQuantity())) ) {
                    setMaterialToLotSizeQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("BOMHeaderBaseUnit") ) {
                final Object value = values.remove("BOMHeaderBaseUnit");
                if( (value == null) || (!value.equals(getBOMHeaderBaseUnit())) ) {
                    setBOMHeaderBaseUnit(((String) value));
                }
            }
            if( values.containsKey("BOMHeaderQuantityInBaseUnit") ) {
                final Object value = values.remove("BOMHeaderQuantityInBaseUnit");
                if( (value == null) || (!value.equals(getBOMHeaderQuantityInBaseUnit())) ) {
                    setBOMHeaderQuantityInBaseUnit(((BigDecimal) value));
                }
            }
            if( values.containsKey("RecordCreationDate") ) {
                final Object value = values.remove("RecordCreationDate");
                if( (value == null) || (!value.equals(getRecordCreationDate())) ) {
                    setRecordCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("BOMIsToBeDeleted") ) {
                final Object value = values.remove("BOMIsToBeDeleted");
                if( (value == null) || (!value.equals(getBOMIsToBeDeleted())) ) {
                    setBOMIsToBeDeleted(((String) value));
                }
            }
            if( values.containsKey("DocumentIsCreatedByCAD") ) {
                final Object value = values.remove("DocumentIsCreatedByCAD");
                if( (value == null) || (!value.equals(getDocumentIsCreatedByCAD())) ) {
                    setDocumentIsCreatedByCAD(((Boolean) value));
                }
            }
            if( values.containsKey("LaboratoryOrDesignOffice") ) {
                final Object value = values.remove("LaboratoryOrDesignOffice");
                if( (value == null) || (!value.equals(getLaboratoryOrDesignOffice())) ) {
                    setLaboratoryOrDesignOffice(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("ProductDescription") ) {
                final Object value = values.remove("ProductDescription");
                if( (value == null) || (!value.equals(getProductDescription())) ) {
                    setProductDescription(((String) value));
                }
            }
            if( values.containsKey("PlantName") ) {
                final Object value = values.remove("PlantName");
                if( (value == null) || (!value.equals(getPlantName())) ) {
                    setPlantName(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialHdrDetailsText") ) {
                final Object value = values.remove("BillOfMaterialHdrDetailsText");
                if( (value == null) || (!value.equals(getBillOfMaterialHdrDetailsText())) ) {
                    setBillOfMaterialHdrDetailsText(((String) value));
                }
            }
            if( values.containsKey("SelectedBillOfMaterialVersion") ) {
                final Object value = values.remove("SelectedBillOfMaterialVersion");
                if( (value == null) || (!value.equals(getSelectedBillOfMaterialVersion())) ) {
                    setSelectedBillOfMaterialVersion(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_BillOfMaterialItem") ) {
                final Object value = (values).remove("to_BillOfMaterialItem");
                if( value instanceof Iterable ) {
                    if( toBillOfMaterialItem == null ) {
                        toBillOfMaterialItem = Lists.newArrayList();
                    } else {
                        toBillOfMaterialItem = Lists.newArrayList(toBillOfMaterialItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MaterialBOMItem entity;
                        if( toBillOfMaterialItem.size() > i ) {
                            entity = toBillOfMaterialItem.get(i);
                        } else {
                            entity = new MaterialBOMItem();
                            toBillOfMaterialItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_BillOfMaterialUsage") ) {
                final Object value = (values).remove("to_BillOfMaterialUsage");
                if( value instanceof Map ) {
                    if( toBillOfMaterialUsage == null ) {
                        toBillOfMaterialUsage = new BillOfMaterialUsage();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBillOfMaterialUsage.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> MaterialBOMField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new MaterialBOMField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MaterialBOMField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MaterialBOMField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillOfMaterialsV2Service.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBillOfMaterialItem != null ) {
            (values).put("to_BillOfMaterialItem", toBillOfMaterialItem);
        }
        if( toBillOfMaterialUsage != null ) {
            (values).put("to_BillOfMaterialUsage", toBillOfMaterialUsage);
        }
        return values;
    }

    /**
     * Fetches the <b>MaterialBOMItem</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_BillOfMaterialItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>MaterialBOMItem</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaterialBOMItem> fetchBillOfMaterialItem()
    {
        return fetchFieldAsList("to_BillOfMaterialItem", MaterialBOMItem.class);
    }

    /**
     * Retrieval of associated <b>MaterialBOMItem</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_BillOfMaterialItem</b>.
     * <p>
     * If the navigation property <b>to_BillOfMaterialItem</b> of a queried <b>MaterialBOM</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaterialBOMItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaterialBOMItem> getBillOfMaterialItemOrFetch()
    {
        if( toBillOfMaterialItem == null ) {
            toBillOfMaterialItem = fetchBillOfMaterialItem();
        }
        return toBillOfMaterialItem;
    }

    /**
     * Retrieval of associated <b>MaterialBOMItem</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_BillOfMaterialItem</b>.
     * <p>
     * If the navigation property for an entity <b>MaterialBOM</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BillOfMaterialItem</b> is already loaded, the result
     *         will contain the <b>MaterialBOMItem</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<MaterialBOMItem>> getBillOfMaterialItemIfPresent()
    {
        return Option.of(toBillOfMaterialItem);
    }

    /**
     * Overwrites the list of associated <b>MaterialBOMItem</b> entities for the loaded navigation property
     * <b>to_BillOfMaterialItem</b>.
     * <p>
     * If the navigation property <b>to_BillOfMaterialItem</b> of a queried <b>MaterialBOM</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>MaterialBOMItem</b> entities.
     */
    public void setBillOfMaterialItem( @Nonnull final List<MaterialBOMItem> value )
    {
        if( toBillOfMaterialItem == null ) {
            toBillOfMaterialItem = Lists.newArrayList();
        }
        toBillOfMaterialItem.clear();
        toBillOfMaterialItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MaterialBOMItem</b> entities. This corresponds to the OData navigation
     * property <b>to_BillOfMaterialItem</b>.
     * <p>
     * If the navigation property <b>to_BillOfMaterialItem</b> of a queried <b>MaterialBOM</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>MaterialBOMItem</b> entities.
     */
    public void addBillOfMaterialItem( MaterialBOMItem... entity )
    {
        if( toBillOfMaterialItem == null ) {
            toBillOfMaterialItem = Lists.newArrayList();
        }
        toBillOfMaterialItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BillOfMaterialUsage</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_BillOfMaterialUsage</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BillOfMaterialUsage</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BillOfMaterialUsage fetchBillOfMaterialUsage()
    {
        return fetchFieldAsSingle("to_BillOfMaterialUsage", BillOfMaterialUsage.class);
    }

    /**
     * Retrieval of associated <b>BillOfMaterialUsage</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BillOfMaterialUsage</b>.
     * <p>
     * If the navigation property <b>to_BillOfMaterialUsage</b> of a queried <b>MaterialBOM</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BillOfMaterialUsage</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BillOfMaterialUsage getBillOfMaterialUsageOrFetch()
    {
        if( toBillOfMaterialUsage == null ) {
            toBillOfMaterialUsage = fetchBillOfMaterialUsage();
        }
        return toBillOfMaterialUsage;
    }

    /**
     * Retrieval of associated <b>BillOfMaterialUsage</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BillOfMaterialUsage</b>.
     * <p>
     * If the navigation property for an entity <b>MaterialBOM</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BillOfMaterialUsage</b> is already loaded, the result
     *         will contain the <b>BillOfMaterialUsage</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<BillOfMaterialUsage> getBillOfMaterialUsageIfPresent()
    {
        return Option.of(toBillOfMaterialUsage);
    }

    /**
     * Overwrites the associated <b>BillOfMaterialUsage</b> entity for the loaded navigation property
     * <b>to_BillOfMaterialUsage</b>.
     *
     * @param value
     *            New <b>BillOfMaterialUsage</b> entity.
     */
    public void setBillOfMaterialUsage( final BillOfMaterialUsage value )
    {
        toBillOfMaterialUsage = value;
    }

    /**
     * Helper class to allow for fluent creation of MaterialBOM instances.
     *
     */
    public final static class MaterialBOMBuilder
    {

        private List<MaterialBOMItem> toBillOfMaterialItem = Lists.newArrayList();
        private BillOfMaterialUsage toBillOfMaterialUsage;

        private MaterialBOM.MaterialBOMBuilder toBillOfMaterialItem( final List<MaterialBOMItem> value )
        {
            toBillOfMaterialItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_BillOfMaterialItem</b> for <b>MaterialBOM</b> to multiple <b>MaterialBOMItem</b>.
         *
         * @param value
         *            The MaterialBOMItems to build this MaterialBOM with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaterialBOM.MaterialBOMBuilder billOfMaterialItem( MaterialBOMItem... value )
        {
            return toBillOfMaterialItem(Lists.newArrayList(value));
        }

        private MaterialBOM.MaterialBOMBuilder toBillOfMaterialUsage( final BillOfMaterialUsage value )
        {
            toBillOfMaterialUsage = value;
            return this;
        }

        /**
         * Navigation property <b>to_BillOfMaterialUsage</b> for <b>MaterialBOM</b> to single
         * <b>BillOfMaterialUsage</b>.
         *
         * @param value
         *            The BillOfMaterialUsage to build this MaterialBOM with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaterialBOM.MaterialBOMBuilder billOfMaterialUsage( final BillOfMaterialUsage value )
        {
            return toBillOfMaterialUsage(value);
        }

    }

}
