/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.field.MaterialBOMItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.link.MaterialBOMItemLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.link.MaterialBOMItemOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.selectable.MaterialBOMItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MaterialBOMItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MaterialBOMItem extends VdmEntity<MaterialBOMItem>
{

    /**
     * Selector for all available fields of MaterialBOMItem.
     *
     */
    public final static MaterialBOMItemSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ConvertItem_ac</b>
     * </p>
     *
     * @return Dyn. Action Control
     */
    @SerializedName( "ConvertItem_ac" )
    @JsonProperty( "ConvertItem_ac" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ConvertItem_ac" )
    private Boolean convertItem_ac;
    /**
     * Use with available fluent helpers to apply the <b>ConvertItem_ac</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<Boolean> CONVERT_ITEM_AC =
        new MaterialBOMItemField<Boolean>("ConvertItem_ac");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DeleteBOMItemWithECN_ac</b>
     * </p>
     *
     * @return Dyn. Action Control
     */
    @SerializedName( "DeleteBOMItemWithECN_ac" )
    @JsonProperty( "DeleteBOMItemWithECN_ac" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "DeleteBOMItemWithECN_ac" )
    private Boolean deleteBOMItemWithECN_ac;
    /**
     * Use with available fluent helpers to apply the <b>DeleteBOMItemWithECN_ac</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<Boolean> DELETE_BOM_ITEM_WITH_ECN_AC =
        new MaterialBOMItemField<Boolean>("DeleteBOMItemWithECN_ac");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>UpdateBOMItemWithECN_ac</b>
     * </p>
     *
     * @return Dyn. Action Control
     */
    @SerializedName( "UpdateBOMItemWithECN_ac" )
    @JsonProperty( "UpdateBOMItemWithECN_ac" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "UpdateBOMItemWithECN_ac" )
    private Boolean updateBOMItemWithECN_ac;
    /**
     * Use with available fluent helpers to apply the <b>UpdateBOMItemWithECN_ac</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<Boolean> UPDATE_BOM_ITEM_WITH_ECN_AC =
        new MaterialBOMItemField<Boolean>("UpdateBOMItemWithECN_ac");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Delete_mc" )
    @JsonProperty( "Delete_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Delete_mc" )
    private Boolean delete_mc;
    /**
     * Use with available fluent helpers to apply the <b>Delete_mc</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<Boolean> DELETE_MC = new MaterialBOMItemField<Boolean>("Delete_mc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Update_mc" )
    @JsonProperty( "Update_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Update_mc" )
    private Boolean update_mc;
    /**
     * Use with available fluent helpers to apply the <b>Update_mc</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<Boolean> UPDATE_MC = new MaterialBOMItemField<Boolean>("Update_mc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_BOMItmObjDependencyAssignment_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_BOMItmObjDependencyAssignment_oc" )
    @JsonProperty( "to_BOMItmObjDependencyAssignment_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_BOMItmObjDependencyAssignment_oc" )
    private Boolean bOMItmObjDependencyAssignment_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_BOMItmObjDependencyAssignment_oc</b> field to query
     * operations.
     *
     */
    public final static MaterialBOMItemField<Boolean> BOM_ITM_OBJ_DEPENDENCY_ASSIGNMENT_OC =
        new MaterialBOMItemField<Boolean>("to_BOMItmObjDependencyAssignment_oc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_BOMSubItems_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_BOMSubItems_oc" )
    @JsonProperty( "to_BOMSubItems_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_BOMSubItems_oc" )
    private Boolean bOMSubItems_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_BOMSubItems_oc</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<Boolean> BOM_SUB_ITEMS_OC =
        new MaterialBOMItemField<Boolean>("to_BOMSubItems_oc");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterial</b>
     * </p>
     *
     * @return Bill of Material
     */
    @Key
    @SerializedName( "BillOfMaterial" )
    @JsonProperty( "BillOfMaterial" )
    @Nullable
    @ODataField( odataName = "BillOfMaterial" )
    private String billOfMaterial;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterial</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> BILL_OF_MATERIAL =
        new MaterialBOMItemField<String>("BillOfMaterial");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialCategory</b>
     * </p>
     *
     * @return BOM category
     */
    @Key
    @SerializedName( "BillOfMaterialCategory" )
    @JsonProperty( "BillOfMaterialCategory" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialCategory" )
    private String billOfMaterialCategory;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialCategory</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> BILL_OF_MATERIAL_CATEGORY =
        new MaterialBOMItemField<String>("BillOfMaterialCategory");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialVariant</b>
     * </p>
     *
     * @return Alternative BOM
     */
    @Key
    @SerializedName( "BillOfMaterialVariant" )
    @JsonProperty( "BillOfMaterialVariant" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialVariant" )
    private String billOfMaterialVariant;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialVariant</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> BILL_OF_MATERIAL_VARIANT =
        new MaterialBOMItemField<String>("BillOfMaterialVariant");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialVersion</b>
     * </p>
     *
     * @return BOM Version
     */
    @Key
    @SerializedName( "BillOfMaterialVersion" )
    @JsonProperty( "BillOfMaterialVersion" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialVersion" )
    private String billOfMaterialVersion;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialVersion</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> BILL_OF_MATERIAL_VERSION =
        new MaterialBOMItemField<String>("BillOfMaterialVersion");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemNodeNumber</b>
     * </p>
     *
     * @return BOM item node number
     */
    @Key
    @SerializedName( "BillOfMaterialItemNodeNumber" )
    @JsonProperty( "BillOfMaterialItemNodeNumber" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialItemNodeNumber" )
    private String billOfMaterialItemNodeNumber;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialItemNodeNumber</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> BILL_OF_MATERIAL_ITEM_NODE_NUMBER =
        new MaterialBOMItemField<String>("BillOfMaterialItemNodeNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>HeaderChangeDocument</b>
     * </p>
     *
     * @return Change Number
     */
    @Key
    @SerializedName( "HeaderChangeDocument" )
    @JsonProperty( "HeaderChangeDocument" )
    @Nullable
    @ODataField( odataName = "HeaderChangeDocument" )
    private String headerChangeDocument;
    /**
     * Use with available fluent helpers to apply the <b>HeaderChangeDocument</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> HEADER_CHANGE_DOCUMENT =
        new MaterialBOMItemField<String>("HeaderChangeDocument");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @Key
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> MATERIAL = new MaterialBOMItemField<String>("Material");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @Key
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> PLANT = new MaterialBOMItemField<String>("Plant");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemUUID</b>
     * </p>
     *
     * @return Global identification of an item's change status
     */
    @SerializedName( "BillOfMaterialItemUUID" )
    @JsonProperty( "BillOfMaterialItemUUID" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialItemUUID" )
    private UUID billOfMaterialItemUUID;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialItemUUID</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<UUID> BILL_OF_MATERIAL_ITEM_UUID =
        new MaterialBOMItemField<UUID>("BillOfMaterialItemUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialHeaderUUID</b>
     * </p>
     *
     * @return Global identification of a BOM header change status
     */
    @SerializedName( "BillOfMaterialHeaderUUID" )
    @JsonProperty( "BillOfMaterialHeaderUUID" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialHeaderUUID" )
    private UUID billOfMaterialHeaderUUID;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialHeaderUUID</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<UUID> BILL_OF_MATERIAL_HEADER_UUID =
        new MaterialBOMItemField<UUID>("BillOfMaterialHeaderUUID");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemInternalChangeCount</b>
     * </p>
     *
     * @return Internal counter
     */
    @SerializedName( "BOMItemInternalChangeCount" )
    @JsonProperty( "BOMItemInternalChangeCount" )
    @Nullable
    @ODataField( odataName = "BOMItemInternalChangeCount" )
    private String bOMItemInternalChangeCount;
    /**
     * Use with available fluent helpers to apply the <b>BOMItemInternalChangeCount</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> BOM_ITEM_INTERNAL_CHANGE_COUNT =
        new MaterialBOMItemField<String>("BOMItemInternalChangeCount");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Valid-From Date
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<LocalDateTime> VALIDITY_START_DATE =
        new MaterialBOMItemField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Valid-to date
     */
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<LocalDateTime> VALIDITY_END_DATE =
        new MaterialBOMItemField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>EngineeringChangeDocForEdit</b>
     * </p>
     *
     * @return Change Number
     */
    @SerializedName( "EngineeringChangeDocForEdit" )
    @JsonProperty( "EngineeringChangeDocForEdit" )
    @Nullable
    @ODataField( odataName = "EngineeringChangeDocForEdit" )
    private String engineeringChangeDocForEdit;
    /**
     * Use with available fluent helpers to apply the <b>EngineeringChangeDocForEdit</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> ENGINEERING_CHANGE_DOC_FOR_EDIT =
        new MaterialBOMItemField<String>("EngineeringChangeDocForEdit");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>EngineeringChangeDocument</b>
     * </p>
     *
     * @return Change Number
     */
    @SerializedName( "EngineeringChangeDocument" )
    @JsonProperty( "EngineeringChangeDocument" )
    @Nullable
    @ODataField( odataName = "EngineeringChangeDocument" )
    private String engineeringChangeDocument;
    /**
     * Use with available fluent helpers to apply the <b>EngineeringChangeDocument</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> ENGINEERING_CHANGE_DOCUMENT =
        new MaterialBOMItemField<String>("EngineeringChangeDocument");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChgToEngineeringChgDocument</b>
     * </p>
     *
     * @return Change Number To
     */
    @SerializedName( "ChgToEngineeringChgDocument" )
    @JsonProperty( "ChgToEngineeringChgDocument" )
    @Nullable
    @ODataField( odataName = "ChgToEngineeringChgDocument" )
    private String chgToEngineeringChgDocument;
    /**
     * Use with available fluent helpers to apply the <b>ChgToEngineeringChgDocument</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> CHG_TO_ENGINEERING_CHG_DOCUMENT =
        new MaterialBOMItemField<String>("ChgToEngineeringChgDocument");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InheritedNodeNumberForBOMItem</b>
     * </p>
     *
     * @return Inherited node number of BOM item
     */
    @SerializedName( "InheritedNodeNumberForBOMItem" )
    @JsonProperty( "InheritedNodeNumberForBOMItem" )
    @Nullable
    @ODataField( odataName = "InheritedNodeNumberForBOMItem" )
    private String inheritedNodeNumberForBOMItem;
    /**
     * Use with available fluent helpers to apply the <b>InheritedNodeNumberForBOMItem</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> INHERITED_NODE_NUMBER_FOR_BOM_ITEM =
        new MaterialBOMItemField<String>("InheritedNodeNumberForBOMItem");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemRecordCreationDate</b>
     * </p>
     *
     * @return Date Record Created On
     */
    @SerializedName( "BOMItemRecordCreationDate" )
    @JsonProperty( "BOMItemRecordCreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BOMItemRecordCreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime bOMItemRecordCreationDate;
    /**
     * Use with available fluent helpers to apply the <b>BOMItemRecordCreationDate</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<LocalDateTime> BOM_ITEM_RECORD_CREATION_DATE =
        new MaterialBOMItemField<LocalDateTime>("BOMItemRecordCreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemCreatedByUser</b>
     * </p>
     *
     * @return User Who Created Record
     */
    @SerializedName( "BOMItemCreatedByUser" )
    @JsonProperty( "BOMItemCreatedByUser" )
    @Nullable
    @ODataField( odataName = "BOMItemCreatedByUser" )
    private String bOMItemCreatedByUser;
    /**
     * Use with available fluent helpers to apply the <b>BOMItemCreatedByUser</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> BOM_ITEM_CREATED_BY_USER =
        new MaterialBOMItemField<String>("BOMItemCreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemLastChangeDate</b>
     * </p>
     *
     * @return Last Changed On
     */
    @SerializedName( "BOMItemLastChangeDate" )
    @JsonProperty( "BOMItemLastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BOMItemLastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime bOMItemLastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>BOMItemLastChangeDate</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<LocalDateTime> BOM_ITEM_LAST_CHANGE_DATE =
        new MaterialBOMItemField<LocalDateTime>("BOMItemLastChangeDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemLastChangedByUser</b>
     * </p>
     *
     * @return Name of Person Who Changed Object
     */
    @SerializedName( "BOMItemLastChangedByUser" )
    @JsonProperty( "BOMItemLastChangedByUser" )
    @Nullable
    @ODataField( odataName = "BOMItemLastChangedByUser" )
    private String bOMItemLastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>BOMItemLastChangedByUser</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> BOM_ITEM_LAST_CHANGED_BY_USER =
        new MaterialBOMItemField<String>("BOMItemLastChangedByUser");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialComponent</b>
     * </p>
     *
     * @return BOM component
     */
    @SerializedName( "BillOfMaterialComponent" )
    @JsonProperty( "BillOfMaterialComponent" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialComponent" )
    private String billOfMaterialComponent;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialComponent</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> BILL_OF_MATERIAL_COMPONENT =
        new MaterialBOMItemField<String>("BillOfMaterialComponent");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemCategory</b>
     * </p>
     *
     * @return Item category (bill of material)
     */
    @SerializedName( "BillOfMaterialItemCategory" )
    @JsonProperty( "BillOfMaterialItemCategory" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialItemCategory" )
    private String billOfMaterialItemCategory;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialItemCategory</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> BILL_OF_MATERIAL_ITEM_CATEGORY =
        new MaterialBOMItemField<String>("BillOfMaterialItemCategory");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemNumber</b>
     * </p>
     *
     * @return BOM Item Number
     */
    @SerializedName( "BillOfMaterialItemNumber" )
    @JsonProperty( "BillOfMaterialItemNumber" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialItemNumber" )
    private String billOfMaterialItemNumber;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialItemNumber</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> BILL_OF_MATERIAL_ITEM_NUMBER =
        new MaterialBOMItemField<String>("BillOfMaterialItemNumber");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemUnit</b>
     * </p>
     *
     * @return Component Unit of Measure
     */
    @SerializedName( "BillOfMaterialItemUnit" )
    @JsonProperty( "BillOfMaterialItemUnit" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialItemUnit" )
    private String billOfMaterialItemUnit;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialItemUnit</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> BILL_OF_MATERIAL_ITEM_UNIT =
        new MaterialBOMItemField<String>("BillOfMaterialItemUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemQuantity</b>
     * </p>
     *
     * @return Component Quantity
     */
    @SerializedName( "BillOfMaterialItemQuantity" )
    @JsonProperty( "BillOfMaterialItemQuantity" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialItemQuantity" )
    private BigDecimal billOfMaterialItemQuantity;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialItemQuantity</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<BigDecimal> BILL_OF_MATERIAL_ITEM_QUANTITY =
        new MaterialBOMItemField<BigDecimal>("BillOfMaterialItemQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsAssembly</b>
     * </p>
     *
     * @return Single-Character Flag
     */
    @SerializedName( "IsAssembly" )
    @JsonProperty( "IsAssembly" )
    @Nullable
    @ODataField( odataName = "IsAssembly" )
    private String isAssembly;
    /**
     * Use with available fluent helpers to apply the <b>IsAssembly</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> IS_ASSEMBLY = new MaterialBOMItemField<String>("IsAssembly");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsSubItem</b>
     * </p>
     *
     * @return Indicator: sub-items exist
     */
    @SerializedName( "IsSubItem" )
    @JsonProperty( "IsSubItem" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsSubItem" )
    private Boolean isSubItem;
    /**
     * Use with available fluent helpers to apply the <b>IsSubItem</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<Boolean> IS_SUB_ITEM = new MaterialBOMItemField<Boolean>("IsSubItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemSorter</b>
     * </p>
     *
     * @return Sort String
     */
    @SerializedName( "BOMItemSorter" )
    @JsonProperty( "BOMItemSorter" )
    @Nullable
    @ODataField( odataName = "BOMItemSorter" )
    private String bOMItemSorter;
    /**
     * Use with available fluent helpers to apply the <b>BOMItemSorter</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> BOM_ITEM_SORTER =
        new MaterialBOMItemField<String>("BOMItemSorter");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FixedQuantity</b>
     * </p>
     *
     * @return Fixed Quantity
     */
    @SerializedName( "FixedQuantity" )
    @JsonProperty( "FixedQuantity" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "FixedQuantity" )
    private Boolean fixedQuantity;
    /**
     * Use with available fluent helpers to apply the <b>FixedQuantity</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<Boolean> FIXED_QUANTITY =
        new MaterialBOMItemField<Boolean>("FixedQuantity");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemHasFixedQuantity</b>
     * </p>
     *
     * @return Fixed Quantity
     */
    @SerializedName( "BOMItemHasFixedQuantity" )
    @JsonProperty( "BOMItemHasFixedQuantity" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "BOMItemHasFixedQuantity" )
    private Boolean bOMItemHasFixedQuantity;
    /**
     * Use with available fluent helpers to apply the <b>BOMItemHasFixedQuantity</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<Boolean> BOM_ITEM_HAS_FIXED_QUANTITY =
        new MaterialBOMItemField<Boolean>("BOMItemHasFixedQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     *
     * @return Purchasing Group
     */
    @SerializedName( "PurchasingGroup" )
    @JsonProperty( "PurchasingGroup" )
    @Nullable
    @ODataField( odataName = "PurchasingGroup" )
    private String purchasingGroup;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingGroup</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> PURCHASING_GROUP =
        new MaterialBOMItemField<String>("PurchasingGroup");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "Currency" )
    @JsonProperty( "Currency" )
    @Nullable
    @ODataField( odataName = "Currency" )
    private String currency;
    /**
     * Use with available fluent helpers to apply the <b>Currency</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> CURRENCY = new MaterialBOMItemField<String>("Currency");
    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaterialComponentPrice</b>
     * </p>
     *
     * @return Price
     */
    @SerializedName( "MaterialComponentPrice" )
    @JsonProperty( "MaterialComponentPrice" )
    @Nullable
    @ODataField( odataName = "MaterialComponentPrice" )
    private BigDecimal materialComponentPrice;
    /**
     * Use with available fluent helpers to apply the <b>MaterialComponentPrice</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<BigDecimal> MATERIAL_COMPONENT_PRICE =
        new MaterialBOMItemField<BigDecimal>("MaterialComponentPrice");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>IdentifierBOMItem</b>
     * </p>
     *
     * @return External identification of an item
     */
    @SerializedName( "IdentifierBOMItem" )
    @JsonProperty( "IdentifierBOMItem" )
    @Nullable
    @ODataField( odataName = "IdentifierBOMItem" )
    private String identifierBOMItem;
    /**
     * Use with available fluent helpers to apply the <b>IdentifierBOMItem</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> IDENTIFIER_BOM_ITEM =
        new MaterialBOMItemField<String>("IdentifierBOMItem");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaterialPriceUnitQty</b>
     * </p>
     *
     * @return Price unit
     */
    @SerializedName( "MaterialPriceUnitQty" )
    @JsonProperty( "MaterialPriceUnitQty" )
    @Nullable
    @ODataField( odataName = "MaterialPriceUnitQty" )
    private BigDecimal materialPriceUnitQty;
    /**
     * Use with available fluent helpers to apply the <b>MaterialPriceUnitQty</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<BigDecimal> MATERIAL_PRICE_UNIT_QTY =
        new MaterialBOMItemField<BigDecimal>("MaterialPriceUnitQty");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>ComponentScrapInPercent</b>
     * </p>
     *
     * @return Component Scrap in Percent
     */
    @SerializedName( "ComponentScrapInPercent" )
    @JsonProperty( "ComponentScrapInPercent" )
    @Nullable
    @ODataField( odataName = "ComponentScrapInPercent" )
    private BigDecimal componentScrapInPercent;
    /**
     * Use with available fluent helpers to apply the <b>ComponentScrapInPercent</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<BigDecimal> COMPONENT_SCRAP_IN_PERCENT =
        new MaterialBOMItemField<BigDecimal>("ComponentScrapInPercent");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>OperationScrapInPercent</b>
     * </p>
     *
     * @return Operation Scrap
     */
    @SerializedName( "OperationScrapInPercent" )
    @JsonProperty( "OperationScrapInPercent" )
    @Nullable
    @ODataField( odataName = "OperationScrapInPercent" )
    private BigDecimal operationScrapInPercent;
    /**
     * Use with available fluent helpers to apply the <b>OperationScrapInPercent</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<BigDecimal> OPERATION_SCRAP_IN_PERCENT =
        new MaterialBOMItemField<BigDecimal>("OperationScrapInPercent");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsNetScrap</b>
     * </p>
     *
     * @return Net Scrap Indicator
     */
    @SerializedName( "IsNetScrap" )
    @JsonProperty( "IsNetScrap" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsNetScrap" )
    private Boolean isNetScrap;
    /**
     * Use with available fluent helpers to apply the <b>IsNetScrap</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<Boolean> IS_NET_SCRAP = new MaterialBOMItemField<Boolean>("IsNetScrap");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfVariableSizeItem</b>
     * </p>
     *
     * @return Required Number of Variable-Size Items
     */
    @SerializedName( "NumberOfVariableSizeItem" )
    @JsonProperty( "NumberOfVariableSizeItem" )
    @Nullable
    @ODataField( odataName = "NumberOfVariableSizeItem" )
    private BigDecimal numberOfVariableSizeItem;
    /**
     * Use with available fluent helpers to apply the <b>NumberOfVariableSizeItem</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<BigDecimal> NUMBER_OF_VARIABLE_SIZE_ITEM =
        new MaterialBOMItemField<BigDecimal>("NumberOfVariableSizeItem");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityVariableSizeItem</b>
     * </p>
     *
     * @return Variable-Size Item Quantity per Piece (PC)
     */
    @SerializedName( "QuantityVariableSizeItem" )
    @JsonProperty( "QuantityVariableSizeItem" )
    @Nullable
    @ODataField( odataName = "QuantityVariableSizeItem" )
    private BigDecimal quantityVariableSizeItem;
    /**
     * Use with available fluent helpers to apply the <b>QuantityVariableSizeItem</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<BigDecimal> QUANTITY_VARIABLE_SIZE_ITEM =
        new MaterialBOMItemField<BigDecimal>("QuantityVariableSizeItem");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FormulaKey</b>
     * </p>
     *
     * @return Formula Key for Variable-Size Items
     */
    @SerializedName( "FormulaKey" )
    @JsonProperty( "FormulaKey" )
    @Nullable
    @ODataField( odataName = "FormulaKey" )
    private String formulaKey;
    /**
     * Use with available fluent helpers to apply the <b>FormulaKey</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> FORMULA_KEY = new MaterialBOMItemField<String>("FormulaKey");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ComponentDescription</b>
     * </p>
     *
     * @return BOM Item Text (Line 1)
     */
    @SerializedName( "ComponentDescription" )
    @JsonProperty( "ComponentDescription" )
    @Nullable
    @ODataField( odataName = "ComponentDescription" )
    private String componentDescription;
    /**
     * Use with available fluent helpers to apply the <b>ComponentDescription</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> COMPONENT_DESCRIPTION =
        new MaterialBOMItemField<String>("ComponentDescription");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemDescription</b>
     * </p>
     *
     * @return BOM Item Text (Line 1)
     */
    @SerializedName( "BOMItemDescription" )
    @JsonProperty( "BOMItemDescription" )
    @Nullable
    @ODataField( odataName = "BOMItemDescription" )
    private String bOMItemDescription;
    /**
     * Use with available fluent helpers to apply the <b>BOMItemDescription</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> BOM_ITEM_DESCRIPTION =
        new MaterialBOMItemField<String>("BOMItemDescription");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemText2</b>
     * </p>
     *
     * @return BOM Item Text (Line 2)
     */
    @SerializedName( "BOMItemText2" )
    @JsonProperty( "BOMItemText2" )
    @Nullable
    @ODataField( odataName = "BOMItemText2" )
    private String bOMItemText2;
    /**
     * Use with available fluent helpers to apply the <b>BOMItemText2</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> BOM_ITEM_TEXT2 = new MaterialBOMItemField<String>("BOMItemText2");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @return Material Group
     */
    @SerializedName( "MaterialGroup" )
    @JsonProperty( "MaterialGroup" )
    @Nullable
    @ODataField( odataName = "MaterialGroup" )
    private String materialGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroup</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> MATERIAL_GROUP = new MaterialBOMItemField<String>("MaterialGroup");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentType</b>
     * </p>
     *
     * @return Document Type
     */
    @SerializedName( "DocumentType" )
    @JsonProperty( "DocumentType" )
    @Nullable
    @ODataField( odataName = "DocumentType" )
    private String documentType;
    /**
     * Use with available fluent helpers to apply the <b>DocumentType</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> DOCUMENT_TYPE = new MaterialBOMItemField<String>("DocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>DocNumber</b>
     * </p>
     *
     * @return Document number
     */
    @SerializedName( "DocNumber" )
    @JsonProperty( "DocNumber" )
    @Nullable
    @ODataField( odataName = "DocNumber" )
    private String docNumber;
    /**
     * Use with available fluent helpers to apply the <b>DocNumber</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> DOC_NUMBER = new MaterialBOMItemField<String>("DocNumber");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DocumentVersion</b>
     * </p>
     *
     * @return Document Version
     */
    @SerializedName( "DocumentVersion" )
    @JsonProperty( "DocumentVersion" )
    @Nullable
    @ODataField( odataName = "DocumentVersion" )
    private String documentVersion;
    /**
     * Use with available fluent helpers to apply the <b>DocumentVersion</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> DOCUMENT_VERSION =
        new MaterialBOMItemField<String>("DocumentVersion");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentPart</b>
     * </p>
     *
     * @return Document Part
     */
    @SerializedName( "DocumentPart" )
    @JsonProperty( "DocumentPart" )
    @Nullable
    @ODataField( odataName = "DocumentPart" )
    private String documentPart;
    /**
     * Use with available fluent helpers to apply the <b>DocumentPart</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> DOCUMENT_PART = new MaterialBOMItemField<String>("DocumentPart");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ClassNumber</b>
     * </p>
     *
     * @return Class number
     */
    @SerializedName( "ClassNumber" )
    @JsonProperty( "ClassNumber" )
    @Nullable
    @ODataField( odataName = "ClassNumber" )
    private String classNumber;
    /**
     * Use with available fluent helpers to apply the <b>ClassNumber</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> CLASS_NUMBER = new MaterialBOMItemField<String>("ClassNumber");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ClassType</b>
     * </p>
     *
     * @return Class Type
     */
    @SerializedName( "ClassType" )
    @JsonProperty( "ClassType" )
    @Nullable
    @ODataField( odataName = "ClassType" )
    private String classType;
    /**
     * Use with available fluent helpers to apply the <b>ClassType</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> CLASS_TYPE = new MaterialBOMItemField<String>("ClassType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ResultingItemCategory</b>
     * </p>
     *
     * @return Resulting item category
     */
    @SerializedName( "ResultingItemCategory" )
    @JsonProperty( "ResultingItemCategory" )
    @Nullable
    @ODataField( odataName = "ResultingItemCategory" )
    private String resultingItemCategory;
    /**
     * Use with available fluent helpers to apply the <b>ResultingItemCategory</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> RESULTING_ITEM_CATEGORY =
        new MaterialBOMItemField<String>("ResultingItemCategory");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>DependencyObjectNumber</b>
     * </p>
     *
     * @return Number of Object with Assigned Dependencies
     */
    @SerializedName( "DependencyObjectNumber" )
    @JsonProperty( "DependencyObjectNumber" )
    @Nullable
    @ODataField( odataName = "DependencyObjectNumber" )
    private String dependencyObjectNumber;
    /**
     * Use with available fluent helpers to apply the <b>DependencyObjectNumber</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> DEPENDENCY_OBJECT_NUMBER =
        new MaterialBOMItemField<String>("DependencyObjectNumber");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ObjectType</b>
     * </p>
     *
     * @return Object type (BOM item)
     */
    @SerializedName( "ObjectType" )
    @JsonProperty( "ObjectType" )
    @Nullable
    @ODataField( odataName = "ObjectType" )
    private String objectType;
    /**
     * Use with available fluent helpers to apply the <b>ObjectType</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> OBJECT_TYPE = new MaterialBOMItemField<String>("ObjectType");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsClassificationRelevant</b>
     * </p>
     *
     * @return Indicator: classification as selection condition
     */
    @SerializedName( "IsClassificationRelevant" )
    @JsonProperty( "IsClassificationRelevant" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsClassificationRelevant" )
    private Boolean isClassificationRelevant;
    /**
     * Use with available fluent helpers to apply the <b>IsClassificationRelevant</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<Boolean> IS_CLASSIFICATION_RELEVANT =
        new MaterialBOMItemField<Boolean>("IsClassificationRelevant");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsBulkMaterial</b>
     * </p>
     *
     * @return Indicator: Bulk Material
     */
    @SerializedName( "IsBulkMaterial" )
    @JsonProperty( "IsBulkMaterial" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsBulkMaterial" )
    private Boolean isBulkMaterial;
    /**
     * Use with available fluent helpers to apply the <b>IsBulkMaterial</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<Boolean> IS_BULK_MATERIAL =
        new MaterialBOMItemField<Boolean>("IsBulkMaterial");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemIsSparePart</b>
     * </p>
     *
     * @return Indicator: Spare Part
     */
    @SerializedName( "BOMItemIsSparePart" )
    @JsonProperty( "BOMItemIsSparePart" )
    @Nullable
    @ODataField( odataName = "BOMItemIsSparePart" )
    private String bOMItemIsSparePart;
    /**
     * Use with available fluent helpers to apply the <b>BOMItemIsSparePart</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> BOM_ITEM_IS_SPARE_PART =
        new MaterialBOMItemField<String>("BOMItemIsSparePart");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemIsSalesRelevant</b>
     * </p>
     *
     * @return Indicator: item relevant to sales
     */
    @SerializedName( "BOMItemIsSalesRelevant" )
    @JsonProperty( "BOMItemIsSalesRelevant" )
    @Nullable
    @ODataField( odataName = "BOMItemIsSalesRelevant" )
    private String bOMItemIsSalesRelevant;
    /**
     * Use with available fluent helpers to apply the <b>BOMItemIsSalesRelevant</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> BOM_ITEM_IS_SALES_RELEVANT =
        new MaterialBOMItemField<String>("BOMItemIsSalesRelevant");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsProductionRelevant</b>
     * </p>
     *
     * @return Indicator: item relevant to production
     */
    @SerializedName( "IsProductionRelevant" )
    @JsonProperty( "IsProductionRelevant" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsProductionRelevant" )
    private Boolean isProductionRelevant;
    /**
     * Use with available fluent helpers to apply the <b>IsProductionRelevant</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<Boolean> IS_PRODUCTION_RELEVANT =
        new MaterialBOMItemField<Boolean>("IsProductionRelevant");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemIsPlantMaintRelevant</b>
     * </p>
     *
     * @return Indicator: item relevant to plant maintenance
     */
    @SerializedName( "BOMItemIsPlantMaintRelevant" )
    @JsonProperty( "BOMItemIsPlantMaintRelevant" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "BOMItemIsPlantMaintRelevant" )
    private Boolean bOMItemIsPlantMaintRelevant;
    /**
     * Use with available fluent helpers to apply the <b>BOMItemIsPlantMaintRelevant</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<Boolean> BOM_ITEM_IS_PLANT_MAINT_RELEVANT =
        new MaterialBOMItemField<Boolean>("BOMItemIsPlantMaintRelevant");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemIsCostingRelevant</b>
     * </p>
     *
     * @return Indicator for relevancy to costing
     */
    @SerializedName( "BOMItemIsCostingRelevant" )
    @JsonProperty( "BOMItemIsCostingRelevant" )
    @Nullable
    @ODataField( odataName = "BOMItemIsCostingRelevant" )
    private String bOMItemIsCostingRelevant;
    /**
     * Use with available fluent helpers to apply the <b>BOMItemIsCostingRelevant</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> BOM_ITEM_IS_COSTING_RELEVANT =
        new MaterialBOMItemField<String>("BOMItemIsCostingRelevant");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsEngineeringRelevant</b>
     * </p>
     *
     * @return Indicator: item relevant to engineering
     */
    @SerializedName( "IsEngineeringRelevant" )
    @JsonProperty( "IsEngineeringRelevant" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsEngineeringRelevant" )
    private Boolean isEngineeringRelevant;
    /**
     * Use with available fluent helpers to apply the <b>IsEngineeringRelevant</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<Boolean> IS_ENGINEERING_RELEVANT =
        new MaterialBOMItemField<Boolean>("IsEngineeringRelevant");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SpecialProcurementType</b>
     * </p>
     *
     * @return Special Procurement Type for BOM Item
     */
    @SerializedName( "SpecialProcurementType" )
    @JsonProperty( "SpecialProcurementType" )
    @Nullable
    @ODataField( odataName = "SpecialProcurementType" )
    private String specialProcurementType;
    /**
     * Use with available fluent helpers to apply the <b>SpecialProcurementType</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> SPECIAL_PROCUREMENT_TYPE =
        new MaterialBOMItemField<String>("SpecialProcurementType");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsBOMRecursiveAllowed</b>
     * </p>
     *
     * @return Indicator: recursiveness allowed
     */
    @SerializedName( "IsBOMRecursiveAllowed" )
    @JsonProperty( "IsBOMRecursiveAllowed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsBOMRecursiveAllowed" )
    private Boolean isBOMRecursiveAllowed;
    /**
     * Use with available fluent helpers to apply the <b>IsBOMRecursiveAllowed</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<Boolean> IS_BOM_RECURSIVE_ALLOWED =
        new MaterialBOMItemField<Boolean>("IsBOMRecursiveAllowed");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OperationLeadTimeOffset</b>
     * </p>
     *
     * @return Lead-time offset for operation
     */
    @SerializedName( "OperationLeadTimeOffset" )
    @JsonProperty( "OperationLeadTimeOffset" )
    @Nullable
    @ODataField( odataName = "OperationLeadTimeOffset" )
    private BigDecimal operationLeadTimeOffset;
    /**
     * Use with available fluent helpers to apply the <b>OperationLeadTimeOffset</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<BigDecimal> OPERATION_LEAD_TIME_OFFSET =
        new MaterialBOMItemField<BigDecimal>("OperationLeadTimeOffset");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpsLeadTimeOffsetUnit</b>
     * </p>
     *
     * @return Unit for lead-time offset for operation
     */
    @SerializedName( "OpsLeadTimeOffsetUnit" )
    @JsonProperty( "OpsLeadTimeOffsetUnit" )
    @Nullable
    @ODataField( odataName = "OpsLeadTimeOffsetUnit" )
    private String opsLeadTimeOffsetUnit;
    /**
     * Use with available fluent helpers to apply the <b>OpsLeadTimeOffsetUnit</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> OPS_LEAD_TIME_OFFSET_UNIT =
        new MaterialBOMItemField<String>("OpsLeadTimeOffsetUnit");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsMaterialProvision</b>
     * </p>
     *
     * @return Material Provision Indicator
     */
    @SerializedName( "IsMaterialProvision" )
    @JsonProperty( "IsMaterialProvision" )
    @Nullable
    @ODataField( odataName = "IsMaterialProvision" )
    private String isMaterialProvision;
    /**
     * Use with available fluent helpers to apply the <b>IsMaterialProvision</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> IS_MATERIAL_PROVISION =
        new MaterialBOMItemField<String>("IsMaterialProvision");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BOMIsRecursive</b>
     * </p>
     *
     * @return Indicator: BOM is recursive
     */
    @SerializedName( "BOMIsRecursive" )
    @JsonProperty( "BOMIsRecursive" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "BOMIsRecursive" )
    private Boolean bOMIsRecursive;
    /**
     * Use with available fluent helpers to apply the <b>BOMIsRecursive</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<Boolean> BOM_IS_RECURSIVE =
        new MaterialBOMItemField<Boolean>("BOMIsRecursive");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DocumentIsCreatedByCAD</b>
     * </p>
     *
     * @return CAD Indicator
     */
    @SerializedName( "DocumentIsCreatedByCAD" )
    @JsonProperty( "DocumentIsCreatedByCAD" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "DocumentIsCreatedByCAD" )
    private Boolean documentIsCreatedByCAD;
    /**
     * Use with available fluent helpers to apply the <b>DocumentIsCreatedByCAD</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<Boolean> DOCUMENT_IS_CREATED_BY_CAD =
        new MaterialBOMItemField<Boolean>("DocumentIsCreatedByCAD");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DistrKeyCompConsumption</b>
     * </p>
     *
     * @return Distribution key for component consumption
     */
    @SerializedName( "DistrKeyCompConsumption" )
    @JsonProperty( "DistrKeyCompConsumption" )
    @Nullable
    @ODataField( odataName = "DistrKeyCompConsumption" )
    private String distrKeyCompConsumption;
    /**
     * Use with available fluent helpers to apply the <b>DistrKeyCompConsumption</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> DISTR_KEY_COMP_CONSUMPTION =
        new MaterialBOMItemField<String>("DistrKeyCompConsumption");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDurationInDays</b>
     * </p>
     *
     * @return Delivery time in days
     */
    @SerializedName( "DeliveryDurationInDays" )
    @JsonProperty( "DeliveryDurationInDays" )
    @Nullable
    @ODataField( odataName = "DeliveryDurationInDays" )
    private BigDecimal deliveryDurationInDays;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryDurationInDays</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<BigDecimal> DELIVERY_DURATION_IN_DAYS =
        new MaterialBOMItemField<BigDecimal>("DeliveryDurationInDays");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Creditor</b>
     * </p>
     *
     * @return Account Number of Supplier
     */
    @SerializedName( "Creditor" )
    @JsonProperty( "Creditor" )
    @Nullable
    @ODataField( odataName = "Creditor" )
    private String creditor;
    /**
     * Use with available fluent helpers to apply the <b>Creditor</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> CREDITOR = new MaterialBOMItemField<String>("Creditor");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostElement</b>
     * </p>
     *
     * @return Cost element
     */
    @SerializedName( "CostElement" )
    @JsonProperty( "CostElement" )
    @Nullable
    @ODataField( odataName = "CostElement" )
    private String costElement;
    /**
     * Use with available fluent helpers to apply the <b>CostElement</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> COST_ELEMENT = new MaterialBOMItemField<String>("CostElement");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Size1</b>
     * </p>
     *
     * @return Size 1
     */
    @SerializedName( "Size1" )
    @JsonProperty( "Size1" )
    @Nullable
    @ODataField( odataName = "Size1" )
    private BigDecimal size1;
    /**
     * Use with available fluent helpers to apply the <b>Size1</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<BigDecimal> SIZE1 = new MaterialBOMItemField<BigDecimal>("Size1");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Size2</b>
     * </p>
     *
     * @return Size 2
     */
    @SerializedName( "Size2" )
    @JsonProperty( "Size2" )
    @Nullable
    @ODataField( odataName = "Size2" )
    private BigDecimal size2;
    /**
     * Use with available fluent helpers to apply the <b>Size2</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<BigDecimal> SIZE2 = new MaterialBOMItemField<BigDecimal>("Size2");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Size3</b>
     * </p>
     *
     * @return Size 3
     */
    @SerializedName( "Size3" )
    @JsonProperty( "Size3" )
    @Nullable
    @ODataField( odataName = "Size3" )
    private BigDecimal size3;
    /**
     * Use with available fluent helpers to apply the <b>Size3</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<BigDecimal> SIZE3 = new MaterialBOMItemField<BigDecimal>("Size3");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasureForSize1To3</b>
     * </p>
     *
     * @return Unit of measure for sizes 1 to 3
     */
    @SerializedName( "UnitOfMeasureForSize1To3" )
    @JsonProperty( "UnitOfMeasureForSize1To3" )
    @Nullable
    @ODataField( odataName = "UnitOfMeasureForSize1To3" )
    private String unitOfMeasureForSize1To3;
    /**
     * Use with available fluent helpers to apply the <b>UnitOfMeasureForSize1To3</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> UNIT_OF_MEASURE_FOR_SIZE1_TO3 =
        new MaterialBOMItemField<String>("UnitOfMeasureForSize1To3");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>GoodsReceiptDuration</b>
     * </p>
     *
     * @return Goods receipt processing time in days
     */
    @SerializedName( "GoodsReceiptDuration" )
    @JsonProperty( "GoodsReceiptDuration" )
    @Nullable
    @ODataField( odataName = "GoodsReceiptDuration" )
    private BigDecimal goodsReceiptDuration;
    /**
     * Use with available fluent helpers to apply the <b>GoodsReceiptDuration</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<BigDecimal> GOODS_RECEIPT_DURATION =
        new MaterialBOMItemField<BigDecimal>("GoodsReceiptDuration");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @return Purchasing Organization
     */
    @SerializedName( "PurchasingOrganization" )
    @JsonProperty( "PurchasingOrganization" )
    @Nullable
    @ODataField( odataName = "PurchasingOrganization" )
    private String purchasingOrganization;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingOrganization</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> PURCHASING_ORGANIZATION =
        new MaterialBOMItemField<String>("PurchasingOrganization");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RequiredComponent</b>
     * </p>
     *
     * @return Required Component
     */
    @SerializedName( "RequiredComponent" )
    @JsonProperty( "RequiredComponent" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "RequiredComponent" )
    private Boolean requiredComponent;
    /**
     * Use with available fluent helpers to apply the <b>RequiredComponent</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<Boolean> REQUIRED_COMPONENT =
        new MaterialBOMItemField<Boolean>("RequiredComponent");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MultipleSelectionAllowed</b>
     * </p>
     *
     * @return Multiple Selection Allowed
     */
    @SerializedName( "MultipleSelectionAllowed" )
    @JsonProperty( "MultipleSelectionAllowed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "MultipleSelectionAllowed" )
    private Boolean multipleSelectionAllowed;
    /**
     * Use with available fluent helpers to apply the <b>MultipleSelectionAllowed</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<Boolean> MULTIPLE_SELECTION_ALLOWED =
        new MaterialBOMItemField<Boolean>("MultipleSelectionAllowed");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProdOrderIssueLocation</b>
     * </p>
     *
     * @return Issue Location for Production Order
     */
    @SerializedName( "ProdOrderIssueLocation" )
    @JsonProperty( "ProdOrderIssueLocation" )
    @Nullable
    @ODataField( odataName = "ProdOrderIssueLocation" )
    private String prodOrderIssueLocation;
    /**
     * Use with available fluent helpers to apply the <b>ProdOrderIssueLocation</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> PROD_ORDER_ISSUE_LOCATION =
        new MaterialBOMItemField<String>("ProdOrderIssueLocation");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaterialIsCoProduct</b>
     * </p>
     *
     * @return Indicator: co-product
     */
    @SerializedName( "MaterialIsCoProduct" )
    @JsonProperty( "MaterialIsCoProduct" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "MaterialIsCoProduct" )
    private Boolean materialIsCoProduct;
    /**
     * Use with available fluent helpers to apply the <b>MaterialIsCoProduct</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<Boolean> MATERIAL_IS_CO_PRODUCT =
        new MaterialBOMItemField<Boolean>("MaterialIsCoProduct");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ExplosionType</b>
     * </p>
     *
     * @return Explosion type
     */
    @SerializedName( "ExplosionType" )
    @JsonProperty( "ExplosionType" )
    @Nullable
    @ODataField( odataName = "ExplosionType" )
    private String explosionType;
    /**
     * Use with available fluent helpers to apply the <b>ExplosionType</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> EXPLOSION_TYPE = new MaterialBOMItemField<String>("ExplosionType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AlternativeItemGroup</b>
     * </p>
     *
     * @return Alternative item: group
     */
    @SerializedName( "AlternativeItemGroup" )
    @JsonProperty( "AlternativeItemGroup" )
    @Nullable
    @ODataField( odataName = "AlternativeItemGroup" )
    private String alternativeItemGroup;
    /**
     * Use with available fluent helpers to apply the <b>AlternativeItemGroup</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> ALTERNATIVE_ITEM_GROUP =
        new MaterialBOMItemField<String>("AlternativeItemGroup");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AlternativeItemPriority</b>
     * </p>
     *
     * @return Alternative item: ranking order
     */
    @SerializedName( "AlternativeItemPriority" )
    @JsonProperty( "AlternativeItemPriority" )
    @Nullable
    @ODataField( odataName = "AlternativeItemPriority" )
    private String alternativeItemPriority;
    /**
     * Use with available fluent helpers to apply the <b>AlternativeItemPriority</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> ALTERNATIVE_ITEM_PRIORITY =
        new MaterialBOMItemField<String>("AlternativeItemPriority");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AlternativeItemStrategy</b>
     * </p>
     *
     * @return Alternative item: strategy
     */
    @SerializedName( "AlternativeItemStrategy" )
    @JsonProperty( "AlternativeItemStrategy" )
    @Nullable
    @ODataField( odataName = "AlternativeItemStrategy" )
    private String alternativeItemStrategy;
    /**
     * Use with available fluent helpers to apply the <b>AlternativeItemStrategy</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> ALTERNATIVE_ITEM_STRATEGY =
        new MaterialBOMItemField<String>("AlternativeItemStrategy");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>UsageProbabilityPercent</b>
     * </p>
     *
     * @return Usage Probability in % (Alternative Item)
     */
    @SerializedName( "UsageProbabilityPercent" )
    @JsonProperty( "UsageProbabilityPercent" )
    @Nullable
    @ODataField( odataName = "UsageProbabilityPercent" )
    private BigDecimal usageProbabilityPercent;
    /**
     * Use with available fluent helpers to apply the <b>UsageProbabilityPercent</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<BigDecimal> USAGE_PROBABILITY_PERCENT =
        new MaterialBOMItemField<BigDecimal>("UsageProbabilityPercent");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FollowUpGroup</b>
     * </p>
     *
     * @return Follow-up group
     */
    @SerializedName( "FollowUpGroup" )
    @JsonProperty( "FollowUpGroup" )
    @Nullable
    @ODataField( odataName = "FollowUpGroup" )
    private String followUpGroup;
    /**
     * Use with available fluent helpers to apply the <b>FollowUpGroup</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> FOLLOW_UP_GROUP =
        new MaterialBOMItemField<String>("FollowUpGroup");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DiscontinuationGroup</b>
     * </p>
     *
     * @return Discontinuation group
     */
    @SerializedName( "DiscontinuationGroup" )
    @JsonProperty( "DiscontinuationGroup" )
    @Nullable
    @ODataField( odataName = "DiscontinuationGroup" )
    private String discontinuationGroup;
    /**
     * Use with available fluent helpers to apply the <b>DiscontinuationGroup</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> DISCONTINUATION_GROUP =
        new MaterialBOMItemField<String>("DiscontinuationGroup");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsConfigurableBOM</b>
     * </p>
     *
     * @return Selection indicator for configurable BOMs
     */
    @SerializedName( "IsConfigurableBOM" )
    @JsonProperty( "IsConfigurableBOM" )
    @Nullable
    @ODataField( odataName = "IsConfigurableBOM" )
    private String isConfigurableBOM;
    /**
     * Use with available fluent helpers to apply the <b>IsConfigurableBOM</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> IS_CONFIGURABLE_BOM =
        new MaterialBOMItemField<String>("IsConfigurableBOM");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ReferencePoint</b>
     * </p>
     *
     * @return Reference point for BOM transfer
     */
    @SerializedName( "ReferencePoint" )
    @JsonProperty( "ReferencePoint" )
    @Nullable
    @ODataField( odataName = "ReferencePoint" )
    private String referencePoint;
    /**
     * Use with available fluent helpers to apply the <b>ReferencePoint</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> REFERENCE_POINT =
        new MaterialBOMItemField<String>("ReferencePoint");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>LeadTimeOffset</b>
     * </p>
     *
     * @return Lead-time offset
     */
    @SerializedName( "LeadTimeOffset" )
    @JsonProperty( "LeadTimeOffset" )
    @Nullable
    @ODataField( odataName = "LeadTimeOffset" )
    private BigDecimal leadTimeOffset;
    /**
     * Use with available fluent helpers to apply the <b>LeadTimeOffset</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<BigDecimal> LEAD_TIME_OFFSET =
        new MaterialBOMItemField<BigDecimal>("LeadTimeOffset");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProductionSupplyArea</b>
     * </p>
     *
     * @return Production Supply Area
     */
    @SerializedName( "ProductionSupplyArea" )
    @JsonProperty( "ProductionSupplyArea" )
    @Nullable
    @ODataField( odataName = "ProductionSupplyArea" )
    private String productionSupplyArea;
    /**
     * Use with available fluent helpers to apply the <b>ProductionSupplyArea</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> PRODUCTION_SUPPLY_AREA =
        new MaterialBOMItemField<String>("ProductionSupplyArea");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsDeleted</b>
     * </p>
     *
     * @return Deletion Indicator
     */
    @SerializedName( "IsDeleted" )
    @JsonProperty( "IsDeleted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsDeleted" )
    private Boolean isDeleted;
    /**
     * Use with available fluent helpers to apply the <b>IsDeleted</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<Boolean> IS_DELETED = new MaterialBOMItemField<Boolean>("IsDeleted");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsALE</b>
     * </p>
     *
     * @return ALE indicator
     */
    @SerializedName( "IsALE" )
    @JsonProperty( "IsALE" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsALE" )
    private Boolean isALE;
    /**
     * Use with available fluent helpers to apply the <b>IsALE</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<Boolean> IS_ALE = new MaterialBOMItemField<Boolean>("IsALE");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new MaterialBOMItemField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PreliminaryComponent</b>
     * </p>
     *
     * @return Material Description
     */
    @SerializedName( "PreliminaryComponent" )
    @JsonProperty( "PreliminaryComponent" )
    @Nullable
    @ODataField( odataName = "PreliminaryComponent" )
    private String preliminaryComponent;
    /**
     * Use with available fluent helpers to apply the <b>PreliminaryComponent</b> field to query operations.
     *
     */
    public final static MaterialBOMItemField<String> PRELIMINARY_COMPONENT =
        new MaterialBOMItemField<String>("PreliminaryComponent");
    /**
     * Navigation property <b>to_BOMItemCategory</b> for <b>MaterialBOMItem</b> to single <b>BOMItemCategory</b>.
     *
     */
    @SerializedName( "to_BOMItemCategory" )
    @JsonProperty( "to_BOMItemCategory" )
    @ODataField( odataName = "to_BOMItemCategory" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BOMItemCategory toBOMItemCategory;
    /**
     * Navigation property <b>to_BOMItmObjDependencyAssignment</b> for <b>MaterialBOMItem</b> to multiple
     * <b>MBOMItmObjDpnAssignment</b>.
     *
     */
    @SerializedName( "to_BOMItmObjDependencyAssignment" )
    @JsonProperty( "to_BOMItmObjDependencyAssignment" )
    @ODataField( odataName = "to_BOMItmObjDependencyAssignment" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MBOMItmObjDpnAssignment> toBOMItmObjDependencyAssignment;
    /**
     * Navigation property <b>to_BOMSubItems</b> for <b>MaterialBOMItem</b> to multiple <b>MaterialBOMSubItem</b>.
     *
     */
    @SerializedName( "to_BOMSubItems" )
    @JsonProperty( "to_BOMSubItems" )
    @ODataField( odataName = "to_BOMSubItems" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MaterialBOMSubItem> toBOMSubItems;
    /**
     * Navigation property <b>to_BillOfMaterial</b> for <b>MaterialBOMItem</b> to single <b>MaterialBOM</b>.
     *
     */
    @SerializedName( "to_BillOfMaterial" )
    @JsonProperty( "to_BillOfMaterial" )
    @ODataField( odataName = "to_BillOfMaterial" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private MaterialBOM toBillOfMaterial;
    /**
     * Use with available fluent helpers to apply the <b>to_BOMItemCategory</b> navigation property to query operations.
     *
     */
    public final static MaterialBOMItemOneToOneLink<BOMItemCategory> TO_BOM_ITEM_CATEGORY =
        new MaterialBOMItemOneToOneLink<BOMItemCategory>("to_BOMItemCategory");
    /**
     * Use with available fluent helpers to apply the <b>to_BOMItmObjDependencyAssignment</b> navigation property to
     * query operations.
     *
     */
    public final static MaterialBOMItemLink<MBOMItmObjDpnAssignment> TO_BOM_ITM_OBJ_DEPENDENCY_ASSIGNMENT =
        new MaterialBOMItemLink<MBOMItmObjDpnAssignment>("to_BOMItmObjDependencyAssignment");
    /**
     * Use with available fluent helpers to apply the <b>to_BOMSubItems</b> navigation property to query operations.
     *
     */
    public final static MaterialBOMItemLink<MaterialBOMSubItem> TO_BOM_SUB_ITEMS =
        new MaterialBOMItemLink<MaterialBOMSubItem>("to_BOMSubItems");
    /**
     * Use with available fluent helpers to apply the <b>to_BillOfMaterial</b> navigation property to query operations.
     *
     */
    public final static MaterialBOMItemOneToOneLink<MaterialBOM> TO_BILL_OF_MATERIAL =
        new MaterialBOMItemOneToOneLink<MaterialBOM>("to_BillOfMaterial");

    @Nonnull
    @Override
    public Class<MaterialBOMItem> getType()
    {
        return MaterialBOMItem.class;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ConvertItem_ac</b>
     * </p>
     *
     * @param convertItem_ac
     *            Dyn. Action Control
     */
    public void setConvertItem_ac( @Nullable final Boolean convertItem_ac )
    {
        rememberChangedField("ConvertItem_ac", this.convertItem_ac);
        this.convertItem_ac = convertItem_ac;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DeleteBOMItemWithECN_ac</b>
     * </p>
     *
     * @param deleteBOMItemWithECN_ac
     *            Dyn. Action Control
     */
    public void setDeleteBOMItemWithECN_ac( @Nullable final Boolean deleteBOMItemWithECN_ac )
    {
        rememberChangedField("DeleteBOMItemWithECN_ac", this.deleteBOMItemWithECN_ac);
        this.deleteBOMItemWithECN_ac = deleteBOMItemWithECN_ac;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>UpdateBOMItemWithECN_ac</b>
     * </p>
     *
     * @param updateBOMItemWithECN_ac
     *            Dyn. Action Control
     */
    public void setUpdateBOMItemWithECN_ac( @Nullable final Boolean updateBOMItemWithECN_ac )
    {
        rememberChangedField("UpdateBOMItemWithECN_ac", this.updateBOMItemWithECN_ac);
        this.updateBOMItemWithECN_ac = updateBOMItemWithECN_ac;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @param delete_mc
     *            Dyn. Method Control
     */
    public void setDelete_mc( @Nullable final Boolean delete_mc )
    {
        rememberChangedField("Delete_mc", this.delete_mc);
        this.delete_mc = delete_mc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @param update_mc
     *            Dyn. Method Control
     */
    public void setUpdate_mc( @Nullable final Boolean update_mc )
    {
        rememberChangedField("Update_mc", this.update_mc);
        this.update_mc = update_mc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_BOMItmObjDependencyAssignment_oc</b>
     * </p>
     *
     * @param bOMItmObjDependencyAssignment_oc
     *            Dynamic CbA-Control
     */
    public void setBOMItmObjDependencyAssignment_oc( @Nullable final Boolean bOMItmObjDependencyAssignment_oc )
    {
        rememberChangedField("to_BOMItmObjDependencyAssignment_oc", this.bOMItmObjDependencyAssignment_oc);
        this.bOMItmObjDependencyAssignment_oc = bOMItmObjDependencyAssignment_oc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_BOMSubItems_oc</b>
     * </p>
     *
     * @param bOMSubItems_oc
     *            Dynamic CbA-Control
     */
    public void setBOMSubItems_oc( @Nullable final Boolean bOMSubItems_oc )
    {
        rememberChangedField("to_BOMSubItems_oc", this.bOMSubItems_oc);
        this.bOMSubItems_oc = bOMSubItems_oc;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterial</b>
     * </p>
     *
     * @param billOfMaterial
     *            Bill of Material
     */
    public void setBillOfMaterial( @Nullable final String billOfMaterial )
    {
        rememberChangedField("BillOfMaterial", this.billOfMaterial);
        this.billOfMaterial = billOfMaterial;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialCategory</b>
     * </p>
     *
     * @param billOfMaterialCategory
     *            BOM category
     */
    public void setBillOfMaterialCategory( @Nullable final String billOfMaterialCategory )
    {
        rememberChangedField("BillOfMaterialCategory", this.billOfMaterialCategory);
        this.billOfMaterialCategory = billOfMaterialCategory;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialVariant</b>
     * </p>
     *
     * @param billOfMaterialVariant
     *            Alternative BOM
     */
    public void setBillOfMaterialVariant( @Nullable final String billOfMaterialVariant )
    {
        rememberChangedField("BillOfMaterialVariant", this.billOfMaterialVariant);
        this.billOfMaterialVariant = billOfMaterialVariant;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialVersion</b>
     * </p>
     *
     * @param billOfMaterialVersion
     *            BOM Version
     */
    public void setBillOfMaterialVersion( @Nullable final String billOfMaterialVersion )
    {
        rememberChangedField("BillOfMaterialVersion", this.billOfMaterialVersion);
        this.billOfMaterialVersion = billOfMaterialVersion;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemNodeNumber</b>
     * </p>
     *
     * @param billOfMaterialItemNodeNumber
     *            BOM item node number
     */
    public void setBillOfMaterialItemNodeNumber( @Nullable final String billOfMaterialItemNodeNumber )
    {
        rememberChangedField("BillOfMaterialItemNodeNumber", this.billOfMaterialItemNodeNumber);
        this.billOfMaterialItemNodeNumber = billOfMaterialItemNodeNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>HeaderChangeDocument</b>
     * </p>
     *
     * @param headerChangeDocument
     *            Change Number
     */
    public void setHeaderChangeDocument( @Nullable final String headerChangeDocument )
    {
        rememberChangedField("HeaderChangeDocument", this.headerChangeDocument);
        this.headerChangeDocument = headerChangeDocument;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemUUID</b>
     * </p>
     *
     * @param billOfMaterialItemUUID
     *            Global identification of an item's change status
     */
    public void setBillOfMaterialItemUUID( @Nullable final UUID billOfMaterialItemUUID )
    {
        rememberChangedField("BillOfMaterialItemUUID", this.billOfMaterialItemUUID);
        this.billOfMaterialItemUUID = billOfMaterialItemUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialHeaderUUID</b>
     * </p>
     *
     * @param billOfMaterialHeaderUUID
     *            Global identification of a BOM header change status
     */
    public void setBillOfMaterialHeaderUUID( @Nullable final UUID billOfMaterialHeaderUUID )
    {
        rememberChangedField("BillOfMaterialHeaderUUID", this.billOfMaterialHeaderUUID);
        this.billOfMaterialHeaderUUID = billOfMaterialHeaderUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemInternalChangeCount</b>
     * </p>
     *
     * @param bOMItemInternalChangeCount
     *            Internal counter
     */
    public void setBOMItemInternalChangeCount( @Nullable final String bOMItemInternalChangeCount )
    {
        rememberChangedField("BOMItemInternalChangeCount", this.bOMItemInternalChangeCount);
        this.bOMItemInternalChangeCount = bOMItemInternalChangeCount;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Valid-From Date
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Valid-to date
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>EngineeringChangeDocForEdit</b>
     * </p>
     *
     * @param engineeringChangeDocForEdit
     *            Change Number
     */
    public void setEngineeringChangeDocForEdit( @Nullable final String engineeringChangeDocForEdit )
    {
        rememberChangedField("EngineeringChangeDocForEdit", this.engineeringChangeDocForEdit);
        this.engineeringChangeDocForEdit = engineeringChangeDocForEdit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>EngineeringChangeDocument</b>
     * </p>
     *
     * @param engineeringChangeDocument
     *            Change Number
     */
    public void setEngineeringChangeDocument( @Nullable final String engineeringChangeDocument )
    {
        rememberChangedField("EngineeringChangeDocument", this.engineeringChangeDocument);
        this.engineeringChangeDocument = engineeringChangeDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChgToEngineeringChgDocument</b>
     * </p>
     *
     * @param chgToEngineeringChgDocument
     *            Change Number To
     */
    public void setChgToEngineeringChgDocument( @Nullable final String chgToEngineeringChgDocument )
    {
        rememberChangedField("ChgToEngineeringChgDocument", this.chgToEngineeringChgDocument);
        this.chgToEngineeringChgDocument = chgToEngineeringChgDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>InheritedNodeNumberForBOMItem</b>
     * </p>
     *
     * @param inheritedNodeNumberForBOMItem
     *            Inherited node number of BOM item
     */
    public void setInheritedNodeNumberForBOMItem( @Nullable final String inheritedNodeNumberForBOMItem )
    {
        rememberChangedField("InheritedNodeNumberForBOMItem", this.inheritedNodeNumberForBOMItem);
        this.inheritedNodeNumberForBOMItem = inheritedNodeNumberForBOMItem;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemRecordCreationDate</b>
     * </p>
     *
     * @param bOMItemRecordCreationDate
     *            Date Record Created On
     */
    public void setBOMItemRecordCreationDate( @Nullable final LocalDateTime bOMItemRecordCreationDate )
    {
        rememberChangedField("BOMItemRecordCreationDate", this.bOMItemRecordCreationDate);
        this.bOMItemRecordCreationDate = bOMItemRecordCreationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemCreatedByUser</b>
     * </p>
     *
     * @param bOMItemCreatedByUser
     *            User Who Created Record
     */
    public void setBOMItemCreatedByUser( @Nullable final String bOMItemCreatedByUser )
    {
        rememberChangedField("BOMItemCreatedByUser", this.bOMItemCreatedByUser);
        this.bOMItemCreatedByUser = bOMItemCreatedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemLastChangeDate</b>
     * </p>
     *
     * @param bOMItemLastChangeDate
     *            Last Changed On
     */
    public void setBOMItemLastChangeDate( @Nullable final LocalDateTime bOMItemLastChangeDate )
    {
        rememberChangedField("BOMItemLastChangeDate", this.bOMItemLastChangeDate);
        this.bOMItemLastChangeDate = bOMItemLastChangeDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemLastChangedByUser</b>
     * </p>
     *
     * @param bOMItemLastChangedByUser
     *            Name of Person Who Changed Object
     */
    public void setBOMItemLastChangedByUser( @Nullable final String bOMItemLastChangedByUser )
    {
        rememberChangedField("BOMItemLastChangedByUser", this.bOMItemLastChangedByUser);
        this.bOMItemLastChangedByUser = bOMItemLastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialComponent</b>
     * </p>
     *
     * @param billOfMaterialComponent
     *            BOM component
     */
    public void setBillOfMaterialComponent( @Nullable final String billOfMaterialComponent )
    {
        rememberChangedField("BillOfMaterialComponent", this.billOfMaterialComponent);
        this.billOfMaterialComponent = billOfMaterialComponent;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemCategory</b>
     * </p>
     *
     * @param billOfMaterialItemCategory
     *            Item category (bill of material)
     */
    public void setBillOfMaterialItemCategory( @Nullable final String billOfMaterialItemCategory )
    {
        rememberChangedField("BillOfMaterialItemCategory", this.billOfMaterialItemCategory);
        this.billOfMaterialItemCategory = billOfMaterialItemCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemNumber</b>
     * </p>
     *
     * @param billOfMaterialItemNumber
     *            BOM Item Number
     */
    public void setBillOfMaterialItemNumber( @Nullable final String billOfMaterialItemNumber )
    {
        rememberChangedField("BillOfMaterialItemNumber", this.billOfMaterialItemNumber);
        this.billOfMaterialItemNumber = billOfMaterialItemNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemUnit</b>
     * </p>
     *
     * @param billOfMaterialItemUnit
     *            Component Unit of Measure
     */
    public void setBillOfMaterialItemUnit( @Nullable final String billOfMaterialItemUnit )
    {
        rememberChangedField("BillOfMaterialItemUnit", this.billOfMaterialItemUnit);
        this.billOfMaterialItemUnit = billOfMaterialItemUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemQuantity</b>
     * </p>
     *
     * @param billOfMaterialItemQuantity
     *            Component Quantity
     */
    public void setBillOfMaterialItemQuantity( @Nullable final BigDecimal billOfMaterialItemQuantity )
    {
        rememberChangedField("BillOfMaterialItemQuantity", this.billOfMaterialItemQuantity);
        this.billOfMaterialItemQuantity = billOfMaterialItemQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsAssembly</b>
     * </p>
     *
     * @param isAssembly
     *            Single-Character Flag
     */
    public void setIsAssembly( @Nullable final String isAssembly )
    {
        rememberChangedField("IsAssembly", this.isAssembly);
        this.isAssembly = isAssembly;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsSubItem</b>
     * </p>
     *
     * @param isSubItem
     *            Indicator: sub-items exist
     */
    public void setIsSubItem( @Nullable final Boolean isSubItem )
    {
        rememberChangedField("IsSubItem", this.isSubItem);
        this.isSubItem = isSubItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemSorter</b>
     * </p>
     *
     * @param bOMItemSorter
     *            Sort String
     */
    public void setBOMItemSorter( @Nullable final String bOMItemSorter )
    {
        rememberChangedField("BOMItemSorter", this.bOMItemSorter);
        this.bOMItemSorter = bOMItemSorter;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FixedQuantity</b>
     * </p>
     *
     * @param fixedQuantity
     *            Fixed Quantity
     */
    public void setFixedQuantity( @Nullable final Boolean fixedQuantity )
    {
        rememberChangedField("FixedQuantity", this.fixedQuantity);
        this.fixedQuantity = fixedQuantity;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemHasFixedQuantity</b>
     * </p>
     *
     * @param bOMItemHasFixedQuantity
     *            Fixed Quantity
     */
    public void setBOMItemHasFixedQuantity( @Nullable final Boolean bOMItemHasFixedQuantity )
    {
        rememberChangedField("BOMItemHasFixedQuantity", this.bOMItemHasFixedQuantity);
        this.bOMItemHasFixedQuantity = bOMItemHasFixedQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     *
     * @param purchasingGroup
     *            Purchasing Group
     */
    public void setPurchasingGroup( @Nullable final String purchasingGroup )
    {
        rememberChangedField("PurchasingGroup", this.purchasingGroup);
        this.purchasingGroup = purchasingGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @param currency
     *            Currency Key
     */
    public void setCurrency( @Nullable final String currency )
    {
        rememberChangedField("Currency", this.currency);
        this.currency = currency;
    }

    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaterialComponentPrice</b>
     * </p>
     *
     * @param materialComponentPrice
     *            Price
     */
    public void setMaterialComponentPrice( @Nullable final BigDecimal materialComponentPrice )
    {
        rememberChangedField("MaterialComponentPrice", this.materialComponentPrice);
        this.materialComponentPrice = materialComponentPrice;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>IdentifierBOMItem</b>
     * </p>
     *
     * @param identifierBOMItem
     *            External identification of an item
     */
    public void setIdentifierBOMItem( @Nullable final String identifierBOMItem )
    {
        rememberChangedField("IdentifierBOMItem", this.identifierBOMItem);
        this.identifierBOMItem = identifierBOMItem;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaterialPriceUnitQty</b>
     * </p>
     *
     * @param materialPriceUnitQty
     *            Price unit
     */
    public void setMaterialPriceUnitQty( @Nullable final BigDecimal materialPriceUnitQty )
    {
        rememberChangedField("MaterialPriceUnitQty", this.materialPriceUnitQty);
        this.materialPriceUnitQty = materialPriceUnitQty;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>ComponentScrapInPercent</b>
     * </p>
     *
     * @param componentScrapInPercent
     *            Component Scrap in Percent
     */
    public void setComponentScrapInPercent( @Nullable final BigDecimal componentScrapInPercent )
    {
        rememberChangedField("ComponentScrapInPercent", this.componentScrapInPercent);
        this.componentScrapInPercent = componentScrapInPercent;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>OperationScrapInPercent</b>
     * </p>
     *
     * @param operationScrapInPercent
     *            Operation Scrap
     */
    public void setOperationScrapInPercent( @Nullable final BigDecimal operationScrapInPercent )
    {
        rememberChangedField("OperationScrapInPercent", this.operationScrapInPercent);
        this.operationScrapInPercent = operationScrapInPercent;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsNetScrap</b>
     * </p>
     *
     * @param isNetScrap
     *            Net Scrap Indicator
     */
    public void setIsNetScrap( @Nullable final Boolean isNetScrap )
    {
        rememberChangedField("IsNetScrap", this.isNetScrap);
        this.isNetScrap = isNetScrap;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfVariableSizeItem</b>
     * </p>
     *
     * @param numberOfVariableSizeItem
     *            Required Number of Variable-Size Items
     */
    public void setNumberOfVariableSizeItem( @Nullable final BigDecimal numberOfVariableSizeItem )
    {
        rememberChangedField("NumberOfVariableSizeItem", this.numberOfVariableSizeItem);
        this.numberOfVariableSizeItem = numberOfVariableSizeItem;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityVariableSizeItem</b>
     * </p>
     *
     * @param quantityVariableSizeItem
     *            Variable-Size Item Quantity per Piece (PC)
     */
    public void setQuantityVariableSizeItem( @Nullable final BigDecimal quantityVariableSizeItem )
    {
        rememberChangedField("QuantityVariableSizeItem", this.quantityVariableSizeItem);
        this.quantityVariableSizeItem = quantityVariableSizeItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FormulaKey</b>
     * </p>
     *
     * @param formulaKey
     *            Formula Key for Variable-Size Items
     */
    public void setFormulaKey( @Nullable final String formulaKey )
    {
        rememberChangedField("FormulaKey", this.formulaKey);
        this.formulaKey = formulaKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ComponentDescription</b>
     * </p>
     *
     * @param componentDescription
     *            BOM Item Text (Line 1)
     */
    public void setComponentDescription( @Nullable final String componentDescription )
    {
        rememberChangedField("ComponentDescription", this.componentDescription);
        this.componentDescription = componentDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemDescription</b>
     * </p>
     *
     * @param bOMItemDescription
     *            BOM Item Text (Line 1)
     */
    public void setBOMItemDescription( @Nullable final String bOMItemDescription )
    {
        rememberChangedField("BOMItemDescription", this.bOMItemDescription);
        this.bOMItemDescription = bOMItemDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemText2</b>
     * </p>
     *
     * @param bOMItemText2
     *            BOM Item Text (Line 2)
     */
    public void setBOMItemText2( @Nullable final String bOMItemText2 )
    {
        rememberChangedField("BOMItemText2", this.bOMItemText2);
        this.bOMItemText2 = bOMItemText2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @param materialGroup
     *            Material Group
     */
    public void setMaterialGroup( @Nullable final String materialGroup )
    {
        rememberChangedField("MaterialGroup", this.materialGroup);
        this.materialGroup = materialGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentType</b>
     * </p>
     *
     * @param documentType
     *            Document Type
     */
    public void setDocumentType( @Nullable final String documentType )
    {
        rememberChangedField("DocumentType", this.documentType);
        this.documentType = documentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>DocNumber</b>
     * </p>
     *
     * @param docNumber
     *            Document number
     */
    public void setDocNumber( @Nullable final String docNumber )
    {
        rememberChangedField("DocNumber", this.docNumber);
        this.docNumber = docNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DocumentVersion</b>
     * </p>
     *
     * @param documentVersion
     *            Document Version
     */
    public void setDocumentVersion( @Nullable final String documentVersion )
    {
        rememberChangedField("DocumentVersion", this.documentVersion);
        this.documentVersion = documentVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentPart</b>
     * </p>
     *
     * @param documentPart
     *            Document Part
     */
    public void setDocumentPart( @Nullable final String documentPart )
    {
        rememberChangedField("DocumentPart", this.documentPart);
        this.documentPart = documentPart;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ClassNumber</b>
     * </p>
     *
     * @param classNumber
     *            Class number
     */
    public void setClassNumber( @Nullable final String classNumber )
    {
        rememberChangedField("ClassNumber", this.classNumber);
        this.classNumber = classNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ClassType</b>
     * </p>
     *
     * @param classType
     *            Class Type
     */
    public void setClassType( @Nullable final String classType )
    {
        rememberChangedField("ClassType", this.classType);
        this.classType = classType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ResultingItemCategory</b>
     * </p>
     *
     * @param resultingItemCategory
     *            Resulting item category
     */
    public void setResultingItemCategory( @Nullable final String resultingItemCategory )
    {
        rememberChangedField("ResultingItemCategory", this.resultingItemCategory);
        this.resultingItemCategory = resultingItemCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>DependencyObjectNumber</b>
     * </p>
     *
     * @param dependencyObjectNumber
     *            Number of Object with Assigned Dependencies
     */
    public void setDependencyObjectNumber( @Nullable final String dependencyObjectNumber )
    {
        rememberChangedField("DependencyObjectNumber", this.dependencyObjectNumber);
        this.dependencyObjectNumber = dependencyObjectNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ObjectType</b>
     * </p>
     *
     * @param objectType
     *            Object type (BOM item)
     */
    public void setObjectType( @Nullable final String objectType )
    {
        rememberChangedField("ObjectType", this.objectType);
        this.objectType = objectType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsClassificationRelevant</b>
     * </p>
     *
     * @param isClassificationRelevant
     *            Indicator: classification as selection condition
     */
    public void setIsClassificationRelevant( @Nullable final Boolean isClassificationRelevant )
    {
        rememberChangedField("IsClassificationRelevant", this.isClassificationRelevant);
        this.isClassificationRelevant = isClassificationRelevant;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsBulkMaterial</b>
     * </p>
     *
     * @param isBulkMaterial
     *            Indicator: Bulk Material
     */
    public void setIsBulkMaterial( @Nullable final Boolean isBulkMaterial )
    {
        rememberChangedField("IsBulkMaterial", this.isBulkMaterial);
        this.isBulkMaterial = isBulkMaterial;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemIsSparePart</b>
     * </p>
     *
     * @param bOMItemIsSparePart
     *            Indicator: Spare Part
     */
    public void setBOMItemIsSparePart( @Nullable final String bOMItemIsSparePart )
    {
        rememberChangedField("BOMItemIsSparePart", this.bOMItemIsSparePart);
        this.bOMItemIsSparePart = bOMItemIsSparePart;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemIsSalesRelevant</b>
     * </p>
     *
     * @param bOMItemIsSalesRelevant
     *            Indicator: item relevant to sales
     */
    public void setBOMItemIsSalesRelevant( @Nullable final String bOMItemIsSalesRelevant )
    {
        rememberChangedField("BOMItemIsSalesRelevant", this.bOMItemIsSalesRelevant);
        this.bOMItemIsSalesRelevant = bOMItemIsSalesRelevant;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsProductionRelevant</b>
     * </p>
     *
     * @param isProductionRelevant
     *            Indicator: item relevant to production
     */
    public void setIsProductionRelevant( @Nullable final Boolean isProductionRelevant )
    {
        rememberChangedField("IsProductionRelevant", this.isProductionRelevant);
        this.isProductionRelevant = isProductionRelevant;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemIsPlantMaintRelevant</b>
     * </p>
     *
     * @param bOMItemIsPlantMaintRelevant
     *            Indicator: item relevant to plant maintenance
     */
    public void setBOMItemIsPlantMaintRelevant( @Nullable final Boolean bOMItemIsPlantMaintRelevant )
    {
        rememberChangedField("BOMItemIsPlantMaintRelevant", this.bOMItemIsPlantMaintRelevant);
        this.bOMItemIsPlantMaintRelevant = bOMItemIsPlantMaintRelevant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemIsCostingRelevant</b>
     * </p>
     *
     * @param bOMItemIsCostingRelevant
     *            Indicator for relevancy to costing
     */
    public void setBOMItemIsCostingRelevant( @Nullable final String bOMItemIsCostingRelevant )
    {
        rememberChangedField("BOMItemIsCostingRelevant", this.bOMItemIsCostingRelevant);
        this.bOMItemIsCostingRelevant = bOMItemIsCostingRelevant;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsEngineeringRelevant</b>
     * </p>
     *
     * @param isEngineeringRelevant
     *            Indicator: item relevant to engineering
     */
    public void setIsEngineeringRelevant( @Nullable final Boolean isEngineeringRelevant )
    {
        rememberChangedField("IsEngineeringRelevant", this.isEngineeringRelevant);
        this.isEngineeringRelevant = isEngineeringRelevant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SpecialProcurementType</b>
     * </p>
     *
     * @param specialProcurementType
     *            Special Procurement Type for BOM Item
     */
    public void setSpecialProcurementType( @Nullable final String specialProcurementType )
    {
        rememberChangedField("SpecialProcurementType", this.specialProcurementType);
        this.specialProcurementType = specialProcurementType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsBOMRecursiveAllowed</b>
     * </p>
     *
     * @param isBOMRecursiveAllowed
     *            Indicator: recursiveness allowed
     */
    public void setIsBOMRecursiveAllowed( @Nullable final Boolean isBOMRecursiveAllowed )
    {
        rememberChangedField("IsBOMRecursiveAllowed", this.isBOMRecursiveAllowed);
        this.isBOMRecursiveAllowed = isBOMRecursiveAllowed;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OperationLeadTimeOffset</b>
     * </p>
     *
     * @param operationLeadTimeOffset
     *            Lead-time offset for operation
     */
    public void setOperationLeadTimeOffset( @Nullable final BigDecimal operationLeadTimeOffset )
    {
        rememberChangedField("OperationLeadTimeOffset", this.operationLeadTimeOffset);
        this.operationLeadTimeOffset = operationLeadTimeOffset;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpsLeadTimeOffsetUnit</b>
     * </p>
     *
     * @param opsLeadTimeOffsetUnit
     *            Unit for lead-time offset for operation
     */
    public void setOpsLeadTimeOffsetUnit( @Nullable final String opsLeadTimeOffsetUnit )
    {
        rememberChangedField("OpsLeadTimeOffsetUnit", this.opsLeadTimeOffsetUnit);
        this.opsLeadTimeOffsetUnit = opsLeadTimeOffsetUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsMaterialProvision</b>
     * </p>
     *
     * @param isMaterialProvision
     *            Material Provision Indicator
     */
    public void setIsMaterialProvision( @Nullable final String isMaterialProvision )
    {
        rememberChangedField("IsMaterialProvision", this.isMaterialProvision);
        this.isMaterialProvision = isMaterialProvision;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BOMIsRecursive</b>
     * </p>
     *
     * @param bOMIsRecursive
     *            Indicator: BOM is recursive
     */
    public void setBOMIsRecursive( @Nullable final Boolean bOMIsRecursive )
    {
        rememberChangedField("BOMIsRecursive", this.bOMIsRecursive);
        this.bOMIsRecursive = bOMIsRecursive;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DocumentIsCreatedByCAD</b>
     * </p>
     *
     * @param documentIsCreatedByCAD
     *            CAD Indicator
     */
    public void setDocumentIsCreatedByCAD( @Nullable final Boolean documentIsCreatedByCAD )
    {
        rememberChangedField("DocumentIsCreatedByCAD", this.documentIsCreatedByCAD);
        this.documentIsCreatedByCAD = documentIsCreatedByCAD;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DistrKeyCompConsumption</b>
     * </p>
     *
     * @param distrKeyCompConsumption
     *            Distribution key for component consumption
     */
    public void setDistrKeyCompConsumption( @Nullable final String distrKeyCompConsumption )
    {
        rememberChangedField("DistrKeyCompConsumption", this.distrKeyCompConsumption);
        this.distrKeyCompConsumption = distrKeyCompConsumption;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDurationInDays</b>
     * </p>
     *
     * @param deliveryDurationInDays
     *            Delivery time in days
     */
    public void setDeliveryDurationInDays( @Nullable final BigDecimal deliveryDurationInDays )
    {
        rememberChangedField("DeliveryDurationInDays", this.deliveryDurationInDays);
        this.deliveryDurationInDays = deliveryDurationInDays;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Creditor</b>
     * </p>
     *
     * @param creditor
     *            Account Number of Supplier
     */
    public void setCreditor( @Nullable final String creditor )
    {
        rememberChangedField("Creditor", this.creditor);
        this.creditor = creditor;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostElement</b>
     * </p>
     *
     * @param costElement
     *            Cost element
     */
    public void setCostElement( @Nullable final String costElement )
    {
        rememberChangedField("CostElement", this.costElement);
        this.costElement = costElement;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Size1</b>
     * </p>
     *
     * @param size1
     *            Size 1
     */
    public void setSize1( @Nullable final BigDecimal size1 )
    {
        rememberChangedField("Size1", this.size1);
        this.size1 = size1;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Size2</b>
     * </p>
     *
     * @param size2
     *            Size 2
     */
    public void setSize2( @Nullable final BigDecimal size2 )
    {
        rememberChangedField("Size2", this.size2);
        this.size2 = size2;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Size3</b>
     * </p>
     *
     * @param size3
     *            Size 3
     */
    public void setSize3( @Nullable final BigDecimal size3 )
    {
        rememberChangedField("Size3", this.size3);
        this.size3 = size3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasureForSize1To3</b>
     * </p>
     *
     * @param unitOfMeasureForSize1To3
     *            Unit of measure for sizes 1 to 3
     */
    public void setUnitOfMeasureForSize1To3( @Nullable final String unitOfMeasureForSize1To3 )
    {
        rememberChangedField("UnitOfMeasureForSize1To3", this.unitOfMeasureForSize1To3);
        this.unitOfMeasureForSize1To3 = unitOfMeasureForSize1To3;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>GoodsReceiptDuration</b>
     * </p>
     *
     * @param goodsReceiptDuration
     *            Goods receipt processing time in days
     */
    public void setGoodsReceiptDuration( @Nullable final BigDecimal goodsReceiptDuration )
    {
        rememberChangedField("GoodsReceiptDuration", this.goodsReceiptDuration);
        this.goodsReceiptDuration = goodsReceiptDuration;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @param purchasingOrganization
     *            Purchasing Organization
     */
    public void setPurchasingOrganization( @Nullable final String purchasingOrganization )
    {
        rememberChangedField("PurchasingOrganization", this.purchasingOrganization);
        this.purchasingOrganization = purchasingOrganization;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RequiredComponent</b>
     * </p>
     *
     * @param requiredComponent
     *            Required Component
     */
    public void setRequiredComponent( @Nullable final Boolean requiredComponent )
    {
        rememberChangedField("RequiredComponent", this.requiredComponent);
        this.requiredComponent = requiredComponent;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MultipleSelectionAllowed</b>
     * </p>
     *
     * @param multipleSelectionAllowed
     *            Multiple Selection Allowed
     */
    public void setMultipleSelectionAllowed( @Nullable final Boolean multipleSelectionAllowed )
    {
        rememberChangedField("MultipleSelectionAllowed", this.multipleSelectionAllowed);
        this.multipleSelectionAllowed = multipleSelectionAllowed;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProdOrderIssueLocation</b>
     * </p>
     *
     * @param prodOrderIssueLocation
     *            Issue Location for Production Order
     */
    public void setProdOrderIssueLocation( @Nullable final String prodOrderIssueLocation )
    {
        rememberChangedField("ProdOrderIssueLocation", this.prodOrderIssueLocation);
        this.prodOrderIssueLocation = prodOrderIssueLocation;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaterialIsCoProduct</b>
     * </p>
     *
     * @param materialIsCoProduct
     *            Indicator: co-product
     */
    public void setMaterialIsCoProduct( @Nullable final Boolean materialIsCoProduct )
    {
        rememberChangedField("MaterialIsCoProduct", this.materialIsCoProduct);
        this.materialIsCoProduct = materialIsCoProduct;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ExplosionType</b>
     * </p>
     *
     * @param explosionType
     *            Explosion type
     */
    public void setExplosionType( @Nullable final String explosionType )
    {
        rememberChangedField("ExplosionType", this.explosionType);
        this.explosionType = explosionType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AlternativeItemGroup</b>
     * </p>
     *
     * @param alternativeItemGroup
     *            Alternative item: group
     */
    public void setAlternativeItemGroup( @Nullable final String alternativeItemGroup )
    {
        rememberChangedField("AlternativeItemGroup", this.alternativeItemGroup);
        this.alternativeItemGroup = alternativeItemGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AlternativeItemPriority</b>
     * </p>
     *
     * @param alternativeItemPriority
     *            Alternative item: ranking order
     */
    public void setAlternativeItemPriority( @Nullable final String alternativeItemPriority )
    {
        rememberChangedField("AlternativeItemPriority", this.alternativeItemPriority);
        this.alternativeItemPriority = alternativeItemPriority;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AlternativeItemStrategy</b>
     * </p>
     *
     * @param alternativeItemStrategy
     *            Alternative item: strategy
     */
    public void setAlternativeItemStrategy( @Nullable final String alternativeItemStrategy )
    {
        rememberChangedField("AlternativeItemStrategy", this.alternativeItemStrategy);
        this.alternativeItemStrategy = alternativeItemStrategy;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>UsageProbabilityPercent</b>
     * </p>
     *
     * @param usageProbabilityPercent
     *            Usage Probability in % (Alternative Item)
     */
    public void setUsageProbabilityPercent( @Nullable final BigDecimal usageProbabilityPercent )
    {
        rememberChangedField("UsageProbabilityPercent", this.usageProbabilityPercent);
        this.usageProbabilityPercent = usageProbabilityPercent;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FollowUpGroup</b>
     * </p>
     *
     * @param followUpGroup
     *            Follow-up group
     */
    public void setFollowUpGroup( @Nullable final String followUpGroup )
    {
        rememberChangedField("FollowUpGroup", this.followUpGroup);
        this.followUpGroup = followUpGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DiscontinuationGroup</b>
     * </p>
     *
     * @param discontinuationGroup
     *            Discontinuation group
     */
    public void setDiscontinuationGroup( @Nullable final String discontinuationGroup )
    {
        rememberChangedField("DiscontinuationGroup", this.discontinuationGroup);
        this.discontinuationGroup = discontinuationGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsConfigurableBOM</b>
     * </p>
     *
     * @param isConfigurableBOM
     *            Selection indicator for configurable BOMs
     */
    public void setIsConfigurableBOM( @Nullable final String isConfigurableBOM )
    {
        rememberChangedField("IsConfigurableBOM", this.isConfigurableBOM);
        this.isConfigurableBOM = isConfigurableBOM;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ReferencePoint</b>
     * </p>
     *
     * @param referencePoint
     *            Reference point for BOM transfer
     */
    public void setReferencePoint( @Nullable final String referencePoint )
    {
        rememberChangedField("ReferencePoint", this.referencePoint);
        this.referencePoint = referencePoint;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>LeadTimeOffset</b>
     * </p>
     *
     * @param leadTimeOffset
     *            Lead-time offset
     */
    public void setLeadTimeOffset( @Nullable final BigDecimal leadTimeOffset )
    {
        rememberChangedField("LeadTimeOffset", this.leadTimeOffset);
        this.leadTimeOffset = leadTimeOffset;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProductionSupplyArea</b>
     * </p>
     *
     * @param productionSupplyArea
     *            Production Supply Area
     */
    public void setProductionSupplyArea( @Nullable final String productionSupplyArea )
    {
        rememberChangedField("ProductionSupplyArea", this.productionSupplyArea);
        this.productionSupplyArea = productionSupplyArea;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsDeleted</b>
     * </p>
     *
     * @param isDeleted
     *            Deletion Indicator
     */
    public void setIsDeleted( @Nullable final Boolean isDeleted )
    {
        rememberChangedField("IsDeleted", this.isDeleted);
        this.isDeleted = isDeleted;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsALE</b>
     * </p>
     *
     * @param isALE
     *            ALE indicator
     */
    public void setIsALE( @Nullable final Boolean isALE )
    {
        rememberChangedField("IsALE", this.isALE);
        this.isALE = isALE;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PreliminaryComponent</b>
     * </p>
     *
     * @param preliminaryComponent
     *            Material Description
     */
    public void setPreliminaryComponent( @Nullable final String preliminaryComponent )
    {
        rememberChangedField("PreliminaryComponent", this.preliminaryComponent);
        this.preliminaryComponent = preliminaryComponent;
    }

    @Override
    protected String getEntityCollection()
    {
        return "MaterialBOMItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BillOfMaterial", getBillOfMaterial());
        result.put("BillOfMaterialCategory", getBillOfMaterialCategory());
        result.put("BillOfMaterialVariant", getBillOfMaterialVariant());
        result.put("BillOfMaterialVersion", getBillOfMaterialVersion());
        result.put("BillOfMaterialItemNodeNumber", getBillOfMaterialItemNodeNumber());
        result.put("HeaderChangeDocument", getHeaderChangeDocument());
        result.put("Material", getMaterial());
        result.put("Plant", getPlant());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ConvertItem_ac", getConvertItem_ac());
        values.put("DeleteBOMItemWithECN_ac", getDeleteBOMItemWithECN_ac());
        values.put("UpdateBOMItemWithECN_ac", getUpdateBOMItemWithECN_ac());
        values.put("Delete_mc", getDelete_mc());
        values.put("Update_mc", getUpdate_mc());
        values.put("to_BOMItmObjDependencyAssignment_oc", getBOMItmObjDependencyAssignment_oc());
        values.put("to_BOMSubItems_oc", getBOMSubItems_oc());
        values.put("BillOfMaterial", getBillOfMaterial());
        values.put("BillOfMaterialCategory", getBillOfMaterialCategory());
        values.put("BillOfMaterialVariant", getBillOfMaterialVariant());
        values.put("BillOfMaterialVersion", getBillOfMaterialVersion());
        values.put("BillOfMaterialItemNodeNumber", getBillOfMaterialItemNodeNumber());
        values.put("HeaderChangeDocument", getHeaderChangeDocument());
        values.put("Material", getMaterial());
        values.put("Plant", getPlant());
        values.put("BillOfMaterialItemUUID", getBillOfMaterialItemUUID());
        values.put("BillOfMaterialHeaderUUID", getBillOfMaterialHeaderUUID());
        values.put("BOMItemInternalChangeCount", getBOMItemInternalChangeCount());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("EngineeringChangeDocForEdit", getEngineeringChangeDocForEdit());
        values.put("EngineeringChangeDocument", getEngineeringChangeDocument());
        values.put("ChgToEngineeringChgDocument", getChgToEngineeringChgDocument());
        values.put("InheritedNodeNumberForBOMItem", getInheritedNodeNumberForBOMItem());
        values.put("BOMItemRecordCreationDate", getBOMItemRecordCreationDate());
        values.put("BOMItemCreatedByUser", getBOMItemCreatedByUser());
        values.put("BOMItemLastChangeDate", getBOMItemLastChangeDate());
        values.put("BOMItemLastChangedByUser", getBOMItemLastChangedByUser());
        values.put("BillOfMaterialComponent", getBillOfMaterialComponent());
        values.put("BillOfMaterialItemCategory", getBillOfMaterialItemCategory());
        values.put("BillOfMaterialItemNumber", getBillOfMaterialItemNumber());
        values.put("BillOfMaterialItemUnit", getBillOfMaterialItemUnit());
        values.put("BillOfMaterialItemQuantity", getBillOfMaterialItemQuantity());
        values.put("IsAssembly", getIsAssembly());
        values.put("IsSubItem", getIsSubItem());
        values.put("BOMItemSorter", getBOMItemSorter());
        values.put("FixedQuantity", getFixedQuantity());
        values.put("BOMItemHasFixedQuantity", getBOMItemHasFixedQuantity());
        values.put("PurchasingGroup", getPurchasingGroup());
        values.put("Currency", getCurrency());
        values.put("MaterialComponentPrice", getMaterialComponentPrice());
        values.put("IdentifierBOMItem", getIdentifierBOMItem());
        values.put("MaterialPriceUnitQty", getMaterialPriceUnitQty());
        values.put("ComponentScrapInPercent", getComponentScrapInPercent());
        values.put("OperationScrapInPercent", getOperationScrapInPercent());
        values.put("IsNetScrap", getIsNetScrap());
        values.put("NumberOfVariableSizeItem", getNumberOfVariableSizeItem());
        values.put("QuantityVariableSizeItem", getQuantityVariableSizeItem());
        values.put("FormulaKey", getFormulaKey());
        values.put("ComponentDescription", getComponentDescription());
        values.put("BOMItemDescription", getBOMItemDescription());
        values.put("BOMItemText2", getBOMItemText2());
        values.put("MaterialGroup", getMaterialGroup());
        values.put("DocumentType", getDocumentType());
        values.put("DocNumber", getDocNumber());
        values.put("DocumentVersion", getDocumentVersion());
        values.put("DocumentPart", getDocumentPart());
        values.put("ClassNumber", getClassNumber());
        values.put("ClassType", getClassType());
        values.put("ResultingItemCategory", getResultingItemCategory());
        values.put("DependencyObjectNumber", getDependencyObjectNumber());
        values.put("ObjectType", getObjectType());
        values.put("IsClassificationRelevant", getIsClassificationRelevant());
        values.put("IsBulkMaterial", getIsBulkMaterial());
        values.put("BOMItemIsSparePart", getBOMItemIsSparePart());
        values.put("BOMItemIsSalesRelevant", getBOMItemIsSalesRelevant());
        values.put("IsProductionRelevant", getIsProductionRelevant());
        values.put("BOMItemIsPlantMaintRelevant", getBOMItemIsPlantMaintRelevant());
        values.put("BOMItemIsCostingRelevant", getBOMItemIsCostingRelevant());
        values.put("IsEngineeringRelevant", getIsEngineeringRelevant());
        values.put("SpecialProcurementType", getSpecialProcurementType());
        values.put("IsBOMRecursiveAllowed", getIsBOMRecursiveAllowed());
        values.put("OperationLeadTimeOffset", getOperationLeadTimeOffset());
        values.put("OpsLeadTimeOffsetUnit", getOpsLeadTimeOffsetUnit());
        values.put("IsMaterialProvision", getIsMaterialProvision());
        values.put("BOMIsRecursive", getBOMIsRecursive());
        values.put("DocumentIsCreatedByCAD", getDocumentIsCreatedByCAD());
        values.put("DistrKeyCompConsumption", getDistrKeyCompConsumption());
        values.put("DeliveryDurationInDays", getDeliveryDurationInDays());
        values.put("Creditor", getCreditor());
        values.put("CostElement", getCostElement());
        values.put("Size1", getSize1());
        values.put("Size2", getSize2());
        values.put("Size3", getSize3());
        values.put("UnitOfMeasureForSize1To3", getUnitOfMeasureForSize1To3());
        values.put("GoodsReceiptDuration", getGoodsReceiptDuration());
        values.put("PurchasingOrganization", getPurchasingOrganization());
        values.put("RequiredComponent", getRequiredComponent());
        values.put("MultipleSelectionAllowed", getMultipleSelectionAllowed());
        values.put("ProdOrderIssueLocation", getProdOrderIssueLocation());
        values.put("MaterialIsCoProduct", getMaterialIsCoProduct());
        values.put("ExplosionType", getExplosionType());
        values.put("AlternativeItemGroup", getAlternativeItemGroup());
        values.put("AlternativeItemPriority", getAlternativeItemPriority());
        values.put("AlternativeItemStrategy", getAlternativeItemStrategy());
        values.put("UsageProbabilityPercent", getUsageProbabilityPercent());
        values.put("FollowUpGroup", getFollowUpGroup());
        values.put("DiscontinuationGroup", getDiscontinuationGroup());
        values.put("IsConfigurableBOM", getIsConfigurableBOM());
        values.put("ReferencePoint", getReferencePoint());
        values.put("LeadTimeOffset", getLeadTimeOffset());
        values.put("ProductionSupplyArea", getProductionSupplyArea());
        values.put("IsDeleted", getIsDeleted());
        values.put("IsALE", getIsALE());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("PreliminaryComponent", getPreliminaryComponent());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConvertItem_ac") ) {
                final Object value = values.remove("ConvertItem_ac");
                if( (value == null) || (!value.equals(getConvertItem_ac())) ) {
                    setConvertItem_ac(((Boolean) value));
                }
            }
            if( values.containsKey("DeleteBOMItemWithECN_ac") ) {
                final Object value = values.remove("DeleteBOMItemWithECN_ac");
                if( (value == null) || (!value.equals(getDeleteBOMItemWithECN_ac())) ) {
                    setDeleteBOMItemWithECN_ac(((Boolean) value));
                }
            }
            if( values.containsKey("UpdateBOMItemWithECN_ac") ) {
                final Object value = values.remove("UpdateBOMItemWithECN_ac");
                if( (value == null) || (!value.equals(getUpdateBOMItemWithECN_ac())) ) {
                    setUpdateBOMItemWithECN_ac(((Boolean) value));
                }
            }
            if( values.containsKey("Delete_mc") ) {
                final Object value = values.remove("Delete_mc");
                if( (value == null) || (!value.equals(getDelete_mc())) ) {
                    setDelete_mc(((Boolean) value));
                }
            }
            if( values.containsKey("Update_mc") ) {
                final Object value = values.remove("Update_mc");
                if( (value == null) || (!value.equals(getUpdate_mc())) ) {
                    setUpdate_mc(((Boolean) value));
                }
            }
            if( values.containsKey("to_BOMItmObjDependencyAssignment_oc") ) {
                final Object value = values.remove("to_BOMItmObjDependencyAssignment_oc");
                if( (value == null) || (!value.equals(getBOMItmObjDependencyAssignment_oc())) ) {
                    setBOMItmObjDependencyAssignment_oc(((Boolean) value));
                }
            }
            if( values.containsKey("to_BOMSubItems_oc") ) {
                final Object value = values.remove("to_BOMSubItems_oc");
                if( (value == null) || (!value.equals(getBOMSubItems_oc())) ) {
                    setBOMSubItems_oc(((Boolean) value));
                }
            }
            if( values.containsKey("BillOfMaterial") ) {
                final Object value = values.remove("BillOfMaterial");
                if( (value == null) || (!value.equals(getBillOfMaterial())) ) {
                    setBillOfMaterial(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialCategory") ) {
                final Object value = values.remove("BillOfMaterialCategory");
                if( (value == null) || (!value.equals(getBillOfMaterialCategory())) ) {
                    setBillOfMaterialCategory(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialVariant") ) {
                final Object value = values.remove("BillOfMaterialVariant");
                if( (value == null) || (!value.equals(getBillOfMaterialVariant())) ) {
                    setBillOfMaterialVariant(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialVersion") ) {
                final Object value = values.remove("BillOfMaterialVersion");
                if( (value == null) || (!value.equals(getBillOfMaterialVersion())) ) {
                    setBillOfMaterialVersion(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialItemNodeNumber") ) {
                final Object value = values.remove("BillOfMaterialItemNodeNumber");
                if( (value == null) || (!value.equals(getBillOfMaterialItemNodeNumber())) ) {
                    setBillOfMaterialItemNodeNumber(((String) value));
                }
            }
            if( values.containsKey("HeaderChangeDocument") ) {
                final Object value = values.remove("HeaderChangeDocument");
                if( (value == null) || (!value.equals(getHeaderChangeDocument())) ) {
                    setHeaderChangeDocument(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialItemUUID") ) {
                final Object value = values.remove("BillOfMaterialItemUUID");
                if( (value == null) || (!value.equals(getBillOfMaterialItemUUID())) ) {
                    setBillOfMaterialItemUUID(((UUID) value));
                }
            }
            if( values.containsKey("BillOfMaterialHeaderUUID") ) {
                final Object value = values.remove("BillOfMaterialHeaderUUID");
                if( (value == null) || (!value.equals(getBillOfMaterialHeaderUUID())) ) {
                    setBillOfMaterialHeaderUUID(((UUID) value));
                }
            }
            if( values.containsKey("BOMItemInternalChangeCount") ) {
                final Object value = values.remove("BOMItemInternalChangeCount");
                if( (value == null) || (!value.equals(getBOMItemInternalChangeCount())) ) {
                    setBOMItemInternalChangeCount(((String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("EngineeringChangeDocForEdit") ) {
                final Object value = values.remove("EngineeringChangeDocForEdit");
                if( (value == null) || (!value.equals(getEngineeringChangeDocForEdit())) ) {
                    setEngineeringChangeDocForEdit(((String) value));
                }
            }
            if( values.containsKey("EngineeringChangeDocument") ) {
                final Object value = values.remove("EngineeringChangeDocument");
                if( (value == null) || (!value.equals(getEngineeringChangeDocument())) ) {
                    setEngineeringChangeDocument(((String) value));
                }
            }
            if( values.containsKey("ChgToEngineeringChgDocument") ) {
                final Object value = values.remove("ChgToEngineeringChgDocument");
                if( (value == null) || (!value.equals(getChgToEngineeringChgDocument())) ) {
                    setChgToEngineeringChgDocument(((String) value));
                }
            }
            if( values.containsKey("InheritedNodeNumberForBOMItem") ) {
                final Object value = values.remove("InheritedNodeNumberForBOMItem");
                if( (value == null) || (!value.equals(getInheritedNodeNumberForBOMItem())) ) {
                    setInheritedNodeNumberForBOMItem(((String) value));
                }
            }
            if( values.containsKey("BOMItemRecordCreationDate") ) {
                final Object value = values.remove("BOMItemRecordCreationDate");
                if( (value == null) || (!value.equals(getBOMItemRecordCreationDate())) ) {
                    setBOMItemRecordCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BOMItemCreatedByUser") ) {
                final Object value = values.remove("BOMItemCreatedByUser");
                if( (value == null) || (!value.equals(getBOMItemCreatedByUser())) ) {
                    setBOMItemCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("BOMItemLastChangeDate") ) {
                final Object value = values.remove("BOMItemLastChangeDate");
                if( (value == null) || (!value.equals(getBOMItemLastChangeDate())) ) {
                    setBOMItemLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BOMItemLastChangedByUser") ) {
                final Object value = values.remove("BOMItemLastChangedByUser");
                if( (value == null) || (!value.equals(getBOMItemLastChangedByUser())) ) {
                    setBOMItemLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialComponent") ) {
                final Object value = values.remove("BillOfMaterialComponent");
                if( (value == null) || (!value.equals(getBillOfMaterialComponent())) ) {
                    setBillOfMaterialComponent(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialItemCategory") ) {
                final Object value = values.remove("BillOfMaterialItemCategory");
                if( (value == null) || (!value.equals(getBillOfMaterialItemCategory())) ) {
                    setBillOfMaterialItemCategory(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialItemNumber") ) {
                final Object value = values.remove("BillOfMaterialItemNumber");
                if( (value == null) || (!value.equals(getBillOfMaterialItemNumber())) ) {
                    setBillOfMaterialItemNumber(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialItemUnit") ) {
                final Object value = values.remove("BillOfMaterialItemUnit");
                if( (value == null) || (!value.equals(getBillOfMaterialItemUnit())) ) {
                    setBillOfMaterialItemUnit(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialItemQuantity") ) {
                final Object value = values.remove("BillOfMaterialItemQuantity");
                if( (value == null) || (!value.equals(getBillOfMaterialItemQuantity())) ) {
                    setBillOfMaterialItemQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("IsAssembly") ) {
                final Object value = values.remove("IsAssembly");
                if( (value == null) || (!value.equals(getIsAssembly())) ) {
                    setIsAssembly(((String) value));
                }
            }
            if( values.containsKey("IsSubItem") ) {
                final Object value = values.remove("IsSubItem");
                if( (value == null) || (!value.equals(getIsSubItem())) ) {
                    setIsSubItem(((Boolean) value));
                }
            }
            if( values.containsKey("BOMItemSorter") ) {
                final Object value = values.remove("BOMItemSorter");
                if( (value == null) || (!value.equals(getBOMItemSorter())) ) {
                    setBOMItemSorter(((String) value));
                }
            }
            if( values.containsKey("FixedQuantity") ) {
                final Object value = values.remove("FixedQuantity");
                if( (value == null) || (!value.equals(getFixedQuantity())) ) {
                    setFixedQuantity(((Boolean) value));
                }
            }
            if( values.containsKey("BOMItemHasFixedQuantity") ) {
                final Object value = values.remove("BOMItemHasFixedQuantity");
                if( (value == null) || (!value.equals(getBOMItemHasFixedQuantity())) ) {
                    setBOMItemHasFixedQuantity(((Boolean) value));
                }
            }
            if( values.containsKey("PurchasingGroup") ) {
                final Object value = values.remove("PurchasingGroup");
                if( (value == null) || (!value.equals(getPurchasingGroup())) ) {
                    setPurchasingGroup(((String) value));
                }
            }
            if( values.containsKey("Currency") ) {
                final Object value = values.remove("Currency");
                if( (value == null) || (!value.equals(getCurrency())) ) {
                    setCurrency(((String) value));
                }
            }
            if( values.containsKey("MaterialComponentPrice") ) {
                final Object value = values.remove("MaterialComponentPrice");
                if( (value == null) || (!value.equals(getMaterialComponentPrice())) ) {
                    setMaterialComponentPrice(((BigDecimal) value));
                }
            }
            if( values.containsKey("IdentifierBOMItem") ) {
                final Object value = values.remove("IdentifierBOMItem");
                if( (value == null) || (!value.equals(getIdentifierBOMItem())) ) {
                    setIdentifierBOMItem(((String) value));
                }
            }
            if( values.containsKey("MaterialPriceUnitQty") ) {
                final Object value = values.remove("MaterialPriceUnitQty");
                if( (value == null) || (!value.equals(getMaterialPriceUnitQty())) ) {
                    setMaterialPriceUnitQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("ComponentScrapInPercent") ) {
                final Object value = values.remove("ComponentScrapInPercent");
                if( (value == null) || (!value.equals(getComponentScrapInPercent())) ) {
                    setComponentScrapInPercent(((BigDecimal) value));
                }
            }
            if( values.containsKey("OperationScrapInPercent") ) {
                final Object value = values.remove("OperationScrapInPercent");
                if( (value == null) || (!value.equals(getOperationScrapInPercent())) ) {
                    setOperationScrapInPercent(((BigDecimal) value));
                }
            }
            if( values.containsKey("IsNetScrap") ) {
                final Object value = values.remove("IsNetScrap");
                if( (value == null) || (!value.equals(getIsNetScrap())) ) {
                    setIsNetScrap(((Boolean) value));
                }
            }
            if( values.containsKey("NumberOfVariableSizeItem") ) {
                final Object value = values.remove("NumberOfVariableSizeItem");
                if( (value == null) || (!value.equals(getNumberOfVariableSizeItem())) ) {
                    setNumberOfVariableSizeItem(((BigDecimal) value));
                }
            }
            if( values.containsKey("QuantityVariableSizeItem") ) {
                final Object value = values.remove("QuantityVariableSizeItem");
                if( (value == null) || (!value.equals(getQuantityVariableSizeItem())) ) {
                    setQuantityVariableSizeItem(((BigDecimal) value));
                }
            }
            if( values.containsKey("FormulaKey") ) {
                final Object value = values.remove("FormulaKey");
                if( (value == null) || (!value.equals(getFormulaKey())) ) {
                    setFormulaKey(((String) value));
                }
            }
            if( values.containsKey("ComponentDescription") ) {
                final Object value = values.remove("ComponentDescription");
                if( (value == null) || (!value.equals(getComponentDescription())) ) {
                    setComponentDescription(((String) value));
                }
            }
            if( values.containsKey("BOMItemDescription") ) {
                final Object value = values.remove("BOMItemDescription");
                if( (value == null) || (!value.equals(getBOMItemDescription())) ) {
                    setBOMItemDescription(((String) value));
                }
            }
            if( values.containsKey("BOMItemText2") ) {
                final Object value = values.remove("BOMItemText2");
                if( (value == null) || (!value.equals(getBOMItemText2())) ) {
                    setBOMItemText2(((String) value));
                }
            }
            if( values.containsKey("MaterialGroup") ) {
                final Object value = values.remove("MaterialGroup");
                if( (value == null) || (!value.equals(getMaterialGroup())) ) {
                    setMaterialGroup(((String) value));
                }
            }
            if( values.containsKey("DocumentType") ) {
                final Object value = values.remove("DocumentType");
                if( (value == null) || (!value.equals(getDocumentType())) ) {
                    setDocumentType(((String) value));
                }
            }
            if( values.containsKey("DocNumber") ) {
                final Object value = values.remove("DocNumber");
                if( (value == null) || (!value.equals(getDocNumber())) ) {
                    setDocNumber(((String) value));
                }
            }
            if( values.containsKey("DocumentVersion") ) {
                final Object value = values.remove("DocumentVersion");
                if( (value == null) || (!value.equals(getDocumentVersion())) ) {
                    setDocumentVersion(((String) value));
                }
            }
            if( values.containsKey("DocumentPart") ) {
                final Object value = values.remove("DocumentPart");
                if( (value == null) || (!value.equals(getDocumentPart())) ) {
                    setDocumentPart(((String) value));
                }
            }
            if( values.containsKey("ClassNumber") ) {
                final Object value = values.remove("ClassNumber");
                if( (value == null) || (!value.equals(getClassNumber())) ) {
                    setClassNumber(((String) value));
                }
            }
            if( values.containsKey("ClassType") ) {
                final Object value = values.remove("ClassType");
                if( (value == null) || (!value.equals(getClassType())) ) {
                    setClassType(((String) value));
                }
            }
            if( values.containsKey("ResultingItemCategory") ) {
                final Object value = values.remove("ResultingItemCategory");
                if( (value == null) || (!value.equals(getResultingItemCategory())) ) {
                    setResultingItemCategory(((String) value));
                }
            }
            if( values.containsKey("DependencyObjectNumber") ) {
                final Object value = values.remove("DependencyObjectNumber");
                if( (value == null) || (!value.equals(getDependencyObjectNumber())) ) {
                    setDependencyObjectNumber(((String) value));
                }
            }
            if( values.containsKey("ObjectType") ) {
                final Object value = values.remove("ObjectType");
                if( (value == null) || (!value.equals(getObjectType())) ) {
                    setObjectType(((String) value));
                }
            }
            if( values.containsKey("IsClassificationRelevant") ) {
                final Object value = values.remove("IsClassificationRelevant");
                if( (value == null) || (!value.equals(getIsClassificationRelevant())) ) {
                    setIsClassificationRelevant(((Boolean) value));
                }
            }
            if( values.containsKey("IsBulkMaterial") ) {
                final Object value = values.remove("IsBulkMaterial");
                if( (value == null) || (!value.equals(getIsBulkMaterial())) ) {
                    setIsBulkMaterial(((Boolean) value));
                }
            }
            if( values.containsKey("BOMItemIsSparePart") ) {
                final Object value = values.remove("BOMItemIsSparePart");
                if( (value == null) || (!value.equals(getBOMItemIsSparePart())) ) {
                    setBOMItemIsSparePart(((String) value));
                }
            }
            if( values.containsKey("BOMItemIsSalesRelevant") ) {
                final Object value = values.remove("BOMItemIsSalesRelevant");
                if( (value == null) || (!value.equals(getBOMItemIsSalesRelevant())) ) {
                    setBOMItemIsSalesRelevant(((String) value));
                }
            }
            if( values.containsKey("IsProductionRelevant") ) {
                final Object value = values.remove("IsProductionRelevant");
                if( (value == null) || (!value.equals(getIsProductionRelevant())) ) {
                    setIsProductionRelevant(((Boolean) value));
                }
            }
            if( values.containsKey("BOMItemIsPlantMaintRelevant") ) {
                final Object value = values.remove("BOMItemIsPlantMaintRelevant");
                if( (value == null) || (!value.equals(getBOMItemIsPlantMaintRelevant())) ) {
                    setBOMItemIsPlantMaintRelevant(((Boolean) value));
                }
            }
            if( values.containsKey("BOMItemIsCostingRelevant") ) {
                final Object value = values.remove("BOMItemIsCostingRelevant");
                if( (value == null) || (!value.equals(getBOMItemIsCostingRelevant())) ) {
                    setBOMItemIsCostingRelevant(((String) value));
                }
            }
            if( values.containsKey("IsEngineeringRelevant") ) {
                final Object value = values.remove("IsEngineeringRelevant");
                if( (value == null) || (!value.equals(getIsEngineeringRelevant())) ) {
                    setIsEngineeringRelevant(((Boolean) value));
                }
            }
            if( values.containsKey("SpecialProcurementType") ) {
                final Object value = values.remove("SpecialProcurementType");
                if( (value == null) || (!value.equals(getSpecialProcurementType())) ) {
                    setSpecialProcurementType(((String) value));
                }
            }
            if( values.containsKey("IsBOMRecursiveAllowed") ) {
                final Object value = values.remove("IsBOMRecursiveAllowed");
                if( (value == null) || (!value.equals(getIsBOMRecursiveAllowed())) ) {
                    setIsBOMRecursiveAllowed(((Boolean) value));
                }
            }
            if( values.containsKey("OperationLeadTimeOffset") ) {
                final Object value = values.remove("OperationLeadTimeOffset");
                if( (value == null) || (!value.equals(getOperationLeadTimeOffset())) ) {
                    setOperationLeadTimeOffset(((BigDecimal) value));
                }
            }
            if( values.containsKey("OpsLeadTimeOffsetUnit") ) {
                final Object value = values.remove("OpsLeadTimeOffsetUnit");
                if( (value == null) || (!value.equals(getOpsLeadTimeOffsetUnit())) ) {
                    setOpsLeadTimeOffsetUnit(((String) value));
                }
            }
            if( values.containsKey("IsMaterialProvision") ) {
                final Object value = values.remove("IsMaterialProvision");
                if( (value == null) || (!value.equals(getIsMaterialProvision())) ) {
                    setIsMaterialProvision(((String) value));
                }
            }
            if( values.containsKey("BOMIsRecursive") ) {
                final Object value = values.remove("BOMIsRecursive");
                if( (value == null) || (!value.equals(getBOMIsRecursive())) ) {
                    setBOMIsRecursive(((Boolean) value));
                }
            }
            if( values.containsKey("DocumentIsCreatedByCAD") ) {
                final Object value = values.remove("DocumentIsCreatedByCAD");
                if( (value == null) || (!value.equals(getDocumentIsCreatedByCAD())) ) {
                    setDocumentIsCreatedByCAD(((Boolean) value));
                }
            }
            if( values.containsKey("DistrKeyCompConsumption") ) {
                final Object value = values.remove("DistrKeyCompConsumption");
                if( (value == null) || (!value.equals(getDistrKeyCompConsumption())) ) {
                    setDistrKeyCompConsumption(((String) value));
                }
            }
            if( values.containsKey("DeliveryDurationInDays") ) {
                final Object value = values.remove("DeliveryDurationInDays");
                if( (value == null) || (!value.equals(getDeliveryDurationInDays())) ) {
                    setDeliveryDurationInDays(((BigDecimal) value));
                }
            }
            if( values.containsKey("Creditor") ) {
                final Object value = values.remove("Creditor");
                if( (value == null) || (!value.equals(getCreditor())) ) {
                    setCreditor(((String) value));
                }
            }
            if( values.containsKey("CostElement") ) {
                final Object value = values.remove("CostElement");
                if( (value == null) || (!value.equals(getCostElement())) ) {
                    setCostElement(((String) value));
                }
            }
            if( values.containsKey("Size1") ) {
                final Object value = values.remove("Size1");
                if( (value == null) || (!value.equals(getSize1())) ) {
                    setSize1(((BigDecimal) value));
                }
            }
            if( values.containsKey("Size2") ) {
                final Object value = values.remove("Size2");
                if( (value == null) || (!value.equals(getSize2())) ) {
                    setSize2(((BigDecimal) value));
                }
            }
            if( values.containsKey("Size3") ) {
                final Object value = values.remove("Size3");
                if( (value == null) || (!value.equals(getSize3())) ) {
                    setSize3(((BigDecimal) value));
                }
            }
            if( values.containsKey("UnitOfMeasureForSize1To3") ) {
                final Object value = values.remove("UnitOfMeasureForSize1To3");
                if( (value == null) || (!value.equals(getUnitOfMeasureForSize1To3())) ) {
                    setUnitOfMeasureForSize1To3(((String) value));
                }
            }
            if( values.containsKey("GoodsReceiptDuration") ) {
                final Object value = values.remove("GoodsReceiptDuration");
                if( (value == null) || (!value.equals(getGoodsReceiptDuration())) ) {
                    setGoodsReceiptDuration(((BigDecimal) value));
                }
            }
            if( values.containsKey("PurchasingOrganization") ) {
                final Object value = values.remove("PurchasingOrganization");
                if( (value == null) || (!value.equals(getPurchasingOrganization())) ) {
                    setPurchasingOrganization(((String) value));
                }
            }
            if( values.containsKey("RequiredComponent") ) {
                final Object value = values.remove("RequiredComponent");
                if( (value == null) || (!value.equals(getRequiredComponent())) ) {
                    setRequiredComponent(((Boolean) value));
                }
            }
            if( values.containsKey("MultipleSelectionAllowed") ) {
                final Object value = values.remove("MultipleSelectionAllowed");
                if( (value == null) || (!value.equals(getMultipleSelectionAllowed())) ) {
                    setMultipleSelectionAllowed(((Boolean) value));
                }
            }
            if( values.containsKey("ProdOrderIssueLocation") ) {
                final Object value = values.remove("ProdOrderIssueLocation");
                if( (value == null) || (!value.equals(getProdOrderIssueLocation())) ) {
                    setProdOrderIssueLocation(((String) value));
                }
            }
            if( values.containsKey("MaterialIsCoProduct") ) {
                final Object value = values.remove("MaterialIsCoProduct");
                if( (value == null) || (!value.equals(getMaterialIsCoProduct())) ) {
                    setMaterialIsCoProduct(((Boolean) value));
                }
            }
            if( values.containsKey("ExplosionType") ) {
                final Object value = values.remove("ExplosionType");
                if( (value == null) || (!value.equals(getExplosionType())) ) {
                    setExplosionType(((String) value));
                }
            }
            if( values.containsKey("AlternativeItemGroup") ) {
                final Object value = values.remove("AlternativeItemGroup");
                if( (value == null) || (!value.equals(getAlternativeItemGroup())) ) {
                    setAlternativeItemGroup(((String) value));
                }
            }
            if( values.containsKey("AlternativeItemPriority") ) {
                final Object value = values.remove("AlternativeItemPriority");
                if( (value == null) || (!value.equals(getAlternativeItemPriority())) ) {
                    setAlternativeItemPriority(((String) value));
                }
            }
            if( values.containsKey("AlternativeItemStrategy") ) {
                final Object value = values.remove("AlternativeItemStrategy");
                if( (value == null) || (!value.equals(getAlternativeItemStrategy())) ) {
                    setAlternativeItemStrategy(((String) value));
                }
            }
            if( values.containsKey("UsageProbabilityPercent") ) {
                final Object value = values.remove("UsageProbabilityPercent");
                if( (value == null) || (!value.equals(getUsageProbabilityPercent())) ) {
                    setUsageProbabilityPercent(((BigDecimal) value));
                }
            }
            if( values.containsKey("FollowUpGroup") ) {
                final Object value = values.remove("FollowUpGroup");
                if( (value == null) || (!value.equals(getFollowUpGroup())) ) {
                    setFollowUpGroup(((String) value));
                }
            }
            if( values.containsKey("DiscontinuationGroup") ) {
                final Object value = values.remove("DiscontinuationGroup");
                if( (value == null) || (!value.equals(getDiscontinuationGroup())) ) {
                    setDiscontinuationGroup(((String) value));
                }
            }
            if( values.containsKey("IsConfigurableBOM") ) {
                final Object value = values.remove("IsConfigurableBOM");
                if( (value == null) || (!value.equals(getIsConfigurableBOM())) ) {
                    setIsConfigurableBOM(((String) value));
                }
            }
            if( values.containsKey("ReferencePoint") ) {
                final Object value = values.remove("ReferencePoint");
                if( (value == null) || (!value.equals(getReferencePoint())) ) {
                    setReferencePoint(((String) value));
                }
            }
            if( values.containsKey("LeadTimeOffset") ) {
                final Object value = values.remove("LeadTimeOffset");
                if( (value == null) || (!value.equals(getLeadTimeOffset())) ) {
                    setLeadTimeOffset(((BigDecimal) value));
                }
            }
            if( values.containsKey("ProductionSupplyArea") ) {
                final Object value = values.remove("ProductionSupplyArea");
                if( (value == null) || (!value.equals(getProductionSupplyArea())) ) {
                    setProductionSupplyArea(((String) value));
                }
            }
            if( values.containsKey("IsDeleted") ) {
                final Object value = values.remove("IsDeleted");
                if( (value == null) || (!value.equals(getIsDeleted())) ) {
                    setIsDeleted(((Boolean) value));
                }
            }
            if( values.containsKey("IsALE") ) {
                final Object value = values.remove("IsALE");
                if( (value == null) || (!value.equals(getIsALE())) ) {
                    setIsALE(((Boolean) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("PreliminaryComponent") ) {
                final Object value = values.remove("PreliminaryComponent");
                if( (value == null) || (!value.equals(getPreliminaryComponent())) ) {
                    setPreliminaryComponent(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_BOMItemCategory") ) {
                final Object value = (values).remove("to_BOMItemCategory");
                if( value instanceof Map ) {
                    if( toBOMItemCategory == null ) {
                        toBOMItemCategory = new BOMItemCategory();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBOMItemCategory.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_BOMItmObjDependencyAssignment") ) {
                final Object value = (values).remove("to_BOMItmObjDependencyAssignment");
                if( value instanceof Iterable ) {
                    if( toBOMItmObjDependencyAssignment == null ) {
                        toBOMItmObjDependencyAssignment = Lists.newArrayList();
                    } else {
                        toBOMItmObjDependencyAssignment = Lists.newArrayList(toBOMItmObjDependencyAssignment);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MBOMItmObjDpnAssignment entity;
                        if( toBOMItmObjDependencyAssignment.size() > i ) {
                            entity = toBOMItmObjDependencyAssignment.get(i);
                        } else {
                            entity = new MBOMItmObjDpnAssignment();
                            toBOMItmObjDependencyAssignment.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_BOMSubItems") ) {
                final Object value = (values).remove("to_BOMSubItems");
                if( value instanceof Iterable ) {
                    if( toBOMSubItems == null ) {
                        toBOMSubItems = Lists.newArrayList();
                    } else {
                        toBOMSubItems = Lists.newArrayList(toBOMSubItems);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MaterialBOMSubItem entity;
                        if( toBOMSubItems.size() > i ) {
                            entity = toBOMSubItems.get(i);
                        } else {
                            entity = new MaterialBOMSubItem();
                            toBOMSubItems.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_BillOfMaterial") ) {
                final Object value = (values).remove("to_BillOfMaterial");
                if( value instanceof Map ) {
                    if( toBillOfMaterial == null ) {
                        toBillOfMaterial = new MaterialBOM();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBillOfMaterial.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> MaterialBOMItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new MaterialBOMItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MaterialBOMItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MaterialBOMItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillOfMaterialsV2Service.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBOMItemCategory != null ) {
            (values).put("to_BOMItemCategory", toBOMItemCategory);
        }
        if( toBOMItmObjDependencyAssignment != null ) {
            (values).put("to_BOMItmObjDependencyAssignment", toBOMItmObjDependencyAssignment);
        }
        if( toBOMSubItems != null ) {
            (values).put("to_BOMSubItems", toBOMSubItems);
        }
        if( toBillOfMaterial != null ) {
            (values).put("to_BillOfMaterial", toBillOfMaterial);
        }
        return values;
    }

    /**
     * Fetches the <b>BOMItemCategory</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_BOMItemCategory</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BOMItemCategory</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BOMItemCategory fetchBOMItemCategory()
    {
        return fetchFieldAsSingle("to_BOMItemCategory", BOMItemCategory.class);
    }

    /**
     * Retrieval of associated <b>BOMItemCategory</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BOMItemCategory</b>.
     * <p>
     * If the navigation property <b>to_BOMItemCategory</b> of a queried <b>MaterialBOMItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BOMItemCategory</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BOMItemCategory getBOMItemCategoryOrFetch()
    {
        if( toBOMItemCategory == null ) {
            toBOMItemCategory = fetchBOMItemCategory();
        }
        return toBOMItemCategory;
    }

    /**
     * Retrieval of associated <b>BOMItemCategory</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BOMItemCategory</b>.
     * <p>
     * If the navigation property for an entity <b>MaterialBOMItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BOMItemCategory</b> is already loaded, the result will
     *         contain the <b>BOMItemCategory</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<BOMItemCategory> getBOMItemCategoryIfPresent()
    {
        return Option.of(toBOMItemCategory);
    }

    /**
     * Overwrites the associated <b>BOMItemCategory</b> entity for the loaded navigation property
     * <b>to_BOMItemCategory</b>.
     *
     * @param value
     *            New <b>BOMItemCategory</b> entity.
     */
    public void setBOMItemCategory( final BOMItemCategory value )
    {
        toBOMItemCategory = value;
    }

    /**
     * Fetches the <b>MBOMItmObjDpnAssignment</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_BOMItmObjDependencyAssignment</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>MBOMItmObjDpnAssignment</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MBOMItmObjDpnAssignment> fetchBOMItmObjDependencyAssignment()
    {
        return fetchFieldAsList("to_BOMItmObjDependencyAssignment", MBOMItmObjDpnAssignment.class);
    }

    /**
     * Retrieval of associated <b>MBOMItmObjDpnAssignment</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BOMItmObjDependencyAssignment</b>.
     * <p>
     * If the navigation property <b>to_BOMItmObjDependencyAssignment</b> of a queried <b>MaterialBOMItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MBOMItmObjDpnAssignment</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MBOMItmObjDpnAssignment> getBOMItmObjDependencyAssignmentOrFetch()
    {
        if( toBOMItmObjDependencyAssignment == null ) {
            toBOMItmObjDependencyAssignment = fetchBOMItmObjDependencyAssignment();
        }
        return toBOMItmObjDependencyAssignment;
    }

    /**
     * Retrieval of associated <b>MBOMItmObjDpnAssignment</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BOMItmObjDependencyAssignment</b>.
     * <p>
     * If the navigation property for an entity <b>MaterialBOMItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BOMItmObjDependencyAssignment</b> is already loaded, the
     *         result will contain the <b>MBOMItmObjDpnAssignment</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<MBOMItmObjDpnAssignment>> getBOMItmObjDependencyAssignmentIfPresent()
    {
        return Option.of(toBOMItmObjDependencyAssignment);
    }

    /**
     * Overwrites the list of associated <b>MBOMItmObjDpnAssignment</b> entities for the loaded navigation property
     * <b>to_BOMItmObjDependencyAssignment</b>.
     * <p>
     * If the navigation property <b>to_BOMItmObjDependencyAssignment</b> of a queried <b>MaterialBOMItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>MBOMItmObjDpnAssignment</b> entities.
     */
    public void setBOMItmObjDependencyAssignment( @Nonnull final List<MBOMItmObjDpnAssignment> value )
    {
        if( toBOMItmObjDependencyAssignment == null ) {
            toBOMItmObjDependencyAssignment = Lists.newArrayList();
        }
        toBOMItmObjDependencyAssignment.clear();
        toBOMItmObjDependencyAssignment.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MBOMItmObjDpnAssignment</b> entities. This corresponds to the OData
     * navigation property <b>to_BOMItmObjDependencyAssignment</b>.
     * <p>
     * If the navigation property <b>to_BOMItmObjDependencyAssignment</b> of a queried <b>MaterialBOMItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>MBOMItmObjDpnAssignment</b> entities.
     */
    public void addBOMItmObjDependencyAssignment( MBOMItmObjDpnAssignment... entity )
    {
        if( toBOMItmObjDependencyAssignment == null ) {
            toBOMItmObjDependencyAssignment = Lists.newArrayList();
        }
        toBOMItmObjDependencyAssignment.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>MaterialBOMSubItem</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_BOMSubItems</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>MaterialBOMSubItem</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaterialBOMSubItem> fetchBOMSubItems()
    {
        return fetchFieldAsList("to_BOMSubItems", MaterialBOMSubItem.class);
    }

    /**
     * Retrieval of associated <b>MaterialBOMSubItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BOMSubItems</b>.
     * <p>
     * If the navigation property <b>to_BOMSubItems</b> of a queried <b>MaterialBOMItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaterialBOMSubItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaterialBOMSubItem> getBOMSubItemsOrFetch()
    {
        if( toBOMSubItems == null ) {
            toBOMSubItems = fetchBOMSubItems();
        }
        return toBOMSubItems;
    }

    /**
     * Retrieval of associated <b>MaterialBOMSubItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BOMSubItems</b>.
     * <p>
     * If the navigation property for an entity <b>MaterialBOMItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BOMSubItems</b> is already loaded, the result will
     *         contain the <b>MaterialBOMSubItem</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<MaterialBOMSubItem>> getBOMSubItemsIfPresent()
    {
        return Option.of(toBOMSubItems);
    }

    /**
     * Overwrites the list of associated <b>MaterialBOMSubItem</b> entities for the loaded navigation property
     * <b>to_BOMSubItems</b>.
     * <p>
     * If the navigation property <b>to_BOMSubItems</b> of a queried <b>MaterialBOMItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>MaterialBOMSubItem</b> entities.
     */
    public void setBOMSubItems( @Nonnull final List<MaterialBOMSubItem> value )
    {
        if( toBOMSubItems == null ) {
            toBOMSubItems = Lists.newArrayList();
        }
        toBOMSubItems.clear();
        toBOMSubItems.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MaterialBOMSubItem</b> entities. This corresponds to the OData
     * navigation property <b>to_BOMSubItems</b>.
     * <p>
     * If the navigation property <b>to_BOMSubItems</b> of a queried <b>MaterialBOMItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>MaterialBOMSubItem</b> entities.
     */
    public void addBOMSubItems( MaterialBOMSubItem... entity )
    {
        if( toBOMSubItems == null ) {
            toBOMSubItems = Lists.newArrayList();
        }
        toBOMSubItems.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>MaterialBOM</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_BillOfMaterial</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>MaterialBOM</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaterialBOM fetchBillOfMaterial()
    {
        return fetchFieldAsSingle("to_BillOfMaterial", MaterialBOM.class);
    }

    /**
     * Retrieval of associated <b>MaterialBOM</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_BillOfMaterial</b>.
     * <p>
     * If the navigation property <b>to_BillOfMaterial</b> of a queried <b>MaterialBOMItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaterialBOM</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaterialBOM getBillOfMaterialOrFetch()
    {
        if( toBillOfMaterial == null ) {
            toBillOfMaterial = fetchBillOfMaterial();
        }
        return toBillOfMaterial;
    }

    /**
     * Retrieval of associated <b>MaterialBOM</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_BillOfMaterial</b>.
     * <p>
     * If the navigation property for an entity <b>MaterialBOMItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BillOfMaterial</b> is already loaded, the result will
     *         contain the <b>MaterialBOM</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<MaterialBOM> getBillOfMaterialIfPresent()
    {
        return Option.of(toBillOfMaterial);
    }

    /**
     * Overwrites the associated <b>MaterialBOM</b> entity for the loaded navigation property <b>to_BillOfMaterial</b>.
     *
     * @param value
     *            New <b>MaterialBOM</b> entity.
     */
    public void setBillOfMaterial( final MaterialBOM value )
    {
        toBillOfMaterial = value;
    }

    /**
     * Helper class to allow for fluent creation of MaterialBOMItem instances.
     *
     */
    public final static class MaterialBOMItemBuilder
    {

        private BOMItemCategory toBOMItemCategory;
        private List<MBOMItmObjDpnAssignment> toBOMItmObjDependencyAssignment = Lists.newArrayList();
        private List<MaterialBOMSubItem> toBOMSubItems = Lists.newArrayList();
        private MaterialBOM toBillOfMaterial;
        private String billOfMaterial = null;

        private MaterialBOMItem.MaterialBOMItemBuilder toBOMItemCategory( final BOMItemCategory value )
        {
            toBOMItemCategory = value;
            return this;
        }

        /**
         * Navigation property <b>to_BOMItemCategory</b> for <b>MaterialBOMItem</b> to single <b>BOMItemCategory</b>.
         *
         * @param value
         *            The BOMItemCategory to build this MaterialBOMItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaterialBOMItem.MaterialBOMItemBuilder bomItemCategory( final BOMItemCategory value )
        {
            return toBOMItemCategory(value);
        }

        private MaterialBOMItem.MaterialBOMItemBuilder toBOMItmObjDependencyAssignment(
            final List<MBOMItmObjDpnAssignment> value )
        {
            toBOMItmObjDependencyAssignment.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_BOMItmObjDependencyAssignment</b> for <b>MaterialBOMItem</b> to multiple
         * <b>MBOMItmObjDpnAssignment</b>.
         *
         * @param value
         *            The MBOMItmObjDpnAssignments to build this MaterialBOMItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaterialBOMItem.MaterialBOMItemBuilder bomItmObjDependencyAssignment( MBOMItmObjDpnAssignment... value )
        {
            return toBOMItmObjDependencyAssignment(Lists.newArrayList(value));
        }

        private MaterialBOMItem.MaterialBOMItemBuilder toBOMSubItems( final List<MaterialBOMSubItem> value )
        {
            toBOMSubItems.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_BOMSubItems</b> for <b>MaterialBOMItem</b> to multiple <b>MaterialBOMSubItem</b>.
         *
         * @param value
         *            The MaterialBOMSubItems to build this MaterialBOMItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaterialBOMItem.MaterialBOMItemBuilder bomSubItems( MaterialBOMSubItem... value )
        {
            return toBOMSubItems(Lists.newArrayList(value));
        }

        private MaterialBOMItem.MaterialBOMItemBuilder toBillOfMaterial( final MaterialBOM value )
        {
            toBillOfMaterial = value;
            return this;
        }

        /**
         * Navigation property <b>to_BillOfMaterial</b> for <b>MaterialBOMItem</b> to single <b>MaterialBOM</b>.
         *
         * @param value
         *            The MaterialBOM to build this MaterialBOMItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaterialBOMItem.MaterialBOMItemBuilder billOfMaterial( final MaterialBOM value )
        {
            return toBillOfMaterial(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 8
         * <p>
         * Original property name from the Odata EDM: <b>BillOfMaterial</b>
         * </p>
         *
         * @param value
         *            The billOfMaterial to build this MaterialBOMItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaterialBOMItem.MaterialBOMItemBuilder billOfMaterial( final String value )
        {
            billOfMaterial = value;
            return this;
        }

    }

}
