/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.field.MaterialBOMSubItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.link.MaterialBOMSubItemOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.selectable.MaterialBOMSubItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Bill of Material Subitem
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MaterialBOMSubItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MaterialBOMSubItem extends VdmEntity<MaterialBOMSubItem>
{

    /**
     * Selector for all available fields of MaterialBOMSubItem.
     *
     */
    public final static MaterialBOMSubItemSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Delete_mc" )
    @JsonProperty( "Delete_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Delete_mc" )
    private Boolean delete_mc;
    /**
     * Use with available fluent helpers to apply the <b>Delete_mc</b> field to query operations.
     *
     */
    public final static MaterialBOMSubItemField<Boolean> DELETE_MC = new MaterialBOMSubItemField<Boolean>("Delete_mc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Update_mc" )
    @JsonProperty( "Update_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Update_mc" )
    private Boolean update_mc;
    /**
     * Use with available fluent helpers to apply the <b>Update_mc</b> field to query operations.
     *
     */
    public final static MaterialBOMSubItemField<Boolean> UPDATE_MC = new MaterialBOMSubItemField<Boolean>("Update_mc");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterial</b>
     * </p>
     *
     * @return Character field, 8 characters long
     */
    @Key
    @SerializedName( "BillOfMaterial" )
    @JsonProperty( "BillOfMaterial" )
    @Nullable
    @ODataField( odataName = "BillOfMaterial" )
    private String billOfMaterial;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterial</b> field to query operations.
     *
     */
    public final static MaterialBOMSubItemField<String> BILL_OF_MATERIAL =
        new MaterialBOMSubItemField<String>("BillOfMaterial");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialCategory</b>
     * </p>
     *
     * @return BOM category
     */
    @Key
    @SerializedName( "BillOfMaterialCategory" )
    @JsonProperty( "BillOfMaterialCategory" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialCategory" )
    private String billOfMaterialCategory;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialCategory</b> field to query operations.
     *
     */
    public final static MaterialBOMSubItemField<String> BILL_OF_MATERIAL_CATEGORY =
        new MaterialBOMSubItemField<String>("BillOfMaterialCategory");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialVariant</b>
     * </p>
     *
     * @return Alternative BOM
     */
    @Key
    @SerializedName( "BillOfMaterialVariant" )
    @JsonProperty( "BillOfMaterialVariant" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialVariant" )
    private String billOfMaterialVariant;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialVariant</b> field to query operations.
     *
     */
    public final static MaterialBOMSubItemField<String> BILL_OF_MATERIAL_VARIANT =
        new MaterialBOMSubItemField<String>("BillOfMaterialVariant");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialVersion</b>
     * </p>
     *
     * @return BOM Version
     */
    @Key
    @SerializedName( "BillOfMaterialVersion" )
    @JsonProperty( "BillOfMaterialVersion" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialVersion" )
    private String billOfMaterialVersion;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialVersion</b> field to query operations.
     *
     */
    public final static MaterialBOMSubItemField<String> BILL_OF_MATERIAL_VERSION =
        new MaterialBOMSubItemField<String>("BillOfMaterialVersion");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemNodeNumber</b>
     * </p>
     *
     * @return BOM item node number
     */
    @Key
    @SerializedName( "BillOfMaterialItemNodeNumber" )
    @JsonProperty( "BillOfMaterialItemNodeNumber" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialItemNodeNumber" )
    private String billOfMaterialItemNodeNumber;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialItemNodeNumber</b> field to query operations.
     *
     */
    public final static MaterialBOMSubItemField<String> BILL_OF_MATERIAL_ITEM_NODE_NUMBER =
        new MaterialBOMSubItemField<String>("BillOfMaterialItemNodeNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>HeaderChangeDocument</b>
     * </p>
     *
     * @return Change Number
     */
    @Key
    @SerializedName( "HeaderChangeDocument" )
    @JsonProperty( "HeaderChangeDocument" )
    @Nullable
    @ODataField( odataName = "HeaderChangeDocument" )
    private String headerChangeDocument;
    /**
     * Use with available fluent helpers to apply the <b>HeaderChangeDocument</b> field to query operations.
     *
     */
    public final static MaterialBOMSubItemField<String> HEADER_CHANGE_DOCUMENT =
        new MaterialBOMSubItemField<String>("HeaderChangeDocument");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @Key
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static MaterialBOMSubItemField<String> MATERIAL = new MaterialBOMSubItemField<String>("Material");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @Key
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static MaterialBOMSubItemField<String> PLANT = new MaterialBOMSubItemField<String>("Plant");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemInternalChangeCount</b>
     * </p>
     *
     * @return Internal counter
     */
    @Key
    @SerializedName( "BOMItemInternalChangeCount" )
    @JsonProperty( "BOMItemInternalChangeCount" )
    @Nullable
    @ODataField( odataName = "BOMItemInternalChangeCount" )
    private String bOMItemInternalChangeCount;
    /**
     * Use with available fluent helpers to apply the <b>BOMItemInternalChangeCount</b> field to query operations.
     *
     */
    public final static MaterialBOMSubItemField<String> BOM_ITEM_INTERNAL_CHANGE_COUNT =
        new MaterialBOMSubItemField<String>("BOMItemInternalChangeCount");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BOMSubItemNumberValue</b>
     * </p>
     *
     * @return Undefined range (can be used for patch levels)
     */
    @Key
    @SerializedName( "BOMSubItemNumberValue" )
    @JsonProperty( "BOMSubItemNumberValue" )
    @Nullable
    @ODataField( odataName = "BOMSubItemNumberValue" )
    private String bOMSubItemNumberValue;
    /**
     * Use with available fluent helpers to apply the <b>BOMSubItemNumberValue</b> field to query operations.
     *
     */
    public final static MaterialBOMSubItemField<String> BOM_SUB_ITEM_NUMBER_VALUE =
        new MaterialBOMSubItemField<String>("BOMSubItemNumberValue");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemUnit</b>
     * </p>
     *
     * @return Component Unit of Measure
     */
    @SerializedName( "BillOfMaterialItemUnit" )
    @JsonProperty( "BillOfMaterialItemUnit" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialItemUnit" )
    private String billOfMaterialItemUnit;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialItemUnit</b> field to query operations.
     *
     */
    public final static MaterialBOMSubItemField<String> BILL_OF_MATERIAL_ITEM_UNIT =
        new MaterialBOMSubItemField<String>("BillOfMaterialItemUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialSubItemQuantity</b>
     * </p>
     *
     * @return Sub-item quantity
     */
    @SerializedName( "BillOfMaterialSubItemQuantity" )
    @JsonProperty( "BillOfMaterialSubItemQuantity" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialSubItemQuantity" )
    private BigDecimal billOfMaterialSubItemQuantity;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialSubItemQuantity</b> field to query operations.
     *
     */
    public final static MaterialBOMSubItemField<BigDecimal> BILL_OF_MATERIAL_SUB_ITEM_QUANTITY =
        new MaterialBOMSubItemField<BigDecimal>("BillOfMaterialSubItemQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>BOMSubItemInstallationPoint</b>
     * </p>
     *
     * @return Installation Point for Subitem
     */
    @SerializedName( "BOMSubItemInstallationPoint" )
    @JsonProperty( "BOMSubItemInstallationPoint" )
    @Nullable
    @ODataField( odataName = "BOMSubItemInstallationPoint" )
    private String bOMSubItemInstallationPoint;
    /**
     * Use with available fluent helpers to apply the <b>BOMSubItemInstallationPoint</b> field to query operations.
     *
     */
    public final static MaterialBOMSubItemField<String> BOM_SUB_ITEM_INSTALLATION_POINT =
        new MaterialBOMSubItemField<String>("BOMSubItemInstallationPoint");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialSubItemText</b>
     * </p>
     *
     * @return BOM sub-item text
     */
    @SerializedName( "BillOfMaterialSubItemText" )
    @JsonProperty( "BillOfMaterialSubItemText" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialSubItemText" )
    private String billOfMaterialSubItemText;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialSubItemText</b> field to query operations.
     *
     */
    public final static MaterialBOMSubItemField<String> BILL_OF_MATERIAL_SUB_ITEM_TEXT =
        new MaterialBOMSubItemField<String>("BillOfMaterialSubItemText");
    /**
     * Navigation property <b>to_BillOfMaterialItem</b> for <b>MaterialBOMSubItem</b> to single <b>MaterialBOMItem</b>.
     *
     */
    @SerializedName( "to_BillOfMaterialItem" )
    @JsonProperty( "to_BillOfMaterialItem" )
    @ODataField( odataName = "to_BillOfMaterialItem" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private MaterialBOMItem toBillOfMaterialItem;
    /**
     * Navigation property <b>to_BillOfMaterial</b> for <b>MaterialBOMSubItem</b> to single <b>MaterialBOM</b>.
     *
     */
    @SerializedName( "to_BillOfMaterial" )
    @JsonProperty( "to_BillOfMaterial" )
    @ODataField( odataName = "to_BillOfMaterial" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private MaterialBOM toBillOfMaterial;
    /**
     * Use with available fluent helpers to apply the <b>to_BillOfMaterialItem</b> navigation property to query
     * operations.
     *
     */
    public final static MaterialBOMSubItemOneToOneLink<MaterialBOMItem> TO_BILL_OF_MATERIAL_ITEM =
        new MaterialBOMSubItemOneToOneLink<MaterialBOMItem>("to_BillOfMaterialItem");
    /**
     * Use with available fluent helpers to apply the <b>to_BillOfMaterial</b> navigation property to query operations.
     *
     */
    public final static MaterialBOMSubItemOneToOneLink<MaterialBOM> TO_BILL_OF_MATERIAL =
        new MaterialBOMSubItemOneToOneLink<MaterialBOM>("to_BillOfMaterial");

    @Nonnull
    @Override
    public Class<MaterialBOMSubItem> getType()
    {
        return MaterialBOMSubItem.class;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @param delete_mc
     *            Dyn. Method Control
     */
    public void setDelete_mc( @Nullable final Boolean delete_mc )
    {
        rememberChangedField("Delete_mc", this.delete_mc);
        this.delete_mc = delete_mc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @param update_mc
     *            Dyn. Method Control
     */
    public void setUpdate_mc( @Nullable final Boolean update_mc )
    {
        rememberChangedField("Update_mc", this.update_mc);
        this.update_mc = update_mc;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterial</b>
     * </p>
     *
     * @param billOfMaterial
     *            Character field, 8 characters long
     */
    public void setBillOfMaterial( @Nullable final String billOfMaterial )
    {
        rememberChangedField("BillOfMaterial", this.billOfMaterial);
        this.billOfMaterial = billOfMaterial;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialCategory</b>
     * </p>
     *
     * @param billOfMaterialCategory
     *            BOM category
     */
    public void setBillOfMaterialCategory( @Nullable final String billOfMaterialCategory )
    {
        rememberChangedField("BillOfMaterialCategory", this.billOfMaterialCategory);
        this.billOfMaterialCategory = billOfMaterialCategory;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialVariant</b>
     * </p>
     *
     * @param billOfMaterialVariant
     *            Alternative BOM
     */
    public void setBillOfMaterialVariant( @Nullable final String billOfMaterialVariant )
    {
        rememberChangedField("BillOfMaterialVariant", this.billOfMaterialVariant);
        this.billOfMaterialVariant = billOfMaterialVariant;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialVersion</b>
     * </p>
     *
     * @param billOfMaterialVersion
     *            BOM Version
     */
    public void setBillOfMaterialVersion( @Nullable final String billOfMaterialVersion )
    {
        rememberChangedField("BillOfMaterialVersion", this.billOfMaterialVersion);
        this.billOfMaterialVersion = billOfMaterialVersion;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemNodeNumber</b>
     * </p>
     *
     * @param billOfMaterialItemNodeNumber
     *            BOM item node number
     */
    public void setBillOfMaterialItemNodeNumber( @Nullable final String billOfMaterialItemNodeNumber )
    {
        rememberChangedField("BillOfMaterialItemNodeNumber", this.billOfMaterialItemNodeNumber);
        this.billOfMaterialItemNodeNumber = billOfMaterialItemNodeNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>HeaderChangeDocument</b>
     * </p>
     *
     * @param headerChangeDocument
     *            Change Number
     */
    public void setHeaderChangeDocument( @Nullable final String headerChangeDocument )
    {
        rememberChangedField("HeaderChangeDocument", this.headerChangeDocument);
        this.headerChangeDocument = headerChangeDocument;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemInternalChangeCount</b>
     * </p>
     *
     * @param bOMItemInternalChangeCount
     *            Internal counter
     */
    public void setBOMItemInternalChangeCount( @Nullable final String bOMItemInternalChangeCount )
    {
        rememberChangedField("BOMItemInternalChangeCount", this.bOMItemInternalChangeCount);
        this.bOMItemInternalChangeCount = bOMItemInternalChangeCount;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BOMSubItemNumberValue</b>
     * </p>
     *
     * @param bOMSubItemNumberValue
     *            Undefined range (can be used for patch levels)
     */
    public void setBOMSubItemNumberValue( @Nullable final String bOMSubItemNumberValue )
    {
        rememberChangedField("BOMSubItemNumberValue", this.bOMSubItemNumberValue);
        this.bOMSubItemNumberValue = bOMSubItemNumberValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemUnit</b>
     * </p>
     *
     * @param billOfMaterialItemUnit
     *            Component Unit of Measure
     */
    public void setBillOfMaterialItemUnit( @Nullable final String billOfMaterialItemUnit )
    {
        rememberChangedField("BillOfMaterialItemUnit", this.billOfMaterialItemUnit);
        this.billOfMaterialItemUnit = billOfMaterialItemUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialSubItemQuantity</b>
     * </p>
     *
     * @param billOfMaterialSubItemQuantity
     *            Sub-item quantity
     */
    public void setBillOfMaterialSubItemQuantity( @Nullable final BigDecimal billOfMaterialSubItemQuantity )
    {
        rememberChangedField("BillOfMaterialSubItemQuantity", this.billOfMaterialSubItemQuantity);
        this.billOfMaterialSubItemQuantity = billOfMaterialSubItemQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>BOMSubItemInstallationPoint</b>
     * </p>
     *
     * @param bOMSubItemInstallationPoint
     *            Installation Point for Subitem
     */
    public void setBOMSubItemInstallationPoint( @Nullable final String bOMSubItemInstallationPoint )
    {
        rememberChangedField("BOMSubItemInstallationPoint", this.bOMSubItemInstallationPoint);
        this.bOMSubItemInstallationPoint = bOMSubItemInstallationPoint;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialSubItemText</b>
     * </p>
     *
     * @param billOfMaterialSubItemText
     *            BOM sub-item text
     */
    public void setBillOfMaterialSubItemText( @Nullable final String billOfMaterialSubItemText )
    {
        rememberChangedField("BillOfMaterialSubItemText", this.billOfMaterialSubItemText);
        this.billOfMaterialSubItemText = billOfMaterialSubItemText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "MaterialBOMSubItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BillOfMaterial", getBillOfMaterial());
        result.put("BillOfMaterialCategory", getBillOfMaterialCategory());
        result.put("BillOfMaterialVariant", getBillOfMaterialVariant());
        result.put("BillOfMaterialVersion", getBillOfMaterialVersion());
        result.put("BillOfMaterialItemNodeNumber", getBillOfMaterialItemNodeNumber());
        result.put("HeaderChangeDocument", getHeaderChangeDocument());
        result.put("Material", getMaterial());
        result.put("Plant", getPlant());
        result.put("BOMItemInternalChangeCount", getBOMItemInternalChangeCount());
        result.put("BOMSubItemNumberValue", getBOMSubItemNumberValue());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Delete_mc", getDelete_mc());
        values.put("Update_mc", getUpdate_mc());
        values.put("BillOfMaterial", getBillOfMaterial());
        values.put("BillOfMaterialCategory", getBillOfMaterialCategory());
        values.put("BillOfMaterialVariant", getBillOfMaterialVariant());
        values.put("BillOfMaterialVersion", getBillOfMaterialVersion());
        values.put("BillOfMaterialItemNodeNumber", getBillOfMaterialItemNodeNumber());
        values.put("HeaderChangeDocument", getHeaderChangeDocument());
        values.put("Material", getMaterial());
        values.put("Plant", getPlant());
        values.put("BOMItemInternalChangeCount", getBOMItemInternalChangeCount());
        values.put("BOMSubItemNumberValue", getBOMSubItemNumberValue());
        values.put("BillOfMaterialItemUnit", getBillOfMaterialItemUnit());
        values.put("BillOfMaterialSubItemQuantity", getBillOfMaterialSubItemQuantity());
        values.put("BOMSubItemInstallationPoint", getBOMSubItemInstallationPoint());
        values.put("BillOfMaterialSubItemText", getBillOfMaterialSubItemText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Delete_mc") ) {
                final Object value = values.remove("Delete_mc");
                if( (value == null) || (!value.equals(getDelete_mc())) ) {
                    setDelete_mc(((Boolean) value));
                }
            }
            if( values.containsKey("Update_mc") ) {
                final Object value = values.remove("Update_mc");
                if( (value == null) || (!value.equals(getUpdate_mc())) ) {
                    setUpdate_mc(((Boolean) value));
                }
            }
            if( values.containsKey("BillOfMaterial") ) {
                final Object value = values.remove("BillOfMaterial");
                if( (value == null) || (!value.equals(getBillOfMaterial())) ) {
                    setBillOfMaterial(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialCategory") ) {
                final Object value = values.remove("BillOfMaterialCategory");
                if( (value == null) || (!value.equals(getBillOfMaterialCategory())) ) {
                    setBillOfMaterialCategory(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialVariant") ) {
                final Object value = values.remove("BillOfMaterialVariant");
                if( (value == null) || (!value.equals(getBillOfMaterialVariant())) ) {
                    setBillOfMaterialVariant(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialVersion") ) {
                final Object value = values.remove("BillOfMaterialVersion");
                if( (value == null) || (!value.equals(getBillOfMaterialVersion())) ) {
                    setBillOfMaterialVersion(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialItemNodeNumber") ) {
                final Object value = values.remove("BillOfMaterialItemNodeNumber");
                if( (value == null) || (!value.equals(getBillOfMaterialItemNodeNumber())) ) {
                    setBillOfMaterialItemNodeNumber(((String) value));
                }
            }
            if( values.containsKey("HeaderChangeDocument") ) {
                final Object value = values.remove("HeaderChangeDocument");
                if( (value == null) || (!value.equals(getHeaderChangeDocument())) ) {
                    setHeaderChangeDocument(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("BOMItemInternalChangeCount") ) {
                final Object value = values.remove("BOMItemInternalChangeCount");
                if( (value == null) || (!value.equals(getBOMItemInternalChangeCount())) ) {
                    setBOMItemInternalChangeCount(((String) value));
                }
            }
            if( values.containsKey("BOMSubItemNumberValue") ) {
                final Object value = values.remove("BOMSubItemNumberValue");
                if( (value == null) || (!value.equals(getBOMSubItemNumberValue())) ) {
                    setBOMSubItemNumberValue(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialItemUnit") ) {
                final Object value = values.remove("BillOfMaterialItemUnit");
                if( (value == null) || (!value.equals(getBillOfMaterialItemUnit())) ) {
                    setBillOfMaterialItemUnit(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialSubItemQuantity") ) {
                final Object value = values.remove("BillOfMaterialSubItemQuantity");
                if( (value == null) || (!value.equals(getBillOfMaterialSubItemQuantity())) ) {
                    setBillOfMaterialSubItemQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("BOMSubItemInstallationPoint") ) {
                final Object value = values.remove("BOMSubItemInstallationPoint");
                if( (value == null) || (!value.equals(getBOMSubItemInstallationPoint())) ) {
                    setBOMSubItemInstallationPoint(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialSubItemText") ) {
                final Object value = values.remove("BillOfMaterialSubItemText");
                if( (value == null) || (!value.equals(getBillOfMaterialSubItemText())) ) {
                    setBillOfMaterialSubItemText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_BillOfMaterialItem") ) {
                final Object value = (values).remove("to_BillOfMaterialItem");
                if( value instanceof Map ) {
                    if( toBillOfMaterialItem == null ) {
                        toBillOfMaterialItem = new MaterialBOMItem();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBillOfMaterialItem.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_BillOfMaterial") ) {
                final Object value = (values).remove("to_BillOfMaterial");
                if( value instanceof Map ) {
                    if( toBillOfMaterial == null ) {
                        toBillOfMaterial = new MaterialBOM();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBillOfMaterial.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> MaterialBOMSubItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new MaterialBOMSubItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MaterialBOMSubItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MaterialBOMSubItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillOfMaterialsV2Service.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBillOfMaterialItem != null ) {
            (values).put("to_BillOfMaterialItem", toBillOfMaterialItem);
        }
        if( toBillOfMaterial != null ) {
            (values).put("to_BillOfMaterial", toBillOfMaterial);
        }
        return values;
    }

    /**
     * Fetches the <b>MaterialBOMItem</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_BillOfMaterialItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>MaterialBOMItem</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaterialBOMItem fetchBillOfMaterialItem()
    {
        return fetchFieldAsSingle("to_BillOfMaterialItem", MaterialBOMItem.class);
    }

    /**
     * Retrieval of associated <b>MaterialBOMItem</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BillOfMaterialItem</b>.
     * <p>
     * If the navigation property <b>to_BillOfMaterialItem</b> of a queried <b>MaterialBOMSubItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaterialBOMItem</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaterialBOMItem getBillOfMaterialItemOrFetch()
    {
        if( toBillOfMaterialItem == null ) {
            toBillOfMaterialItem = fetchBillOfMaterialItem();
        }
        return toBillOfMaterialItem;
    }

    /**
     * Retrieval of associated <b>MaterialBOMItem</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BillOfMaterialItem</b>.
     * <p>
     * If the navigation property for an entity <b>MaterialBOMSubItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BillOfMaterialItem</b> is already loaded, the result
     *         will contain the <b>MaterialBOMItem</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<MaterialBOMItem> getBillOfMaterialItemIfPresent()
    {
        return Option.of(toBillOfMaterialItem);
    }

    /**
     * Overwrites the associated <b>MaterialBOMItem</b> entity for the loaded navigation property
     * <b>to_BillOfMaterialItem</b>.
     *
     * @param value
     *            New <b>MaterialBOMItem</b> entity.
     */
    public void setBillOfMaterialItem( final MaterialBOMItem value )
    {
        toBillOfMaterialItem = value;
    }

    /**
     * Fetches the <b>MaterialBOM</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_BillOfMaterial</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>MaterialBOM</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaterialBOM fetchBillOfMaterial()
    {
        return fetchFieldAsSingle("to_BillOfMaterial", MaterialBOM.class);
    }

    /**
     * Retrieval of associated <b>MaterialBOM</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_BillOfMaterial</b>.
     * <p>
     * If the navigation property <b>to_BillOfMaterial</b> of a queried <b>MaterialBOMSubItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaterialBOM</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaterialBOM getBillOfMaterialOrFetch()
    {
        if( toBillOfMaterial == null ) {
            toBillOfMaterial = fetchBillOfMaterial();
        }
        return toBillOfMaterial;
    }

    /**
     * Retrieval of associated <b>MaterialBOM</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_BillOfMaterial</b>.
     * <p>
     * If the navigation property for an entity <b>MaterialBOMSubItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BillOfMaterial</b> is already loaded, the result will
     *         contain the <b>MaterialBOM</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<MaterialBOM> getBillOfMaterialIfPresent()
    {
        return Option.of(toBillOfMaterial);
    }

    /**
     * Overwrites the associated <b>MaterialBOM</b> entity for the loaded navigation property <b>to_BillOfMaterial</b>.
     *
     * @param value
     *            New <b>MaterialBOM</b> entity.
     */
    public void setBillOfMaterial( final MaterialBOM value )
    {
        toBillOfMaterial = value;
    }

    /**
     * Helper class to allow for fluent creation of MaterialBOMSubItem instances.
     *
     */
    public final static class MaterialBOMSubItemBuilder
    {

        private MaterialBOMItem toBillOfMaterialItem;
        private MaterialBOM toBillOfMaterial;
        private String billOfMaterial = null;

        private MaterialBOMSubItem.MaterialBOMSubItemBuilder toBillOfMaterialItem( final MaterialBOMItem value )
        {
            toBillOfMaterialItem = value;
            return this;
        }

        /**
         * Navigation property <b>to_BillOfMaterialItem</b> for <b>MaterialBOMSubItem</b> to single
         * <b>MaterialBOMItem</b>.
         *
         * @param value
         *            The MaterialBOMItem to build this MaterialBOMSubItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaterialBOMSubItem.MaterialBOMSubItemBuilder billOfMaterialItem( final MaterialBOMItem value )
        {
            return toBillOfMaterialItem(value);
        }

        private MaterialBOMSubItem.MaterialBOMSubItemBuilder toBillOfMaterial( final MaterialBOM value )
        {
            toBillOfMaterial = value;
            return this;
        }

        /**
         * Navigation property <b>to_BillOfMaterial</b> for <b>MaterialBOMSubItem</b> to single <b>MaterialBOM</b>.
         *
         * @param value
         *            The MaterialBOM to build this MaterialBOMSubItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaterialBOMSubItem.MaterialBOMSubItemBuilder billOfMaterial( final MaterialBOM value )
        {
            return toBillOfMaterial(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 8
         * <p>
         * Original property name from the Odata EDM: <b>BillOfMaterial</b>
         * </p>
         *
         * @param value
         *            The billOfMaterial to build this MaterialBOMSubItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaterialBOMSubItem.MaterialBOMSubItemBuilder billOfMaterial( final String value )
        {
            billOfMaterial = value;
            return this;
        }

    }

}
