/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2;

import java.math.BigDecimal;
import java.net.URI;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.SingleValuedFluentHelperFunction;

/**
 * Fluent helper for the <b>UpdateBOMItemWithECN</b> OData function import.
 *
 */
public class UpdateBOMItemWithECNFluentHelper
    extends
    SingleValuedFluentHelperFunction<UpdateBOMItemWithECNFluentHelper, MaterialBOMItem, MaterialBOMItem>
{

    private final Map<String, Object> values = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will execute the <b>UpdateBOMItemWithECN</b> OData function import with the
     * provided parameters. To perform execution, call the {@link #executeRequest executeRequest} method on the fluent
     * helper object.
     *
     * @param deliveryDurationInDays
     *            Delivery time (days)
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 3, Scale: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeliveryDurationInDays</b>
     *            </p>
     * @param isMaterialProvision
     *            Mat. Provision Ind.
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>IsMaterialProvision</b>
     *            </p>
     * @param productionSupplyArea
     *            Prodn Supply Area
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ProductionSupplyArea</b>
     *            </p>
     * @param followUpGroup
     *            Follow-up group
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>FollowUpGroup</b>
     *            </p>
     * @param goodsReceiptDuration
     *            GR processing time
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 3, Scale: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>GoodsReceiptDuration</b>
     *            </p>
     * @param validityEndDate
     *            Valid to
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ValidityEndDate</b>
     *            </p>
     * @param explosionType
     *            Explosion type
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ExplosionType</b>
     *            </p>
     * @param materialIsCoProduct
     *            Co-product
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaterialIsCoProduct</b>
     *            </p>
     * @param materialPriceUnitQty
     *            Price unit
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 5, Scale: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaterialPriceUnitQty</b>
     *            </p>
     * @param bOMItemSorter
     *            Sort String
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMItemSorter</b>
     *            </p>
     * @param chgToEngineeringChgDocument
     *            Change Number To
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ChgToEngineeringChgDocument</b>
     *            </p>
     * @param formulaKey
     *            VSI Formula
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>FormulaKey</b>
     *            </p>
     * @param operationScrapInPercent
     *            Operation Scrap in %
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 5, Scale: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OperationScrapInPercent</b>
     *            </p>
     * @param bOMItemDescription
     *            Item Text
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMItemDescription</b>
     *            </p>
     * @param engineeringChangeDocForEdit
     *            Change Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>EngineeringChangeDocForEdit</b>
     *            </p>
     * @param billOfMaterial
     *            Bill of Material
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterial</b>
     *            </p>
     * @param billOfMaterialItemNodeNumber
     *            Item node
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialItemNodeNumber</b>
     *            </p>
     * @param preliminaryComponent
     *            Material Description
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PreliminaryComponent</b>
     *            </p>
     * @param billOfMaterialItemObjectType
     *            Object Type
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialItemObjectType</b>
     *            </p>
     * @param alternativeItemPriority
     *            Priority
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>AlternativeItemPriority</b>
     *            </p>
     * @param requiredComponent
     *            Required Component
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>RequiredComponent</b>
     *            </p>
     * @param bOMItemRecordCreationDate
     *            Created On
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMItemRecordCreationDate</b>
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Plant</b>
     *            </p>
     * @param bOMItemCreatedByUser
     *            Created By
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMItemCreatedByUser</b>
     *            </p>
     * @param creditor
     *            Supplier
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Creditor</b>
     *            </p>
     * @param resultingItemCategory
     *            Res. item category
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ResultingItemCategory</b>
     *            </p>
     * @param costElement
     *            Cost element
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CostElement</b>
     *            </p>
     * @param prodOrderIssueLocation
     *            Storage Location
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ProdOrderIssueLocation</b>
     *            </p>
     * @param isAssembly
     *            Single-Character Flag
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>IsAssembly</b>
     *            </p>
     * @param purchasingOrganization
     *            Purch. Organization
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PurchasingOrganization</b>
     *            </p>
     * @param alternativeItemGroup
     *            AltItemGroup
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>AlternativeItemGroup</b>
     *            </p>
     * @param dependencyObjectNumber
     *            Assignment number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 18
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DependencyObjectNumber</b>
     *            </p>
     * @param inheritedNodeNumberForBOMItem
     *            Item node
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 8
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>InheritedNodeNumberForBOMItem</b>
     *            </p>
     * @param bOMItemIsCostingRelevant
     *            Relevancy to costing
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMItemIsCostingRelevant</b>
     *            </p>
     * @param classNumber
     *            Class
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 18
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ClassNumber</b>
     *            </p>
     * @param billOfMaterialItemUUID
     *            ID item chge status
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialItemUUID</b>
     *            </p>
     * @param isDeleted
     *            Deletion Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>IsDeleted</b>
     *            </p>
     * @param engineeringChangeDocument
     *            Change Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>EngineeringChangeDocument</b>
     *            </p>
     * @param bOMItemIsSalesRelevant
     *            Relevant to sales
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMItemIsSalesRelevant</b>
     *            </p>
     * @param materialComponentPrice
     *            Price
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 12, Scale: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaterialComponentPrice</b>
     *            </p>
     * @param leadTimeOffset
     *            Lead-time offset
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 3, Scale: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>LeadTimeOffset</b>
     *            </p>
     * @param lastChangeDateTime
     *            Time Stamp
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 7
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>LastChangeDateTime</b>
     *            </p>
     * @param currency
     *            Currency
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 5
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Currency</b>
     *            </p>
     * @param isConfigurableBOM
     *            Selection indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>IsConfigurableBOM</b>
     *            </p>
     * @param opsLeadTimeOffsetUnit
     *            Operation LTO unit
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OpsLeadTimeOffsetUnit</b>
     *            </p>
     * @param bOMItemLastChangeDate
     *            Changed On
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMItemLastChangeDate</b>
     *            </p>
     * @param specialProcurementType
     *            Special Procurement
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SpecialProcurementType</b>
     *            </p>
     * @param discontinuationGroup
     *            Discont. group
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DiscontinuationGroup</b>
     *            </p>
     * @param bOMItemLastChangedByUser
     *            Changed By
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMItemLastChangedByUser</b>
     *            </p>
     * @param operationLeadTimeOffset
     *            Oper. LT offset
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 3, Scale: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OperationLeadTimeOffset</b>
     *            </p>
     * @param servicePath
     *            Service path to be used to call the functions against.
     * @param bOMItemInternalChangeCount
     *            Counter
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 8
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMItemInternalChangeCount</b>
     *            </p>
     * @param isNetScrap
     *            Net Scrap Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>IsNetScrap</b>
     *            </p>
     * @param billOfMaterialItemUnit
     *            Component UoM
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialItemUnit</b>
     *            </p>
     * @param documentPart
     *            Document Part
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DocumentPart</b>
     *            </p>
     * @param billOfMaterialComponent
     *            Component
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialComponent</b>
     *            </p>
     * @param docNumber
     *            Document
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 25
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DocNumber</b>
     *            </p>
     * @param unitOfMeasureForSize1To3
     *            Size unit
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>UnitOfMeasureForSize1To3</b>
     *            </p>
     * @param bOMItemIsSparePart
     *            Spare Part Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMItemIsSparePart</b>
     *            </p>
     * @param usageProbabilityPercent
     *            Usage Probability
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 3, Scale: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>UsageProbabilityPercent</b>
     *            </p>
     * @param documentVersion
     *            Document Version
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DocumentVersion</b>
     *            </p>
     * @param distrKeyCompConsumption
     *            Distribution key
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DistrKeyCompConsumption</b>
     *            </p>
     * @param bOMItemHasFixedQuantity
     *            Fixed Quantity
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMItemHasFixedQuantity</b>
     *            </p>
     * @param bOMIsRecursive
     *            Recursive
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMIsRecursive</b>
     *            </p>
     * @param headerChangeDocument
     *            Change Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>HeaderChangeDocument</b>
     *            </p>
     * @param componentScrapInPercent
     *            Component Scrap (%)
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 5, Scale: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ComponentScrapInPercent</b>
     *            </p>
     * @param purchasingGroup
     *            Purchasing Group
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PurchasingGroup</b>
     *            </p>
     * @param bOMItemText2
     *            Item Text 2
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMItemText2</b>
     *            </p>
     * @param materialGroup
     *            Material Group
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 9
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaterialGroup</b>
     *            </p>
     * @param classType
     *            Class Type
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ClassType</b>
     *            </p>
     * @param bOMItemIsPlantMaintRelevant
     *            Plant maintenance
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BOMItemIsPlantMaintRelevant</b>
     *            </p>
     * @param identifierBOMItem
     *            Item identification
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 8
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>IdentifierBOMItem</b>
     *            </p>
     * @param variableSizeItemQuantity
     *            No. of VSI Required
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 13, Scale: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>VariableSizeItemQuantity</b>
     *            </p>
     * @param documentType
     *            Document Type
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DocumentType</b>
     *            </p>
     * @param isBOMRecursiveAllowed
     *            Recurs. allowed
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>IsBOMRecursiveAllowed</b>
     *            </p>
     * @param isBulkMaterial
     *            Bulk Material
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>IsBulkMaterial</b>
     *            </p>
     * @param quantityVariableSizeItem
     *            VSI Quantity per PC
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 13, Scale: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>QuantityVariableSizeItem</b>
     *            </p>
     * @param size3
     *            Size 3
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 13, Scale: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Size3</b>
     *            </p>
     * @param variableSizeCompUnitOfMeasure
     *            Var-size item unit
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>VariableSizeCompUnitOfMeasure</b>
     *            </p>
     * @param billOfMaterialCategory
     *            BOM category
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialCategory</b>
     *            </p>
     * @param size1
     *            Size 1
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 13, Scale: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Size1</b>
     *            </p>
     * @param size2
     *            Size 2
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 13, Scale: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Size2</b>
     *            </p>
     * @param billOfMaterialItemNumber
     *            Item Number
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialItemNumber</b>
     *            </p>
     * @param billOfMaterialVariant
     *            Alternative BOM
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialVariant</b>
     *            </p>
     * @param multipleSelectionAllowed
     *            Multiple Selection
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MultipleSelectionAllowed</b>
     *            </p>
     * @param documentIsCreatedByCAD
     *            CAD Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DocumentIsCreatedByCAD</b>
     *            </p>
     * @param validityStartDate
     *            Valid From
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ValidityStartDate</b>
     *            </p>
     * @param isSubItem
     *            Sub-item indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>IsSubItem</b>
     *            </p>
     * @param billOfMaterialVersion
     *            BOM Version
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialVersion</b>
     *            </p>
     * @param componentDescription
     *            Item Text
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ComponentDescription</b>
     *            </p>
     * @param isALE
     *            ALE indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>IsALE</b>
     *            </p>
     * @param alternativeItemStrategy
     *            Strategy
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>AlternativeItemStrategy</b>
     *            </p>
     * @param referencePoint
     *            Reference point
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 20
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ReferencePoint</b>
     *            </p>
     * @param isClassificationRelevant
     *            as selection cond.
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>IsClassificationRelevant</b>
     *            </p>
     * @param material
     *            Material
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Material</b>
     *            </p>
     * @param billOfMaterialItemQuantity
     *            Component Quantity
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 13, Scale: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialItemQuantity</b>
     *            </p>
     * @param isProductionRelevant
     *            Production relevant
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>IsProductionRelevant</b>
     *            </p>
     * @param billOfMaterialItemCategory
     *            Item Category
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 1
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BillOfMaterialItemCategory</b>
     *            </p>
     * @param isEngineeringRelevant
     *            Engineering/design
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>IsEngineeringRelevant</b>
     *            </p>
     */
    public UpdateBOMItemWithECNFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String billOfMaterial,
        @Nonnull final String billOfMaterialCategory,
        @Nonnull final String billOfMaterialVariant,
        @Nonnull final String billOfMaterialVersion,
        @Nonnull final String billOfMaterialItemNodeNumber,
        @Nonnull final String headerChangeDocument,
        @Nonnull final String material,
        @Nonnull final String plant,
        @Nullable final UUID billOfMaterialItemUUID,
        @Nullable final String bOMItemInternalChangeCount,
        @Nullable final LocalDateTime validityStartDate,
        @Nullable final LocalDateTime validityEndDate,
        @Nullable final String engineeringChangeDocForEdit,
        @Nullable final String engineeringChangeDocument,
        @Nullable final String chgToEngineeringChgDocument,
        @Nullable final String inheritedNodeNumberForBOMItem,
        @Nullable final LocalDateTime bOMItemRecordCreationDate,
        @Nullable final String bOMItemCreatedByUser,
        @Nullable final LocalDateTime bOMItemLastChangeDate,
        @Nullable final String bOMItemLastChangedByUser,
        @Nullable final String billOfMaterialComponent,
        @Nullable final String billOfMaterialItemCategory,
        @Nullable final String billOfMaterialItemNumber,
        @Nullable final String billOfMaterialItemUnit,
        @Nullable final BigDecimal billOfMaterialItemQuantity,
        @Nullable final String isAssembly,
        @Nullable final Boolean isSubItem,
        @Nullable final String bOMItemSorter,
        @Nullable final Boolean bOMItemHasFixedQuantity,
        @Nullable final String purchasingGroup,
        @Nullable final String currency,
        @Nullable final BigDecimal materialComponentPrice,
        @Nullable final String identifierBOMItem,
        @Nullable final BigDecimal materialPriceUnitQty,
        @Nullable final BigDecimal componentScrapInPercent,
        @Nullable final BigDecimal operationScrapInPercent,
        @Nullable final Boolean isNetScrap,
        @Nullable final BigDecimal variableSizeItemQuantity,
        @Nullable final String variableSizeCompUnitOfMeasure,
        @Nullable final BigDecimal quantityVariableSizeItem,
        @Nullable final String formulaKey,
        @Nullable final String componentDescription,
        @Nullable final String bOMItemDescription,
        @Nullable final String bOMItemText2,
        @Nullable final String materialGroup,
        @Nullable final String documentType,
        @Nullable final String docNumber,
        @Nullable final String documentVersion,
        @Nullable final String documentPart,
        @Nullable final String classNumber,
        @Nullable final String classType,
        @Nullable final String resultingItemCategory,
        @Nullable final String dependencyObjectNumber,
        @Nullable final String billOfMaterialItemObjectType,
        @Nullable final Boolean isClassificationRelevant,
        @Nullable final Boolean isBulkMaterial,
        @Nullable final String bOMItemIsSparePart,
        @Nullable final String bOMItemIsSalesRelevant,
        @Nullable final Boolean isProductionRelevant,
        @Nullable final Boolean bOMItemIsPlantMaintRelevant,
        @Nullable final String bOMItemIsCostingRelevant,
        @Nullable final Boolean isEngineeringRelevant,
        @Nullable final String specialProcurementType,
        @Nullable final Boolean isBOMRecursiveAllowed,
        @Nullable final BigDecimal operationLeadTimeOffset,
        @Nullable final String opsLeadTimeOffsetUnit,
        @Nullable final String isMaterialProvision,
        @Nullable final Boolean bOMIsRecursive,
        @Nullable final Boolean documentIsCreatedByCAD,
        @Nullable final String distrKeyCompConsumption,
        @Nullable final BigDecimal deliveryDurationInDays,
        @Nullable final String creditor,
        @Nullable final String costElement,
        @Nullable final BigDecimal size1,
        @Nullable final BigDecimal size2,
        @Nullable final BigDecimal size3,
        @Nullable final String unitOfMeasureForSize1To3,
        @Nullable final BigDecimal goodsReceiptDuration,
        @Nullable final String purchasingOrganization,
        @Nullable final Boolean requiredComponent,
        @Nullable final Boolean multipleSelectionAllowed,
        @Nullable final String prodOrderIssueLocation,
        @Nullable final Boolean materialIsCoProduct,
        @Nullable final String explosionType,
        @Nullable final String alternativeItemGroup,
        @Nullable final String alternativeItemPriority,
        @Nullable final String alternativeItemStrategy,
        @Nullable final BigDecimal usageProbabilityPercent,
        @Nullable final String followUpGroup,
        @Nullable final String discontinuationGroup,
        @Nullable final String isConfigurableBOM,
        @Nullable final String referencePoint,
        @Nullable final BigDecimal leadTimeOffset,
        @Nullable final String productionSupplyArea,
        @Nullable final Boolean isDeleted,
        @Nullable final Boolean isALE,
        @Nullable final ZonedDateTime lastChangeDateTime,
        @Nullable final String preliminaryComponent )
    {
        super(servicePath);
        values.put("BillOfMaterial", billOfMaterial);
        values.put("BillOfMaterialCategory", billOfMaterialCategory);
        values.put("BillOfMaterialVariant", billOfMaterialVariant);
        values.put("BillOfMaterialVersion", billOfMaterialVersion);
        values.put("BillOfMaterialItemNodeNumber", billOfMaterialItemNodeNumber);
        values.put("HeaderChangeDocument", headerChangeDocument);
        values.put("Material", material);
        values.put("Plant", plant);
        if( billOfMaterialItemUUID != null ) {
            values.put("BillOfMaterialItemUUID", billOfMaterialItemUUID);
        }
        if( bOMItemInternalChangeCount != null ) {
            values.put("BOMItemInternalChangeCount", bOMItemInternalChangeCount);
        }
        if( validityStartDate != null ) {
            values.put("ValidityStartDate", validityStartDate);
        }
        if( validityEndDate != null ) {
            values.put("ValidityEndDate", validityEndDate);
        }
        if( engineeringChangeDocForEdit != null ) {
            values.put("EngineeringChangeDocForEdit", engineeringChangeDocForEdit);
        }
        if( engineeringChangeDocument != null ) {
            values.put("EngineeringChangeDocument", engineeringChangeDocument);
        }
        if( chgToEngineeringChgDocument != null ) {
            values.put("ChgToEngineeringChgDocument", chgToEngineeringChgDocument);
        }
        if( inheritedNodeNumberForBOMItem != null ) {
            values.put("InheritedNodeNumberForBOMItem", inheritedNodeNumberForBOMItem);
        }
        if( bOMItemRecordCreationDate != null ) {
            values.put("BOMItemRecordCreationDate", bOMItemRecordCreationDate);
        }
        if( bOMItemCreatedByUser != null ) {
            values.put("BOMItemCreatedByUser", bOMItemCreatedByUser);
        }
        if( bOMItemLastChangeDate != null ) {
            values.put("BOMItemLastChangeDate", bOMItemLastChangeDate);
        }
        if( bOMItemLastChangedByUser != null ) {
            values.put("BOMItemLastChangedByUser", bOMItemLastChangedByUser);
        }
        if( billOfMaterialComponent != null ) {
            values.put("BillOfMaterialComponent", billOfMaterialComponent);
        }
        if( billOfMaterialItemCategory != null ) {
            values.put("BillOfMaterialItemCategory", billOfMaterialItemCategory);
        }
        if( billOfMaterialItemNumber != null ) {
            values.put("BillOfMaterialItemNumber", billOfMaterialItemNumber);
        }
        if( billOfMaterialItemUnit != null ) {
            values.put("BillOfMaterialItemUnit", billOfMaterialItemUnit);
        }
        if( billOfMaterialItemQuantity != null ) {
            values.put("BillOfMaterialItemQuantity", billOfMaterialItemQuantity);
        }
        if( isAssembly != null ) {
            values.put("IsAssembly", isAssembly);
        }
        if( isSubItem != null ) {
            values.put("IsSubItem", isSubItem);
        }
        if( bOMItemSorter != null ) {
            values.put("BOMItemSorter", bOMItemSorter);
        }
        if( bOMItemHasFixedQuantity != null ) {
            values.put("BOMItemHasFixedQuantity", bOMItemHasFixedQuantity);
        }
        if( purchasingGroup != null ) {
            values.put("PurchasingGroup", purchasingGroup);
        }
        if( currency != null ) {
            values.put("Currency", currency);
        }
        if( materialComponentPrice != null ) {
            values.put("MaterialComponentPrice", materialComponentPrice);
        }
        if( identifierBOMItem != null ) {
            values.put("IdentifierBOMItem", identifierBOMItem);
        }
        if( materialPriceUnitQty != null ) {
            values.put("MaterialPriceUnitQty", materialPriceUnitQty);
        }
        if( componentScrapInPercent != null ) {
            values.put("ComponentScrapInPercent", componentScrapInPercent);
        }
        if( operationScrapInPercent != null ) {
            values.put("OperationScrapInPercent", operationScrapInPercent);
        }
        if( isNetScrap != null ) {
            values.put("IsNetScrap", isNetScrap);
        }
        if( variableSizeItemQuantity != null ) {
            values.put("VariableSizeItemQuantity", variableSizeItemQuantity);
        }
        if( variableSizeCompUnitOfMeasure != null ) {
            values.put("VariableSizeCompUnitOfMeasure", variableSizeCompUnitOfMeasure);
        }
        if( quantityVariableSizeItem != null ) {
            values.put("QuantityVariableSizeItem", quantityVariableSizeItem);
        }
        if( formulaKey != null ) {
            values.put("FormulaKey", formulaKey);
        }
        if( componentDescription != null ) {
            values.put("ComponentDescription", componentDescription);
        }
        if( bOMItemDescription != null ) {
            values.put("BOMItemDescription", bOMItemDescription);
        }
        if( bOMItemText2 != null ) {
            values.put("BOMItemText2", bOMItemText2);
        }
        if( materialGroup != null ) {
            values.put("MaterialGroup", materialGroup);
        }
        if( documentType != null ) {
            values.put("DocumentType", documentType);
        }
        if( docNumber != null ) {
            values.put("DocNumber", docNumber);
        }
        if( documentVersion != null ) {
            values.put("DocumentVersion", documentVersion);
        }
        if( documentPart != null ) {
            values.put("DocumentPart", documentPart);
        }
        if( classNumber != null ) {
            values.put("ClassNumber", classNumber);
        }
        if( classType != null ) {
            values.put("ClassType", classType);
        }
        if( resultingItemCategory != null ) {
            values.put("ResultingItemCategory", resultingItemCategory);
        }
        if( dependencyObjectNumber != null ) {
            values.put("DependencyObjectNumber", dependencyObjectNumber);
        }
        if( billOfMaterialItemObjectType != null ) {
            values.put("BillOfMaterialItemObjectType", billOfMaterialItemObjectType);
        }
        if( isClassificationRelevant != null ) {
            values.put("IsClassificationRelevant", isClassificationRelevant);
        }
        if( isBulkMaterial != null ) {
            values.put("IsBulkMaterial", isBulkMaterial);
        }
        if( bOMItemIsSparePart != null ) {
            values.put("BOMItemIsSparePart", bOMItemIsSparePart);
        }
        if( bOMItemIsSalesRelevant != null ) {
            values.put("BOMItemIsSalesRelevant", bOMItemIsSalesRelevant);
        }
        if( isProductionRelevant != null ) {
            values.put("IsProductionRelevant", isProductionRelevant);
        }
        if( bOMItemIsPlantMaintRelevant != null ) {
            values.put("BOMItemIsPlantMaintRelevant", bOMItemIsPlantMaintRelevant);
        }
        if( bOMItemIsCostingRelevant != null ) {
            values.put("BOMItemIsCostingRelevant", bOMItemIsCostingRelevant);
        }
        if( isEngineeringRelevant != null ) {
            values.put("IsEngineeringRelevant", isEngineeringRelevant);
        }
        if( specialProcurementType != null ) {
            values.put("SpecialProcurementType", specialProcurementType);
        }
        if( isBOMRecursiveAllowed != null ) {
            values.put("IsBOMRecursiveAllowed", isBOMRecursiveAllowed);
        }
        if( operationLeadTimeOffset != null ) {
            values.put("OperationLeadTimeOffset", operationLeadTimeOffset);
        }
        if( opsLeadTimeOffsetUnit != null ) {
            values.put("OpsLeadTimeOffsetUnit", opsLeadTimeOffsetUnit);
        }
        if( isMaterialProvision != null ) {
            values.put("IsMaterialProvision", isMaterialProvision);
        }
        if( bOMIsRecursive != null ) {
            values.put("BOMIsRecursive", bOMIsRecursive);
        }
        if( documentIsCreatedByCAD != null ) {
            values.put("DocumentIsCreatedByCAD", documentIsCreatedByCAD);
        }
        if( distrKeyCompConsumption != null ) {
            values.put("DistrKeyCompConsumption", distrKeyCompConsumption);
        }
        if( deliveryDurationInDays != null ) {
            values.put("DeliveryDurationInDays", deliveryDurationInDays);
        }
        if( creditor != null ) {
            values.put("Creditor", creditor);
        }
        if( costElement != null ) {
            values.put("CostElement", costElement);
        }
        if( size1 != null ) {
            values.put("Size1", size1);
        }
        if( size2 != null ) {
            values.put("Size2", size2);
        }
        if( size3 != null ) {
            values.put("Size3", size3);
        }
        if( unitOfMeasureForSize1To3 != null ) {
            values.put("UnitOfMeasureForSize1To3", unitOfMeasureForSize1To3);
        }
        if( goodsReceiptDuration != null ) {
            values.put("GoodsReceiptDuration", goodsReceiptDuration);
        }
        if( purchasingOrganization != null ) {
            values.put("PurchasingOrganization", purchasingOrganization);
        }
        if( requiredComponent != null ) {
            values.put("RequiredComponent", requiredComponent);
        }
        if( multipleSelectionAllowed != null ) {
            values.put("MultipleSelectionAllowed", multipleSelectionAllowed);
        }
        if( prodOrderIssueLocation != null ) {
            values.put("ProdOrderIssueLocation", prodOrderIssueLocation);
        }
        if( materialIsCoProduct != null ) {
            values.put("MaterialIsCoProduct", materialIsCoProduct);
        }
        if( explosionType != null ) {
            values.put("ExplosionType", explosionType);
        }
        if( alternativeItemGroup != null ) {
            values.put("AlternativeItemGroup", alternativeItemGroup);
        }
        if( alternativeItemPriority != null ) {
            values.put("AlternativeItemPriority", alternativeItemPriority);
        }
        if( alternativeItemStrategy != null ) {
            values.put("AlternativeItemStrategy", alternativeItemStrategy);
        }
        if( usageProbabilityPercent != null ) {
            values.put("UsageProbabilityPercent", usageProbabilityPercent);
        }
        if( followUpGroup != null ) {
            values.put("FollowUpGroup", followUpGroup);
        }
        if( discontinuationGroup != null ) {
            values.put("DiscontinuationGroup", discontinuationGroup);
        }
        if( isConfigurableBOM != null ) {
            values.put("IsConfigurableBOM", isConfigurableBOM);
        }
        if( referencePoint != null ) {
            values.put("ReferencePoint", referencePoint);
        }
        if( leadTimeOffset != null ) {
            values.put("LeadTimeOffset", leadTimeOffset);
        }
        if( productionSupplyArea != null ) {
            values.put("ProductionSupplyArea", productionSupplyArea);
        }
        if( isDeleted != null ) {
            values.put("IsDeleted", isDeleted);
        }
        if( isALE != null ) {
            values.put("IsALE", isALE);
        }
        if( lastChangeDateTime != null ) {
            values.put("LastChangeDateTime", lastChangeDateTime);
        }
        if( preliminaryComponent != null ) {
            values.put("PreliminaryComponent", preliminaryComponent);
        }
    }

    @Override
    @Nonnull
    protected Class<MaterialBOMItem> getEntityClass()
    {
        return MaterialBOMItem.class;
    }

    @Override
    @Nonnull
    protected String getFunctionName()
    {
        return "UpdateBOMItemWithECN";
    }

    @Override
    @Nullable
    protected JsonElement refineJsonResponse( @Nullable JsonElement jsonElement )
    {
        if( (jsonElement instanceof JsonObject) && ((JsonObject) jsonElement).has(getFunctionName()) ) {
            jsonElement = ((JsonObject) jsonElement).get(getFunctionName());
        }
        return super.refineJsonResponse(jsonElement);
    }

    @Override
    @Nonnull
    protected Map<String, Object> getParameters()
    {
        return values;
    }

    @Override
    @Nonnull
    protected HttpUriRequest createRequest( @Nonnull final URI uri )
    {
        return new HttpPost(uri);
    }

    /**
     * Execute this function import.
     *
     */
    @Override
    @Nullable
    public MaterialBOMItem executeRequest( @Nonnull final HttpDestinationProperties destination )
    {
        return super.executeSingle(destination);
    }

}
