/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MBOMItmObjDpnAssignment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOM;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItem;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillOfMaterialsV2Service BillOfMaterialsV2Service}.
 *
 */
public interface BillOfMaterialsV2ServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<BillOfMaterialsV2ServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<BillOfMaterialsV2ServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMItem
     * MaterialBOMItem} entity and save it to the S/4HANA system.
     *
     * @param materialBOMItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMItem
     *            MaterialBOMItem} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BillOfMaterialsV2ServiceBatchChangeSet createMaterialBOMItem( @Nonnull final MaterialBOMItem materialBOMItem );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMItem
     * MaterialBOMItem} entity and save it to the S/4HANA system.
     *
     * @param materialBOMItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMItem
     *            MaterialBOMItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BillOfMaterialsV2ServiceBatchChangeSet updateMaterialBOMItem( @Nonnull final MaterialBOMItem materialBOMItem );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMItem
     * MaterialBOMItem} entity in the S/4HANA system.
     *
     * @param materialBOMItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMItem
     *            MaterialBOMItem} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BillOfMaterialsV2ServiceBatchChangeSet deleteMaterialBOMItem( @Nonnull final MaterialBOMItem materialBOMItem );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItem
     * MaterialBOMSubItem} entity and save it to the S/4HANA system.
     *
     * @param materialBOMSubItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItem
     *            MaterialBOMSubItem} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BillOfMaterialsV2ServiceBatchChangeSet
        createMaterialBOMSubItem( @Nonnull final MaterialBOMSubItem materialBOMSubItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItem
     * MaterialBOMSubItem} entity and save it to the S/4HANA system.
     *
     * @param materialBOMSubItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItem
     *            MaterialBOMSubItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BillOfMaterialsV2ServiceBatchChangeSet
        updateMaterialBOMSubItem( @Nonnull final MaterialBOMSubItem materialBOMSubItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItem
     * MaterialBOMSubItem} entity in the S/4HANA system.
     *
     * @param materialBOMSubItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItem
     *            MaterialBOMSubItem} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BillOfMaterialsV2ServiceBatchChangeSet
        deleteMaterialBOMSubItem( @Nonnull final MaterialBOMSubItem materialBOMSubItem );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOM
     * MaterialBOM} entity and save it to the S/4HANA system.
     *
     * @param materialBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOM MaterialBOM}
     *            entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BillOfMaterialsV2ServiceBatchChangeSet createMaterialBOM( @Nonnull final MaterialBOM materialBOM );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOM
     * MaterialBOM} entity and save it to the S/4HANA system.
     *
     * @param materialBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOM MaterialBOM}
     *            entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BillOfMaterialsV2ServiceBatchChangeSet updateMaterialBOM( @Nonnull final MaterialBOM materialBOM );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOM
     * MaterialBOM} entity in the S/4HANA system.
     *
     * @param materialBOM
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOM MaterialBOM}
     *            entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BillOfMaterialsV2ServiceBatchChangeSet deleteMaterialBOM( @Nonnull final MaterialBOM materialBOM );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MBOMItmObjDpnAssignment
     * MBOMItmObjDpnAssignment} entity and save it to the S/4HANA system.
     *
     * @param mBOMItmObjDpnAssignment
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MBOMItmObjDpnAssignment
     *            MBOMItmObjDpnAssignment} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BillOfMaterialsV2ServiceBatchChangeSet
        updateMBOMItmObjDpnAssignment( @Nonnull final MBOMItmObjDpnAssignment mBOMItmObjDpnAssignment );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MBOMItmObjDpnAssignment
     * MBOMItmObjDpnAssignment} entity in the S/4HANA system.
     *
     * @param mBOMItmObjDpnAssignment
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MBOMItmObjDpnAssignment
     *            MBOMItmObjDpnAssignment} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BillOfMaterialsV2ServiceBatchChangeSet
        deleteMBOMItmObjDpnAssignment( @Nonnull final MBOMItmObjDpnAssignment mBOMItmObjDpnAssignment );

}
