/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MBOMItmObjDpnAssignment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOM;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItem;

/**
 * Implementation of the {@link BillOfMaterialsV2ServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillOfMaterialsV2Service BillOfMaterialsV2Service}.
 *
 */
public class DefaultBillOfMaterialsV2ServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<BillOfMaterialsV2ServiceBatch, BillOfMaterialsV2ServiceBatchChangeSet>
    implements
    BillOfMaterialsV2ServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillOfMaterialsV2Service service;

    @SuppressWarnings( "deprecation" )
    DefaultBillOfMaterialsV2ServiceBatchChangeSet(
        @Nonnull final DefaultBillOfMaterialsV2ServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillOfMaterialsV2Service service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultBillOfMaterialsV2ServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public BillOfMaterialsV2ServiceBatchChangeSet createMaterialBOMItem(
        @Nonnull final MaterialBOMItem materialBOMItem )
    {
        return addRequestCreate(service::createMaterialBOMItem, materialBOMItem);
    }

    @Nonnull
    @Override
    public BillOfMaterialsV2ServiceBatchChangeSet updateMaterialBOMItem(
        @Nonnull final MaterialBOMItem materialBOMItem )
    {
        return addRequestUpdate(service::updateMaterialBOMItem, materialBOMItem);
    }

    @Nonnull
    @Override
    public BillOfMaterialsV2ServiceBatchChangeSet deleteMaterialBOMItem(
        @Nonnull final MaterialBOMItem materialBOMItem )
    {
        return addRequestDelete(service::deleteMaterialBOMItem, materialBOMItem);
    }

    @Nonnull
    @Override
    public BillOfMaterialsV2ServiceBatchChangeSet createMaterialBOMSubItem(
        @Nonnull final MaterialBOMSubItem materialBOMSubItem )
    {
        return addRequestCreate(service::createMaterialBOMSubItem, materialBOMSubItem);
    }

    @Nonnull
    @Override
    public BillOfMaterialsV2ServiceBatchChangeSet updateMaterialBOMSubItem(
        @Nonnull final MaterialBOMSubItem materialBOMSubItem )
    {
        return addRequestUpdate(service::updateMaterialBOMSubItem, materialBOMSubItem);
    }

    @Nonnull
    @Override
    public BillOfMaterialsV2ServiceBatchChangeSet deleteMaterialBOMSubItem(
        @Nonnull final MaterialBOMSubItem materialBOMSubItem )
    {
        return addRequestDelete(service::deleteMaterialBOMSubItem, materialBOMSubItem);
    }

    @Nonnull
    @Override
    public BillOfMaterialsV2ServiceBatchChangeSet createMaterialBOM( @Nonnull final MaterialBOM materialBOM )
    {
        return addRequestCreate(service::createMaterialBOM, materialBOM);
    }

    @Nonnull
    @Override
    public BillOfMaterialsV2ServiceBatchChangeSet updateMaterialBOM( @Nonnull final MaterialBOM materialBOM )
    {
        return addRequestUpdate(service::updateMaterialBOM, materialBOM);
    }

    @Nonnull
    @Override
    public BillOfMaterialsV2ServiceBatchChangeSet deleteMaterialBOM( @Nonnull final MaterialBOM materialBOM )
    {
        return addRequestDelete(service::deleteMaterialBOM, materialBOM);
    }

    @Nonnull
    @Override
    public BillOfMaterialsV2ServiceBatchChangeSet updateMBOMItmObjDpnAssignment(
        @Nonnull final MBOMItmObjDpnAssignment mBOMItmObjDpnAssignment )
    {
        return addRequestUpdate(service::updateMBOMItmObjDpnAssignment, mBOMItmObjDpnAssignment);
    }

    @Nonnull
    @Override
    public BillOfMaterialsV2ServiceBatchChangeSet deleteMBOMItmObjDpnAssignment(
        @Nonnull final MBOMItmObjDpnAssignment mBOMItmObjDpnAssignment )
    {
        return addRequestDelete(service::deleteMBOMItmObjDpnAssignment, mBOMItmObjDpnAssignment);
    }

}
