/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.link;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.EntityLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.selectable.MaterialBOMSubItemSelectable;

/**
 * Template class to represent entity navigation links of
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItem MaterialBOMSubItem}
 * to other entities. Instances of this object are used in query modifier methods of the entity fluent helpers. Contains
 * methods to compare a field's value with a provided value.
 *
 * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData
 * field names, so use the constructor with caution.
 *
 * @param <ObjectT>
 *            Entity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.
 *
 */
public class MaterialBOMSubItemLink<ObjectT extends VdmObject<?>>
    extends
    EntityLink<MaterialBOMSubItemLink<ObjectT>, MaterialBOMSubItem, ObjectT>
    implements
    MaterialBOMSubItemSelectable
{

    /**
     * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying
     * OData field names, so use with caution.
     *
     * @param fieldName
     *            OData navigation field name. Must match the field returned by the underlying OData service.
     */
    public MaterialBOMSubItemLink( final String fieldName )
    {
        super(fieldName);
    }

    private MaterialBOMSubItemLink(
        final EntityLink<MaterialBOMSubItemLink<ObjectT>, MaterialBOMSubItem, ObjectT> toClone )
    {
        super(toClone);
    }

    @Nonnull
    @Override
    protected MaterialBOMSubItemLink<ObjectT> translateLinkType(
        final EntityLink<MaterialBOMSubItemLink<ObjectT>, MaterialBOMSubItem, ObjectT> link )
    {
        return new MaterialBOMSubItemLink<ObjectT>(link);
    }

}
