/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.BillOfMaterialUsageText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.BillOfMaterialUsageText
 * BillOfMaterialUsageText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.field.BillOfMaterialUsageTextField
 * BillOfMaterialUsageTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.link.BillOfMaterialUsageTextLink
 * BillOfMaterialUsageTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.BillOfMaterialUsageText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.BillOfMaterialUsageText#BILL_OF_MATERIAL_VARIANT_USAGE
 * BILL_OF_MATERIAL_VARIANT_USAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.BillOfMaterialUsageText#BILL_OF_MATERIAL_VARIANT_USAGE_DESC
 * BILL_OF_MATERIAL_VARIANT_USAGE_DESC}</li>
 * </ul>
 *
 */
public interface BillOfMaterialUsageTextSelectable extends EntitySelectable<BillOfMaterialUsageText>
{

}
