/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItem MaterialBOMSubItem}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.field.MaterialBOMSubItemField
 * MaterialBOMSubItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.link.MaterialBOMSubItemLink
 * MaterialBOMSubItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItem#DELETE_MC
 * DELETE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItem#UPDATE_MC
 * UPDATE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItem#BILL_OF_MATERIAL
 * BILL_OF_MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItem#BILL_OF_MATERIAL_CATEGORY
 * BILL_OF_MATERIAL_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItem#BILL_OF_MATERIAL_VARIANT
 * BILL_OF_MATERIAL_VARIANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItem#BILL_OF_MATERIAL_VERSION
 * BILL_OF_MATERIAL_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItem#BILL_OF_MATERIAL_ITEM_NODE_NUMBER
 * BILL_OF_MATERIAL_ITEM_NODE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItem#HEADER_CHANGE_DOCUMENT
 * HEADER_CHANGE_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItem#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItem#PLANT PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItem#BOM_ITEM_INTERNAL_CHANGE_COUNT
 * BOM_ITEM_INTERNAL_CHANGE_COUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItem#BOM_SUB_ITEM_NUMBER_VALUE
 * BOM_SUB_ITEM_NUMBER_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItem#BILL_OF_MATERIAL_ITEM_UNIT
 * BILL_OF_MATERIAL_ITEM_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItem#BILL_OF_MATERIAL_SUB_ITEM_QUANTITY
 * BILL_OF_MATERIAL_SUB_ITEM_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItem#BOM_SUB_ITEM_INSTALLATION_POINT
 * BOM_SUB_ITEM_INSTALLATION_POINT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItem#BILL_OF_MATERIAL_SUB_ITEM_TEXT
 * BILL_OF_MATERIAL_SUB_ITEM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItem#TO_BILL_OF_MATERIAL_ITEM
 * TO_BILL_OF_MATERIAL_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billofmaterialsv2.MaterialBOMSubItem#TO_BILL_OF_MATERIAL
 * TO_BILL_OF_MATERIAL}</li>
 * </ul>
 *
 */
public interface MaterialBOMSubItemSelectable extends EntitySelectable<MaterialBOMSubItem>
{

}
