/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billsofmaterialwhereusedlist;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billsofmaterialwhereusedlist.field.BOMWhereUsedField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billsofmaterialwhereusedlist.selectable.BOMWhereUsedSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Where Used List
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BOMWhereUsedType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BOMWhereUsed extends VdmEntity<BOMWhereUsed>
{

    /**
     * Selector for all available fields of BOMWhereUsed.
     *
     */
    public final static BOMWhereUsedSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemUUID</b>
     * </p>
     *
     * @return Global identification of an item's change status
     */
    @Key
    @SerializedName( "BillOfMaterialItemUUID" )
    @JsonProperty( "BillOfMaterialItemUUID" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialItemUUID" )
    private UUID billOfMaterialItemUUID;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialItemUUID</b> field to query operations.
     *
     */
    public final static BOMWhereUsedField<UUID> BILL_OF_MATERIAL_ITEM_UUID =
        new BOMWhereUsedField<UUID>("BillOfMaterialItemUUID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialComponent</b>
     * </p>
     *
     * @return BOM component
     */
    @SerializedName( "BillOfMaterialComponent" )
    @JsonProperty( "BillOfMaterialComponent" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialComponent" )
    private String billOfMaterialComponent;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialComponent</b> field to query operations.
     *
     */
    public final static BOMWhereUsedField<String> BILL_OF_MATERIAL_COMPONENT =
        new BOMWhereUsedField<String>("BillOfMaterialComponent");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemNumber</b>
     * </p>
     *
     * @return BOM Item Number
     */
    @SerializedName( "BillOfMaterialItemNumber" )
    @JsonProperty( "BillOfMaterialItemNumber" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialItemNumber" )
    private String billOfMaterialItemNumber;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialItemNumber</b> field to query operations.
     *
     */
    public final static BOMWhereUsedField<String> BILL_OF_MATERIAL_ITEM_NUMBER =
        new BOMWhereUsedField<String>("BillOfMaterialItemNumber");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>HeaderChangeDocument</b>
     * </p>
     *
     * @return Change Number
     */
    @SerializedName( "HeaderChangeDocument" )
    @JsonProperty( "HeaderChangeDocument" )
    @Nullable
    @ODataField( odataName = "HeaderChangeDocument" )
    private String headerChangeDocument;
    /**
     * Use with available fluent helpers to apply the <b>HeaderChangeDocument</b> field to query operations.
     *
     */
    public final static BOMWhereUsedField<String> HEADER_CHANGE_DOCUMENT =
        new BOMWhereUsedField<String>("HeaderChangeDocument");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialCategory</b>
     * </p>
     *
     * @return BOM category
     */
    @SerializedName( "BillOfMaterialCategory" )
    @JsonProperty( "BillOfMaterialCategory" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialCategory" )
    private String billOfMaterialCategory;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialCategory</b> field to query operations.
     *
     */
    public final static BOMWhereUsedField<String> BILL_OF_MATERIAL_CATEGORY =
        new BOMWhereUsedField<String>("BillOfMaterialCategory");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterial</b>
     * </p>
     *
     * @return Bill of Material
     */
    @SerializedName( "BillOfMaterial" )
    @JsonProperty( "BillOfMaterial" )
    @Nullable
    @ODataField( odataName = "BillOfMaterial" )
    private String billOfMaterial;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterial</b> field to query operations.
     *
     */
    public final static BOMWhereUsedField<String> BILL_OF_MATERIAL = new BOMWhereUsedField<String>("BillOfMaterial");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialVariant</b>
     * </p>
     *
     * @return Alternative BOM
     */
    @SerializedName( "BillOfMaterialVariant" )
    @JsonProperty( "BillOfMaterialVariant" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialVariant" )
    private String billOfMaterialVariant;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialVariant</b> field to query operations.
     *
     */
    public final static BOMWhereUsedField<String> BILL_OF_MATERIAL_VARIANT =
        new BOMWhereUsedField<String>("BillOfMaterialVariant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialVersion</b>
     * </p>
     *
     * @return BOM Version
     */
    @SerializedName( "BillOfMaterialVersion" )
    @JsonProperty( "BillOfMaterialVersion" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialVersion" )
    private String billOfMaterialVersion;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialVersion</b> field to query operations.
     *
     */
    public final static BOMWhereUsedField<String> BILL_OF_MATERIAL_VERSION =
        new BOMWhereUsedField<String>("BillOfMaterialVersion");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemCategory</b>
     * </p>
     *
     * @return Item category (bill of material)
     */
    @SerializedName( "BillOfMaterialItemCategory" )
    @JsonProperty( "BillOfMaterialItemCategory" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialItemCategory" )
    private String billOfMaterialItemCategory;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialItemCategory</b> field to query operations.
     *
     */
    public final static BOMWhereUsedField<String> BILL_OF_MATERIAL_ITEM_CATEGORY =
        new BOMWhereUsedField<String>("BillOfMaterialItemCategory");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemUnit</b>
     * </p>
     *
     * @return Component Unit of Measure
     */
    @SerializedName( "BillOfMaterialItemUnit" )
    @JsonProperty( "BillOfMaterialItemUnit" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialItemUnit" )
    private String billOfMaterialItemUnit;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialItemUnit</b> field to query operations.
     *
     */
    public final static BOMWhereUsedField<String> BILL_OF_MATERIAL_ITEM_UNIT =
        new BOMWhereUsedField<String>("BillOfMaterialItemUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemQuantity</b>
     * </p>
     *
     * @return Component Quantity
     */
    @SerializedName( "BillOfMaterialItemQuantity" )
    @JsonProperty( "BillOfMaterialItemQuantity" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialItemQuantity" )
    private BigDecimal billOfMaterialItemQuantity;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialItemQuantity</b> field to query operations.
     *
     */
    public final static BOMWhereUsedField<BigDecimal> BILL_OF_MATERIAL_ITEM_QUANTITY =
        new BOMWhereUsedField<BigDecimal>("BillOfMaterialItemQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>EngineeringChangeDocument</b>
     * </p>
     *
     * @return Change Number
     */
    @SerializedName( "EngineeringChangeDocument" )
    @JsonProperty( "EngineeringChangeDocument" )
    @Nullable
    @ODataField( odataName = "EngineeringChangeDocument" )
    private String engineeringChangeDocument;
    /**
     * Use with available fluent helpers to apply the <b>EngineeringChangeDocument</b> field to query operations.
     *
     */
    public final static BOMWhereUsedField<String> ENGINEERING_CHANGE_DOCUMENT =
        new BOMWhereUsedField<String>("EngineeringChangeDocument");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Valid-From Date
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static BOMWhereUsedField<LocalDateTime> VALIDITY_START_DATE =
        new BOMWhereUsedField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Valid-to date
     */
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static BOMWhereUsedField<LocalDateTime> VALIDITY_END_DATE =
        new BOMWhereUsedField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemNodeNumber</b>
     * </p>
     *
     * @return BOM item node number
     */
    @SerializedName( "BillOfMaterialItemNodeNumber" )
    @JsonProperty( "BillOfMaterialItemNodeNumber" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialItemNodeNumber" )
    private String billOfMaterialItemNodeNumber;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialItemNodeNumber</b> field to query operations.
     *
     */
    public final static BOMWhereUsedField<String> BILL_OF_MATERIAL_ITEM_NODE_NUMBER =
        new BOMWhereUsedField<String>("BillOfMaterialItemNodeNumber");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemDescription</b>
     * </p>
     *
     * @return BOM Item Text (Line 1)
     */
    @SerializedName( "BOMItemDescription" )
    @JsonProperty( "BOMItemDescription" )
    @Nullable
    @ODataField( odataName = "BOMItemDescription" )
    private String bOMItemDescription;
    /**
     * Use with available fluent helpers to apply the <b>BOMItemDescription</b> field to query operations.
     *
     */
    public final static BOMWhereUsedField<String> BOM_ITEM_DESCRIPTION =
        new BOMWhereUsedField<String>("BOMItemDescription");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static BOMWhereUsedField<String> MATERIAL = new BOMWhereUsedField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaterialName</b>
     * </p>
     *
     * @return Material Description
     */
    @SerializedName( "MaterialName" )
    @JsonProperty( "MaterialName" )
    @Nullable
    @ODataField( odataName = "MaterialName" )
    private String materialName;
    /**
     * Use with available fluent helpers to apply the <b>MaterialName</b> field to query operations.
     *
     */
    public final static BOMWhereUsedField<String> MATERIAL_NAME = new BOMWhereUsedField<String>("MaterialName");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PlantName</b>
     * </p>
     *
     * @return Plant Name
     */
    @SerializedName( "PlantName" )
    @JsonProperty( "PlantName" )
    @Nullable
    @ODataField( odataName = "PlantName" )
    private String plantName;
    /**
     * Use with available fluent helpers to apply the <b>PlantName</b> field to query operations.
     *
     */
    public final static BOMWhereUsedField<String> PLANT_NAME = new BOMWhereUsedField<String>("PlantName");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialVariantUsageDesc</b>
     * </p>
     *
     * @return BOM usage text
     */
    @SerializedName( "BillOfMaterialVariantUsageDesc" )
    @JsonProperty( "BillOfMaterialVariantUsageDesc" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialVariantUsageDesc" )
    private String billOfMaterialVariantUsageDesc;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialVariantUsageDesc</b> field to query operations.
     *
     */
    public final static BOMWhereUsedField<String> BILL_OF_MATERIAL_VARIANT_USAGE_DESC =
        new BOMWhereUsedField<String>("BillOfMaterialVariantUsageDesc");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static BOMWhereUsedField<String> PLANT = new BOMWhereUsedField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialVariantUsage</b>
     * </p>
     *
     * @return BOM Usage
     */
    @SerializedName( "BillOfMaterialVariantUsage" )
    @JsonProperty( "BillOfMaterialVariantUsage" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialVariantUsage" )
    private String billOfMaterialVariantUsage;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialVariantUsage</b> field to query operations.
     *
     */
    public final static BOMWhereUsedField<String> BILL_OF_MATERIAL_VARIANT_USAGE =
        new BOMWhereUsedField<String>("BillOfMaterialVariantUsage");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BOMVersionStatus</b>
     * </p>
     *
     * @return BOM Version Status
     */
    @SerializedName( "BOMVersionStatus" )
    @JsonProperty( "BOMVersionStatus" )
    @Nullable
    @ODataField( odataName = "BOMVersionStatus" )
    private String bOMVersionStatus;
    /**
     * Use with available fluent helpers to apply the <b>BOMVersionStatus</b> field to query operations.
     *
     */
    public final static BOMWhereUsedField<String> BOM_VERSION_STATUS =
        new BOMWhereUsedField<String>("BOMVersionStatus");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BOMVersionStatusDescription</b>
     * </p>
     *
     * @return Short Text for Fixed Values
     */
    @SerializedName( "BOMVersionStatusDescription" )
    @JsonProperty( "BOMVersionStatusDescription" )
    @Nullable
    @ODataField( odataName = "BOMVersionStatusDescription" )
    private String bOMVersionStatusDescription;
    /**
     * Use with available fluent helpers to apply the <b>BOMVersionStatusDescription</b> field to query operations.
     *
     */
    public final static BOMWhereUsedField<String> BOM_VERSION_STATUS_DESCRIPTION =
        new BOMWhereUsedField<String>("BOMVersionStatusDescription");

    @Nonnull
    @Override
    public Class<BOMWhereUsed> getType()
    {
        return BOMWhereUsed.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemUUID</b>
     * </p>
     *
     * @param billOfMaterialItemUUID
     *            Global identification of an item's change status
     */
    public void setBillOfMaterialItemUUID( @Nullable final UUID billOfMaterialItemUUID )
    {
        rememberChangedField("BillOfMaterialItemUUID", this.billOfMaterialItemUUID);
        this.billOfMaterialItemUUID = billOfMaterialItemUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialComponent</b>
     * </p>
     *
     * @param billOfMaterialComponent
     *            BOM component
     */
    public void setBillOfMaterialComponent( @Nullable final String billOfMaterialComponent )
    {
        rememberChangedField("BillOfMaterialComponent", this.billOfMaterialComponent);
        this.billOfMaterialComponent = billOfMaterialComponent;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemNumber</b>
     * </p>
     *
     * @param billOfMaterialItemNumber
     *            BOM Item Number
     */
    public void setBillOfMaterialItemNumber( @Nullable final String billOfMaterialItemNumber )
    {
        rememberChangedField("BillOfMaterialItemNumber", this.billOfMaterialItemNumber);
        this.billOfMaterialItemNumber = billOfMaterialItemNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>HeaderChangeDocument</b>
     * </p>
     *
     * @param headerChangeDocument
     *            Change Number
     */
    public void setHeaderChangeDocument( @Nullable final String headerChangeDocument )
    {
        rememberChangedField("HeaderChangeDocument", this.headerChangeDocument);
        this.headerChangeDocument = headerChangeDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialCategory</b>
     * </p>
     *
     * @param billOfMaterialCategory
     *            BOM category
     */
    public void setBillOfMaterialCategory( @Nullable final String billOfMaterialCategory )
    {
        rememberChangedField("BillOfMaterialCategory", this.billOfMaterialCategory);
        this.billOfMaterialCategory = billOfMaterialCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterial</b>
     * </p>
     *
     * @param billOfMaterial
     *            Bill of Material
     */
    public void setBillOfMaterial( @Nullable final String billOfMaterial )
    {
        rememberChangedField("BillOfMaterial", this.billOfMaterial);
        this.billOfMaterial = billOfMaterial;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialVariant</b>
     * </p>
     *
     * @param billOfMaterialVariant
     *            Alternative BOM
     */
    public void setBillOfMaterialVariant( @Nullable final String billOfMaterialVariant )
    {
        rememberChangedField("BillOfMaterialVariant", this.billOfMaterialVariant);
        this.billOfMaterialVariant = billOfMaterialVariant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialVersion</b>
     * </p>
     *
     * @param billOfMaterialVersion
     *            BOM Version
     */
    public void setBillOfMaterialVersion( @Nullable final String billOfMaterialVersion )
    {
        rememberChangedField("BillOfMaterialVersion", this.billOfMaterialVersion);
        this.billOfMaterialVersion = billOfMaterialVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemCategory</b>
     * </p>
     *
     * @param billOfMaterialItemCategory
     *            Item category (bill of material)
     */
    public void setBillOfMaterialItemCategory( @Nullable final String billOfMaterialItemCategory )
    {
        rememberChangedField("BillOfMaterialItemCategory", this.billOfMaterialItemCategory);
        this.billOfMaterialItemCategory = billOfMaterialItemCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemUnit</b>
     * </p>
     *
     * @param billOfMaterialItemUnit
     *            Component Unit of Measure
     */
    public void setBillOfMaterialItemUnit( @Nullable final String billOfMaterialItemUnit )
    {
        rememberChangedField("BillOfMaterialItemUnit", this.billOfMaterialItemUnit);
        this.billOfMaterialItemUnit = billOfMaterialItemUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemQuantity</b>
     * </p>
     *
     * @param billOfMaterialItemQuantity
     *            Component Quantity
     */
    public void setBillOfMaterialItemQuantity( @Nullable final BigDecimal billOfMaterialItemQuantity )
    {
        rememberChangedField("BillOfMaterialItemQuantity", this.billOfMaterialItemQuantity);
        this.billOfMaterialItemQuantity = billOfMaterialItemQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>EngineeringChangeDocument</b>
     * </p>
     *
     * @param engineeringChangeDocument
     *            Change Number
     */
    public void setEngineeringChangeDocument( @Nullable final String engineeringChangeDocument )
    {
        rememberChangedField("EngineeringChangeDocument", this.engineeringChangeDocument);
        this.engineeringChangeDocument = engineeringChangeDocument;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Valid-From Date
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Valid-to date
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemNodeNumber</b>
     * </p>
     *
     * @param billOfMaterialItemNodeNumber
     *            BOM item node number
     */
    public void setBillOfMaterialItemNodeNumber( @Nullable final String billOfMaterialItemNodeNumber )
    {
        rememberChangedField("BillOfMaterialItemNodeNumber", this.billOfMaterialItemNodeNumber);
        this.billOfMaterialItemNodeNumber = billOfMaterialItemNodeNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemDescription</b>
     * </p>
     *
     * @param bOMItemDescription
     *            BOM Item Text (Line 1)
     */
    public void setBOMItemDescription( @Nullable final String bOMItemDescription )
    {
        rememberChangedField("BOMItemDescription", this.bOMItemDescription);
        this.bOMItemDescription = bOMItemDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaterialName</b>
     * </p>
     *
     * @param materialName
     *            Material Description
     */
    public void setMaterialName( @Nullable final String materialName )
    {
        rememberChangedField("MaterialName", this.materialName);
        this.materialName = materialName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PlantName</b>
     * </p>
     *
     * @param plantName
     *            Plant Name
     */
    public void setPlantName( @Nullable final String plantName )
    {
        rememberChangedField("PlantName", this.plantName);
        this.plantName = plantName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialVariantUsageDesc</b>
     * </p>
     *
     * @param billOfMaterialVariantUsageDesc
     *            BOM usage text
     */
    public void setBillOfMaterialVariantUsageDesc( @Nullable final String billOfMaterialVariantUsageDesc )
    {
        rememberChangedField("BillOfMaterialVariantUsageDesc", this.billOfMaterialVariantUsageDesc);
        this.billOfMaterialVariantUsageDesc = billOfMaterialVariantUsageDesc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialVariantUsage</b>
     * </p>
     *
     * @param billOfMaterialVariantUsage
     *            BOM Usage
     */
    public void setBillOfMaterialVariantUsage( @Nullable final String billOfMaterialVariantUsage )
    {
        rememberChangedField("BillOfMaterialVariantUsage", this.billOfMaterialVariantUsage);
        this.billOfMaterialVariantUsage = billOfMaterialVariantUsage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BOMVersionStatus</b>
     * </p>
     *
     * @param bOMVersionStatus
     *            BOM Version Status
     */
    public void setBOMVersionStatus( @Nullable final String bOMVersionStatus )
    {
        rememberChangedField("BOMVersionStatus", this.bOMVersionStatus);
        this.bOMVersionStatus = bOMVersionStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BOMVersionStatusDescription</b>
     * </p>
     *
     * @param bOMVersionStatusDescription
     *            Short Text for Fixed Values
     */
    public void setBOMVersionStatusDescription( @Nullable final String bOMVersionStatusDescription )
    {
        rememberChangedField("BOMVersionStatusDescription", this.bOMVersionStatusDescription);
        this.bOMVersionStatusDescription = bOMVersionStatusDescription;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BOMWhereUsed";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BillOfMaterialItemUUID", getBillOfMaterialItemUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BillOfMaterialItemUUID", getBillOfMaterialItemUUID());
        values.put("BillOfMaterialComponent", getBillOfMaterialComponent());
        values.put("BillOfMaterialItemNumber", getBillOfMaterialItemNumber());
        values.put("HeaderChangeDocument", getHeaderChangeDocument());
        values.put("BillOfMaterialCategory", getBillOfMaterialCategory());
        values.put("BillOfMaterial", getBillOfMaterial());
        values.put("BillOfMaterialVariant", getBillOfMaterialVariant());
        values.put("BillOfMaterialVersion", getBillOfMaterialVersion());
        values.put("BillOfMaterialItemCategory", getBillOfMaterialItemCategory());
        values.put("BillOfMaterialItemUnit", getBillOfMaterialItemUnit());
        values.put("BillOfMaterialItemQuantity", getBillOfMaterialItemQuantity());
        values.put("EngineeringChangeDocument", getEngineeringChangeDocument());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("BillOfMaterialItemNodeNumber", getBillOfMaterialItemNodeNumber());
        values.put("BOMItemDescription", getBOMItemDescription());
        values.put("Material", getMaterial());
        values.put("MaterialName", getMaterialName());
        values.put("PlantName", getPlantName());
        values.put("BillOfMaterialVariantUsageDesc", getBillOfMaterialVariantUsageDesc());
        values.put("Plant", getPlant());
        values.put("BillOfMaterialVariantUsage", getBillOfMaterialVariantUsage());
        values.put("BOMVersionStatus", getBOMVersionStatus());
        values.put("BOMVersionStatusDescription", getBOMVersionStatusDescription());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BillOfMaterialItemUUID") ) {
                final Object value = values.remove("BillOfMaterialItemUUID");
                if( (value == null) || (!value.equals(getBillOfMaterialItemUUID())) ) {
                    setBillOfMaterialItemUUID(((UUID) value));
                }
            }
            if( values.containsKey("BillOfMaterialComponent") ) {
                final Object value = values.remove("BillOfMaterialComponent");
                if( (value == null) || (!value.equals(getBillOfMaterialComponent())) ) {
                    setBillOfMaterialComponent(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialItemNumber") ) {
                final Object value = values.remove("BillOfMaterialItemNumber");
                if( (value == null) || (!value.equals(getBillOfMaterialItemNumber())) ) {
                    setBillOfMaterialItemNumber(((String) value));
                }
            }
            if( values.containsKey("HeaderChangeDocument") ) {
                final Object value = values.remove("HeaderChangeDocument");
                if( (value == null) || (!value.equals(getHeaderChangeDocument())) ) {
                    setHeaderChangeDocument(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialCategory") ) {
                final Object value = values.remove("BillOfMaterialCategory");
                if( (value == null) || (!value.equals(getBillOfMaterialCategory())) ) {
                    setBillOfMaterialCategory(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterial") ) {
                final Object value = values.remove("BillOfMaterial");
                if( (value == null) || (!value.equals(getBillOfMaterial())) ) {
                    setBillOfMaterial(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialVariant") ) {
                final Object value = values.remove("BillOfMaterialVariant");
                if( (value == null) || (!value.equals(getBillOfMaterialVariant())) ) {
                    setBillOfMaterialVariant(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialVersion") ) {
                final Object value = values.remove("BillOfMaterialVersion");
                if( (value == null) || (!value.equals(getBillOfMaterialVersion())) ) {
                    setBillOfMaterialVersion(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialItemCategory") ) {
                final Object value = values.remove("BillOfMaterialItemCategory");
                if( (value == null) || (!value.equals(getBillOfMaterialItemCategory())) ) {
                    setBillOfMaterialItemCategory(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialItemUnit") ) {
                final Object value = values.remove("BillOfMaterialItemUnit");
                if( (value == null) || (!value.equals(getBillOfMaterialItemUnit())) ) {
                    setBillOfMaterialItemUnit(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialItemQuantity") ) {
                final Object value = values.remove("BillOfMaterialItemQuantity");
                if( (value == null) || (!value.equals(getBillOfMaterialItemQuantity())) ) {
                    setBillOfMaterialItemQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("EngineeringChangeDocument") ) {
                final Object value = values.remove("EngineeringChangeDocument");
                if( (value == null) || (!value.equals(getEngineeringChangeDocument())) ) {
                    setEngineeringChangeDocument(((String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BillOfMaterialItemNodeNumber") ) {
                final Object value = values.remove("BillOfMaterialItemNodeNumber");
                if( (value == null) || (!value.equals(getBillOfMaterialItemNodeNumber())) ) {
                    setBillOfMaterialItemNodeNumber(((String) value));
                }
            }
            if( values.containsKey("BOMItemDescription") ) {
                final Object value = values.remove("BOMItemDescription");
                if( (value == null) || (!value.equals(getBOMItemDescription())) ) {
                    setBOMItemDescription(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("MaterialName") ) {
                final Object value = values.remove("MaterialName");
                if( (value == null) || (!value.equals(getMaterialName())) ) {
                    setMaterialName(((String) value));
                }
            }
            if( values.containsKey("PlantName") ) {
                final Object value = values.remove("PlantName");
                if( (value == null) || (!value.equals(getPlantName())) ) {
                    setPlantName(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialVariantUsageDesc") ) {
                final Object value = values.remove("BillOfMaterialVariantUsageDesc");
                if( (value == null) || (!value.equals(getBillOfMaterialVariantUsageDesc())) ) {
                    setBillOfMaterialVariantUsageDesc(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialVariantUsage") ) {
                final Object value = values.remove("BillOfMaterialVariantUsage");
                if( (value == null) || (!value.equals(getBillOfMaterialVariantUsage())) ) {
                    setBillOfMaterialVariantUsage(((String) value));
                }
            }
            if( values.containsKey("BOMVersionStatus") ) {
                final Object value = values.remove("BOMVersionStatus");
                if( (value == null) || (!value.equals(getBOMVersionStatus())) ) {
                    setBOMVersionStatus(((String) value));
                }
            }
            if( values.containsKey("BOMVersionStatusDescription") ) {
                final Object value = values.remove("BOMVersionStatusDescription");
                if( (value == null) || (!value.equals(getBOMVersionStatusDescription())) ) {
                    setBOMVersionStatusDescription(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> BOMWhereUsedField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BOMWhereUsedField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BOMWhereUsedField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BOMWhereUsedField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillsOfMaterialWhereUsedListService.DEFAULT_SERVICE_PATH);
    }

}
