/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billsofmaterialwhereusedlist.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link BillsOfMaterialWhereUsedListServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillsOfMaterialWhereUsedListService
 * BillsOfMaterialWhereUsedListService}, allowing you to create multiple changesets and finally execute the batch
 * request.
 *
 */
public class DefaultBillsOfMaterialWhereUsedListServiceBatch
    extends
    BatchFluentHelperBasic<BillsOfMaterialWhereUsedListServiceBatch, BillsOfMaterialWhereUsedListServiceBatchChangeSet>
    implements
    BillsOfMaterialWhereUsedListServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillsOfMaterialWhereUsedListService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultBillsOfMaterialWhereUsedListServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultBillsOfMaterialWhereUsedListServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillsOfMaterialWhereUsedListService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillsOfMaterialWhereUsedListService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultBillsOfMaterialWhereUsedListServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultBillsOfMaterialWhereUsedListServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillsOfMaterialWhereUsedListService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultBillsOfMaterialWhereUsedListServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public BillsOfMaterialWhereUsedListServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultBillsOfMaterialWhereUsedListServiceBatchChangeSet(this, service);
    }

}
