/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billsofmaterialwhereusedlist.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link BillsOfMaterialWhereUsedListServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillsOfMaterialWhereUsedListService
 * BillsOfMaterialWhereUsedListService}.
 *
 */
public class DefaultBillsOfMaterialWhereUsedListServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<BillsOfMaterialWhereUsedListServiceBatch, BillsOfMaterialWhereUsedListServiceBatchChangeSet>
    implements
    BillsOfMaterialWhereUsedListServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillsOfMaterialWhereUsedListService service;

    @SuppressWarnings( "deprecation" )
    DefaultBillsOfMaterialWhereUsedListServiceBatchChangeSet(
        @Nonnull final DefaultBillsOfMaterialWhereUsedListServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BillsOfMaterialWhereUsedListService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultBillsOfMaterialWhereUsedListServiceBatchChangeSet getThis()
    {
        return this;
    }

}
