/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billsofmaterialwhereusedlist.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billsofmaterialwhereusedlist.BOMWhereUsed;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billsofmaterialwhereusedlist.BOMWhereUsed BOMWhereUsed}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billsofmaterialwhereusedlist.field.BOMWhereUsedField
 * BOMWhereUsedField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billsofmaterialwhereusedlist.link.BOMWhereUsedLink
 * BOMWhereUsedLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billsofmaterialwhereusedlist.BOMWhereUsed#BILL_OF_MATERIAL_ITEM_UUID
 * BILL_OF_MATERIAL_ITEM_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billsofmaterialwhereusedlist.BOMWhereUsed#BILL_OF_MATERIAL_COMPONENT
 * BILL_OF_MATERIAL_COMPONENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billsofmaterialwhereusedlist.BOMWhereUsed#BILL_OF_MATERIAL_ITEM_NUMBER
 * BILL_OF_MATERIAL_ITEM_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billsofmaterialwhereusedlist.BOMWhereUsed#HEADER_CHANGE_DOCUMENT
 * HEADER_CHANGE_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billsofmaterialwhereusedlist.BOMWhereUsed#BILL_OF_MATERIAL_CATEGORY
 * BILL_OF_MATERIAL_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billsofmaterialwhereusedlist.BOMWhereUsed#BILL_OF_MATERIAL
 * BILL_OF_MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billsofmaterialwhereusedlist.BOMWhereUsed#BILL_OF_MATERIAL_VARIANT
 * BILL_OF_MATERIAL_VARIANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billsofmaterialwhereusedlist.BOMWhereUsed#BILL_OF_MATERIAL_VERSION
 * BILL_OF_MATERIAL_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billsofmaterialwhereusedlist.BOMWhereUsed#BILL_OF_MATERIAL_ITEM_CATEGORY
 * BILL_OF_MATERIAL_ITEM_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billsofmaterialwhereusedlist.BOMWhereUsed#BILL_OF_MATERIAL_ITEM_UNIT
 * BILL_OF_MATERIAL_ITEM_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billsofmaterialwhereusedlist.BOMWhereUsed#BILL_OF_MATERIAL_ITEM_QUANTITY
 * BILL_OF_MATERIAL_ITEM_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billsofmaterialwhereusedlist.BOMWhereUsed#ENGINEERING_CHANGE_DOCUMENT
 * ENGINEERING_CHANGE_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billsofmaterialwhereusedlist.BOMWhereUsed#VALIDITY_START_DATE
 * VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billsofmaterialwhereusedlist.BOMWhereUsed#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billsofmaterialwhereusedlist.BOMWhereUsed#BILL_OF_MATERIAL_ITEM_NODE_NUMBER
 * BILL_OF_MATERIAL_ITEM_NODE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billsofmaterialwhereusedlist.BOMWhereUsed#BOM_ITEM_DESCRIPTION
 * BOM_ITEM_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billsofmaterialwhereusedlist.BOMWhereUsed#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billsofmaterialwhereusedlist.BOMWhereUsed#MATERIAL_NAME
 * MATERIAL_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billsofmaterialwhereusedlist.BOMWhereUsed#PLANT_NAME
 * PLANT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billsofmaterialwhereusedlist.BOMWhereUsed#BILL_OF_MATERIAL_VARIANT_USAGE_DESC
 * BILL_OF_MATERIAL_VARIANT_USAGE_DESC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billsofmaterialwhereusedlist.BOMWhereUsed#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billsofmaterialwhereusedlist.BOMWhereUsed#BILL_OF_MATERIAL_VARIANT_USAGE
 * BILL_OF_MATERIAL_VARIANT_USAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billsofmaterialwhereusedlist.BOMWhereUsed#BOM_VERSION_STATUS
 * BOM_VERSION_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.billsofmaterialwhereusedlist.BOMWhereUsed#BOM_VERSION_STATUS_DESCRIPTION
 * BOM_VERSION_STATUS_DESCRIPTION}</li>
 * </ul>
 *
 */
public interface BOMWhereUsedSelectable extends EntitySelectable<BOMWhereUsed>
{

}
