/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilbusinessplace;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmComplex;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original complex type name from the Odata EDM: <b>BranchAddress</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BranchAddress extends VdmComplex<BranchAddress>
{

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>AddressID</b>
     * </p>
     *
     * @param addressID
     *
     * @return Address Number
     */
    @SerializedName( "AddressID" )
    @JsonProperty( "AddressID" )
    @Nullable
    @ODataField( odataName = "AddressID" )
    private String addressID;
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>Name</b>
     * </p>
     *
     * @param name
     *
     * @return Name
     */
    @SerializedName( "Name" )
    @JsonProperty( "Name" )
    @Nullable
    @ODataField( odataName = "Name" )
    private String name;
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>Name2</b>
     * </p>
     *
     * @param name2
     *
     * @return Name 2
     */
    @SerializedName( "Name2" )
    @JsonProperty( "Name2" )
    @Nullable
    @ODataField( odataName = "Name2" )
    private String name2;
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>Name3</b>
     * </p>
     *
     * @param name3
     *
     * @return Name 3
     */
    @SerializedName( "Name3" )
    @JsonProperty( "Name3" )
    @Nullable
    @ODataField( odataName = "Name3" )
    private String name3;
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>Name4</b>
     * </p>
     *
     * @param name4
     *
     * @return Name 4
     */
    @SerializedName( "Name4" )
    @JsonProperty( "Name4" )
    @Nullable
    @ODataField( odataName = "Name4" )
    private String name4;
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>CityName</b>
     * </p>
     *
     * @param cityName
     *
     * @return City
     */
    @SerializedName( "CityName" )
    @JsonProperty( "CityName" )
    @Nullable
    @ODataField( odataName = "CityName" )
    private String cityName;
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>District</b>
     * </p>
     *
     * @param district
     *
     * @return District
     */
    @SerializedName( "District" )
    @JsonProperty( "District" )
    @Nullable
    @ODataField( odataName = "District" )
    private String district;
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>PostalCode</b>
     * </p>
     *
     * @param postalCode
     *
     * @return Postal Code
     */
    @SerializedName( "PostalCode" )
    @JsonProperty( "PostalCode" )
    @Nullable
    @ODataField( odataName = "PostalCode" )
    private String postalCode;
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>POBox</b>
     * </p>
     *
     * @param pOBox
     *
     * @return PO Box
     */
    @SerializedName( "POBox" )
    @JsonProperty( "POBox" )
    @Nullable
    @ODataField( odataName = "POBox" )
    private String pOBox;
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>StreetName</b>
     * </p>
     *
     * @param streetName
     *
     * @return Street
     */
    @SerializedName( "StreetName" )
    @JsonProperty( "StreetName" )
    @Nullable
    @ODataField( odataName = "StreetName" )
    private String streetName;
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>AddressHouseNumber</b>
     * </p>
     *
     * @param addressHouseNumber
     *
     * @return House Number
     */
    @SerializedName( "AddressHouseNumber" )
    @JsonProperty( "AddressHouseNumber" )
    @Nullable
    @ODataField( odataName = "AddressHouseNumber" )
    private String addressHouseNumber;
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>Floor</b>
     * </p>
     *
     * @param floor
     *
     * @return Floor
     */
    @SerializedName( "Floor" )
    @JsonProperty( "Floor" )
    @Nullable
    @ODataField( odataName = "Floor" )
    private String floor;
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>RoomNumber</b>
     * </p>
     *
     * @param roomNumber
     *
     * @return Room Number
     */
    @SerializedName( "RoomNumber" )
    @JsonProperty( "RoomNumber" )
    @Nullable
    @ODataField( odataName = "RoomNumber" )
    private String roomNumber;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>Region</b>
     * </p>
     *
     * @param region
     *
     * @return Region
     */
    @SerializedName( "Region" )
    @JsonProperty( "Region" )
    @Nullable
    @ODataField( odataName = "Region" )
    private String region;
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     *
     * @param taxJurisdiction
     *
     * @return Tax Jurisdiction
     */
    @SerializedName( "TaxJurisdiction" )
    @JsonProperty( "TaxJurisdiction" )
    @Nullable
    @ODataField( odataName = "TaxJurisdiction" )
    private String taxJurisdiction;
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property from the Odata EDM: <b>PhoneNumber1</b>
     * </p>
     *
     * @param phoneNumber1
     *
     * @return Telephone
     */
    @SerializedName( "PhoneNumber1" )
    @JsonProperty( "PhoneNumber1" )
    @Nullable
    @ODataField( odataName = "PhoneNumber1" )
    private String phoneNumber1;
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>PhoneNumberExtension</b>
     * </p>
     *
     * @param phoneNumberExtension
     *
     * @return Extension
     */
    @SerializedName( "PhoneNumberExtension" )
    @JsonProperty( "PhoneNumberExtension" )
    @Nullable
    @ODataField( odataName = "PhoneNumberExtension" )
    private String phoneNumberExtension;
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property from the Odata EDM: <b>AddressFaxNumber</b>
     * </p>
     *
     * @param addressFaxNumber
     *
     * @return Fax
     */
    @SerializedName( "AddressFaxNumber" )
    @JsonProperty( "AddressFaxNumber" )
    @Nullable
    @ODataField( odataName = "AddressFaxNumber" )
    private String addressFaxNumber;

    @Nonnull
    @Override
    public Class<BranchAddress> getType()
    {
        return BranchAddress.class;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("AddressID", getAddressID());
        values.put("Name", getName());
        values.put("Name2", getName2());
        values.put("Name3", getName3());
        values.put("Name4", getName4());
        values.put("CityName", getCityName());
        values.put("District", getDistrict());
        values.put("PostalCode", getPostalCode());
        values.put("POBox", getPOBox());
        values.put("StreetName", getStreetName());
        values.put("AddressHouseNumber", getAddressHouseNumber());
        values.put("Floor", getFloor());
        values.put("RoomNumber", getRoomNumber());
        values.put("Region", getRegion());
        values.put("TaxJurisdiction", getTaxJurisdiction());
        values.put("PhoneNumber1", getPhoneNumber1());
        values.put("PhoneNumberExtension", getPhoneNumberExtension());
        values.put("AddressFaxNumber", getAddressFaxNumber());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("AddressID") ) {
                final Object value = values.remove("AddressID");
                if( (value == null) || (!value.equals(getAddressID())) ) {
                    setAddressID(((String) value));
                }
            }
            if( values.containsKey("Name") ) {
                final Object value = values.remove("Name");
                if( (value == null) || (!value.equals(getName())) ) {
                    setName(((String) value));
                }
            }
            if( values.containsKey("Name2") ) {
                final Object value = values.remove("Name2");
                if( (value == null) || (!value.equals(getName2())) ) {
                    setName2(((String) value));
                }
            }
            if( values.containsKey("Name3") ) {
                final Object value = values.remove("Name3");
                if( (value == null) || (!value.equals(getName3())) ) {
                    setName3(((String) value));
                }
            }
            if( values.containsKey("Name4") ) {
                final Object value = values.remove("Name4");
                if( (value == null) || (!value.equals(getName4())) ) {
                    setName4(((String) value));
                }
            }
            if( values.containsKey("CityName") ) {
                final Object value = values.remove("CityName");
                if( (value == null) || (!value.equals(getCityName())) ) {
                    setCityName(((String) value));
                }
            }
            if( values.containsKey("District") ) {
                final Object value = values.remove("District");
                if( (value == null) || (!value.equals(getDistrict())) ) {
                    setDistrict(((String) value));
                }
            }
            if( values.containsKey("PostalCode") ) {
                final Object value = values.remove("PostalCode");
                if( (value == null) || (!value.equals(getPostalCode())) ) {
                    setPostalCode(((String) value));
                }
            }
            if( values.containsKey("POBox") ) {
                final Object value = values.remove("POBox");
                if( (value == null) || (!value.equals(getPOBox())) ) {
                    setPOBox(((String) value));
                }
            }
            if( values.containsKey("StreetName") ) {
                final Object value = values.remove("StreetName");
                if( (value == null) || (!value.equals(getStreetName())) ) {
                    setStreetName(((String) value));
                }
            }
            if( values.containsKey("AddressHouseNumber") ) {
                final Object value = values.remove("AddressHouseNumber");
                if( (value == null) || (!value.equals(getAddressHouseNumber())) ) {
                    setAddressHouseNumber(((String) value));
                }
            }
            if( values.containsKey("Floor") ) {
                final Object value = values.remove("Floor");
                if( (value == null) || (!value.equals(getFloor())) ) {
                    setFloor(((String) value));
                }
            }
            if( values.containsKey("RoomNumber") ) {
                final Object value = values.remove("RoomNumber");
                if( (value == null) || (!value.equals(getRoomNumber())) ) {
                    setRoomNumber(((String) value));
                }
            }
            if( values.containsKey("Region") ) {
                final Object value = values.remove("Region");
                if( (value == null) || (!value.equals(getRegion())) ) {
                    setRegion(((String) value));
                }
            }
            if( values.containsKey("TaxJurisdiction") ) {
                final Object value = values.remove("TaxJurisdiction");
                if( (value == null) || (!value.equals(getTaxJurisdiction())) ) {
                    setTaxJurisdiction(((String) value));
                }
            }
            if( values.containsKey("PhoneNumber1") ) {
                final Object value = values.remove("PhoneNumber1");
                if( (value == null) || (!value.equals(getPhoneNumber1())) ) {
                    setPhoneNumber1(((String) value));
                }
            }
            if( values.containsKey("PhoneNumberExtension") ) {
                final Object value = values.remove("PhoneNumberExtension");
                if( (value == null) || (!value.equals(getPhoneNumberExtension())) ) {
                    setPhoneNumberExtension(((String) value));
                }
            }
            if( values.containsKey("AddressFaxNumber") ) {
                final Object value = values.remove("AddressFaxNumber");
                if( (value == null) || (!value.equals(getAddressFaxNumber())) ) {
                    setAddressFaxNumber(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        return result;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>AddressID</b>
     * </p>
     *
     * @param addressID
     *            Address Number
     */
    public void setAddressID( @Nullable final String addressID )
    {
        rememberChangedField("AddressID", this.addressID);
        this.addressID = addressID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>Name</b>
     * </p>
     *
     * @param name
     *            Name
     */
    public void setName( @Nullable final String name )
    {
        rememberChangedField("Name", this.name);
        this.name = name;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>Name2</b>
     * </p>
     *
     * @param name2
     *            Name 2
     */
    public void setName2( @Nullable final String name2 )
    {
        rememberChangedField("Name2", this.name2);
        this.name2 = name2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>Name3</b>
     * </p>
     *
     * @param name3
     *            Name 3
     */
    public void setName3( @Nullable final String name3 )
    {
        rememberChangedField("Name3", this.name3);
        this.name3 = name3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>Name4</b>
     * </p>
     *
     * @param name4
     *            Name 4
     */
    public void setName4( @Nullable final String name4 )
    {
        rememberChangedField("Name4", this.name4);
        this.name4 = name4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>CityName</b>
     * </p>
     *
     * @param cityName
     *            City
     */
    public void setCityName( @Nullable final String cityName )
    {
        rememberChangedField("CityName", this.cityName);
        this.cityName = cityName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>District</b>
     * </p>
     *
     * @param district
     *            District
     */
    public void setDistrict( @Nullable final String district )
    {
        rememberChangedField("District", this.district);
        this.district = district;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>PostalCode</b>
     * </p>
     *
     * @param postalCode
     *            Postal Code
     */
    public void setPostalCode( @Nullable final String postalCode )
    {
        rememberChangedField("PostalCode", this.postalCode);
        this.postalCode = postalCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>POBox</b>
     * </p>
     *
     * @param pOBox
     *            PO Box
     */
    public void setPOBox( @Nullable final String pOBox )
    {
        rememberChangedField("POBox", this.pOBox);
        this.pOBox = pOBox;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>StreetName</b>
     * </p>
     *
     * @param streetName
     *            Street
     */
    public void setStreetName( @Nullable final String streetName )
    {
        rememberChangedField("StreetName", this.streetName);
        this.streetName = streetName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>AddressHouseNumber</b>
     * </p>
     *
     * @param addressHouseNumber
     *            House Number
     */
    public void setAddressHouseNumber( @Nullable final String addressHouseNumber )
    {
        rememberChangedField("AddressHouseNumber", this.addressHouseNumber);
        this.addressHouseNumber = addressHouseNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>Floor</b>
     * </p>
     *
     * @param floor
     *            Floor
     */
    public void setFloor( @Nullable final String floor )
    {
        rememberChangedField("Floor", this.floor);
        this.floor = floor;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>RoomNumber</b>
     * </p>
     *
     * @param roomNumber
     *            Room Number
     */
    public void setRoomNumber( @Nullable final String roomNumber )
    {
        rememberChangedField("RoomNumber", this.roomNumber);
        this.roomNumber = roomNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>Region</b>
     * </p>
     *
     * @param region
     *            Region
     */
    public void setRegion( @Nullable final String region )
    {
        rememberChangedField("Region", this.region);
        this.region = region;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     *
     * @param taxJurisdiction
     *            Tax Jurisdiction
     */
    public void setTaxJurisdiction( @Nullable final String taxJurisdiction )
    {
        rememberChangedField("TaxJurisdiction", this.taxJurisdiction);
        this.taxJurisdiction = taxJurisdiction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property from the Odata EDM: <b>PhoneNumber1</b>
     * </p>
     *
     * @param phoneNumber1
     *            Telephone
     */
    public void setPhoneNumber1( @Nullable final String phoneNumber1 )
    {
        rememberChangedField("PhoneNumber1", this.phoneNumber1);
        this.phoneNumber1 = phoneNumber1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>PhoneNumberExtension</b>
     * </p>
     *
     * @param phoneNumberExtension
     *            Extension
     */
    public void setPhoneNumberExtension( @Nullable final String phoneNumberExtension )
    {
        rememberChangedField("PhoneNumberExtension", this.phoneNumberExtension);
        this.phoneNumberExtension = phoneNumberExtension;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property from the Odata EDM: <b>AddressFaxNumber</b>
     * </p>
     *
     * @param addressFaxNumber
     *            Fax
     */
    public void setAddressFaxNumber( @Nullable final String addressFaxNumber )
    {
        rememberChangedField("AddressFaxNumber", this.addressFaxNumber);
        this.addressFaxNumber = addressFaxNumber;
    }

}
