/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilbusinessplace;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmComplex;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original complex type name from the Odata EDM: <b>BranchDetail</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BranchDetail extends VdmComplex<BranchDetail>
{

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *
     * @return Company Code
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>Branch</b>
     * </p>
     *
     * @param branch
     *
     * @return Business Place
     */
    @SerializedName( "Branch" )
    @JsonProperty( "Branch" )
    @Nullable
    @ODataField( odataName = "Branch" )
    private String branch;
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property from the Odata EDM: <b>BusinessPlaceName</b>
     * </p>
     *
     * @param businessPlaceName
     *
     * @return Name 1
     */
    @SerializedName( "BusinessPlaceName" )
    @JsonProperty( "BusinessPlaceName" )
    @Nullable
    @ODataField( odataName = "BusinessPlaceName" )
    private String businessPlaceName;
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property from the Odata EDM: <b>BR_BusinessPlacePartOfCNPJ</b>
     * </p>
     *
     * @param bR_BusinessPlacePartOfCNPJ
     *
     * @return CNPJ Number
     */
    @SerializedName( "BR_BusinessPlacePartOfCNPJ" )
    @JsonProperty( "BR_BusinessPlacePartOfCNPJ" )
    @Nullable
    @ODataField( odataName = "BR_BusinessPlacePartOfCNPJ" )
    private String bR_BusinessPlacePartOfCNPJ;
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property from the Odata EDM: <b>BR_SUFRAMACode</b>
     * </p>
     *
     * @param bR_SUFRAMACode
     *
     * @return Suframa Code
     */
    @SerializedName( "BR_SUFRAMACode" )
    @JsonProperty( "BR_SUFRAMACode" )
    @Nullable
    @ODataField( odataName = "BR_SUFRAMACode" )
    private String bR_SUFRAMACode;
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>BusinessPlaceActivity</b>
     * </p>
     *
     * @param businessPlaceActivity
     *
     * @return SPED Activity Ind.
     */
    @SerializedName( "BusinessPlaceActivity" )
    @JsonProperty( "BusinessPlaceActivity" )
    @Nullable
    @ODataField( odataName = "BusinessPlaceActivity" )
    private String businessPlaceActivity;

    @Nonnull
    @Override
    public Class<BranchDetail> getType()
    {
        return BranchDetail.class;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CompanyCode", getCompanyCode());
        values.put("Branch", getBranch());
        values.put("BusinessPlaceName", getBusinessPlaceName());
        values.put("BR_BusinessPlacePartOfCNPJ", getBR_BusinessPlacePartOfCNPJ());
        values.put("BR_SUFRAMACode", getBR_SUFRAMACode());
        values.put("BusinessPlaceActivity", getBusinessPlaceActivity());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("Branch") ) {
                final Object value = values.remove("Branch");
                if( (value == null) || (!value.equals(getBranch())) ) {
                    setBranch(((String) value));
                }
            }
            if( values.containsKey("BusinessPlaceName") ) {
                final Object value = values.remove("BusinessPlaceName");
                if( (value == null) || (!value.equals(getBusinessPlaceName())) ) {
                    setBusinessPlaceName(((String) value));
                }
            }
            if( values.containsKey("BR_BusinessPlacePartOfCNPJ") ) {
                final Object value = values.remove("BR_BusinessPlacePartOfCNPJ");
                if( (value == null) || (!value.equals(getBR_BusinessPlacePartOfCNPJ())) ) {
                    setBR_BusinessPlacePartOfCNPJ(((String) value));
                }
            }
            if( values.containsKey("BR_SUFRAMACode") ) {
                final Object value = values.remove("BR_SUFRAMACode");
                if( (value == null) || (!value.equals(getBR_SUFRAMACode())) ) {
                    setBR_SUFRAMACode(((String) value));
                }
            }
            if( values.containsKey("BusinessPlaceActivity") ) {
                final Object value = values.remove("BusinessPlaceActivity");
                if( (value == null) || (!value.equals(getBusinessPlaceActivity())) ) {
                    setBusinessPlaceActivity(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        return result;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>Branch</b>
     * </p>
     *
     * @param branch
     *            Business Place
     */
    public void setBranch( @Nullable final String branch )
    {
        rememberChangedField("Branch", this.branch);
        this.branch = branch;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property from the Odata EDM: <b>BusinessPlaceName</b>
     * </p>
     *
     * @param businessPlaceName
     *            Name 1
     */
    public void setBusinessPlaceName( @Nullable final String businessPlaceName )
    {
        rememberChangedField("BusinessPlaceName", this.businessPlaceName);
        this.businessPlaceName = businessPlaceName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property from the Odata EDM: <b>BR_BusinessPlacePartOfCNPJ</b>
     * </p>
     *
     * @param bR_BusinessPlacePartOfCNPJ
     *            CNPJ Number
     */
    public void setBR_BusinessPlacePartOfCNPJ( @Nullable final String bR_BusinessPlacePartOfCNPJ )
    {
        rememberChangedField("BR_BusinessPlacePartOfCNPJ", this.bR_BusinessPlacePartOfCNPJ);
        this.bR_BusinessPlacePartOfCNPJ = bR_BusinessPlacePartOfCNPJ;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property from the Odata EDM: <b>BR_SUFRAMACode</b>
     * </p>
     *
     * @param bR_SUFRAMACode
     *            Suframa Code
     */
    public void setBR_SUFRAMACode( @Nullable final String bR_SUFRAMACode )
    {
        rememberChangedField("BR_SUFRAMACode", this.bR_SUFRAMACode);
        this.bR_SUFRAMACode = bR_SUFRAMACode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>BusinessPlaceActivity</b>
     * </p>
     *
     * @param businessPlaceActivity
     *            SPED Activity Ind.
     */
    public void setBusinessPlaceActivity( @Nullable final String businessPlaceActivity )
    {
        rememberChangedField("BusinessPlaceActivity", this.businessPlaceActivity);
        this.businessPlaceActivity = businessPlaceActivity;
    }

}
