/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilbusinessplace;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilbusinessplace.field.BusinessPlaceField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilbusinessplace.link.BusinessPlaceLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilbusinessplace.selectable.BusinessPlaceSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Business Place
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>BusinessPlace</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BusinessPlace extends VdmEntity<BusinessPlace>
{

    /**
     * Selector for all available fields of BusinessPlace.
     *
     */
    public final static BusinessPlaceSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>BranchAddress</b>
     * </p>
     *
     * @return The branchAddress contained in this entity.
     */
    @SerializedName( "BranchAddress" )
    @JsonProperty( "BranchAddress" )
    @Nullable
    @ODataField( odataName = "BranchAddress" )
    private BranchAddress branchAddress;
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>BranchDetail</b>
     * </p>
     *
     * @return The branchDetail contained in this entity.
     */
    @SerializedName( "BranchDetail" )
    @JsonProperty( "BranchDetail" )
    @Nullable
    @ODataField( odataName = "BranchDetail" )
    private BranchDetail branchDetail;
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Branch</b>
     * </p>
     *
     * @return Business Place
     */
    @Key
    @SerializedName( "Branch" )
    @JsonProperty( "Branch" )
    @Nullable
    @ODataField( odataName = "Branch" )
    private String branch;
    /**
     * Use with available fluent helpers to apply the <b>Branch</b> field to query operations.
     *
     */
    public final static BusinessPlaceField<String> BRANCH = new BusinessPlaceField<String>("Branch");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @Key
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static BusinessPlaceField<String> COMPANY_CODE = new BusinessPlaceField<String>("CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPlaceStateTaxNumber</b>
     * </p>
     *
     * @return State Tax No.
     */
    @SerializedName( "BusinessPlaceStateTaxNumber" )
    @JsonProperty( "BusinessPlaceStateTaxNumber" )
    @Nullable
    @ODataField( odataName = "BusinessPlaceStateTaxNumber" )
    private String businessPlaceStateTaxNumber;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPlaceStateTaxNumber</b> field to query operations.
     *
     */
    public final static BusinessPlaceField<String> BUSINESS_PLACE_STATE_TAX_NUMBER =
        new BusinessPlaceField<String>("BusinessPlaceStateTaxNumber");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>BusPlaceMunicipalTaxNumber</b>
     * </p>
     *
     * @return Munic. Tax No.
     */
    @SerializedName( "BusPlaceMunicipalTaxNumber" )
    @JsonProperty( "BusPlaceMunicipalTaxNumber" )
    @Nullable
    @ODataField( odataName = "BusPlaceMunicipalTaxNumber" )
    private String busPlaceMunicipalTaxNumber;
    /**
     * Use with available fluent helpers to apply the <b>BusPlaceMunicipalTaxNumber</b> field to query operations.
     *
     */
    public final static BusinessPlaceField<String> BUS_PLACE_MUNICIPAL_TAX_NUMBER =
        new BusinessPlaceField<String>("BusPlaceMunicipalTaxNumber");
    /**
     * Navigation property <b>to_emails</b> for <b>BusinessPlace</b> to multiple <b>SmtpNumbers</b>.
     *
     */
    @SerializedName( "to_emails" )
    @JsonProperty( "to_emails" )
    @ODataField( odataName = "to_emails" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SmtpNumbers> toEmails;
    /**
     * Use with available fluent helpers to apply the <b>to_emails</b> navigation property to query operations.
     *
     */
    public final static BusinessPlaceLink<SmtpNumbers> TO_EMAILS = new BusinessPlaceLink<SmtpNumbers>("to_emails");

    @Nonnull
    @Override
    public Class<BusinessPlace> getType()
    {
        return BusinessPlace.class;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>BranchAddress</b>
     * </p>
     *
     * @param branchAddress
     *            The branchAddress to set.
     */
    public void setBranchAddress( @Nullable final BranchAddress branchAddress )
    {
        rememberChangedField("BranchAddress", this.branchAddress);
        this.branchAddress = branchAddress;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>BranchDetail</b>
     * </p>
     *
     * @param branchDetail
     *            The branchDetail to set.
     */
    public void setBranchDetail( @Nullable final BranchDetail branchDetail )
    {
        rememberChangedField("BranchDetail", this.branchDetail);
        this.branchDetail = branchDetail;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Branch</b>
     * </p>
     *
     * @param branch
     *            Business Place
     */
    public void setBranch( @Nullable final String branch )
    {
        rememberChangedField("Branch", this.branch);
        this.branch = branch;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPlaceStateTaxNumber</b>
     * </p>
     *
     * @param businessPlaceStateTaxNumber
     *            State Tax No.
     */
    public void setBusinessPlaceStateTaxNumber( @Nullable final String businessPlaceStateTaxNumber )
    {
        rememberChangedField("BusinessPlaceStateTaxNumber", this.businessPlaceStateTaxNumber);
        this.businessPlaceStateTaxNumber = businessPlaceStateTaxNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>BusPlaceMunicipalTaxNumber</b>
     * </p>
     *
     * @param busPlaceMunicipalTaxNumber
     *            Munic. Tax No.
     */
    public void setBusPlaceMunicipalTaxNumber( @Nullable final String busPlaceMunicipalTaxNumber )
    {
        rememberChangedField("BusPlaceMunicipalTaxNumber", this.busPlaceMunicipalTaxNumber);
        this.busPlaceMunicipalTaxNumber = busPlaceMunicipalTaxNumber;
    }

    @Override
    protected String getEntityCollection()
    {
        return "BusinessPlaceSet";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Branch", getBranch());
        result.put("CompanyCode", getCompanyCode());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BranchAddress", getBranchAddress());
        values.put("BranchDetail", getBranchDetail());
        values.put("Branch", getBranch());
        values.put("CompanyCode", getCompanyCode());
        values.put("BusinessPlaceStateTaxNumber", getBusinessPlaceStateTaxNumber());
        values.put("BusPlaceMunicipalTaxNumber", getBusPlaceMunicipalTaxNumber());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Branch") ) {
                final Object value = values.remove("Branch");
                if( (value == null) || (!value.equals(getBranch())) ) {
                    setBranch(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("BusinessPlaceStateTaxNumber") ) {
                final Object value = values.remove("BusinessPlaceStateTaxNumber");
                if( (value == null) || (!value.equals(getBusinessPlaceStateTaxNumber())) ) {
                    setBusinessPlaceStateTaxNumber(((String) value));
                }
            }
            if( values.containsKey("BusPlaceMunicipalTaxNumber") ) {
                final Object value = values.remove("BusPlaceMunicipalTaxNumber");
                if( (value == null) || (!value.equals(getBusPlaceMunicipalTaxNumber())) ) {
                    setBusPlaceMunicipalTaxNumber(((String) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("BranchAddress") ) {
                final Object value = values.remove("BranchAddress");
                if( value instanceof Map ) {
                    if( getBranchAddress() == null ) {
                        setBranchAddress(new BranchAddress());
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    getBranchAddress().fromMap(inputMap);
                }
                if( (value == null) && (getBranchAddress() != null) ) {
                    setBranchAddress(null);
                }
            }
            if( values.containsKey("BranchDetail") ) {
                final Object value = values.remove("BranchDetail");
                if( value instanceof Map ) {
                    if( getBranchDetail() == null ) {
                        setBranchDetail(new BranchDetail());
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    getBranchDetail().fromMap(inputMap);
                }
                if( (value == null) && (getBranchDetail() != null) ) {
                    setBranchDetail(null);
                }
            }
        }
        // navigation properties
        {
            if( (values).containsKey("to_emails") ) {
                final Object value = (values).remove("to_emails");
                if( value instanceof Iterable ) {
                    if( toEmails == null ) {
                        toEmails = Lists.newArrayList();
                    } else {
                        toEmails = Lists.newArrayList(toEmails);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SmtpNumbers entity;
                        if( toEmails.size() > i ) {
                            entity = toEmails.get(i);
                        } else {
                            entity = new SmtpNumbers();
                            toEmails.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> BusinessPlaceField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BusinessPlaceField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BusinessPlaceField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BusinessPlaceField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BrazilBusinessPlaceService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toEmails != null ) {
            (values).put("to_emails", toEmails);
        }
        return values;
    }

    /**
     * Fetches the <b>SmtpNumbers</b> entities (one to many) associated with this entity. This corresponds to the OData
     * navigation property <b>to_emails</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SmtpNumbers</b> entities. If no entities are associated then an
     *         empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SmtpNumbers> fetchEmails()
    {
        return fetchFieldAsList("to_emails", SmtpNumbers.class);
    }

    /**
     * Retrieval of associated <b>SmtpNumbers</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_emails</b>.
     * <p>
     * If the navigation property <b>to_emails</b> of a queried <b>BusinessPlace</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SmtpNumbers</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SmtpNumbers> getEmailsOrFetch()
    {
        if( toEmails == null ) {
            toEmails = fetchEmails();
        }
        return toEmails;
    }

    /**
     * Retrieval of associated <b>SmtpNumbers</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_emails</b>.
     * <p>
     * If the navigation property for an entity <b>BusinessPlace</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_emails</b> is already loaded, the result will contain
     *         the <b>SmtpNumbers</b> entities. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<List<SmtpNumbers>> getEmailsIfPresent()
    {
        return Option.of(toEmails);
    }

    /**
     * Overwrites the list of associated <b>SmtpNumbers</b> entities for the loaded navigation property
     * <b>to_emails</b>.
     * <p>
     * If the navigation property <b>to_emails</b> of a queried <b>BusinessPlace</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SmtpNumbers</b> entities.
     */
    public void setEmails( @Nonnull final List<SmtpNumbers> value )
    {
        if( toEmails == null ) {
            toEmails = Lists.newArrayList();
        }
        toEmails.clear();
        toEmails.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SmtpNumbers</b> entities. This corresponds to the OData navigation
     * property <b>to_emails</b>.
     * <p>
     * If the navigation property <b>to_emails</b> of a queried <b>BusinessPlace</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SmtpNumbers</b> entities.
     */
    public void addEmails( SmtpNumbers... entity )
    {
        if( toEmails == null ) {
            toEmails = Lists.newArrayList();
        }
        toEmails.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of BusinessPlace instances.
     *
     */
    public final static class BusinessPlaceBuilder
    {

        private List<SmtpNumbers> toEmails = Lists.newArrayList();

        private BusinessPlace.BusinessPlaceBuilder toEmails( final List<SmtpNumbers> value )
        {
            toEmails.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_emails</b> for <b>BusinessPlace</b> to multiple <b>SmtpNumbers</b>.
         *
         * @param value
         *            The SmtpNumberss to build this BusinessPlace with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusinessPlace.BusinessPlaceBuilder emails( SmtpNumbers... value )
        {
            return toEmails(Lists.newArrayList(value));
        }

    }

}
