/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilbusinessplace;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilbusinessplace.selectable.BusinessPlaceSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilbusinessplace.BusinessPlace BusinessPlace} entity
 * using key fields. This fluent helper allows methods which modify the underlying query to be called before executing
 * the query itself.
 *
 */
public class BusinessPlaceByKeyFluentHelper
    extends
    FluentHelperByKey<BusinessPlaceByKeyFluentHelper, BusinessPlace, BusinessPlaceSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilbusinessplace.BusinessPlace BusinessPlace}
     * entity with the provided key field values. To perform execution, call the {@link #executeRequest executeRequest}
     * method on the fluent helper object.
     *
     * @param companyCode
     *            Company Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code BusinessPlace}
     * @param servicePath
     *            Service path to be used to fetch a single {@code BusinessPlace}
     * @param branch
     *            Business Place
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     */
    public BusinessPlaceByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String branch,
        final String companyCode )
    {
        super(servicePath, entityCollection);
        this.key.put("Branch", branch);
        this.key.put("CompanyCode", companyCode);
    }

    @Override
    @Nonnull
    protected Class<BusinessPlace> getEntityClass()
    {
        return BusinessPlace.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
