/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilbusinessplace;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilbusinessplace.field.SmtpNumbersField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilbusinessplace.selectable.SmtpNumbersSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * E-mail Addresses
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SmtpNumbers</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SmtpNumbers extends VdmEntity<SmtpNumbers>
{

    /**
     * Selector for all available fields of SmtpNumbers.
     *
     */
    public final static SmtpNumbersSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: Not nullable, Maximum length: 241
     * <p>
     * Original property name from the Odata EDM: <b>EmailAddress</b>
     * </p>
     *
     * @return Email Address
     */
    @SerializedName( "EmailAddress" )
    @JsonProperty( "EmailAddress" )
    @Nullable
    @ODataField( odataName = "EmailAddress" )
    private String emailAddress;
    /**
     * Use with available fluent helpers to apply the <b>EmailAddress</b> field to query operations.
     *
     */
    public final static SmtpNumbersField<String> EMAIL_ADDRESS = new SmtpNumbersField<String>("EmailAddress");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Branch</b>
     * </p>
     *
     * @return Business Place
     */
    @Key
    @SerializedName( "Branch" )
    @JsonProperty( "Branch" )
    @Nullable
    @ODataField( odataName = "Branch" )
    private String branch;
    /**
     * Use with available fluent helpers to apply the <b>Branch</b> field to query operations.
     *
     */
    public final static SmtpNumbersField<String> BRANCH = new SmtpNumbersField<String>("Branch");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @Key
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static SmtpNumbersField<String> COMPANY_CODE = new SmtpNumbersField<String>("CompanyCode");

    @Nonnull
    @Override
    public Class<SmtpNumbers> getType()
    {
        return SmtpNumbers.class;
    }

    /**
     * Constraints: Not nullable, Maximum length: 241
     * <p>
     * Original property name from the Odata EDM: <b>EmailAddress</b>
     * </p>
     *
     * @param emailAddress
     *            Email Address
     */
    public void setEmailAddress( @Nullable final String emailAddress )
    {
        rememberChangedField("EmailAddress", this.emailAddress);
        this.emailAddress = emailAddress;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Branch</b>
     * </p>
     *
     * @param branch
     *            Business Place
     */
    public void setBranch( @Nullable final String branch )
    {
        rememberChangedField("Branch", this.branch);
        this.branch = branch;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    @Override
    protected String getEntityCollection()
    {
        return "SmtpNumbersSet";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Branch", getBranch());
        result.put("CompanyCode", getCompanyCode());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("EmailAddress", getEmailAddress());
        values.put("Branch", getBranch());
        values.put("CompanyCode", getCompanyCode());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("EmailAddress") ) {
                final Object value = values.remove("EmailAddress");
                if( (value == null) || (!value.equals(getEmailAddress())) ) {
                    setEmailAddress(((String) value));
                }
            }
            if( values.containsKey("Branch") ) {
                final Object value = values.remove("Branch");
                if( (value == null) || (!value.equals(getBranch())) ) {
                    setBranch(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> SmtpNumbersField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SmtpNumbersField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SmtpNumbersField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SmtpNumbersField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BrazilBusinessPlaceService.DEFAULT_SERVICE_PATH);
    }

}
