/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilbusinessplace.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link BrazilBusinessPlaceServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BrazilBusinessPlaceService BrazilBusinessPlaceService},
 * allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultBrazilBusinessPlaceServiceBatch
    extends
    BatchFluentHelperBasic<BrazilBusinessPlaceServiceBatch, BrazilBusinessPlaceServiceBatchChangeSet>
    implements
    BrazilBusinessPlaceServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BrazilBusinessPlaceService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultBrazilBusinessPlaceServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultBrazilBusinessPlaceServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BrazilBusinessPlaceService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.BrazilBusinessPlaceService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultBrazilBusinessPlaceServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultBrazilBusinessPlaceServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BrazilBusinessPlaceService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultBrazilBusinessPlaceServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public BrazilBusinessPlaceServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultBrazilBusinessPlaceServiceBatchChangeSet(this, service);
    }

}
