/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.brazilbusinessplace.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link BrazilBusinessPlaceServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BrazilBusinessPlaceService BrazilBusinessPlaceService}.
 *
 */
public class DefaultBrazilBusinessPlaceServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<BrazilBusinessPlaceServiceBatch, BrazilBusinessPlaceServiceBatchChangeSet>
    implements
    BrazilBusinessPlaceServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BrazilBusinessPlaceService service;

    @SuppressWarnings( "deprecation" )
    DefaultBrazilBusinessPlaceServiceBatchChangeSet(
        @Nonnull final DefaultBrazilBusinessPlaceServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BrazilBusinessPlaceService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultBrazilBusinessPlaceServiceBatchChangeSet getThis()
    {
        return this;
    }

}
